<?php

namespace Internetgalerie\IgCrmAdmin\Controller;

use Ig\IgFibu\Domain\Repository\InvoicestatusRepository;
use Internetgalerie\IgCrmAdmin\Controller\TYPO3\CMS\Extbase\Annotation\IgnoreValidation;
use Internetgalerie\IgsCrm\Domain\Model\Card;
use Internetgalerie\IgsCrm\Domain\Model\Verband;
use Internetgalerie\IgsCrm\Domain\Repository\CardRepository;
use Internetgalerie\IgsCrm\Domain\Repository\LanguageRepository;
use Internetgalerie\IgsCrm\Domain\Repository\MitgliedschaftRepository;
use Internetgalerie\IgsCrm\Domain\Repository\VerbandRepository;
use Psr\Http\Message\ResponseInterface;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Persistence\Generic\PersistenceManager;
use TYPO3\CMS\Extbase\Utility\LocalizationUtility;

class CardController extends AbstractCrmController
{
    protected $objectClass = Card::class;
    /**
     * verbandRepository
     *
     * @var VerbandRepository
     */
    protected $verbandRepository = null;

    /**
     * cardRepository
     *
     * @var CardRepository
     */
    protected $cardRepository = null;

    public function injectVerbandRepository(VerbandRepository $verbandRepository): void
    {
        $this->verbandRepository = $verbandRepository;
    }
 
    public function injectCardRepository(CardRepository $cardRepository): void
    {
        $this->cardRepository = $cardRepository;
    }
    
    /**
     * action edit
     */
    #[IgnoreValidation([
        'argumentName' => 'card',
    ])]
    public function editAction(Card $card, Verband $verband): ResponseInterface
    {
        $this->assignGeneral($verband);
        //var_dump($verband);exit(0);
        $this->view->assign('card', $card);
        return $this->htmlResponse($this->view->render());
    }
    /**
     * action new
     */
    public function newAction(Verband $verband): ResponseInterface
    {
        $this->assignGeneral($verband);
        $copy = $this->request->hasArgument('copy') ? (int)$this->request->getArgument('copy') : 0;
        if ($copy) {
            $card = clone $this->cardRepository->findByUid($copy);
            $card->setName($card->getName() . ' (COPY)');
        }
        $this->view->assign('clone', $copy);

        $this->view->assign('card', $card);
        return $this->htmlResponse($this->view->render());
    }


    /**
     * action update
     */
    #[IgnoreValidation([
        'argumentName' => 'card',
    ])]
    public function updateAction(Card $card, Verband $verband): ResponseInterface
    {
        /*
        if ($card->getType() !== get_class($card)) {
            var_dump($card->getType(), get_class($card));exit(0);
        }
        */
        $this->cardRepository->update($card);
        $this->addFlashMessage('Der Eintrag wurde aktualisiert.');
        $args = [
            'verband' => $verband,
        ];
        if ($this->request->hasArgument('activeTab')) {
            $args['activeTab'] = $this->request->getArgument('activeTab');
        }
        return $this->redirectWithSearch('show', '', null, $args);
    }

    /**
     * action create
     */
    #[IgnoreValidation([
        'argumentName' => 'card',
    ])]
    public function createAction(Card $card, Verband $verband): ResponseInterface
    {
        $this->cardRepository->add($card);
        $this->addFlashMessage('Der Eintrag wurde erstellt.');
        $persistenceManager = GeneralUtility::makeInstance(PersistenceManager::class);
        $persistenceManager->persistAll();
        $args = [
            'verband' => $verband,
        ];
        //$args= ['card' => $card];
        if ($this->request->hasArgument('activeTab')) {
            $args['activeTab'] = $this->request->getArgument('activeTab');
        }
        return $this->redirectWithSearch('show', '', null, $args);
    }


    /**
     * action confirmDelete
     */
    #[IgnoreValidation([
        'argumentName' => 'card',
    ])]
    public function confirmDeleteAction(Card $card, Verband $verband): ResponseInterface
    {
        $this->view->assign('card', $card);
        $this->view->assign('verband', $verband);
        if ($this->request->hasArgument('activeTab')) {
            $activeTab = $this->request->getArgument('activeTab');
        }
        $this->view->assign('activeTab', $activeTab);
        return $this->htmlResponse($this->view->render());
    }

    /**
     * action delete
     */
    #[IgnoreValidation([
        'argumentName' => 'verband',
    ])]
    public function deleteAction(Card $card, Verband $verband): ResponseInterface
    {
        $this->cardRepository->remove($card);
        $this->addFlashMessage('Der Eintrag wurde aktualisiert.');
        $args = [
            'verband' => $verband,
        ];
        if ($this->request->hasArgument('activeTab')) {
            $args['activeTab'] = $this->request->getArgument('activeTab');
        }
        return $this->redirectWithSearch('show', 'Verband', null, $args);
    }

    
    protected function assignGeneral(Verband $verband)
    {
        $items = $GLOBALS['TCA']['tx_igcrmtemplate_domain_model_templateletter']['columns']['object_type']['config']['items'];
        $optionsObjectType = [];
        foreach ($items as $item) {
            $label = $item['label'] ?? $item[0] ?? '';
            $value = $item['value'] ?? $item[1] ?? '';
            $optionsObjectType[$value] = $label;
        }
        $this->view->assign('optionsObjectType', $optionsObjectType);

        $items = $GLOBALS['TCA']['tx_igfibu_domain_model_invoice']['columns']['type']['config']['items'];
        $optionsTemplateObjectType = [];
        foreach ($items as $item) {
            $label = $item['label'] ?? $item[0] ?? '';
            $value = $item['value'] ?? $item[1] ?? '';
            if ($label ?? false) {
                $optionsTemplateObjectType[$value] = LocalizationUtility::translate($label);
            }
        }
        $this->view->assign('optionsTemplateObjectType', $optionsTemplateObjectType);

    
        $items = $GLOBALS['TCA']['tx_igcrmtemplate_domain_model_templateletter']['columns']['template_type']['config']['items'];
        $optionsTemplateType = [];
        foreach ($items as $item) {
            $label = $item['label'] ?? $item[0] ?? '';
            $value = $item['value'] ?? $item[1] ?? '';
            if ($label ?? false) {
                $optionsTemplateType[$value] = $label;
            }
        }
        $this->view->assign('optionsTemplateType', $optionsTemplateType);
        $this->languageRepository = GeneralUtility::makeInstance(LanguageRepository::class);
        $this->view->assign('languages', $this->languageRepository->findAll());

        $mitgliedschaftRepository = GeneralUtility::makeInstance(MitgliedschaftRepository::class);
        $this->view->assign('mitgliedschaften', $mitgliedschaftRepository->findBy([
            'verband' => $verband,
        ]));

        $invoicestatusRepository = GeneralUtility::makeInstance(InvoicestatusRepository::class);
        $this->view->assign('optionsInvoicestatus', $invoicestatusRepository->findAll());
        
        $this->view->assign('verband', $verband);

        if ($this->request->hasArgument('activeTab')) {
            $activeTab = $this->request->getArgument('activeTab');
        }
        $this->view->assign('activeTab', $activeTab);
    }
}
