<?php

namespace Internetgalerie\IgCrmAdmin\Controller;

use Internetgalerie\IgCrmAdmin\Controller\TYPO3\CMS\Extbase\Annotation\IgnoreValidation;
use Internetgalerie\IgDatapoolFe\Controller\ActionController;
use Internetgalerie\IgsCrm\Domain\Model\Category;
use Internetgalerie\IgsCrm\Domain\Model\Verband;
use Internetgalerie\IgsCrm\Domain\Repository\CategoryRepository;
use Internetgalerie\IgsCrm\Domain\Repository\VerbandRepository;
use Psr\Http\Message\ResponseInterface;

class CategoryController extends ActionController
{
    protected $objectClass = Category::class;
    /**
     * categoryRepository
     *
     * @var CategoryRepository
     */
    protected $categoryRepository = null;

    /**
     * verbandRepository
     *
     * @var VerbandRepository
     */
    protected $verbandRepository = null;

    public function injectVerbandRepository(VerbandRepository $verbandRepository): void
    {
        $this->verbandRepository = $verbandRepository;
    }

    public function injectCategoryRepository(CategoryRepository $categoryRepository): void
    {
        $this->categoryRepository = $categoryRepository;
    }

    /**
     * action new
     */
    #[IgnoreValidation([
        'argumentName' => 'category',
    ])]
    public function newAction(Verband $verband, Category $category = null): ResponseInterface
    {
        $this->view->assign('category', $category);
        $this->view->assign('verband', $verband);
        $this->view->assign('verbaende', $this->verbandRepository->findAll());
        if ($this->request->hasArgument('activeTab')) {
            $activeTab = $this->request->getArgument('activeTab');
        }
        $this->view->assign('activeTab', $activeTab);
        return $this->htmlResponse($this->view->render());
    }
    
    /**
     * action edit
     */
    #[IgnoreValidation([
        'argumentName' => 'category',
    ])]
    public function editAction(Category $category, Verband $verband): ResponseInterface
    {
        $this->view->assign('category', $category);
        $this->view->assign('verband', $verband);
        $this->view->assign('verbaende', $this->verbandRepository->findAll());
        if ($this->request->hasArgument('activeTab')) {
            $activeTab = $this->request->getArgument('activeTab');
        }
        $this->view->assign('activeTab', $activeTab);
        return $this->htmlResponse($this->view->render());
    }

    /**
     * action create
     */
    #[IgnoreValidation([
        'argumentName' => 'verband',
    ])]
    public function createAction(Category $category, Verband $verband): ResponseInterface
    {
        $this->categoryRepository->add($category);
        $this->addFlashMessage('Der Eintrag wurde erstellt.');
        $args = [
            'verband' => $verband,
        ];
        if ($this->request->hasArgument('activeTab')) {
            $args['activeTab'] = $this->request->getArgument('activeTab');
        }
        return $this->redirectWithSearch('show', 'Verband', null, $args);
    }

    /**
     * action update
     */
    #[IgnoreValidation([
        'argumentName' => 'verband',
    ])]
    public function updateAction(Category $category, Verband $verband): ResponseInterface
    {
        $this->categoryRepository->update($category);
        $this->addFlashMessage('Der Eintrag wurde aktualisiert.');
        $args = [
            'verband' => $verband,
        ];
        if ($this->request->hasArgument('activeTab')) {
            $args['activeTab'] = $this->request->getArgument('activeTab');
        }
        return $this->redirectWithSearch('show', 'Verband', null, $args);
    }

    /**
     * action confirmDelete
     */
    #[IgnoreValidation([
        'argumentName' => 'category',
    ])]
    public function confirmDeleteAction(Category $category, Verband $verband): ResponseInterface
    {
        $this->view->assign('category', $category);
        $this->view->assign('verband', $verband);
        if ($this->request->hasArgument('activeTab')) {
            $activeTab = $this->request->getArgument('activeTab');
        }
        $this->view->assign('activeTab', $activeTab);
        return $this->htmlResponse($this->view->render());
    }

    /**
     * action delete
     */
    #[IgnoreValidation([
        'argumentName' => 'verband',
    ])]
    public function deleteAction(Category $category, Verband $verband): ResponseInterface
    {
        $this->categoryRepository->remove($category);
        $this->addFlashMessage('Der Eintrag wurde aktualisiert.');
        $args = [
            'verband' => $verband,
        ];
        if ($this->request->hasArgument('activeTab')) {
            $args['activeTab'] = $this->request->getArgument('activeTab');
        }
        return $this->redirectWithSearch('show', 'Verband', null, $args);
    }
}
