<?php

namespace Internetgalerie\IgCrmAdmin\Controller;

use DateTime;
use Internetgalerie\IgCrmAdmin\Controller\TYPO3\CMS\Extbase\Annotation\IgnoreValidation;
use Internetgalerie\IgsCrm\Domain\Model\Contact;
use Internetgalerie\IgsCrm\Domain\Model\ContactContact;
use Internetgalerie\IgsCrm\Domain\Model\Organisation;
use Internetgalerie\IgsCrm\Domain\Repository\ContactContactRepository;
use Internetgalerie\IgsCrm\Domain\Repository\ContactRepository;
use Internetgalerie\IgsCrm\Domain\Repository\RelationFunctionRepository;
use Internetgalerie\IgsCrm\Domain\Repository\RelationTypeRepository;
use Psr\Http\Message\ResponseInterface;
use TYPO3\CMS\Core\Page\PageRenderer;
use TYPO3\CMS\Core\Type\ContextualFeedbackSeverity;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Persistence\Generic\PersistenceManager;
use TYPO3\CMS\Extbase\Property\TypeConverter\DateTimeConverter;

class ContactContactController extends AbstractCrmController
{
    protected $objectClass = ContactContact::class;


    protected $acls = [
        1 => 'Firmendaten',
        2 => 'Mitglieder',
        3 => 'Administrator',
    ];

    /**
     * contactContactRepository
     *
     * @var ContactContactRepository
     */
    protected $contactContactRepository = null;

    /**
     * contactRepository
     *
     * @var ContactRepository
     */
    protected $contactRepository = null;


    public function injectContactContactRepository(ContactContactRepository $contactContactRepository): void
    {
        $this->contactContactRepository = $contactContactRepository;
    }

    public function injectContactRepository(ContactRepository $contactRepository): void
    {
        $this->contactRepository = $contactRepository;
    }

    /**
     * action edit
     */
    #[IgnoreValidation([
        'argumentName' => 'contact',
    ])]
    public function editAction(
        ContactContact $contactContact = null,
        Contact $contact = null,
        Organisation $organisation = null
    ): ResponseInterface {
        $pageRenderer = GeneralUtility::makeInstance(PageRenderer::class);
        $pageRenderer->addJsFooterFile('EXT:ig_crm_admin/Resources/Public/JavaScript/ContactEdit.js');
        $this->assignCrm();
        $control = $this->getControl();
        $this->assignControl($control);
        //$organisationUid = 0;
        $default = [];
        //$default['active'] = $organisationUid > 0 ? 1 : 0;
        //$default['startDate'] = $organisationUid > 0 ? new \DateTime() : null;
        if ($control['organisation'] ?? false) {
            $organisation = $this->contactRepository->findByUid($control['organisation']);
            $default['organisationId'] = $organisation;

            if ($contactContact === null) {
                $default['active'] = true;
                //$defaultActive = 1;
            }
            if ($contactContact === null || $contactContact->getStartDate() === null) {
                $default['startDate'] = new DateTime();
                //$defaultStartDate = new \DateTime();
            }
        }
        if ($control['person'] ?? false) {
            $contact = $this->contactRepository->findByUid($control['person']);
            //$default['organisationId'] = $organisation;

            if ($contactContact === null) {
                $default['active'] = true;
                //$defaultActive = 1;
            }
            if ($contactContact === null || $contactContact->getStartDate() === null) {
                $default['startDate'] = new DateTime();
                //$defaultStartDate = new \DateTime();
            }
        }
        $this->view->assign('default', $default);
        //$this->view->assign('defaultActive', $defaultActive);
        //$this->view->assign('defaultStartDate', $defaultStartDate);


        $relationFunctionRepository = GeneralUtility::makeInstance(RelationFunctionRepository::class);
        $this->view->assign('relationFunctions', $relationFunctionRepository->findAll());
        
        $relationTypeRepository = GeneralUtility::makeInstance(RelationTypeRepository::class);
        $this->view->assign('relationTypes', $relationTypeRepository->findAll());
        $this->view->assign('acls', $this->acls);

        
        $this->view->assign('contactContact', $contactContact);
        $this->view->assign('contact', $contact);
        $this->view->assign('organisation', $organisation);
        return $this->htmlResponse($this->view->render());
    }

    /**
     * action update
     */
    public function updateAction(ContactContact $contactContact): ResponseInterface
    {
        $control = $this->getControl();
        $this->contactContactRepository->update($contactContact);
        $this->addFlashMessage('Der Eintrag wurde aktualisiert.');
        if ($this->request->getPluginName() == 'Of') {
            $modelClassName = 'Organisation';
            $organisation = $contactContact->getOrganisation();
            $args = [
                strtolower($modelClassName) => $organisation,
            ];
        } else {
            $contact = $contactContact->getContact();
            $modelClassName = $contact->getType() ?: 'Person';
            $args = [
                strtolower((string) $modelClassName) => $contact,
            ];
        }
        $args['activeTab'] = $this->getActiveTab();
        if (isset($control['redirect']) && is_array($control['redirect'])) {
            return $this->redirect(
                'show',
                $control['redirect']['controllerName'],
                $control['redirect']['extensionName '],
                $control['redirect']['arguments'],
                $control['redirect']['pageUid']
            );
        }
        return $this->redirectWithSearch('show', $modelClassName, null, $args);
    }
    /**
     * Add Function in Controller
     */
    public function initializeAction(): void
    {
        parent::initializeAction();
        if (isset($this->arguments['contactContact'])) {
            $contactContact = $this->arguments['contactContact'];
 
            // Set date format of date fields
            foreach (['startDate', 'endDate', 'journalEnd'] as $dateField) {
                $contactContact->getPropertyMappingConfiguration()
                    ->forProperty($dateField)
                    ->setTypeConverterOption(
                        DateTimeConverter::class,
                        DateTimeConverter::CONFIGURATION_DATE_FORMAT,
                        'Y-m-d'
                    );
            }

            // allow creation of sub entries
            foreach (['organisations', 'tags'] as $fieldName) {
                $contactContact->getPropertyMappingConfiguration()
->allowCreationForSubProperty($fieldName . '.*');//setTargetTypeForSubProperty('contactContact.'.$fieldName, 'array');
                //$contactContact->getPropertyMappingConfiguration()->setTargetTypeForSubProperty($fieldName,'array');
            }
        }
    }

    /**
     * action create
     */
    public function createAction(ContactContact $contactContact): ResponseInterface
    {
        $control = $this->getControl();
        $contact = $contactContact->getContact();
        if ($this->request->hasArgument('setAcl')) {
            $setAcl = $this->request->getArgument('setAcl');
            $verband = $contactContact->getVerband();
            if ($setAcl['read'] ?? 0) {
                foreach ($verband->getAclReadGroups() as $group) {
                    $contact->addAclReadGroupsIfNotContains($group);
                }
            }
            if ($setAcl['write'] ?? 0) {
                foreach ($verband->getAclWriteGroups() as $group) {
                    $contact->addAclWriteGroupsIfNotContains($group);
                }
            }
        }

        $this->contactContactRepository->add($contactContact);
        $this->contactRepository->update($contact);
        $persistenceManager = GeneralUtility::makeInstance(PersistenceManager::class);
        $persistenceManager->persistAll();
        $this->addFlashMessage('Der Eintrag wurde erstellt.', '', ContextualFeedbackSeverity::OK);
        
        
        $modelClassName = $contact->getType() ?: 'Person';
        $args = [
            strtolower((string) $modelClassName) => $contact,
        ];
        $args['activeTab'] = $this->getActiveTab();


        if (isset($control['redirect']) && is_array($control['redirect'])) {
            return $this->redirect(
                'show',
                $control['redirect']['controllerName'],
                $control['redirect']['extensionName '],
                $control['redirect']['arguments'],
                $control['redirect']['pageUid']
            );
        }
        return $this->redirectWithSearch('show', $modelClassName, null, $args);
    }

    /**
     * action confirmDelete
     */
    #[IgnoreValidation([
        'argumentName' => 'contactContact',
    ])]
    public function confirmDeleteAction(ContactContact $contactContact): ResponseInterface
    {
        $this->assignCrm();
        $control = $this->getControl();
        $this->assignControl($control);
        $this->view->assign('contactContact', $contactContact);
        return $this->htmlResponse($this->view->render());
    }

    /**
     * action delete
     */
    #[IgnoreValidation([
        'argumentName' => 'contactContact',
    ])]
    public function deleteAction(ContactContact $contactContact): ResponseInterface
    {
        $contact = $contactContact->getContact();
        if (!$this->securityUtility->hasPermissionWrite($contact, self::$requiredRole, ['fe_person_edit'])) {
            return $this->htmlResponse('Access denied');
        }
        $organisation = $contactContact->getOrganisation();
        $this->contactContactRepository->remove($contactContact);
        $this->addFlashMessage('Der Eintrag wurde gelöscht.');
        if ($this->request->getPluginName() == 'Of') {
            $modelClassName = 'Organisation';
            $args = [
                strtolower($modelClassName) => $organisation,
            ];
        } else {
            $modelClassName = $contact->getType() ?: 'Person';
            $args = [
                strtolower((string) $modelClassName) => $contact,
            ];
        }
        $args['activeTab'] = $this->getActiveTab();
        return $this->redirectWithSearch('show', $modelClassName, null, $args);
    }

    public function getActiveTab(string $defaultActiveTab = 'relation')
    {
        if ($this->request->hasArgument('activeTab')) {
            return $this->request->getArgument('activeTab');
        }
        return 'relation';
    }
}
