<?php

namespace Internetgalerie\IgCrmAdmin\Controller;

use DateTime;
use Ig\IgFibu\Domain\Model\Invoice;
use Ig\IgFibu\Domain\Model\InvoiceItem;
use Ig\IgFibu\Domain\Repository\CostCenterRepository;
use Ig\IgFibu\Domain\Repository\CreditRepository;
use Ig\IgFibu\Domain\Repository\InvoiceRepository;
use Ig\IgGeodata\Utility\CountryUtility;
use Ig\IgGeodata\Utility\PlzUtility;
use TYPO3\CMS\Extbase\Annotation\IgnoreValidation;
use Internetgalerie\IgCrmAdmin\Utility\PeriodUtility;
use Internetgalerie\IgCrmTemplate\Domain\Model\TemplateLetter;
use Internetgalerie\IgCrmTemplate\Domain\Repository\TemplateLetterRepository;
use Internetgalerie\IgCrmTemplate\Utility\CrmTranslate;
use Internetgalerie\IgDatapoolFe\Domain\Repository\CountryRepository;
use Internetgalerie\IgDatapoolFe\Property\TypeConverter\DateTimeConverter;
use Internetgalerie\IgDoctrinePaginator\Pagination\DoctrinePaginator;
use Internetgalerie\IgRender\Utility\PdfUtility;
use Internetgalerie\IgsCrm\Domain\Model\Contact;
use Internetgalerie\IgsCrm\Domain\Model\ContactVerband;
use Internetgalerie\IgsCrm\Domain\Model\InvoiceAnnual;
use Internetgalerie\IgsCrm\Domain\Model\InvoiceItemJournal;
use Internetgalerie\IgsCrm\Domain\Model\InvoiceItemMembership;
use Internetgalerie\IgsCrm\Domain\Model\Language;
use Internetgalerie\IgsCrm\Domain\Model\Mitgliedschaft;
use Internetgalerie\IgsCrm\Domain\Model\Organisation;
use Internetgalerie\IgsCrm\Domain\Model\Person;
use Internetgalerie\IgsCrm\Domain\Model\Verband;
use Internetgalerie\IgsCrm\Domain\Repository\AnredeRepository;
use Internetgalerie\IgsCrm\Domain\Repository\CategoryOrganisationRepository;
use Internetgalerie\IgsCrm\Domain\Repository\CertificateRepository;
use Internetgalerie\IgsCrm\Domain\Repository\ContactRepository;
use Internetgalerie\IgsCrm\Domain\Repository\ContactVerbandRepository;
use Internetgalerie\IgsCrm\Domain\Repository\EmailcategoryRepository;
use Internetgalerie\IgsCrm\Domain\Repository\ExportRepository;
use Internetgalerie\IgFrontendUser\Domain\Repository\FrontendUserGroupRepository;
use Internetgalerie\IgsCrm\Domain\Repository\FrontendUserRepository;
use Internetgalerie\IgsCrm\Domain\Repository\KantonRepository;
use Internetgalerie\IgsCrm\Domain\Repository\LanguageRepository;
use Internetgalerie\IgsCrm\Domain\Repository\MitgliedschaftRepository;
use Internetgalerie\IgsCrm\Domain\Repository\PhonecategoryRepository;
use Internetgalerie\IgsCrm\Domain\Repository\SektionRepository;
use Internetgalerie\IgsCrm\Domain\Repository\TagRepository;
use Internetgalerie\IgsCrm\Domain\Repository\TagRoleRepository;
use Internetgalerie\IgsCrm\Domain\Repository\TagverbandRepository;
use Internetgalerie\IgsCrm\Domain\Repository\VerbandRepository;
use Internetgalerie\IgsCrm\Utility\ConfUtility;
use Internetgalerie\IgsCrm\Utility\ExcelUtility;
use Internetgalerie\IgsCrm\Utility\ExportUtility;
use Internetgalerie\IgPostApi\PrintAddresses;
use Internetgalerie\IgPostApi\Domain\Model\Customer;
use Internetgalerie\IgPostApi\Domain\Model\Item;
use Internetgalerie\IgPostApi\Domain\Model\Recipient;
use Internetgalerie\IgPostApi\Utility\AuthUtility;
use Internetgalerie\IgPostApi\Utility\AddressLabelUtility;
use Internetgalerie\IgPostLabel\LabelType;
use Internetgalerie\IgPostLabel\Utility\CustomLabelUtility;
use PhpOffice\PhpSpreadsheet\Cell\Coordinate;
use PhpOffice\PhpSpreadsheet\Shared\Date;
use Psr\Http\Message\ResponseInterface;
use TYPO3\CMS\Core\Context\Context;
use TYPO3\CMS\Core\Crypto\PasswordHashing\PasswordHashFactory;
use TYPO3\CMS\Core\Page\PageRenderer;
use TYPO3\CMS\Core\Type\ContextualFeedbackSeverity;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Core\Utility\VersionNumberUtility;
use TYPO3\CMS\Extbase\Http\ForwardResponse;
use TYPO3\CMS\Extbase\Persistence\Generic\Mapper\DataMapper;
use TYPO3\CMS\Extbase\Persistence\Generic\PersistenceManager;
use TYPO3\CMS\Extbase\Persistence\ObjectStorage;
use TYPO3\CMS\Extbase\Property\TypeConverter\PersistentObjectConverter;
use TYPO3\CMS\Extbase\Utility\LocalizationUtility;



class ContactController extends AbstractCrmController
{
    protected const ACCESS_DENIED = 'Access denied';
    protected static $requiredRole = 'crm.contact';
    protected $useCustomLabel = true;
    protected $objectClass = Person::class;
    protected $type = '';
    protected $aclReadGroup = 'fe_person';
    protected $aclExportGroup = 'fe_export';
    protected $aclWriteGroup = 'fe_person_edit';
    protected $aclDeleteGroup = 'fe_person_delete';

    protected $partial = [
        'searchForm' => 'Organisation/SearchForm',
        'action' => 'Organisation/Action',
    ];
    /**
     * @var bool
     */
    protected $debugInvoice = false;

    /**
     * @var array
     */
    protected $searchDefault = [
        'memberActive' => 1,
    ];
    protected $optionsLogicalOperators = [
        1 => [
            'uid' => 1,
            'name' => 'Und',
            'operator' => 'AND',
        ],
        2 => [
            'uid' => 2,
            'name' => 'Oder',
            'operator' => 'OR',
        ],
    ];

    /**
     *verbandRepository
     *
     * @var VerbandRepository
     */
    protected $verbandRepository = null;


    /**
     * entryRepository
     *
     * @var ContactRepository
     */
    protected $entryRepository = null;



    /**
     * contactVerbandRepository
     *
     * @var ContactVerbandRepository
     */
    protected $contactVerbandRepository = null;


    /**
     * MitgliedschaftRepository
     *
     * @var MitgliedschaftRepository
     */
    protected $mitgliedschaftRepository = null;

    /**
     * SektionRepository
     *
     * @var SektionRepository
     */
    protected $sektionRepository = null;


    /**
     * FrontendUserGroupRepository
     *
     * @var FrontendUserGroupRepository
     */
    protected $frontendUserGroupRepository = null;

    /**
     * tagRepository
     *
     * @var TagRepository
     */
    protected $tagRepository = null;

    /**
     * tagRoleRepository
     *
     * @var TagRoleRepository
     */
    protected $tagRoleRepository = null;


    /**
     * exportRepository
     *
     * @var ExportRepository
     */
    protected $exportRepository = null;

    /**
     * languageRepository
     *
     * @var LanguageRepository
     */
    protected $languageRepository = null;


    /**
     * exportUtility
     *
     * @var ExportUtility
     */
    protected $exportUtility = null;
    /**
     * ConfUtility
     *
     * @var ConfUtility
     */
    protected $confUtility = null;
    
    /**
     * FrontendUserRepository
     *
     * @var FrontendUserRepository
     */
    protected $frontendUserRepository = null;


    protected $addYear = 0;
    protected $periode = null;


    public function __construct(
        ContactRepository $entryRepository
    ) {
        $this->entryRepository = $entryRepository;
    }
 
    
    public function injectVerbandRepository(VerbandRepository $verbandRepository): void
    {
        $this->verbandRepository = $verbandRepository;
    }

    public function injectContactVerbandRepository(ContactVerbandRepository $contactVerbandRepository): void
    {
        $this->contactVerbandRepository = $contactVerbandRepository;
    }

    public function injectMitgliedschaftRepository(MitgliedschaftRepository $mitgliedschaftRepository): void
    {
        $this->mitgliedschaftRepository = $mitgliedschaftRepository;
    }

    public function injectSektionRepository(SektionRepository $sektionRepository): void
    {
        $this->sektionRepository = $sektionRepository;
    }
    public function injectLanguageRepository(LanguageRepository $languageRepository): void
    {
        $this->languageRepository = $languageRepository;
    }

    public function injectExportRepository(ExportRepository $exportRepository): void
    {
        $this->exportRepository = $exportRepository;
    }

    public function injectFrontendUserRepository(FrontendUserRepository $frontendUserRepository): void
    {
        $this->frontendUserRepository = $frontendUserRepository;
    }

    public function injectFrontendUserGroupRepository(FrontendUserGroupRepository $frontendUserGroupRepository): void
    {
        $this->frontendUserGroupRepository = $frontendUserGroupRepository;
    }
    
    public function injectTagRepository(TagRepository $tagRepository): void
    {
        $this->tagRepository = $tagRepository;
    }
    
    public function injectTagRoleRepository(TagRoleRepository $tagRoleRepository): void
    {
        $this->tagRoleRepository = $tagRoleRepository;
    }
    /**
     * set default storage Page ids for frontendUser and frontendUserGroup
     */
    public function initializeObject(): void
    {
        $frontendUserStoragePid = (int) ($this->settings['frontendUserStoragePid'] ?? 0);
        if ($frontendUserStoragePid) {
            $this->frontendUserGroupRepository->setStoragePageId($frontendUserStoragePid);
            $this->frontendUserRepository->setStoragePageId($frontendUserStoragePid);
        }
    }
    
    /**
     * action list
     */
    public function listAction(): ResponseInterface
    {
        if (!$this->securityUtility->hasRoleAdmin('crm.contact') && !$this->securityUtility->hasGroupName($this->aclReadGroup)) {
            return $this->htmlResponse(self::ACCESS_DENIED);
        }
        
        $search = $this->getSearch();
        $control = $this->getControl();
        if (!($search['showentries'] ?? 0) && !isset($search['verband'])) {
            $verbandUid = $this->securityUtility->getGlobalVerband();
            if ($verbandUid) {
                $search['verband'] = $verbandUid;
            }
        }
        $this->view->assign('defaultVerbandUid', $this->settings['verbandUid'] ?? '');
        $search['type'] = $this->type;
        $this->assignAdvancedSearch($search);
        $this->assignControl($control);

        $verbands = $this->verbandRepository->findAllWithAcl();
        $this->view->assign('verbands', $verbands);
        $verband = $this->getVerbandSetSearch($search, $verbands);
        $this->view->assign('verband', $verband);

        $this->assignMitgliedschaften($verband, true);

        $headerVerbands = $this->securityUtility->getFrontendUserHeaderVerband();
        $this->view->assign('headerVerbands', $headerVerbands);

        if ($verband) {
            $templateLetterRepository = GeneralUtility::makeInstance(TemplateLetterRepository::class);
            $templateLetterFavorites = $templateLetterRepository->findFavoritesByVerbandType(
                $verband->getUid(),
                'Letter',
                $this->type
            );
            $this->view->assign('templateLetterFavorites', $templateLetterFavorites);
        }
        
        $contactQueryBuilder = $this->entryRepository->findBySearch($search);
        //$contacts = $this->entryRepository->findByVerband($verband, $search);

        $this->view->assign('hiddenCount', $this->entryRepository->countHidden());


        if ($search['showentries'] ?? false) {//   || $this->request->hasArgument('@widget_0')
            $this->view->assign('showentries', 1);
            //$this->view->assign('persons', $contacts);
        } else {
            if ($search['showentries'] ?? false) {
                //  $this->view->assign('persons', $contacts);
            } else {
                $this->view->assign('persons', null);
                $this->view->assign('meBildungspass', 1);
                $this->view->assign('meIsLernende', 1);
                $this->view->assign('meSgpfActive', 1);
            }
        }
        $this->view->assign('search', $search);
        $addressGroup = $this->settings['AddressGroup'] ?? '';
        if ($addressGroup == 'geosummit') {
            $this->view->assign('meTags', $this->tagRepository->findAll());
        }

        if ($this->settings['show']['person']['meKantonId'] ?? false) {
            $this->assignCrmKantone();
        }
        $tagsWithRoles = 0;
        $searchTagRoles = [];
        $searchTag = null;
        if (!empty($search['tags'])) {
            foreach ($search['tags'] as $tagGroupId => $tag) {
                $tagRoles = $this->tagRoleRepository->findBy([
                    'tag' => $tag,
                ]);
                if ($tagRoles->count()) {
                    $searchTagRoles = $tagRoles;
                    $searchTag = $tag;
                    $tagsWithRoles++;
                }
            }
        }
        $hasRoles = $tagsWithRoles === 1;
        //var_dump($tagsWithRoles, $hasRoles);exit(0);
        $this->view->assign('hasRoles', $hasRoles);
        $this->view->assign('searchTagRoles', $searchTagRoles);
        $this->view->assign('searchTag', $searchTag ? $this->tagRepository->findByUid((int)$searchTag) : null);


        if ($this->settings['PersonList'] ?? false) {
            $tableTempalte = 'PersonList';
        } else {
            if ($hasRoles) {
                $tableTempalte = 'TagRole';
                $pageRenderer = GeneralUtility::makeInstance(PageRenderer::class);
                $pageRenderer->addJsFooterFile('EXT:ig_crm_admin/Resources/Public/JavaScript/person-role.js');
            } else {
                $tableTempalte = 'Verband';
            }
        }
        
        $this->view->assign('tableTempalte', $tableTempalte);
        $this->view->assign('partial', $this->partial);

        $this->view->assign('page', $GLOBALS['TSFE']->page);

        $currentPage = $this->request->hasArgument('currentPage') ? (int)$this->request->getArgument('currentPage') : 1;
        
        $paginator = new DoctrinePaginator($contactQueryBuilder, $currentPage, 50, Contact::class);

        //$queryBuilderCount = clone $contactQueryBuilder;
        //$totalAmountOfItems = $queryBuilderCount->selectLiteral('count(1)')->executeQuery()->fetchOne();
        
        //var_dump($search, $totalAmountOfItems, $persons);

        // redirect if only 1 entry is found and showentries is not set and a search is given
        if (isset($search['showentries'])) {
            $showentries = (bool)$search['showentries'];
        } else {
            $showentries = true;
            if (!empty($search)) {
                foreach ($search as $key => $value) {
                    if ($key !== 'memberActive' && $key !== 'type') {
                        $showentries = false;
                    }
                }
            }
        }
        
        if ($showentries == 0 && $paginator->getTotalAmountOfItems() == 1) {
            $contact = $paginator->getPaginatedItems()[0];
            //var_dump($search,$showentries, $contact->getUid());exit(0);
            return (new ForwardResponse('show'))->withArguments([
                strtolower((string) $this->type) => $contact->getUid(),
            ]);
        }
        
        $pagination = $paginator->createSlidingWindowPagination(10);
        $this->view->assign('pagination', [
            'paginator' => $paginator,
            'pagination' => $pagination,
        ]);
        return $this->htmlResponse($this->view->render());
    }


        
    /**
     * action map
     */
    public function mapAction(): ResponseInterface
    {
        $search = $this->getSearch();
        $control = $this->getControl();
        if (!($search['showentries'] ?? 0) && !isset($search['verband'])) {
            $search['verband'] = $this->securityUtility->getGlobalVerband();
        }
        $search['type'] = $this->type;
        $this->assignAdvancedSearch($search);
        $this->assignControl($control);

        $verbands = $this->verbandRepository->findAllWithAcl();
        $this->view->assign('verbands', $verbands);
        $verband = $this->getVerbandSetSearch($search, $verbands);
        $this->view->assign('verband', $verband);

        $this->assignMitgliedschaften($verband, true);


        $headerVerbands = $this->securityUtility->getFrontendUserHeaderVerband();
        $this->view->assign('headerVerbands', $headerVerbands);
            
        
        $contactQueryBuilder = $this->entryRepository->findBySearch($search);

        $this->view->assign('hiddenCount', $this->entryRepository->countHidden());


        $showentries = (int)($search['showentries'] ?? 0);
        $this->view->assign('showentries', $showentries);

        $markers = [];
        $counts = [
            'all' => 0,
            'map' => 0,
            'zip' => 0,
            'country' => 0,
            'latLng' => 0,
            'notUsedTotal' => 0,
            'notUsedNoData' => 0,
            'notUsedCountry' => 0,
            'countries' => [],
        ];
        if ($showentries) {
            if (!class_exists(PlzUtility::class)) {
                return $this->htmlResponse('extensions ig_geodata and ig_googlemap are needed');
            }

            $plzUtility = GeneralUtility::makeInstance(PlzUtility::class);
            $countryUtility = GeneralUtility::makeInstance(CountryUtility::class);
            $res = $contactQueryBuilder->executeQuery();
            $rows = $res->fetchAllAssociative();
            $dataMapper = GeneralUtility::makeInstance(DataMapper::class);
            $contacts = $dataMapper->map(Contact::class, $rows);
            
            //while ($contactRow = $res->fetchAssociative()) {
            foreach ($contacts as $contact) {
                $counts['all']++;
                $countryIsoCode = $contact->getCountryIsoCode();
                $marker = [
                    'uid' => $contact->getUid(),
                    'type' => $contact->getType(),
                    'name' => $contact->getName(),
                    'address' => $contact->getAddress(),
                    'city' => $contact->getCity(),
                    'zip' => $contact->getZip(),
                    'countryIso2Code' => $countryIsoCode,
                ];
                if ($countryIsoCode === 'CH' || $countryIsoCode === 'LI' || $countryIsoCode === '') {
                    $latLng = $contact->getMap();
                    if ($latLng) {
                        $counts['map']++;
                        $counts['latLng']++;
                        $marker['latLng'] = $latLng;
                        $markers[] = $marker;
                    } else {
                        $latLng = $plzUtility->latlngByPlz($contact->getZip());
                        if ($latLng) {
                            $counts['map']++;
                            $counts['zip']++;
                            $marker['latLng'] = $plzUtility->latlngByPlz($contact->getZip());
                            $markers[] = $marker;
                        } else {
                            $counts['notUsedTotal']++;
                            $counts['notUsedNoData']++;
                        }
                    }
                } else {
                    $latLng = $countryUtility->latlngByCountryIso2Code($countryIsoCode);
                    if ($latLng) {
                        $counts['map']++;
                        $counts['country']++;
                        $marker['latLng'] = $latLng;
                        $markers[] = $marker;
                    } else {
                        $counts['notUsedTotal']++;
                        $counts['notUsedCountry']++;
                        if (isset($counts['countries'][$countryIsoCode])) {
                            $counts['countries'][$countryIsoCode]++;
                        } else {
                            $counts['countries'][$countryIsoCode] = 1;
                        }
                    }
                }
            }
        }
        
        $this->view->assign('contacts', $markers);
        $this->view->assign('counts', $counts);

        $this->view->assign('search', $search);

        $this->view->assign('type', $this->type);

        if ($this->settings['show']['person']['meKantonId'] ?? false) {
            $this->assignCrmKantone();
        }
        $tagsWithRoles = 0;
        $searchTagRoles = [];
        $searchTag = null;
        if (!empty($search['tags'])) {
            foreach ($search['tags'] as $tagGroupId => $tag) {
                $tagRoles = $this->tagRoleRepository->findBy([
                    'tag' => $tag,
                ]);
                if ($tagRoles->count()) {
                    $searchTagRoles = $tagRoles;
                    $searchTag = $tag;
                    $tagsWithRoles++;
                }
            }
        }
        $hasRoles = $tagsWithRoles === 1;
        //var_dump($tagsWithRoles, $hasRoles);exit(0);
        $this->view->assign('hasRoles', $hasRoles);
        $this->view->assign('searchTagRoles', $searchTagRoles);
        $this->view->assign('searchTag', $this->tagRepository->findByUid((int)$searchTag));


        if ($this->settings['PersonList'] ?? false) {
            $tableTempalte = 'PersonList';
        } else {
            if ($hasRoles) {
                $tableTempalte = 'TagRole';
                $pageRenderer = GeneralUtility::makeInstance(PageRenderer::class);
                $pageRenderer->addJsFooterFile('EXT:ig_crm_admin/Resources/Public/JavaScript/person-role.js');
            } else {
                $tableTempalte = 'Verband';
            }
        }
        
        $this->view->assign('tableTempalte', $tableTempalte);
        $this->view->assign('partial', $this->partial);

        $this->view->assign('page', $GLOBALS['TSFE']->page);
        return $this->htmlResponse($this->view->render());
    }

    
    public function multiEditAction(): ResponseInterface
    {
        $search = $this->getSearch();
        $this->assignAdvancedSearch($search);
        $this->view->assign('search', $search);

        $verbands = $this->verbandRepository->findAllWithAcl();
        $this->view->assign('verbands', $verbands);
        $verband = $this->getVerbandSetSearch($search, $verbands);
        $this->view->assign('verband', $verband);
        $optionActions = [
            'add' => 'Ausgewählte Einträge hinzufügen',
            'remove' => 'Ausgewählte Einträge entfernen',
            'set' => 'Ausgewählte Einträge setzen',
        ];
        $this->view->assign('optionActions', $optionActions);
        $contacts = $this->entryRepository->findByVerband($verband, $search);
        $this->view->assign('contacts', $contacts);

        $frontendUserGroups = $this->frontendUserGroupRepository->findAll();
        $this->view->assign('frontendUserGroups', $frontendUserGroups);
        
        $tagverbandRepository = GeneralUtility::makeInstance(TagverbandRepository::class);
        $this->view->assign('tagsverband', $tagverbandRepository->findBy([
            'verband' => $verband,
        ]));
        
        $this->assignMitgliedschaften($verband, false);
        return $this->htmlResponse($this->view->render());
    }

    public function multiUpdateAction(): ResponseInterface
    {
        $search = $this->getSearch();
        $this->assignAdvancedSearch($search);
        $verband = $this->getVerbandSetSearch($search, null);
        $contacts = $this->entryRepository->findByVerband($verband, $search);

        $tagAction = $this->request->hasArgument('tagAction') ? $this->request->getArgument('tagAction') : 'add';
        $addVerband = $this->request->hasArgument('addVerband') ? $this->request->getArgument('addVerband') : [];
        $leavingVerband = $this->request->hasArgument('leavingVerband') ? $this->request->getArgument(
            'leavingVerband'
        ) : [];

        $dateTimeConverter = GeneralUtility::makeInstance(DateTimeConverter::class);
        
        $count = 0;
        $tagsTitleUid = [];
        if ($this->request->hasArgument('tags') && !empty($contacts)) {
            $formTags = $this->request->getArgument('tags');
            $tags = [];
            foreach ($formTags as $formTag) {
                $tag = $this->tagRepository->findByUid((int)$formTag);
                $tags[] = $tag;
                $tagsTitleUid[] = $tag->getName() . ' (' . $tag->getUid() . ')';
            }
            
            foreach ($contacts as $contact) {
                $count++;
                $contactVerband = $contact->getContactVerbandById($verband->getUid());

                if ($tagAction === 'set') {
                    $objectStorageTags = GeneralUtility::makeInstance(ObjectStorage::class);
                    foreach ($tags as $tag) {
                        $objectStorageTags->attach($tag);
                    }
                    $contactVerband->setTags($objectStorageTags);
                } else {
                    foreach ($tags as $tag) {
                        if ($tagAction === 'add') {
                            $contactVerband->addTagIfNotContains($tag);
                        } elseif ($tagAction === 'remove') {
                            $contactVerband->removeTag($tag);
                        }
                    }
                }
                /*
                 foreach ($contactVerband->getTags() as $tag) {
                    echo 'has tag: ' . $tag->getName() .'<br />';
                }
                    echo('Person<br />');
               */
                $this->contactVerbandRepository->update($contactVerband);
            }
        }
        if (!empty($tagsTitleUid)) {
            if ($tagAction === 'add') {
                $messageText = 'Einträge ergänzt mit: ' . implode(', ', $tagsTitleUid);
            } elseif ($tagAction === 'remove') {
                $messageText = 'Entfernt von Einträge: ' . implode(', ', $tagsTitleUid);
            } elseif ($tagAction === 'set') {
                $messageText = 'Einträge gesetzt: ' . implode(', ', $tagsTitleUid);
            }
            $this->addFlashMessage(
                $messageText,
                $count . ' Einträge wurden aktualisiert',// [optional] the header
                ContextualFeedbackSeverity::OK
            );
        }


        if ($this->request->hasArgument('mitgliedschaft') && !empty($contacts)) {
            $formMitgliedschaft = (int) $this->request->getArgument('mitgliedschaft');
            if ($formMitgliedschaft > 0) {
                $mitgliedschaft = $this->mitgliedschaftRepository->findByUid($formMitgliedschaft);
                if ($mitgliedschaft instanceof Mitgliedschaft) {
                    $count = 0;
                    $countChanged = 0;
                    $countHasThisValue = 0;
                    foreach ($contacts as $contact) {
                        $count++;
                        $contactVerband = $contact->getContactVerbandById($verband->getUid());
                        if ($contactVerband instanceof ContactVerband) {
                            $currentMitgliedschaft = $contactVerband->getMitgliedschaft();
                            if ($mitgliedschaft != $currentMitgliedschaft) {
                                $contactVerband->setMitgliedschaft($mitgliedschaft);
                                $this->contactVerbandRepository->update($contactVerband);
                                $countChanged++;
                            } else {
                                $countHasThisValue++;
                            }
                        }
                    }
                    $message = 'Einträge geändert: ' . $countChanged;
                    if ($countHasThisValue) {
                        $message .= ' - Einträge unverändert (Wert ist schon gesetzt): ' . $countHasThisValue;
                    }
                    $this->addFlashMessage(
                        $message,
                        $count . ' Einträge in Auswahl',// [optional] the header
                        ContextualFeedbackSeverity::OK
                    );
                }
            }
        }

        

        $aclAction = $this->request->hasArgument('aclAction') ? $this->request->getArgument(
            'aclAction'
        ) : 'add';
        $aclReadGroupIds = $this->request->hasArgument('aclReadGroups') ? $this->request->getArgument(
            'aclReadGroups'
        ) : [];
        $aclWriteGroupIds = $this->request->hasArgument('aclWriteGroups') ? $this->request->getArgument(
            'aclWriteGroups'
        ) : [];

        $objectStorageAclReadGroups = GeneralUtility::makeInstance(ObjectStorage::class);
        foreach ($aclReadGroupIds as $id) {
            $group = $this->frontendUserGroupRepository->findOneBy([
                'uid' => $id,
            ]);
            $objectStorageAclReadGroups->attach($group);
        }

        $objectStorageAclWriteGroups = GeneralUtility::makeInstance(ObjectStorage::class);
        foreach ($aclWriteGroupIds as $id) {
            $group = $this->frontendUserGroupRepository->findOneBy([
                'uid' => $id,
            ]);
            $objectStorageAclWriteGroups->attach($group);
        }
        
        foreach ($contacts as $contact) {
            if ($aclAction === 'set') {
                $contact->setAclReadGroups(clone $objectStorageAclReadGroups);
                $contact->setAclWriteGroups(clone $objectStorageAclWriteGroups);
            } elseif ($aclAction === 'add') {
                foreach ($objectStorageAclReadGroups as $group) {
                    $contact->addAclReadGroupsIfNotContains($group);
                }
                foreach ($objectStorageAclWriteGroups as $group) {
                    $contact->addAclWriteGroupsIfNotContains($group);
                }
            } elseif ($aclAction === 'remove') {
                foreach ($objectStorageAclReadGroups as $group) {
                    $contact->removeAclReadGroups($group);
                }
                foreach ($objectStorageAclWriteGroups as $group) {
                    $contact->removeAclWriteGroups($group);
                }
            }
            $this->entryRepository->update($contact);
        }

        //var_dump($search);exit(0);
        $persistenceManager = GeneralUtility::makeInstance(PersistenceManager::class);
        $persistenceManager->persistAll();
        $countContactVerbandNew = 0;
        if ($addVerband['uid'] ?? false) {
            $addVerbandUid = (int) $addVerband['uid'];
            $addVerbandObject = $this->verbandRepository->findOneBy([
                'uid' => $addVerbandUid,
            ]);
            foreach ($contacts as $contact) {
                $count++;
                if ($addVerband['to']['date'] ?? false) {
                    $addDateTime = $dateTimeConverter->convertFrom($addVerband['to'], DateTime::class);
                } else {
                    $addDateTime = new DateTime();
                }
                //$pv = $contact->getContactVerbandById($verband->getUid());
                $contactVerband = $contact->getContactVerbandById($addVerbandUid);
                if (!$contactVerband) {
                    $countContactVerbandNew++;
                    $contactVerband = GeneralUtility::makeInstance(ContactVerband::class);
                    $contactVerband->setVerband($addVerbandObject);
                    $contactVerband->setPerson($contact);
                    $contactVerband->setStartDate($addDateTime);
                    //$contactVerband->setStartDate($pv->getStartDate());// take date from other tenant
                    $contactVerband->setActive(true);
                    //$contactVerband->setImportSource($importSource);
                    $contact->addMeContactVerband($contactVerband);
                    $this->entryRepository->update($contact);
                } else {
                    if (!$contactVerband->getActive() || $contactVerband->getEndDate() !== null) {
                        $contactVerband->setStartDate($addDateTime);
                        $contactVerband->setActive(true);
                        $contactVerband->setEndDate(null);
                    }
                }
            }
            $messageTitle = 'Neue Verbandseintritte: ' . $countContactVerbandNew;
            $this->addFlashMessage('', $messageTitle, ContextualFeedbackSeverity::OK);
        }
        if ($leavingVerband['uid'] ?? false) {
            $leavingVerbandUid = (int) $leavingVerband['uid'];
            $leavingVerbandObject = $this->verbandRepository->findOneBy([
                'uid' => $leavingVerbandUid,
            ]);
            $countContactVerbandLeaving = 0;
            if ($leavingVerband['to']['date'] ?? false) {
                $leavingDateTime = $dateTimeConverter->convertFrom($leavingVerband['to'], DateTime::class);
            } else {
                $leavingDateTime = new DateTime();
            }

            foreach ($contacts as $contact) {
                $count++;
                $contactVerband = $contact->getContactVerbandById($verband->getUid());
                if ($contactVerband) {
                    $countContactVerbandLeaving++;
                    $contactVerband->setEndDate($leavingDateTime);
                    $contactVerband->setActive(false);
                    $this->entryRepository->update($contact);
                }
            }
            $messageTitle = 'Verbandsaustritte: ' . $countContactVerbandLeaving;
            $this->addFlashMessage('', $messageTitle, ContextualFeedbackSeverity::OK);
        }
        
        
        $this->searchPrefix = 'search';
        return $this->redirectWithSearch('list');
    }


    public function letterFormAction(): ResponseInterface
    {
        $search = $this->getSearch(false);
        $this->assignAdvancedSearch($search);
        $this->view->assign('search', $search);
        $verband = $this->getVerbandSetSearch($search, null);
        $this->view->assign('verband', $verband);
        $contacts = $this->entryRepository->findByVerband($verband, $search);
        $this->view->assign('contacts', $contacts);
        $templateLetterRepository = GeneralUtility::makeInstance(TemplateLetterRepository::class);
        $templateLetters = $templateLetterRepository->findByVerbandType(
            $verband->getUid(),
            'Letter',
            null,
            $this->type
        );
        $this->view->assign('templateLetters', $templateLetters);
        $pageRenderer = GeneralUtility::makeInstance(PageRenderer::class);
        if (VersionNumberUtility::convertVersionNumberToInteger(
            VersionNumberUtility::getNumericTypo3Version()
        ) < 12000000) {
            $pageRenderer->addJsFooterFile('EXT:ig_crm_admin/Resources/Public/JavaScript/letter.js');
        } else {
            $pageRenderer->addJsFooterFile('EXT:ig_crm_admin/Resources/Public/JavaScript/letter-ckeditor5.js');
        }
        return $this->htmlResponse($this->view->render());
    }

    /**
     * action letterPdf
     */
    public function letterPdfAction(TemplateLetter $templateLetter): ResponseInterface
    {
        $search = $this->getSearch(false);
        $this->assignAdvancedSearch($search);
        $this->view->assign('search', $search);

        //$templateLetter = $this->request->hasArgument('templateLetter') ? $this->request->getArgument('templateLetter') : '';
        $this->view->assign('template', $templateLetter);
        $content = $this->request->hasArgument('content') ? $this->request->getArgument('content') : [];
        // should be done in HtmlConverter.php
        $content['text']['value'] = str_replace(["\n", "\r"], '', $content['text']['value']['html'] ?? '');
        $content['text']['parse'] = true;
        $content['text']['formatHtml'] = false;
        if (!is_array($content['title'])) {
            $content['title'] = [
                'value' => $content['title'],
            ];
        }
        $content['title']['parse'] = true;
        $content['title']['formatHtml'] = true;
        $this->view->assign('content', $content);
        
        //var_dump($content,$text);exit(0);
        $verband = $this->getVerbandSetSearch($search, null);
        $this->view->assign('verband', $verband);
        $this->view->assign('tenant', $verband);
        $this->view->assign('sender', $verband);
        $contacts = $this->entryRepository->findByVerband($verband, $search);
        $this->view->assign('contacts', $contacts);
        //$this->view->assign('contacts', $contacts);

        /*
        if ($languageAspect->getId() == 2) {
            $date = strftime('le %d %B %Y');
        } else {
            $date = strftime('%d. %B %Y');
        }
        */

        $language = $GLOBALS['TYPO3_REQUEST']->getAttribute('language', null);
        if ($language) {
            $defaultLanguageKey = $language->getTypo3Language();
            $defaultLanguageLocale = $language->getLocale();
        }

        
        $crmLanguage = $templateLetter->getCrmLanguage();
        if ($crmLanguage) {
            $languageKey = $crmLanguage->getLgCode();
            $languageLocale = $crmLanguage->getLgLocale();
        } else {
            $languageKey = $defaultLanguageKey;
            $languageLocale = $defaultLanguageLocale;
        }

        setlocale(LC_ALL, $languageLocale);
        if ($this->request->hasArgument('lcTimeLanguage')) {
            setlocale(LC_TIME, $this->request->getArgument('lcTimeLanguage'));
        } else {
            setlocale(LC_TIME, $languageLocale);
        }

        $languageMethod = ucfirst((string) $languageKey);
        $language = [
            'key' => $languageKey,
            'method' => $languageMethod,
        ];
        $this->view->assign('language', $language);
        if ($verband) {
            CrmTranslate::setVerband($verband->getUid());
        }
        //CrmTranslate::setCrmLanguage($crmLanguageUid);
        //var_dump($language);exit(0);
        $date = strftime('%d. %B %Y');
        $this->view->assign('date', $date);
        //$this->view->assign('currentDate', new \DateTime());

        $filename = LocalizationUtility::translate('letter', 'igsCrm');
        $filename .= '-' . str_replace(' ', '-', $templateLetter->getName()) . '-' . strftime('%Y-%m-%d');

        $title = $templateLetter->getTitle() ?: $verband->getNameFibu();
        
        $html = $this->view->render();
        $pdf = GeneralUtility::makeInstance(PdfUtility::class);
        $pdf->setFilename($filename . '.pdf'); // TODO Sprache
        $pdf->setTitle($title); // TODO Sprache

        $pdf->setConverter(PdfUtility::CONVERTER_WEASYPRINT);
        //$pdf->setCssFile('EXT:ig_crm_admin/Resources/Public/Css/organisation-getLetter.css');
        $pdf->setCssFile('EXT:ig_crm_admin/Resources/Public/Css/letter.css');
        $pdf->addCssFile('EXT:ig_crm_template/Resources/Public/Css/box.css');
        //$pdf->setCssFile('EXT:ig_fibu/Resources/Public/Css/weasyprint.css');
        $cssFile = $templateLetter->getCssFile();
        if ($cssFile) {
            $pdf->addCssFile($cssFile);
        }

        if (1) {
            $pdf->out($html);
            exit(0);
        }
        $pdf->debug($html);
    }


    /**
     * action list
     */
    public function newListAction(): ResponseInterface
    {
        $pageRenderer = GeneralUtility::makeInstance(PageRenderer::class);
        $uids = $this->entryRepository->findUidsMeOkOnNew();
        $countTotal = $this->entryRepository->count([
            'meOk' => 0,
        ]);
        $count = count($uids);


        $this->view->assign('count', $count);
        $this->view->assign('countTotal', $countTotal);
        return $this->htmlResponse($this->view->render());
    }

    /**
     * action list
     */
    public function diffListAction(): ResponseInterface
    {
        $pageRenderer = GeneralUtility::makeInstance(PageRenderer::class);
        $pageRenderer->addJsFooterFile('EXT:ig_crm_admin/Resources/Public/js/merge.js');
        //		var_dump($this->request->getArgument('@search'));exit(0);

        $count = $this->entryRepository->updateMeOkOnNew();
        if ($count) {
            $this->addFlashMessage(
                $count . ' Einträge wurden als importiert markiert',
                'Einträge mit neuem Vor-/Nachnamen importiert', // [optional] the header
                ContextualFeedbackSeverity::OK
            );
        }
        $contacts = $this->entryRepository->findWithNameByMeOk(0);
        $this->view->assign('persons', $contacts);

        $this->view->assign('page', $GLOBALS['TSFE']->page);
        return $this->htmlResponse($this->view->render());
    }

    public function combineAction(): ResponseInterface
    {
        if ($this->request->hasArgument('merge')) {
            $mergeUids = $this->request->getArgument('merge');
            $changes = $this->entryRepository->mergeUids($mergeUids);
            $this->addFlashMessage(
                count(
                    $changes
                ) . ' Einträge wurden zusammengeführt (gleicher Vor-/Nachname und PLZ oder Ort identisch)',
                'Einträge mit eindeutigen vorhandenen Einträgen wurden zusammengeführt', // [optional] the header
                ContextualFeedbackSeverity::OK
            );
            $this->view->assign('changes', $changes);
        } else {
            return new ForwardResponse('mergeList');
        }
        return $this->htmlResponse($this->view->render());
    }



    /**
     * action mergeList
     */
    public function mergeListAction(): ResponseInterface
    {
        $pageRenderer = GeneralUtility::makeInstance(PageRenderer::class);
        $pageRenderer->addJsFooterFile('EXT:ig_crm_admin/Resources/Public/js/merge.js');
        //		var_dump($this->request->getArgument('@search'));exit(0);

        $contacts = $this->entryRepository->findWithNameByMeOk(0);
        $this->view->assign('persons', $contacts);

        $this->view->assign('page', $GLOBALS['TSFE']->page);
        return $this->htmlResponse($this->view->render());
    }



    public function combineWeakAction(): ResponseInterface
    {
        if ($this->request->hasArgument('merge')) {
            $mergeUids = $this->request->getArgument('merge');
            $changes = $this->entryRepository->mergeUids($mergeUids);
            $this->addFlashMessage(
                count($changes) . ' Einträge wurden zusammengeführt',
                'Einträge mit vorhandenen Einträgen wurden zusammengeführt', // [optional] the header
                ContextualFeedbackSeverity::OK
            );
            $this->view->assign('changes', $changes);
        } else {
            $this->view->assign('changes', []);
        }
        return $this->htmlResponse($this->view->render());
    }

    /**
     * action list
     */
    public function mergeFinishAction(): ResponseInterface
    {
        $count = $this->entryRepository->updateMeOkAll();
        return $this->htmlResponse($this->view->render());
    }


    /**
     * action bildungspass
     */
    public function bildungspassAction(Person $person): ResponseInterface
    {
        $this->view->assign('person', $person);
        return $this->htmlResponse($this->view->render());
        //$this->view->assign('kursteilnahmen', $kursteilnahmen);
    }



    public function initializeAction(): void
    {
        parent::initializeAction();
        if ($this->request->hasArgument('person')) {
            for ($j = 0; $j < 10; $j++) {
                foreach (['', 'temp'] as $k) {
                    $i = $k . $j;
                    $propertyMappingConfiguration = $this->arguments->getArgument('person')
->getPropertyMappingConfiguration();
                    $propertyMappingConfiguration->allowAllProperties();
                    $propertyMappingConfiguration->forProperty('mePhoneNumberId.' . $i)->allowAllProperties();
                    $propertyMappingConfiguration->allowCreationForSubProperty('mePhoneNumberId.' . $i);
                    $propertyMappingConfiguration->allowModificationForSubProperty('mePhoneNumberId.' . $i);
                    $propertyMappingConfiguration->allowProperties('meEmailaddressId');
                    $propertyMappingConfiguration->forProperty('meEmailaddressId.' . $i)->allowAllProperties();
                    $propertyMappingConfiguration->allowCreationForSubProperty('meEmailaddressId.' . $i);
                    $propertyMappingConfiguration->allowModificationForSubProperty('meEmailaddressId.' . $i);
                    $propertyMappingConfiguration->forProperty('mePhoneNumberId.' . $i)->setTypeConverterOption(
                        PersistentObjectConverter::class,
                        PersistentObjectConverter::CONFIGURATION_CREATION_ALLOWED,
                        true
                    );
                    $propertyMappingConfiguration->forProperty('meEmailaddressId.' . $i)->setTypeConverterOption(
                        PersistentObjectConverter::class,
                        PersistentObjectConverter::CONFIGURATION_CREATION_ALLOWED,
                        true
                    );
                    foreach (['meDateOfBirth', 'meTodestag'] as $dateField) {
                        $propertyMappingConfiguration->forProperty($dateField)
                                                     ->setTypeConverterOption(
                                                         \TYPO3\CMS\Extbase\Property\TypeConverter\DateTimeConverter::class,
                                                         \TYPO3\CMS\Extbase\Property\TypeConverter\DateTimeConverter::CONFIGURATION_DATE_FORMAT,
                                                         'Y-m-d'
                                                     );
                    }
                }
            }
        }
    }


    /**
     * action editAdmin
     */
    #[IgnoreValidation(['argumentName' => 'person'])]
    public function editAdminAction(Contact $person): ResponseInterface
    {
        if (!$this->securityUtility->hasPermissionWrite($person, self::$requiredRole, [$this->aclWriteGroup])) {
            return $this->htmlResponse(self::ACCESS_DENIED);
        }
        $frontendUserGroups = $this->frontendUserGroupRepository->findAll();
        $this->view->assign('frontendUserGroups', $frontendUserGroups);
        $this->view->assign('person', $person);
        return $this->htmlResponse($this->view->render());
    }


    public function historyAction(): ResponseInterface
    {
        $contacts = $this->entryRepository->findHistory();
        $this->view->assign('persons', $contacts);
        return $this->htmlResponse($this->view->render());
    }


    public function historyExportAction(): ResponseInterface
    {
        $contacts = $this->entryRepository->findHistory();
        /*
          $exportData=$contacts->toArray();
          for($i=0;$i<count($exportData);$i++) {
          $m=$exportData[$i];
          //$exportData[$i]['tstamp']='a';
          }
         */
        $type = 'excel';
        $exporter = GeneralUtility::makeInstance(
            'Internetgalerie\\IgDatapoolFe\\Services\\Exporter\\' . ucfirst(strtolower($type)) . 'ExporterService',
            $type
        );

        $cols = [
            'tstampIso' => 'Datum',
            'meEmail' => 'E-Mail',
            'meGeosummit' => 'Geosummit',
            'meNewsletterGeosummit' => 'Geosummit NL',
            'meFirma' => 'Firma',
            'meLastname' => 'Nachname',
            'meFirstname' => 'Vorname',
            'meAddress' => 'Adresse',
            'meZip' => 'PLZ',
            'meCity' => 'Ort',
        ];
        //                  $hauptsitz = $h->getOfCompanyname() . ' ' .$h->getOfZip() . ' ' .$h->getOfCity();


        $options = [
            'filename' => 'PersonHistory',
        ];
        $fields = array_keys($cols);
        $exporter->setOptions($fields, $options);
        $exporter->setHeaders($cols);
        $exporter->export($contacts);
        exit(0);
    }


    public function kurseExportFormAction(): ResponseInterface
    {
        $jahre = [];
        for ($j = date('Y');$j >= 2015;$j--) {
            $jahre[$j] = $j;
        }
        $this->view->assign('jahre', $jahre);
        $this->view->assign('aktiv', [
            '' => 'Alle',
            '1' => 'nur Mitglieder',
            '0' => 'keine Mitglieder',
        ]);
        return $this->htmlResponse($this->view->render());
    }
    public function kurseExportAction(): ResponseInterface
    {
        $search = [];
        if ($this->request->hasArgument('search')) {
            $search = $this->request->getArgument('search');
        }
        $fields = [
            'me_addressid' => 'AdrId',
            'me_anrede_id' => 'Anrede ID',
            'me_lastname' => 'Nachname',
            'me_firstname' => 'Vorname',
            'me_firma' => 'Firma',
            'me_addon' => 'Line1', // Zusatz
            'me_address' => 'Line2',
            'me_pobox' => 'Postfach',
            'me_zip' => 'PLZ',
            'me_city' => 'Ort',
            'me_country_abrev' => 'Land',
            //'me_kanton_id' => 'Kanton',
            'me_languageid' => 'Sprache ID',
            'me_igs_invoice_id' => 'IGS Organisation Id',
            'me_geosuisse_invoice_id' => 'geosuisse Organisation Id',
        ];

        $contacts = $this->entryRepository->findExportKurse($search, array_keys($fields));

        $this->exportUtility->personsExpandAddresses($fields, $contacts);

        $excelUtility = GeneralUtility::makeInstance(ExcelUtility::class);
        $excelUtility->export(array_values($fields), $contacts, 'Kursteilnehmer', 'Kursteilnehmer', [
            'A' => '000000',
        ]);
        return $this->htmlResponse($this->view->render());
    }





    public function ajaxSearchAction(): ResponseInterface
    {
        $queryParams = $this->request->getQueryParams();
        if ($queryParams['uid'] ?? false) {
            $uid = (int)$queryParams['uid'];
            $contact = $this->entryRepository->findByUid($uid);
            $data = [
                'value' => $contact->getUid(),
                'label' => $contact->getName(),
            ];
            die(json_encode($data));
        }
        $keyword = $queryParams['q'] ?? '';
        $page = (int)($queryParams['page'] ?? 0);
        if ($page > 0) {
            $page--;
        }
        $limit = 250;
        $offset = intval($page) * $limit;

        $contacts = $this->entryRepository->findAjax($keyword, $offset, $limit + 1);
        $results = [];
        $resultsOhneName = [];

        foreach ($contacts as $contact) {
            if ($this->settings['useOwnAddressNo'] ?? false) {
                if ($contact['me_addressid']) {
                    $textNumber = ' - Nr. ' . $contact['me_addressid'];
                }
            } else {
                $textNumber = ' - Nr. ' . $contact['uid'];
            }

            if ($contact['type'] == 'Organisation') {
                $results[] = [
                    'id' => $contact['uid'],
                    'text' => $contact['me_companyname'] . ' (' . $contact['me_city'] . ')' . $textNumber,
                ];
            } else {
                $hasName = $contact['me_lastname'] || $contact['me_firstname'];
                $text = ($hasName ? $contact['me_lastname'] . ' ' . $contact['me_firstname'] : '`ohne Name`');
                $text .= ' (' . $contact['me_zip'] . ' ' . $contact['me_city'] . ')' . $textNumber;

                $entry = [
                    'id' => $contact['uid'],
                    'text' => $text,
                ];

                if ($hasName) {
                    $results[] = $entry;
                } else {
                    $resultsOhneName[] = $entry;
                }
            }
        }
        $more = count($results) > $limit;
        if ($more) {
            unset($results[$limit]);
        }

        $data = [
            'results' => $results,
            'pagination' => [
                'more' => $more,
            ],
            'debug' => $queryParams['q'] ?? '',
        ];

        header('Content-Type: application/json; charset=UTF-8');
        die(json_encode($data));
    }


    public function assignExportForm($search, $conf, $verband): void
    {
        $this->view->assign('verband', $verband);
        // set default languages from verband
        if ($verband) {
            $languages = $verband->getLanguages();
            if (!empty($languages) && !isset($conf['languages'])) {
                $conf['languages'] = [];
                foreach ($languages as $language) {
                    $conf['languages'][] = $language->getUid();
                }
            }
        }
        $this->view->assign('formats', [
            'xlsx' => 'Excel (xlsx)',
        ]);
        $this->view->assign('search', $search);
        $this->assignAdvancedSearch($search);
        $context = GeneralUtility::makeInstance(Context::class);
        $this->view->assign('languageId', $context->getPropertyFromAspect('language', 'id'));
        //var_dump($search);exit(0);
        $contacts = $this->entryRepository->findByVerband(null, $search);
        $this->view->assign('contacts', $contacts);
    }

    /**
     * action exportLink
     */
    public function exportLinkAction(): ResponseInterface
    {
        $feUserTagUids = $this->securityUtility->getFeUserTagUids();
        $feUserTagGroups = $this->securityUtility->getFeUserTagsGrouped();
        $verband = null;
        $tagLabel = 'Tags';
        if (empty($feUserTagGroups)) {
            return $this->htmlResponse('');
        }
        foreach ($feUserTagGroups as $feUserTagGroup) {
            $verband = $feUserTagGroup['tagverband']->getVerband();
            break;
        }
        $feUserTagUids['settings']['operator'] = 'OR';
        $search = [
            'showentries' => 1,
            'memberActive' => 1,
            'tags' => $feUserTagUids,
            'verband' => $verband->getUid(),
        ];
        //$control = $this->getControl();
        $conf = $this->getConf();
        $search['type'] = $this->type;
        $this->assignExportForm($search, $conf, $verband);
        $this->view->assign('userTagGroups', $feUserTagGroups);
        $this->view->assign('showUserTags', count($feUserTagUids) > 1);
        return $this->htmlResponse($this->view->render());
    }
    
    /**
     * action exportForm
     */
    public function exportFormAction(): ResponseInterface
    {
        $search = $this->getSearch();
        $control = $this->getControl();
        $conf = $this->getConf();
        $search['type'] = $this->type;

        $verbands = $this->verbandRepository->findAllWithAcl();
        $this->view->assign('verbands', $verbands);
        $verband = $this->getVerbandSetSearch($search, $verbands);

        
        $this->assignControl($control);
        $this->assignConf($conf);
        $this->assignExportForm($search, $conf, $verband);
        return $this->htmlResponse($this->view->render());
    }

    /**
     * action export
     */
    public function exportAction(): ResponseInterface
    {
        $search = $this->getSearch();
        //$control = $this->getControl();
        $conf = $this->getConf();
        $feUserTagUids = $this->securityUtility->getFeUserTagUids();

        if (!empty($conf['tags'])) {
            $search['tags'] = array_map(\INTVAL, $conf['tags']);
        } else {
            if (!empty($feUserTagUids)) {
                $search['tags'] = $feUserTagUids;
            }
        }
        $search['tags']['settings']['operator'] = 'OR';

        if (!$this->securityUtility->hasRoleAdmin('crm.contact') && !$this->securityUtility->hasGroupName($this->aclExportGroup)) {
            return $this->htmlResponse(self::ACCESS_DENIED);
        }
        
        // check access rights
        /*
        if (!$this->securityUtility->hasRoleAdmin('crm.contact') && !$this->securityUtility->hasGroupName('fe_admin')) {
            $feUserTags = $this->securityUtility->getFeUserTags();
            if (empty($feUserTags)) {
                return $this->htmlResponse(self::ACCESS_DENIED);
            }
            if (!$this->securityUtility->hasGroupName($this->aclExportGroup)) {
                return $this->htmlResponse(self::ACCESS_DENIED);
            }
            if (empty($search['tags'])) {
                return $this->htmlResponse(self::ACCESS_DENIED);
            }
            foreach ($search['tags'] as $name => $tag) {
                if ($name != 'settings' && !in_array((int)$tag, $feUserTagUids)) {
                    return $this->htmlResponse(self::ACCESS_DENIED);
                }
            }
        }
        */

        $contacts = $this->entryRepository->findByVerband(null, $search);
        
        $verbandUids = [];
        $searchVerband = null;

        $headerVerbands = [];
        if ($conf['showVerbandHeader'] ?? 0) {
            $headerVerbands = $this->securityUtility->getFrontendUserHeaderVerband();
        }

        
        $excelUtility = GeneralUtility::makeInstance(ExcelUtility::class);
        $headers = [];
        $colsFormatCodes = [];
        if (!empty($headerVerbands)) {
            foreach ($headerVerbands as $headerVerband) {
                $headers[] = $headerVerband->getName();
            }
        }

        $showCertificatesDetails = $conf['showCertificatesDetails'] ?? false; // show diplomas/Certificates with years in own columns
        $showPatent = $this->objectClass == Person::class && $this->settings['showPersonPatent'];
        $headers[] = 'ID';

        $headers[] = 'Sprache';
        $headers[] = 'Fallback-Sprache';
        $headers[] = 'Kommunikationssprache';


        $headers = array_merge($headers, $this->getExportEntryHeader());
    
        if ($showCertificatesDetails) {
            // show certificates in columns
            $emptyRowCertificates = [];
            $this->certificateRepository ??= GeneralUtility::makeInstance(CertificateRepository::class);
            $certificates = $this->certificateRepository->findByLimitToTypeOrNull($this->type);
            foreach ($certificates as $certificate) {
                $emptyRowCertificates[$certificate->getUid()] = '';
                $headers[] = $certificate->getName();
            }
        } else {
            $headers[] = $this->objectClass == Person::class ? 'Diplome' : 'Zertifikate';
        }
        if ($showPatent) {
            $headers[] = 'Patent';
            $headers[] = 'Patent Jahr';
        }


        $verbands = [];
        if (isset($search['verband']) && intval($search['verband']) > 0) {
            $verband = $this->verbandRepository->findByUid($search['verband']);
            if ($verband) {
                $searchVerband = $verband;
                $searchVerbandUid = $verband->getUid();
                //isset($search['verband']) && intval($search['verband'])>0 ? intval($search['verband']) : -1;
            }
        } else {
            $verbands = $this->verbandRepository->findAllWithAcl();
        }

        // use verbansHeader
        if (!empty($verbands)) {
            foreach ($verbands as $verband) {
                $verbandUids[] = $verband->getUid();
                $headers[] = $verband->getName();
            }
        }

        $exportTags = [];
        if ($searchVerband !== null) {
            /*
            $mitgliedschaftenUidName=[];
            foreach ($searchVerband->getMitgliedschaften() as $mitgliedschaft) {
                $mitgliedschaftenUidName[$mitgliedschaft->getUid()]=$mitgliedschaft->getName();
            }
            if (!empty($mitgliedschaftenUidName)) {
                if (count($mitgliedschaftenUidName)>1) {
                    $headers[] = $verband->getName() . ': Mitgliedschaft';
                } else {
                    // hide Mitgliedschaft if only one possibility exists
                    $mitgliedschaftenUidName =[];
                }
            }
            */

            foreach ($searchVerband->getTagsverband() as $tagverband) {
                $tags = $tagverband->getTags();
                $tagsUidName = [];
                foreach ($tags as $tag) {
                    $tagsUidName[$tag->getUid()] = $tag->getName();
                }
                $exportTags[] = [
                    'uid' => $tagverband->getUid(),
                    'header' => $tagverband->getName(),
                    'mapping' => $tagsUidName,
                ];
                //echo( $tagverband->getUid() . $tagverband->getName() . ',');
            }
            /*
            foreach ($exportTags as $exportTag) {
                $headers[]=$exportTag['header'];
            }
            */
        }


        


        if ($conf['showAdditionalAddresses']) {
            $headers = array_merge(
                $headers,
                [
                    'Privat: Corp',
                    'Privat: Line1',
                    'Privat: Line2',
                    'Privat: Road',
                    'Privat: CCode',
                    'Privat: ACode',
                    'Privat: City',
                ]
            );
        }
        if ($conf['showVerbandMembership']) {
            $excelDateFormat = 'dd.mm.yyyy'; //yyyy-mm-dd hh:mm:ss
            $verbandName = $verband->getName();
            
            $headers[] = $verbandName . ': Aktiv';
            $headers[] = $verbandName . ': Start';
            //$colsFormatCodes
            $currentCol = count($headers); // current Count of next line
            $colsFormatCodes[Coordinate::stringFromColumnIndex($currentCol)] = $excelDateFormat;
            $headers[] = $verbandName . ': End';
            $currentCol++;
            $colsFormatCodes[Coordinate::stringFromColumnIndex($currentCol)] = $excelDateFormat;

            $headers[] = $verbandName . ': Mitgliedschaft';
        }

        // show additional addresses
        if ($conf['showAdditionalAddresses']) {
            $headers = array_merge(
                $headers,
                [
                    'Korrespondenzadresse: Versandart',
                    'Korrespondenzadresse: Mode',
                    'Korrespondenzadresse: Corp',
                    'Korrespondenzadresse: Line1',
                    'Korrespondenzadresse: Line2',
                    'Korrespondenzadresse: Road',
                    'Korrespondenzadresse: CCode',
                    'Korrespondenzadresse: ACode',
                    'Korrespondenzadresse: City',
                    'Korrespondenzadresse: Postfach',
                    'Korrespondenzadresse: Firmenzusatz',
                ]
            );
            
            $titleOrganisation = $verband->getTitleOrganisationId();
            if ($titleOrganisation) {
                $headers = array_merge(
                    $headers,
                    [
                        $titleOrganisation . ': Corp',
                        $titleOrganisation . ': Line1',
                        $titleOrganisation . ': Line2',
                        $titleOrganisation . ': Road',
                        $titleOrganisation . ': CCode',
                        $titleOrganisation . ': ACode',
                        $titleOrganisation . ': City',
                    ]
                );
            }
        }

        // Show invoice address
        if ($conf['showInvoiceAddress']) {
            $headers = array_merge(
                $headers,
                [
                    'Rechnungsadresse: Versandart',
                    'Rechnungsadresse: Mode',
                    'Rechnungsadresse: Corp',
                    'Rechnungsadresse: Line1',
                    'Rechnungsadresse: Line2',
                    'Rechnungsadresse: Road',
                    'Rechnungsadresse: CCode',
                    'Rechnungsadresse: ACode',
                    'Rechnungsadresse: City',
                    'Rechnungsadresse: Postfach',
                    'Rechnungsadresse: Firmenzusatz',
                ]
            );
        }
            
        $defaultLanguage = 'D';// @todo - get Default Lanugage from verband
        // Deutsch nicht in Sprachauswahl
        if (!empty($conf['languages']) && !in_array(1, $conf['languages'])) {
            $firstLanguageUid = (int)$conf['languages'][0];
            $firstLanguage = $this->languageRepository->findByUid($firstLanguageUid);
            $defaultLanguage = $firstLanguage->getShort();
        }
        $rows = [];
        foreach ($contacts as $contact) {
            $row = [];
            if (!empty($headerVerbands)) {
                foreach ($headerVerbands as $headerVerband) {
                    //    <crm:person.verband person="{person}" verband="{verband}" as="contactVerband">
                    $headerContactVerband = $contact->getContactVerbandById($headerVerband->getUid());
                    $row[] = $headerContactVerband instanceof ContactVerband && $headerContactVerband->getActive() ? 'X' : '';
                }
            }

            $row[] = $contact->getMeAddressid();

            $languageShort = $contact->getLanguageShort();

            $row[] = $languageShort;
            $fallbackLanguage = $contact->getFallbackLanguage();
            $row[] = $fallbackLanguage instanceof Language ? $fallbackLanguage->getShort() : '';

            if (!empty($conf['languages'])) {
                $targetLanguage = null;
                
                $language = $contact->getLanguage();
                
                if ($language instanceof Language && in_array(
                    $language->getUid(),
                    $conf['languages']
                )) {
                    $targetLanguage = $language->getShort();
                }
                if ($targetLanguage === null && $fallbackLanguage instanceof Language) {
                    $targetLanguage = $fallbackLanguage->getShort();
                }
                if ($targetLanguage === null) {
                    $targetLanguage = $defaultLanguage;
                }
                $row[] = $targetLanguage;
            } else {
                $row[] = $languageShort;
            }

            
            $row = array_merge($row, $this->getExportEntryRow($contact));
            if ($showCertificatesDetails && !empty($emptyRowCertificates)) {
                // show certificates in columns
                $myRowCertificates = $emptyRowCertificates;
                foreach ($contact->getMeCertificates() as $contactCertificate) {
                    $yearAcademy = $contactCertificate->getYearAcademy() ?: 'X';
                    $myRowCertificates[$contactCertificate->getCertificate()->getUid()] = $yearAcademy;
                }
                $row = array_merge($row, $myRowCertificates);
                //var_dump($myRowCertificates);exit(0);
            } else {
                $value = '';
                foreach ($contact->getMeCertificates() as $contactCertificate) {
                    if ($value) {
                        $value .= ', ';
                    }
                    $value .= $contactCertificate->getCertificate()
->getName();
                }
                $row[] = $value;
            }
            if ($showPatent) {
                $row[] = $contact->getMePatentVorhanden() ? 'x' : '-';
                $row[] = $contact->getMePatentYear();
            }

            $searchContactVerband = false;


            // ContactVerband
            if (!empty($verbandUids)) {
                foreach ($verbandUids as $verbandUid) {
                    $contactVerband = $contact->getContactVerbandById($verbandUid);
                    $row[] = $contactVerband && $contactVerband->getActive() ? 'x' : '-';
                }
            }



            if ($searchContactVerband) {
                $tagUids = $searchContactVerband->getTagsUids();
                foreach ($exportTags as $exportTag) {
                    $rowTags = [];
                    foreach ($exportTag['mapping'] as $tagUid => $tagName) {
                        if (in_array($tagUid, $tagUids)) {
                            $rowTags[] = $tagName;
                        }
                    }
                    $row[] = implode(',', $rowTags);
                }
            }

            if ($conf['showAdditionalAddresses']) {
                if ($contact->getType() == 'Organisation') {
                    $row[] = $contact->getCompanyname() . ($contact->getAddonIntern() ? ' (' . $contact->getAddonIntern() . ')' : ''); //Corp
                } else {
                    $row[] = $contact->getMeLastname() . ' ' . $contact->getMeFirstname(); //Corp
                }
                $row[] = $contact->getMeAddon(); // Line 1
                $row[] = $contact->getMePobox() ?? ''; // Line 2
                $row[] = $contact->getMeAddress(); // Road
                $row[] = $contact->getCountryIsoCode(); // CCode
                $row[] = $contact->getMeZip(); // ACode
                $row[] = $contact->getMeCity(); // City
            }
            if ($conf['showVerbandMembership'] || $conf['showAdditionalAddresses'] || $conf['showInvoiceAddress']) {
                $contactVerband = $contact->getContactVerbandById($verband->getUid());
                if (!is_object($contactVerband)) {
                    die('error: data was changed?!');
                }
            }
            if ($conf['showVerbandMembership']) {
                $mitgliedschaft = $contactVerband->getMitgliedschaft();
                $row[] = $contactVerband->getActive();
                $row[] = Date::PHPToExcel($contactVerband->getStartDate());
                $row[] = Date::PHPToExcel($contactVerband->getEndDate());

                $row[] = $mitgliedschaft instanceof Mitgliedschaft ? $mitgliedschaft->getName() : '';
            }
            // Rechnungsadresse
            if ($conf['showAdditionalAddresses']) {
                $deliveryMode = $contactVerband->getCorrespondenceDeliveryMode(); // 1=post, 2=mail
                $row[] = LocalizationUtility::translate('delivery-mode-' . $deliveryMode, 'igCrmAdmin');
                $row[] = $contactVerband->getCombinedCorrespondenceAddressUsed(); // CorrespondenceMode
                $address = $contactVerband->getCombinedCorrespondenceAddress();
                if ($address instanceof Organisation) {
                    $row[] = $address->getMeCompanyname(); //Corp
                    $row[] = $contact->getMeLastname() . ' ' . $contact->getMeFirstname(); //Line 1
                    $row[] = $address->getMePobox() ?: $address->getMeAddon(); // Line 2
                    $row[] = $address->getMeAddress(); // Road
                    $row[] = $address->getCountryIsoCode();
                    $row[] = $address->getMeZip();
                    $row[] = $address->getMeCity();
                    $row[] = $address->getMePobox();
                    $row[] = $address->getMeAddon(); // Line 2
                } elseif ($address instanceof Person) {
                    $row[] = '';
                    $row[] = $address->getMeLastname() . ' ' . $address->getMeFirstname(); //Line 1
                    $row[] = $address->getMePobox() ?: $address->getMeAddon(); // Line 2
                    $row[] = $address->getMeAddress(); // Road
                    $row[] = $address->getCountryIsoCode();
                    $row[] = $address->getMeZip();
                    $row[] = $address->getMeCity();
                    $row[] = $address->getMePobox();
                    $row[] = $address->getMeAddon(); // Line 2
                } else {
                    // Spalten leer fueller
                    for ($i = 0; $i < 9; $i++) {
                        $row[] = '';
                    }
                }
                if ($titleOrganisation) {
                    $organisation = $contactVerband->getOrganisationId();
                    if ($organisation instanceof Contact) {
                        $row[] = $organisation->getMeLastname() . ' ' . $organisation->getMeFirstname(); //Corp
                        $row[] = $organisation->getMeAddon(); // Line 1
                        $row[] = $organisation->getMePobox() ?? ''; // Line 2
                        $row[] = $organisation->getMeAddress(); // Road
                        $row[] = $organisation->getCountryIsoCode(); // CCode
                        $row[] = $organisation->getMeZip(); // ACode
                        $row[] = $organisation->getMeCity(); // City
                    } else {
                        $row[] = ''; //Corp
                        $row[] = ''; // Line 1
                        $row[] = ''; // Line 2
                        $row[] = ''; // Road
                        $row[] = ''; // CCode
                        $row[] = ''; // ACode
                        $row[] = ''; // City
                    }
                }
            }
            if ($conf['showInvoiceAddress']) {
                $deliveryMode = $contactVerband->getInvoiceDeliveryMode(); // 1=post, 2=mail
                $row[] = LocalizationUtility::translate('delivery-mode-' . $deliveryMode, 'igCrmAdmin');
                $row[] = $contactVerband->getCombinedInvoiceAddressUsed(); //Rechnungsadresse: Mode
                $address = $contactVerband->getCombinedInvoiceAddress();
                if ($address instanceof Organisation) {
                    $row[] = $address->getMeCompanyname(); //Corp
                    $row[] = $contact->getMeLastname() . ' ' . $contact->getMeFirstname(); //Line 1
                    $row[] = $address->getMePobox() ?: $address->getMeAddon(); // Line 2
                    $row[] = $address->getMeAddress(); // Road
                    $row[] = $address->getCountryIsoCode();
                    $row[] = $address->getMeZip();
                    $row[] = $address->getMeCity();
                    $row[] = $address->getMePobox();
                    $row[] = $address->getMeAddon(); // Line 2
                } elseif ($address instanceof Person) {
                    $row[] = '';
                    $row[] = $address->getMeLastname() . ' ' . $address->getMeFirstname(); //Line 1
                    $row[] = $address->getMePobox() ?: $address->getMeAddon(); // Line 2
                    $row[] = $address->getMeAddress(); // Road
                    $row[] = $address->getCountryIsoCode();
                    $row[] = $address->getMeZip();
                    $row[] = $address->getMeCity();
                    $row[] = $address->getMePobox();
                    $row[] = $address->getMeAddon(); // Line 2
                } else {
                    // Spalten leer fueller
                    for ($i = 0; $i < 9; $i++) {
                        $row[] = '';
                    }
                }
            }

            $rows[] = $row;
        }
        $filename = isset($search['duplicate']) && $search['duplicate'] ? 'dubletten' : $this->type;
        $sheetName = $this->type;
        $excelUtility->export($headers, $rows, $filename, $sheetName, $colsFormatCodes);
        return $this->htmlResponse($this->view->render());
    }

    /**
     * action card
     */
    public function cardAction(): ResponseInterface
    {
        $search = $this->getSearch(false);
        $this->assignAdvancedSearch($search);

        $verbands = $this->verbandRepository->findAllWithAcl();
        $this->view->assign('verbands', $verbands);
        $verband = $this->getVerbandSetSearch($search, $verbands);
        $this->view->assign('verband', $verband);

        if ($this->request->hasArgument('person')) {
            $search['person'] = $this->request->getArgument('person');
        }
        $search['hasMemberCard'] = true;
        /*
        if ($search['mitgliedschaft']) {
            $this->view->assign('contactVerband', $this->contactVerbandRepository->findByUid($search['mitgliedschaft']));
        }
        */
        $contacts = $this->entryRepository->findByVerband($verband, $search, ['meAddressidWithMeFamiliyMeInvoiceTo']);
        $this->view->assign('persons', $contacts);

        // Keine New Text fallse Jahresabo ausgewählt
        $showNewText = isset($search['jahresabo']) && $search['jahresabo'] == 1 ? true : false;
        $this->view->assign('showNewText', $showNewText);

        $html = $this->view->render();
        if (isset($search['mitgliedschaft']) && !is_array($search['mitgliedschaft']) && $search['mitgliedschaft'] > 0) {
            $mitgliedschaft = $this->mitgliedschaftRepository->findByUid($search['mitgliedschaft']);
            $filename = 'Card-' . $mitgliedschaft->getCode() . '.pdf';
        } elseif (isset($search['meIsSammelinvoice']) && $search['meIsSammelinvoice'] == 1) {
            $filename = 'Card-SammelRechnung.pdf';
        } elseif (!empty($contacts) && count($contacts) == 1) {
            $contact = $contacts[0];
            $number = ($this->settings['useOwnAddressNo'] ?? false) ? $contact->getMeAddressid() : $contact->getNumber();
            $filename = 'Card-' . $number . '.pdf';
        } else {
            $filename = 'Card.pdf';
        }

        // Generate PDF here
        $pdf = GeneralUtility::makeInstance(PdfUtility::class);
        $pdf->setCssFile('EXT:ig_crm_admin/Resources/Public/Css/contactverband_pdf.css');
        $pdf->setFilename($filename);
        $pdf->setTitle('Mitgliederkarte');
        $pdf->setPageMargin('0');
        $pdf->addOption('-d 1200');
        if (isset($_GET['html'])) {
            $pdf->debug($html);
            exit(0);
        }
        $pdf->out($html);
        exit(0);
    }
    
    /**
     * action invoice (invoice preview)
     */
    public function invoiceAction(): ResponseInterface
    {
        $search = $this->getSearch();
        $search['hasInvoice'] = 1;
        $this->view->assign('search', $search);
        $conf = $this->assignGetConfOptionYear($search);
        $verband = $this->assignGetVerband($search);

        $optionAddEmpty = [
            0 => 'Betrag grösser 0',
            1 => 'Alle erstellen (CHF 0.00 als offen)',
        ];
        $this->view->assign('optionAddEmpty', $optionAddEmpty);

        $contacts = $this->entryRepository->findByVerband($verband, $search, ['meAddressidWithMeFamiliyMeInvoiceTo']);
        //echo('Time Find: ' . (microtime(true)-$time_start) . '<br />');
        $this->assignInvoices($verband, $contacts, $conf, false);
        //echo('Time assing (objects): ' . (microtime(true)-$time_start) . '<br />');
        $this->view->assign('persons', $contacts);
        return $this->htmlResponse($this->view->render());
    }

    /**
     * action invoiceCreate
     */
    public function invoiceCreateAction(): ResponseInterface
    {
        $search = $this->getSearch();
        $search['hasInvoice'] = 1;
        $this->view->assign('search', $search);
        $conf = $this->assignGetConfOptionYear($search, 'invoice');
        $verband = $this->assignGetVerband($search);

        $contacts = $this->entryRepository->findByVerband($verband, $search, ['meAddressidWithMeFamiliyMeInvoiceTo']);
        $this->assignInvoices($verband, $contacts, $conf, true);
        $this->view->assign('persons', $contacts);
        return $this->htmlResponse($this->view->render());
    }




    /**
     * action emptyNew
     */
    public function emptyNewAction(Verband $verband, array $create = []): ResponseInterface
    {
        if (!$this->securityUtility->hasPermissionWrite(null, self::$requiredRole, [$this->aclWriteGroup])) {
            return $this->htmlResponse(self::ACCESS_DENIED);
        }
        $this->view->assign('verband', $verband);
        $this->view->assign('create', $create);
        return $this->htmlResponse($this->view->render());
    }

    /**
     * action emptyCreate
     */
    public function emptyCreateAction(Verband $verband, array $create): ResponseInterface
    {
        if (!isset($create['mitgliedschaft']) || !isset($create['quantity']) || $create['quantity'] < 1 || $create['quantity'] > 200) {
            $this->addFlashMessage('Ungültige Eingabe', '', ContextualFeedbackSeverity::ERROR);
            return new ForwardResponse('emptyNew');
        }
        $nextAddress = $this->entryRepository->getMaxAddressNo() + 1;
        $create['min'] = $nextAddress;
        $create['max'] = $nextAddress + (int)$create['quantity'] - 1;
        $mitgliedschaft = $this->mitgliedschaftRepository->findByUid((int) $create['mitgliedschaft']);
        $contacts = [];
        for ($i = 0; $i < (int)$create['quantity']; $i++) {
            $person = GeneralUtility::makeInstance($this->objectClass);
            $contactVerband = GeneralUtility::makeInstance(ContactVerband::class);
            $contactVerband->setActive(false);
            $contactVerband->setVerband($verband);
            $contactVerband->setMitgliedschaft($mitgliedschaft);

            $person->setMeAddressid($nextAddress + $i);
            $person->addMeContactVerband($contactVerband);
            $this->securityUtility->setAcl($person, $verband->getUid());
            $contacts[] = $person;
            $this->securityUtility->setAcl($person);
            $this->entryRepository->add($person);
        }

        $this->view->assign('verband', $verband);
        $this->view->assign('mitgliedschaft', $mitgliedschaft);
        $this->view->assign('persons', $contacts);
        $this->view->assign('create', $create);
        return $this->htmlResponse($this->view->render());
    }



    public function postlabelAction(Verband $verband, Contact $contact, bool $return = false): ResponseInterface
    {
        $clientId = $verband->getPostClientId();
        $clientSecret = $verband->getPostClientSecret();
        $frankingLicense = $verband->getPostFrankingLicense();
        //$customerNumber = '34148418';
        $requiredScope = 'DCAPI_BARCODE_READ'; // Example scope

        $this->authUtility = GeneralUtility::makeInstance(AuthUtility::class);
        if ($this->useCustomLabel) {
            $this->labelUtility = GeneralUtility::makeInstance(CustomLabelUtility::class);
        } else {
            $this->labelUtility = GeneralUtility::makeInstance(AddressLabelUtility::class);
        }
        $token = $this->authUtility->getAccessToken($clientId, $clientSecret, $requiredScope);
        $this->labelUtility->setToken($token);
        //$this->labelUtility->setPrintPreview(false);
        $this->labelUtility->setFrankingLicense($frankingLicense);
        $this->labelUtility->setPrintAddresses(PrintAddresses::RECIPIENT_AND_CUSTOMER);

        // remove illigal characters 
        $recipientName1 = str_replace(['|', "\\"],'',$contact->getName());

        $customer = GeneralUtility::makeInstance(Customer::class);
        if ($return) {
            $this->labelUtility->setPrintAddresses(PrintAddresses::ONLY_RECIPIENT);
        }
        $customer->setName1($verband->getName());
        $verbandStreet = $verband->getStreet();
        if ($verband->getStreetNumber()) {
            $verbandStreet .= ' ' . trim($verband->getStreetNumber());
        }
        $customer->setStreet($verbandStreet);
        $customer->setZip($verband->getZip());
        $customer->setCity($verband->getCity());
        $customer->setDomicilePostOffice($verband->getZip() . ' ' . $verband->getCity());
            
        //$customer->setCountry('CH');
        //$customer->setPobox('Postfach');
        //$customer->setDomicilePostOffice('3074 Muri b. Bern');

        $this->labelUtility->setCustomer($customer);
        //$this->labelUtility->setCustomerNumber($customerNumber);

        $recipient = GeneralUtility::makeInstance(Recipient::class);
        if ($return) {
            $recipient->setName1($verband->getName());
            //$recipient->setName1('Muster');
            $recipient->setStreet($verbandStreet);
            $recipient->setZip($verband->getZip());
            $recipient->setCity($verband->getCity());
            $przl = ['GAS', 'ECO']; // RINL
        } else {
            $recipient->setName1($recipientName1);
            //$recipient->setName1('Muster');
            $recipient->setStreet(trim($contact->getAddress()));
            //$recipient->setStreet('Aarestrasse');
            //$recipient->setHouseNo('32');
            $recipient->setZip($contact->getZip());
            $recipient->setCity($contact->getCity());
            $przl = ['ECO']; // RINL
            //$recipient->setCountry('CH');
        }
        $item = GeneralUtility::makeInstance(Item::class);
        $item->setRecipient($recipient);
        $item->setAttributesPrzl($przl);
        try {
            if ($this->useCustomLabel) {
                $this->labelUtility->setDocumentCreator('IG CRM');
                $this->labelUtility->setDocumentAuthor($verband->getName());
                //$this->labelUtility->setDocumentTitle('PEDOS AG');

                //$item->setItemID('ITEM12338'); //ab 45
                //$item->setItemNumber('12338');

                /*
                // Test Daten
                $beilagen = [];
                $beilagen['P'] = '- Messprotokoll';
                $beilagen['R'] = '- Rechnung';

                $anzahlDosimeter = 1;
                $text_anzahl = $anzahlDosimeter > 0 ? $anzahlDosimeter : '';
                $textCustomerNumber = 'B99090';
                $headerLines = [ $textCustomerNumber, $text_anzahl];
                if (!empty($beilagen)) {
                    $headerLines[] = implode('', array_keys($beilagen));
                }
                $item->setHeaderLines($headerLines);
                $footerLines = array_values($beilagen);
                $item->setFooterLines($footerLines);
                */

                $barcode = $this->labelUtility->addLabel($item, LabelType::BARCODE);

                return $this->responseFactory->createResponse()
                    ->withHeader('Content-Type', 'application/pdf')
                    ->withBody($this->streamFactory->createStream($this->labelUtility->getPdfContent()));
                throw new PropagateResponseException($response, 200);

            } else {
                // address label from post (barcode and address)
                $data = $this->labelUtility->generateAddressLabel($item);
                return $this->responseFactory->createResponse()
                    ->withHeader('Content-Type', 'application/pdf')
                    ->withBody($this->streamFactory->createStream($data['pdf']));
                throw new PropagateResponseException($response, 200);

            }
        } catch (\Exception $e) {
            return $this->htmlResponse('❌ POST API Fehler: ' . $e->getMessage());
        }

    }


    public function assignCrmKantone(bool $addEmpty = true): void
    {
        $this->kantonRepository = GeneralUtility::makeInstance(KantonRepository::class);
        $crmkantone = $this->kantonRepository->findAll()
            ->toArray();
        if ($addEmpty) {
            $crmkantone[] = [
                'uid' => -1,
                'beschriftung' => '-- Ohne --',
                'kaName' => '-- Ohne --',
                'kaAbkuerzung' => '',
            ];
        }

        $this->view->assign('crmkantone', $crmkantone);
    }

    /**
     * Returns the hashed password
     *
     * @param string $password
     *
     * @return string
     */
    protected function getHashedPassword($password)
    {
        $hashFactory = GeneralUtility::makeInstance(PasswordHashFactory::class);
        $hashInstance = $hashFactory->getDefaultHashInstance('FE');
        return $hashInstance->getHashedPassword($password);
    }
    protected function assignGetConfOptionYear(array $search, string $forwardAction = null)
    {
        $conf = $this->request->hasArgument('conf') ? $this->request->getArgument('conf') : [];

        // default values
        $conf['invoiceCreate'] ??= 1;
        $conf['invoiceUpdate'] ??= 0;
        
        $currentYear = date('m') > 7 ? date('Y') + 1 : date('Y');
        $year = (int) ($conf['year'] ?? $currentYear);
        $conf['year'] = $year;
        $this->periode = $year;
        $this->addYear = $year - date('Y');
        if ($forwardAction !== null) {
            $oldYear = (int) ($conf['oldYear'] ?? 0);
            if (!$year || $oldYear != $year) {
                return (new ForwardResponse($forwardAction))->withArguments([
                    'search' => $search,
                    'conf' => $conf,
                ]);
            }
        }
        
        $this->view->assign('conf', $conf);
        $optionYear = [];
        for ($j = $currentYear - 2; $j <= $currentYear + 1; $j++) {
            $optionYear[$j] = $j;
        }
        $this->view->assign('optionYear', $optionYear);
        return $conf;
    }
    
    protected function assignGetVerband($search)
    {
        if ($search['verband']) {
            $verband = $this->verbandRepository->findByUid($search['verband']);
            $this->view->assign('verband', $verband);
            return $verband;
        }
        return null;
    }

    protected function assignOpenerProperty()
    {
        if ($this->request->hasArgument('openerProperty')) {
            $this->view->assign('openerProperty', $this->request->getArgument('openerProperty'));
        } else {
            die('openerProperty missing');
        }
    }

    protected function assignInvoices($verband, $contacts, $conf, $doCreate = false)
    {
        $invoices = [];
        $invoiceRepository = GeneralUtility::makeInstance(InvoiceRepository::class);
        $costCenterRepository = GeneralUtility::makeInstance(CostCenterRepository::class);

        $useMembership = true;
        $doInvoiceCreate = (bool)$conf['invoiceCreate'] ?? false;
        $doInvoiceUpdate = (bool)$conf['invoiceUpdate'] ?? false;
        
        if ($verband) {
            $memberships = $this->mitgliedschaftRepository->findByVerbandAndType($verband, $this->type);
            //$memberships = $verband->getMitgliedschaften();
            if (count($memberships) == 0) {
                $useMembership = false;
            }
        }
        
        $total = [
            //'amount' => 0,
            'invoiceTotal' => 0,
            'amountNew' => 0,
            'amountOld' => 0,
            'amountUpdate' => 0,
            'count' => [
                'all' => 0,
                'new' => 0,
                'old' => 0,
                'newWithAmount' => 0,
                'error' => 0,
                'unuesedStatus' => 0,
            ],
        ];
        $amountMembership = null;
        
        // invoice to aufloesen
        $personToInvoice = [];
        $personSubEntries = [];
        foreach ($contacts as $person) {
            $invoiceToPerson = $person->getMeInvoiceTo();
            if ($invoiceToPerson instanceof Person) {
                $invoiceToPersonUid = $invoiceToPerson->getUid();
                if (!isset($personSubEntries[$invoiceToPersonUid])  || !is_array($personSubEntries[$invoiceToPersonUid])) {
                    $personSubEntries[$invoiceToPersonUid] = [];
                }
                $personSubEntries[$invoiceToPersonUid][] = $person;
            } else {
                $personToInvoice[] = $person;
            }
        }
        foreach ($personToInvoice as $person) {
            $error = false;
            $errorMessage = '';
            $total['count']['all']++;
            $oldTotal = null;
            $contactVerband = $person->getContactVerbandByVerband($verband);
            if ($useMembership) {
                $mitgliedschaft = $contactVerband->getMitgliedschaft();
                if (!$mitgliedschaft instanceof Mitgliedschaft) {
                    $total['count']['error']++;
                    $invoices[] = [
                        'person' => $person,
                        'invoice' => null,
                        'status' => [
                            'error' => true,
                            'message' => 'ohne Mitgliedschaft',
                            'isNew' => false,
                        ],
                    ];
                    continue;
                }
            } else {
                $mitgliedschaft = null;
            }

            $invoice = $invoiceRepository->findOneByVerbandPeriodeEntry(
                $verband->getUid(),
                $this->periode,
                $person->getUid(),
                $this->type
            );//'tx_igscrm_domain_model_contact'
            $invoicestextProducts = '';

            $updateOrInsert = false;

            $ageInYear = $person->getMeAlterWithYear() + $this->addYear;
            $invoicestext = $mitgliedschaft ? $mitgliedschaft->getInvoicestextWithAlter($ageInYear) : '';
            $amountMembership = $contactVerband->getMembershipAmount($this->periode);
            
            if (is_object($invoice)) {
                $isNew = false;
                $amount = 0;
                $oldTotal = $invoice->getTotal();
                $total['amountOld'] += $oldTotal;
                $total['count']['old']++;
                $status = $invoice->getStatus();
                if (!$status || !($status->getIsDraft() || ($status->getIsSent() && !$status->getIsReminder()))) {
                    $total['count']['unuesedStatus']++;
                }
                if ($doInvoiceUpdate && $status->getIsDraft()) {
                    $amount += $this->invoiceAddInvoiceItems(
                        $invoice,
                        $contactVerband,
                        $verband,
                        $amountMembership,
                        $invoicestext
                    );
                    if ($doCreate) {
                        $invoiceRepository->updateAndCalculate($invoice);
                    } else {
                        $invoiceRepository->calculate($invoice);
                    }
                    $total['amountUpdate'] += $invoice->getTotal() - $oldTotal;
                }
            } else { // new invoice
                if (!$doInvoiceCreate) {
                    continue;
                }
                $total['count']['new']++;
                $isNew = true;
                // totoal amount of this invoice
                $amount = 0;
                //$contactVerband->getTotalBetrag($this->periode);

                
                if ($amountMembership > 0) {
                    $total['count']['newWithAmount']++;
                }
                // Bei Betrag werden weitere Abos addiert
                if (!empty($personSubEntries[$person->getUid()])) {
                    $mitgliedschafts = [];
                    $mitgliedschafts[$mitgliedschaft->getCode()] = 1;
                    foreach ($personSubEntries[$person->getUid()] as $personSubEntry) {
                        $subContactVerband = $personSubEntry->getContactVerbandByVerband($verband);
                        $subMitgliedschaft = $subContactVerband->getMitgliedschaft();
                        $amountMembership += $subContactVerband->getMembershipAmount($this->periode);
                        if (isset($mitgliedschafts[$subMitgliedschaft->getCode()])) {
                            $mitgliedschafts[$subMitgliedschaft->getCode()]++;
                        } else {
                            $mitgliedschafts[$subMitgliedschaft->getCode()] = 1;
                        }
                    }
                    $invoicestext = $verband->getInvoiceBaseText() ? $verband->getInvoiceBaseText() . "\n" : '';
                    $invoicestextProducts = '';
                    foreach ($mitgliedschafts as $code => $quantity) {
                        $invoicestextProducts .= ($invoicestextProducts ? ', ' : '') . $quantity . ' x ' . $code;
                    }
                    $invoicestext .= $invoicestextProducts;
                }
                /*
                  if ($person->getUid()==482) {
                  foreach($personSubEntries[$person->getUid()] as $p) {
                  var_dump($p->getUid() .':'. $p->getLastnameFirstname());
                  }
                  exit(0);
                  }
                */
                
                // create new annual invoice
                $invoice = GeneralUtility::makeInstance(InvoiceAnnual::class);
                $invoice->setStatusDefault();
                
                
                $amount += $this->invoiceAddInvoiceItems(
                    $invoice,
                    $contactVerband,
                    $verband,
                    $amountMembership,
                    $invoicestext
                );

                // general stuff
                $invoice->setTaxRate($verband->getTaxRate());
                $invoice->setDebitor($this->type, $person->getUid());
                $invoice->setPeriode($this->periode);
                $invoice->setVerbandId($verband->getUid());
                
                if ($doCreate && ($amount !== null || (int) $conf['addEmpty'])) {
                    if ($this->debugInvoice) {
                        echo 'debug PersonController.php $invoiceRepository->add deaktiviert<br />';
                    } else {
                        $invoiceRepository->add($invoice);
                    }
                } else {
                    // not added, so total not calculated
                    $invoiceRepository->calculate($invoice);
                }
                if ($amount > 0) {
                    $total['amountNew'] += $amount;
                } else {
                    $amount = null;
                }
            }
            $total['invoiceTotal'] += $invoice->getTotal();
            $invoices[] = [
                'person' => $person,
                'invoice' => $invoice,
                'old' => [
                    'total' => $oldTotal,

                ],
                'comment' => $invoicestextProducts,
                'status' => [
                    'error' => $error,
                    'isNew' => $isNew,
                ],
            ];
        }
        if ($doCreate) {
            $persistenceManager = GeneralUtility::makeInstance(PersistenceManager::class);
            $persistenceManager->persistAll();
        }
        $this->view->assign('doCreate', $doCreate);
        $this->view->assign('doInvoiceUpdate', $doInvoiceUpdate);
        $this->view->assign('total', $total);
        $this->view->assign('invoices', $invoices);
    }

    protected function invoiceAddInvoiceItems(
        Invoice $invoice,
        ContactVerband $contactVerband,
        Verband $verband,
        $amountMembership,
        $invoicestext
    ) {
        $amount = 0;
        $invoice->clearInvoiceItem();
        // add amount for journal
        $invoiceitem = InvoiceItemJournal::create($contactVerband, $this->periode);
                    
        if ($invoiceitem !== null) {
            $invoice->addInvoiceItem($invoiceitem);
            $amount += $invoiceitem->getAmount();
        }
        // add amount for membership
        if ($amountMembership !== null) {
            $invoiceitem = InvoiceItemMembership::create($contactVerband, $this->periode);
                    
            // overrite text and amount for panoramarundweg (invoice to and family members)
            // @todo remove
            if ($verband->getName() == 'PRT') {
                $invoiceitem->setDescription($invoicestext);
                $invoiceitem->setIsLocalText(true);
                $invoiceitem->setTotalInkl($amountMembership, $verband->getTaxRate());
            }

            $invoice->addInvoiceItem($invoiceitem);
            $amount += $invoiceitem->getAmount();
        }
                
        // extra amount from client/verband
        $extraAmount = $contactVerband->getVerbandExtraBetragValue();
        if ($extraAmount) {
            $invoiceItem = InvoiceItem::createWithDescription(
                $contactVerband->getVerband(),
                $contactVerband->getVerband()->getExtraBetragTitle(),
                $extraAmount
            );
            if ($invoiceItem !== null) {
                $invoice->addInvoiceItem($invoiceItem);
                $amount += $invoiceitem->getAmount();
            }
        }

        
        return $amount;
    }

    protected function getControl()
    {
        return $this->request->hasArgument('control') ? $this->request->getArgument('control') : [];
    }
    protected function assignControl(array $control)
    {
        $this->view->assign('control', $control);
    }
    protected function getConf()
    {
        $conf = $this->request->hasArgument('conf') ? $this->request->getArgument('conf') : [];
        if (!isset($conf['period'])) {
            $conf['period'] = PeriodUtility::getCurrentPeriod();
        }
        return $conf;
    }
    protected function assignConf(array $conf)
    {
        $this->view->assign('conf', $conf);
    }
    protected function assignMitgliedschaften(Verband $verband = null, bool $addWithout = false)
    {
        if ($verband === null) {
            return;
        }
        $verbandMitgliedschaften = $this->mitgliedschaftRepository->findByVerbandAndType($verband, $this->type)
->toArray();
        if ($addWithout && !empty($verbandMitgliedschaften)) {
            $verbandMitgliedschaften[] = [
                'uid' => -1,
                'name' => '--- Ohne Mitgliedschaft ---',
            ];
        }
        $this->view->assign('verbandMitgliedschaften', $verbandMitgliedschaften);
    }
        

    protected function getSearch($setActive = true)
    {
        $search = [];
        if ($this->request->hasArgument('@search')) {
            $search = array_merge($search, $this->request->getArgument('@search'));
            $search['showentries'] = true;
        } elseif ($this->request->hasArgument('_search')) {
            $search = array_merge($search, $this->request->getArgument('_search'));
            $search['showentries'] = true;
        } elseif ($this->request->hasArgument('search')) {
            $search = array_merge($search, $this->request->getArgument('search'));
        } else {
            $search = $this->searchDefault;
            if ($this->settings['verbandUid'] ?? false) {
                $search['verband'] = (int)$this->settings['verbandUid'];
            }
        }
        if ($setActive && isset($search['verband']) && $search['verband'] > 0 && !isset($search['memberActive'])) {
            $search['memberActive'] = 1;
        }
        // remove __trustedProperteis etc.
        foreach ($search as $name => $value) {
            if (str_starts_with($name, '__')) {
                unset($search[$name]);
            }
        }
        return $search;
    }

    protected function assignAdvancedSearch(array $search)
    {
        $this->view->assign('optionsActive', [
            '1' => 'Aktive',
            'current' => 'Aktive (Ein-/Austrittsdatum)',
            '0' => 'Inaktive',
        ]);
        //$this->view->assign('optionsActive', ['1' => 'Aktive', '0' => 'Inaktive/Leer']);
        $this->view->assign('optionsFamily', [
            '1' => 'Familie',
            '0' => 'Keine Familie',
        ]);
        $this->view->assign('optionsSammelinvoice', [
            '1' => 'Sammelrechnung',
            0 => 'Keine Sammelr.',
        ]);
        $this->view->assign('optionsJahresabo', [
            '1' => 'Jahresabo',
            '0' => 'Kein Jahresabo',
        ]);
        $this->view->assign('optionsBoolean', [
            '1' => 'Ja',
            '0' => 'Nein',
        ]);
        $this->view->assign('optionsVersand', [
            'letter' => 'Brief',
            'email' => 'E-Mail',
        ]);
        $crmLanguages = $this->languageRepository->findAll();
        $this->view->assign('crmLanguages', $crmLanguages);
        $this->confUtility ??= GeneralUtility::makeInstance(ConfUtility::class);
        $crmVertorbene = $this->confUtility->getCrmVertorbene($this->type);
        $this->view->assign('crmVertorbene', $crmVertorbene);
        $this->categoryOrganisationRepository = GeneralUtility::makeInstance(CategoryOrganisationRepository::class);
        $this->view->assign('optionsLogicalOperators', $this->optionsLogicalOperators);
        //if ($this->type == 'Organisation') {
        //}
        $this->view->assign('categories', $this->categoryOrganisationRepository->findByLimitToTypeOrNull($this->type));
        $this->anredeRepository = GeneralUtility::makeInstance(AnredeRepository::class);
        $this->view->assign('anreden', $this->anredeRepository->findAll());
        $advancedBoxIsOpen = false;
        if (!empty($search)) {
            foreach ($search as $name => $value) {
                // is date and value set
                if (in_array($name, ['memberDateFrom', 'memberDateTo']) && !empty($value['date'])) {
                    $advancedBoxIsOpen = true;
                } elseif (!str_starts_with($name, '__') && !in_array(
                    $name,
                    ['showentries', 'dp-submit-button', 'type', 'meName', 'meZipCity', 'verband', 'memberActive', 'memberDateFrom', 'memberDateTo']
                ) && $value !== '') {
                    $advancedBoxIsOpen = true;
                    //echo('<b>'. $name .'='. $value .'</b><br />');
                }
                // echo($name .'='. $value .'<br />');
            }
        }
        $this->view->assign('advancedBoxIsOpen', $advancedBoxIsOpen);

        $this->certificateRepository = GeneralUtility::makeInstance(CertificateRepository::class);
        $certificates = $this->certificateRepository->findByLimitToTypeOrNull($this->type);
        $this->view->assign('certificates', $certificates);
        
        $this->categoryOrganisationRepository = GeneralUtility::makeInstance(CategoryOrganisationRepository::class);
        $categories = $this->categoryOrganisationRepository->findByLimitToTypeOrNull($this->type)
->toArray();
        if (!empty($categories)) {
            $categories[] = [
                'uid' => -1,
                'coName' => '--- Ohne ---',
            ];
        }
        $this->view->assign('categories', $categories);

        $this->view->assign('crmboolean', [
            '1' => 'Ja',
            '0' => 'Nein',
        ]);
    }
    protected function getVerbandSetSearch(&$search, $verbands)
    {
        if ($verbands !== null && count($verbands) == 1 && !$this->securityUtility->hasRoleAdmin('crm.contact')) {
            $search['verband'] = $verbands[0]->getUid();
        }
        
        if ($search['verband'] ?? false) {
            return $this->verbandRepository->findByUid($search['verband']);
        }
        return null;
    }
    protected function assignFormfields()
    {
        $this->anredeRepository = GeneralUtility::makeInstance(AnredeRepository::class);
        $this->view->assign('anreden', $this->anredeRepository->findAll());

        $this->categoryOrganisationRepository = GeneralUtility::makeInstance(CategoryOrganisationRepository::class);
        $this->view->assign('categories', $this->categoryOrganisationRepository->findByLimitToTypeOrNull($this->type));

        $this->certificateRepository = GeneralUtility::makeInstance(CertificateRepository::class);
        $this->view->assign('certificates', $this->certificateRepository->findByLimitToTypeOrNull($this->type));

        $countryRepository = GeneralUtility::makeInstance(CountryRepository::class);
        $countries = $countryRepository->getIsoCountryName();
        $this->view->assign('countries', $countries);

        $this->emailcategoryRepository = GeneralUtility::makeInstance(EmailcategoryRepository::class);
        $this->view->assign('emailcategories', $this->emailcategoryRepository->findAll());

        $this->kantonRepository = GeneralUtility::makeInstance(KantonRepository::class);
        $this->view->assign('kantone', $this->kantonRepository->findAll());

        $this->languageRepository = GeneralUtility::makeInstance(LanguageRepository::class);
        $this->view->assign('languages', $this->languageRepository->findAll());

        $this->phonecategoryRepository = GeneralUtility::makeInstance(PhonecategoryRepository::class);
        $this->view->assign('phonecategories', $this->phonecategoryRepository->findAll());

        $this->view->assign('verbaende', $this->verbandRepository->findAllWithAcl());
    }



    protected function createTenantTabs($tenants, Contact $contact)
    {
        $tabs = [];
        $invoiceRepository = GeneralUtility::makeInstance(InvoiceRepository::class);
        $creditRepository = GeneralUtility::makeInstance(CreditRepository::class);

        foreach ($tenants as $tenant) {
            //echo( $verband->getUid() .'='. $verband->getName() .'<br />');
            $tabs[] = [
                'name' => 'verband-' . $tenant->getUid(),
                'verband' => $tenant,
                'invoices' => $invoiceRepository->findByVerbandPerson(
                    $tenant->getUid(),
                    $contact->getUid(),
                    $this->type
                ),
                'credits' => $creditRepository->findByTenantDebitor($tenant->getUid(), $contact->getUid()),
            ];
        }

        return $tabs;
    }
       

    
    
    protected function getExportEntryHeader()
    {
        $headers = [];
        $headers[] = 'Nachname';
        $headers[] = 'Vorname';
        $headers[] = 'Addon';
        $headers[] = 'Postfach';
        $headers[] = 'Adresse';
        $headers[] = 'Land';
        $headers[] = 'PLZ';
        $headers[] = 'Ort';
        $headers[] = 'Kanton';

        $headers[] = 'E-Mail';
        // Telefon
        // Fax
        // URL
        
        $headers[] = 'Titel';
        $headers[] = 'Anrede';
        $headers[] = 'Anrede DE';
        $headers[] = 'Briefanrede Name D+F';
        $headers[] = 'Briefanrede Name';
        $headers[] = 'Briefanrede D+F';
        $headers[] = 'Briefanrede';
        $headers[] = 'Geburtsjahr';
        
        return $headers;
    }
    protected function getExportEntryRow($contact)
    {
        $row = [];
        if ($contact->getType() == 'Organisation') {
            $row[] = $contact->getCompanyname();
            $row[] = $contact->getAddonIntern();
        } else {
            $row[] = $contact->getMeLastname();
            $row[] = $contact->getMeFirstname();
        }
        $row[] = $contact->getMeAddon();
        $row[] = $contact->getMePobox() ?? '';
        $row[] = $contact->getMeAddress();
        $row[] = $contact->getCountryIsoCode();
        $row[] = $contact->getMeZip();
        $row[] = $contact->getMeCity();
        $row[] = $contact->getStateAbbreviation();
        $row[] = $contact->getMeEmail();
        $row[] = $contact->getMeTitel(); // Titel

        $row[] = $contact->getAnrede(); // Anrede D,F,I
        $row[] = $contact->getMeAnrede(); // Anrede D
        $row[] = $contact->getBriefanredeDF();
        $row[] = $contact->getBriefanrede();
        $row[] = $contact->getBriefanredeOhneNameDF();
        $row[] = $contact->getBriefanredeOhneName();
        $row[] = $contact->getMeYearOfBirth(); //Geburtsjahr
        return $row;
    }
}
