<?php

namespace Internetgalerie\IgCrmAdmin\Controller;

use Internetgalerie\IgCrmAdmin\Controller\TYPO3\CMS\Extbase\Annotation\IgnoreValidation;
use Internetgalerie\IgDatapoolFe\Controller\ActionController;
use Internetgalerie\IgsCrm\Domain\Model\ContactTag;
use Internetgalerie\IgsCrm\Domain\Model\Tag;
use Internetgalerie\IgsCrm\Domain\Model\TagRole;
use Internetgalerie\IgsCrm\Domain\Repository\ContactTagRepository;
use Internetgalerie\IgsCrm\Domain\Repository\TagRoleRepository;
use Psr\Http\Message\ResponseInterface;

class ContactTagController extends ActionController
{
    protected $objectClass = ContactTag::class;
    /**
     * tagRoleRepository
     *
     * @var TagRoleRepository
     */
    protected $tagRoleRepository = null;

    /**
     * contactTagRepository
     *
     * @var contactTagRepository
     */
    protected $contactTagRepository = null;

    public function injectContactTagRepository(ContactTagRepository $contactTagRepository): void
    {
        $this->contactTagRepository = $contactTagRepository;
    }

    public function injectTagRoleRepository(TagRoleRepository $tagRoleRepository): void
    {
        $this->tagRoleRepository = $tagRoleRepository;
    }


    /**
     * action list
     */
    public function listAction(Tag $tag): ResponseInterface
    {
        $this->view->assign('tag', $tag);
        $verband = $tag->getVerband() ?: $tag->getTagVerband()
->getVerband();
        $this->view->assign('verband', $verband);
        $tagRoles = $this->tagRoleRepository->findBy([
            'tag' => $tag,
        ]);
        $this->view->assign('tagRoles', $tagRoles);
        if ($this->request->hasArgument('activeTab')) {
            $activeTab = $this->request->getArgument('activeTab');
        }
        $this->view->assign('activeTab', $activeTab);
        return $this->htmlResponse($this->view->render());
    }
    
    /**
     * action new
     */
    #[IgnoreValidation([
        'argumentName' => 'tagRole',
    ])]
    public function newAction(Tag $tag, TagRole $tagRole = null): ResponseInterface
    {
        $this->view->assign('tag', $tag);
        $verband = $tag->getVerband() ?: $tag->getTagVerband()
->getVerband();
        $this->view->assign('verband', $verband);
        if ($this->request->hasArgument('activeTab')) {
            $activeTab = $this->request->getArgument('activeTab');
        }
        $this->view->assign('activeTab', $activeTab);
        return $this->htmlResponse($this->view->render());
    }

    /**
     * action edit
     */
    #[IgnoreValidation([
        'argumentName' => 'tagRole',
    ])]
    public function editAction(TagRole $tagRole, Tag $tag): ResponseInterface
    {
        $this->view->assign('tag', $tag);
        $verband = $tag->getVerband() ?: $tag->getTagVerband()
->getVerband();
        $this->view->assign('verband', $verband);
        $this->view->assign('tagRole', $tagRole);

        if ($this->request->hasArgument('activeTab')) {
            $activeTab = $this->request->getArgument('activeTab');
        }
        $this->view->assign('activeTab', $activeTab);
        return $this->htmlResponse($this->view->render());
    }

    /**
     * action create
     */
    public function createAction(TagRole $tagRole): ResponseInterface
    {
        $this->tagRoleRepository->add($tagRole);
        $this->addFlashMessage('Der Eintrag wurde erstellt.');
        $args = [
            'tag' => $tagRole->getTag(),
        ];
        if ($this->request->hasArgument('activeTab')) {
            $args['activeTab'] = $this->request->getArgument('activeTab');
        }
        return $this->redirectWithSearch('list', null, null, $args);
    }

    /**
     * action update
     */
    public function updateAction(TagRole $tagRole): ResponseInterface
    {
        $this->tagRoleRepository->update($tagRole);
        $this->addFlashMessage('Der Eintrag wurde aktualisiert.');
        $args = [
            'tag' => $tagRole->getTag(),
        ];
        if ($this->request->hasArgument('activeTab')) {
            $args['activeTab'] = $this->request->getArgument('activeTab');
        }
        return $this->redirectWithSearch('list', null, null, $args);
    }

    /**
     * action confirmDelete
     */
    public function confirmDeleteAction(TagRole $tagRole): ResponseInterface
    {
        $this->view->assign('tag', $tagRole->getTag());
        $this->view->assign('tagRole', $tagRole);
        if ($this->request->hasArgument('activeTab')) {
            $activeTab = $this->request->getArgument('activeTab');
        }
        $this->view->assign('activeTab', $activeTab);
        return $this->htmlResponse($this->view->render());
    }

    /**
     * action delete
     */
    public function deleteAction(TagRole $tagRole): ResponseInterface
    {
        $tag = $tagRole->getTag();
        $this->tagRoleRepository->remove($tagRole);
        $this->addFlashMessage('Der Eintrag wurde aktualisiert.');
        $args = [
            'tag' => $tag,
        ];
        if ($this->request->hasArgument('activeTab')) {
            $args['activeTab'] = $this->request->getArgument('activeTab');
        }
        return $this->redirectWithSearch('list', null, null, $args);
    }

    /**
     * action ajaxUpdate
     */
    public function ajaxUpdateAction(): ResponseInterface
    {
        // the call time for client, the client only accept the newst response
        $calltime = $this->request->hasArgument('calltime') ? (int) $this->request->getArgument('calltime') : 0;
        // the data params
        $data = $this->request->hasArgument('data') ? $this->request->getArgument('data') : [];
        $contactTags = $data['contactTag'] ?? [];
        $dataTagRole = $data['tagRole'] ?? null;
        //$dataContactTagField = $data['contactTagField'] ?? [];
        $dataTag = $data['tag'] ?? null;
        if (!empty($contactTags) && $dataTagRole !== null) {
            $dataTagRole = (int) $dataTagRole;
            $dataTag = (int) $dataTag;

            if ($dataTagRole > 0) {
                $tagRole = $this->tagRoleRepository->findByUid($dataTagRole);
            } else {
                $tagRole = null;
            }
            $updateRoleForPersonUids = [];
            foreach ($contactTags as $personUid => $contactTag) {
                $personUid = (int) $personUid;
                if ($personUid > 0) {
                    if ((int) $contactTag['tagRole'] === 1 || $contactTag['tagRole'] === 'true') {
                        $contactTag['tagRole'] = $dataTagRole;
                        $updateRoleForPersonUids[] = $personUid;
                    } else {
                        unset($contactTag['tagRole']);
                    }
                    $html = 'OK: ' . $this->contactTagRepository->rawInsertUpdate(
                        $personUid,
                        $dataTag,
                        $dataTagRole,
                        $contactTag
                    );
                    /*
                    if (!empty($dataContactTagField[$contactTag['uid']])) {
                        foreach ($dataContactTagField[$contactTag['uid']] as $contactTagField) {
                            $this->contactTagFieldRepository->rawInsertUpdate($contactTagField);
                        }
                    }
                    */
                    /*
                    if ($tagRole === null) {
                        //$this->tagRoleRepository->rawDelete($person, $tag);
                    } else {
                        $this->tagRoleRepository->rawInsertUpdate($person, $tag, $dataTagRole);
                    }
                    */
                }
            }

            //$html = 'OK';
            $error = 0;
        } else {
            $html = 'ERROR';
            $error = 1;
        }


        $json = json_encode([
            'html' => $html,
            'data' => $data,
            'updateRoleForPersonUids' => $updateRoleForPersonUids,
            'tagRoleName' => $tagRole instanceof TagRole ? $tagRole->getName() : '',
            'error' => $error,
            'calltime' => $calltime,
        ]);
        return $this->jsonResponse($json);
        // throw new PropagateResponseException($response, 200);
    }
}
