<?php

namespace Internetgalerie\IgCrmAdmin\Controller;

use DateTime;
use Ig\IgFibu\Domain\Model\InvoiceItem;
use Ig\IgFibu\Domain\Repository\InvoiceRepository;
use Ig\IgFibu\Utility\InvoiceUtility;
use Internetgalerie\IgCrmAdmin\Controller\TYPO3\CMS\Extbase\Annotation\IgnoreValidation;
use Internetgalerie\IgRender\Utility\PdfUtility;
use Internetgalerie\IgsCrm\Domain\Model\Contact;
use Internetgalerie\IgsCrm\Domain\Model\ContactVerband;
use Internetgalerie\IgsCrm\Domain\Model\InvoiceAnnual;
use Internetgalerie\IgsCrm\Domain\Model\InvoiceItemJournal;
use Internetgalerie\IgsCrm\Domain\Model\InvoiceItemMembership;
use Internetgalerie\IgsCrm\Domain\Model\Verband;
use Internetgalerie\IgsCrm\Domain\Repository\CommissionRepository;
use Internetgalerie\IgsCrm\Domain\Repository\ContactRepository;
use Internetgalerie\IgsCrm\Domain\Repository\ContactVerbandRepository;
use Internetgalerie\IgsCrm\Domain\Repository\MitgliedschaftRepository;
use Internetgalerie\IgsCrm\Domain\Repository\SektionRepository;
use Internetgalerie\IgsCrm\Domain\Repository\TagverbandRepository;
use Internetgalerie\IgsCrm\Domain\Repository\ZeitschriftRepository;
use Internetgalerie\IgsCrm\Utility\SecurityUtility;
use Psr\Http\Message\ResponseInterface;
use TYPO3\CMS\Core\Context\Context;
use TYPO3\CMS\Core\Page\PageRenderer;
use TYPO3\CMS\Core\Type\ContextualFeedbackSeverity;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Persistence\Generic\PersistenceManager;
use TYPO3\CMS\Extbase\Property\TypeConverter\DateTimeConverter;

class ContactVerbandController extends AbstractCrmController
{
    protected $objectClass = ContactVerband::class;

    /**
     * contactVerbandRepository
     *
     * @var ContactVerbandRepository
     */
    protected $contactVerbandRepository = null;

    /**
     * contactRepository
     *
     * @var ContactRepository
     */
    protected $contactRepository = null;


    public function injectContactVerbandRepository(ContactVerbandRepository $contactVerbandRepository): void
    {
        $this->contactVerbandRepository = $contactVerbandRepository;
    }

    public function injectContactRepository(ContactRepository $contactRepository): void
    {
        $this->contactRepository = $contactRepository;
    }

    /**
     * action edit
     */
    #[IgnoreValidation([
        'argumentName' => 'contact',
    ])] // Verband
    public function editAction(
        ContactVerband $contactVerband = null,
        Contact $contact = null,
        Verband $verband = null
    ): ResponseInterface {
        $pageRenderer = GeneralUtility::makeInstance(PageRenderer::class);
        $pageRenderer->addJsFooterFile('EXT:ig_crm_admin/Resources/Public/JavaScript/ContactEdit.js');
        $this->assignCrm();
        $verbandUid = (int) $this->settings['verbandUid'];
        $control = $this->getControl();
        $this->assignControl($control);
        $default = [];
        $default['active'] = $verbandUid > 0 ? 1 : 0;
        $default['startDate'] = $verbandUid > 0 ? new DateTime() : null;
        if ($control['organisation'] ?? false) {
            $organisation = $this->contactRepository->findByUid($control['organisation']);
            $default['organisationId'] = $organisation;

            if ($contactVerband === null) {
                $default['active'] = true;
                //$defaultActive = 1;
            }
            if ($contactVerband === null || $contactVerband->getStartDate() === null) {
                $default['startDate'] = new DateTime();
                //$defaultStartDate = new \DateTime();
            }
        }
        $this->view->assign('default', $default);
        //$this->view->assign('defaultActive', $defaultActive);
        //$this->view->assign('defaultStartDate', $defaultStartDate);

        $this->view->assign('contactVerband', $contactVerband);
        $this->view->assign('contact', $contact);
        $this->view->assign('verband', $verband);
        $mitgliedschaftRepository = GeneralUtility::makeInstance(MitgliedschaftRepository::class);
        $contactType = $contact ? $contact->getType() : null;
        $this->view->assign(
            'mitgliedschaften',
            $mitgliedschaftRepository->findByVerbandAndType($verband, $contactType)
        );



        $deliveryModes = [
            0 => '',
            1 => 'Per Post',
            2 => 'Per E-Mail',
        ];
        $this->view->assign('deliveryModes', $deliveryModes);

        $tagverbandRepository = GeneralUtility::makeInstance(TagverbandRepository::class);
        $this->view->assign('tagsverband', $tagverbandRepository->findBy([
            'verband' => $verband,
        ]));


        $journalRepository = GeneralUtility::makeInstance(ZeitschriftRepository::class);
        $this->view->assign('journals', $journalRepository->findBy([
            'verband' => $verband,
        ]));
        $commissionRepository = GeneralUtility::makeInstance(CommissionRepository::class);

        $sektionRepository = GeneralUtility::makeInstance(SektionRepository::class);
        $this->view->assign('sektionen', $sektionRepository->findBy([
            'verband' => $verband,
        ]));
        //$this->view->assign('verbaende', $this->verbandRepository->findAll());
        return $this->htmlResponse($this->view->render());
    }


    /**
     * action update
     */
    public function updateAction(ContactVerband $contactVerband): ResponseInterface
    {
        $control = $this->getControl();
        $this->contactVerbandRepository->update($contactVerband);
        $this->addFlashMessage('Der Eintrag wurde aktualisiert.');
        $contact = $contactVerband->getContact();
        $modelClassName = $contact->getType() ?: 'Person';
        $args = [
            strtolower((string) $modelClassName) => $contact,
        ];
        if ($this->request->hasArgument('activeTab')) {
            $args['activeTab'] = $this->request->getArgument('activeTab');
        }
        if (isset($control['redirect']) && is_array($control['redirect'])) {
            return $this->redirect(
                'show',
                $control['redirect']['controllerName'],
                $control['redirect']['extensionName '],
                $control['redirect']['arguments'],
                $control['redirect']['pageUid']
            );
        }
        return $this->redirectWithSearch('show', $modelClassName, null, $args);
    }
    /**
     *	Add Function in Controller
     */
public function initializeAction(): void
    {
        parent::initializeAction();
        if (isset($this->arguments['contactVerband'])) {
            $contactVerband = $this->arguments['contactVerband'];
 
            // Set date format of date fields
            foreach (['startDate', 'endDate', 'journalEnd'] as $dateField) {
                $contactVerband->getPropertyMappingConfiguration()
                    ->forProperty($dateField)
                    ->setTypeConverterOption(
                        DateTimeConverter::class,
                        DateTimeConverter::CONFIGURATION_DATE_FORMAT,
                        'Y-m-d'
                    );
            }

            // allow creation of sub entries
            foreach (['organisations', 'tags'] as $fieldName) {
                $contactVerband->getPropertyMappingConfiguration()
->allowCreationForSubProperty($fieldName . '.*');//setTargetTypeForSubProperty('contactVerband.'.$fieldName, 'array');
                //$contactVerband->getPropertyMappingConfiguration()->setTargetTypeForSubProperty($fieldName,'array');
            }
        }
    }
    /**
     * action create
     */
    public function createAction(ContactVerband $contactVerband): ResponseInterface
    {
        $control = $this->getControl();
        $contact = $contactVerband->getContact();
        if ($this->request->hasArgument('setAcl')) {
            $setAcl = $this->request->getArgument('setAcl');
            $verband = $contactVerband->getVerband();
            if ($setAcl['read'] ?? 0) {
                foreach ($verband->getAclReadGroups() as $group) {
                    $contact->addAclReadGroupsIfNotContains($group);
                }
            }
            if ($setAcl['write'] ?? 0) {
                foreach ($verband->getAclWriteGroups() as $group) {
                    $contact->addAclWriteGroupsIfNotContains($group);
                }
            }
        }

        $this->contactVerbandRepository->add($contactVerband);
        $this->contactRepository->update($contact);
        $persistenceManager = GeneralUtility::makeInstance(PersistenceManager::class);
        $persistenceManager->persistAll();
        $this->addFlashMessage('Der Eintrag wurde erstellt.', '', ContextualFeedbackSeverity::OK);
        
        
        $modelClassName = $contact->getType() ?: 'Person';
        $args = [
            strtolower((string) $modelClassName) => $contact,
        ];
        if ($this->request->hasArgument('activeTab')) {
            $args['activeTab'] = $this->request->getArgument('activeTab');
        }

        if (isset($control['redirect']) && is_array($control['redirect'])) {
            return $this->redirect(
                'show',
                $control['redirect']['controllerName'],
                $control['redirect']['extensionName '],
                $control['redirect']['arguments'],
                $control['redirect']['pageUid']
            );
        }
        return $this->redirectWithSearch('show', $modelClassName, null, $args);
    }


    /**
     * action invoice
     */
    public function invoiceAction(ContactVerband $contactVerband): ResponseInterface
    {
        $verband = $contactVerband->getVerband();
        $contact = $contactVerband->getContact();
        $modelClassName = $contact->getType() ?: 'Person';
        $invoiceUtility = GeneralUtility::makeInstance(InvoiceUtility::class);
        $periode = '';
        $className = array_pop(explode('\\', $contact::class));
        $taxRate = $verband->getTaxRate();
        if (!$this->request->hasArgument('invoice')) {
            $invoice = GeneralUtility::makeInstance(InvoiceAnnual::class);
            $invoice->setStatusDefault();
            $invoice->setTaxRate($taxRate);
        } else {
            $description = null;
            $title = '';
            $amount = 0;
            $invoiceForm = $this->request->getArgument('invoice');

            $periode = $invoiceForm['periode'] ?? date('Y');
            if (!$periode) {
                $periode = date('Y');
            }
            $mitgliedschaft = null;
            if (isset($invoiceForm['taxRate'])) {
                $taxRate = (float) $invoiceForm['taxRate'];
            }
            $invoice = GeneralUtility::makeInstance(InvoiceAnnual::class);
            $invoice->setStatusDefault();
            if (isset($invoiceForm['mode']) && $invoiceForm['mode'] == 'mitgliedschaft') {
                // add amount for membership
                $invoiceItem = InvoiceItemMembership::create($contactVerband, $periode);
                if ($invoiceItem !== null) {
                    $invoice->addInvoiceItem($invoiceItem);
                }
                // add amount for journal
                $invoiceItem = InvoiceItemJournal::create($contactVerband, $periode);
                if ($invoiceItem !== null) {
                    $invoice->addInvoiceItem($invoiceItem);
                }
                // extra amount from client/verband
                $extraAmount = $contactVerband->getVerbandExtraBetragValue();
                if ($extraAmount) {
                    $invoiceItem = InvoiceItem::createWithDescription(
                        $contactVerband->getVerband(),
                        $contactVerband->getVerband()->getExtraBetragTitle(),
                        $extraAmount
                    );
                    if ($invoiceItem !== null) {
                        $invoice->addInvoiceItem($invoiceItem);
                    }
                }
            }

            if (isset($invoiceForm['title'])) {
                $title = $invoiceForm['title'];
            }
            if (isset($invoiceForm['amount'])) {
                $amount = (float) $invoiceForm['amount'];
            }
            if (isset($invoiceForm['description'])) {
                $description = $invoiceForm['description'];
            }

            if ($amount > 0.0 || $title || $description) {
                $invoiceItem = InvoiceItem::createWithDescription(
                    $contactVerband->getVerband(),
                    $description,
                    $amount,
                    $taxRate
                );
                if ($periode) {
                    $invoiceItem->setPeriod($periode);
                }
                $invoiceItem->setTitle($title);
                if ($invoiceItem !== null) {
                    $invoice->addInvoiceItem($invoiceItem);
                }
            }
            /*
            if ($mitgliedschaft === null) {
                $invoice->setInkl($amount, $taxRate, $description);
            } else {
                $invoicestext = $description;
                $invoice->setInkl($amount, $taxRate, $invoicestext);
                /*
                if ($amountMembership > 0) {
                    $invoice->setSub1Inkl($amountMembership);
                    $invoice->setSub1Text($invoicestext);
                }
                if ($amountJournal > 0) {
                    $invoice->setSub2Inkl($amountJournal);
                }
                if ($mitgliedschaft instanceof Mitgliedschaft) {
                    $invoice->setMitgliedschaft($mitgliedschaft->getUid());
                }
            }
            */
        }
        
        
        //$invoice->addInkl($betrag, $taxRate, 'Mitgliedschaft');
        //$invoice->setBetragEz()
        $invoice->setDebitor($className, $contact->getUid());
        $invoice->setVerbandId($verband);
        if ($periode) {
            $invoice->setPeriode($periode);
        }
        $invoiceRepository = GeneralUtility::makeInstance(InvoiceRepository::class);
        $invoiceRepository->add($invoice);

        $persistenceManager = GeneralUtility::makeInstance(PersistenceManager::class);
        $persistenceManager->persistAll();
        $this->addFlashMessage('Die Rechnung wurde erstellt.', '', ContextualFeedbackSeverity::OK);

        $args = [
            strtolower((string) $modelClassName) => $contact,
        ];
        if ($this->request->hasArgument('activeTab')) {
            $args['activeTab'] = $this->request->getArgument('activeTab');
        }
        $invoicePageUid = $invoiceUtility->getInvoicePageUid();
        if ($invoicePageUid) {
            $this->uriBuilder
                ->reset()
                ->setRequest($this->request)
                ->setTargetPageUid($invoicePageUid);
            $uri = $this->uriBuilder->uriFor(
                'show',
                [
                    'invoice' => $invoice->getUid(),
                ],
                'Invoice',
                'IgCrmAdmin',
                'Re'
            );
            return $this->redirectToUri($uri);
        }
        return $this->redirectWithSearch('show', $modelClassName, null, $args);
    }

    /**
     * action cardPdf
     */
    public function cardPdfAction(ContactVerband $contactVerband): ResponseInterface
    {
        $this->view->assign('contactVerband', $contactVerband);
        $this->view->assign('contact', $contactVerband->getContact());
        $this->view->assign('verband', $contactVerband->getVerband());
        
        $this->view->assign('mitgliedschaft', $contactVerband->getMitgliedschaft());
        //        $this->view->assign('contactName', 'contact.meFirstname');
        $this->view->assign(
            'card',
            $contactVerband->getMitgliedschaft() ? $contactVerband->getMitgliedschaft()->getCard() : null
        );
        $html = $this->view->render();

        // Generate PDF here
        $pdf = GeneralUtility::makeInstance(PdfUtility::class);
        $pdf->setCssFile('EXT:ig_crm_admin/Resources/Public/Css/contactverband_pdf.css');
        //$pdf->setFilename('PRT-Mitgliederkarte-' . $contactVerband->getUid() . '.pdf');
        //$pdf->setFilename($filename);
        $pdf->setTitle('Mitgliederkarte');
        $pdf->setPageMargin(0);
        $pdf->addOption('-d 1200');
        if (isset($_GET['html'])) {
            $pdf->debug($html);
            exit(0);
        }
        $pdf->out($html);
        exit(0);
        return $this->htmlResponse($this->view->render());
    }
    public function validationAction(): ResponseInterface
    {
        $currentYear = date('Y');
        $years = [$currentYear, $currentYear + 1];
        $providedHash = $_GET['h'] ?? '';
        $success = false;
        $uid = 0;
        $contactVerband = null;
        $validationYear = null;

        if ($this->settings['validationNoAccessUrl']) {
            $context = GeneralUtility::makeInstance(Context::class);
            $userIsLoggedIn = $context->getPropertyFromAspect('frontend.user', 'isLoggedIn');
            if (!$userIsLoggedIn) {
                return $this->redirectToUri($this->settings['validationNoAccessUrl']);
            }
        }

        //$providedHash = '42204_OSt8y0DbZ+JHGi/imm9TLu89';
        if (str_contains((string) $providedHash, '_')) {
            [$uid] = explode('_', (string) $providedHash, 1);
            if ($uid > 0) {
                $contactVerband = $this->contactVerbandRepository->findByUid($uid);
                foreach ($years as $year) {
                    if ($contactVerband instanceof ContactVerband) {
                        $checkHash = SecurityUtility::getUidYearHash($contactVerband->getUid(), $year);
                        if (hash_equals($checkHash, $providedHash)) {
                            $success = true;
                            $validationYear = $year;
                            break;
                        }
                    }
                }
            }
        }
        $this->view->assign('success', $success);
        $this->view->assign('year', $year);
        $this->view->assign('contactVerband', $contactVerband);
        $this->view->assign('uid', $uid);
        
        return $this->htmlResponse($this->view->render());
    }
}
