<?php

namespace Internetgalerie\IgCrmAdmin\Controller;

use Internetgalerie\IgsCrm\Utility\SecurityUtility;

class FibuStatistikController extends \Ig\IgFibu\Controller\FibuStatistikController
{
    /**
     * securityUtility
     *
     * @var SecurityUtility
     */
    protected $securityUtility = null;

    /**
     * inject the SecurityUtility (for checking access to objects)
     */
    public function injectSecurityUtility(SecurityUtility $securityUtility): void
    {
        $this->securityUtility = $securityUtility;
    }

    protected function getSearch()
    {
        $search = parent::getSearch();
        if (!isset($search['verband'])) {
            $search['verband'] = $this->securityUtility->getGlobalVerband();
        }
        return $search;
    }
}
