<?php

namespace Internetgalerie\IgCrmAdmin\Controller;

use Ig\IgFibu\Controller\AbstractInvoiceController;
use Ig\IgFibu\Domain\Model\Invoice;
use Ig\IgFibu\Domain\Model\InvoiceDate;
use Ig\IgFibu\Domain\Model\InvoiceItem;
use Ig\IgFibu\Domain\Model\Payment;
use Internetgalerie\IgCrmAdmin\Utility\ContactUtility;
use Internetgalerie\IgCrmAdmin\Utility\PeriodUtility;
use Internetgalerie\IgsCrm\Domain\Model\Contact;
use Internetgalerie\IgsCrm\Domain\Repository\InvoiceRepository;
use Internetgalerie\IgsCrm\Domain\Repository\LanguageRepository;
use Internetgalerie\IgsCrm\Domain\Repository\MitgliedschaftRepository;
use Internetgalerie\IgsCrm\Domain\Repository\VerbandRepository;
use Internetgalerie\IgsCrm\Domain\Repository\ZeitschriftRepository;
use Internetgalerie\IgsCrm\Utility\ConfUtility;
use Internetgalerie\IgsCrm\Utility\SecurityUtility;
use Psr\Http\Message\ResponseInterface;
use TYPO3\CMS\Core\Messaging\FlashMessage;
use TYPO3\CMS\Core\Type\ContextualFeedbackSeverity;
use TYPO3\CMS\Core\Utility\GeneralUtility;

class InvoiceController extends AbstractInvoiceController
{
    protected $objectClass = Invoice::class;

    /**
     * invoiceRepository
     *
     * @var InvoiceRepository
     */
    protected $invoiceRepository = null;

    /**
     *verbandRepository
     *
     * @var VerbandRepository
     */
    protected $verbandRepository = null;

    /**
     * languageRepository
     *
     * @var LanguageRepository
     */
    protected $languageRepository = null;


    /**
     * securityUtility
     *
     * @var SecurityUtility
     */
    protected $securityUtility = null;

    public function __construct(
        InvoiceRepository $invoiceRepository,
        VerbandRepository  $verbandRepository,
        LanguageRepository $languageRepository,
        MitgliedschaftRepository $mitgliedschaftRepository
    ) {
        $this->invoiceRepository = $invoiceRepository;
        $this->verbandRepository = $verbandRepository;
        $this->languageRepository = $languageRepository;
        $this->mitgliedschaftRepository = $mitgliedschaftRepository;
    }
    /**
     * inject the SecurityUtility (for checking access to objects)
     */
    public function injectSecurityUtility(SecurityUtility $securityUtility): void
    {
        $this->securityUtility = $securityUtility;
    }
    
    public function getAdditionalFilename(): string
    {
        $additionalFilename = '';
        if ($this->search['contactVerbandMembership'] ?? false) {
            $mitgliedschaft = $this->mitgliedschaftRepository->findByUid(
                (int) $this->search['contactVerbandMembership']
            );
            $additionalFilename = $mitgliedschaft->getCode();
        } elseif ($this->search['sammelinvoice'] ?? false) {
            $additionalFilename = 'SammelRechnung';
        }
        return $additionalFilename;
    }
    public function assignList(): void
    {
        $crmLanguages = $this->languageRepository->findAll();
        $this->view->assign('crmLanguages', $crmLanguages);
        $verbands = $this->verbandRepository->findAllWithAcl();
        $this->view->assign('verbands', $verbands);
        $verbandUids = [];
        if ($this->search['verband'] ?? 0) {
            $verbandUids = [(int) $this->search['verband']];
        } else {
            foreach ($verbands as $verband) {
                $verbandUids[] = $verband->getUid();
            }
        }
        $mitgliedschaften = $this->mitgliedschaftRepository->findByUids($verbandUids);
        $this->view->assign('mitgliedschaften', $mitgliedschaften);
    }
    
    /**
     * action list
     */
    public function listAction(): ResponseInterface
    {
        return $this->initListAction();
    }

    public function showAction(Invoice $invoice): ResponseInterface
    {
        return $this->initShowAction($invoice);
        //var_dump($this->view->getPartialRootPaths());die('s');
    }
    public function invoicePrintHtmlAction(Invoice $invoice, InvoiceDate $invoiceDate = null): ResponseInterface
    {
        return $this->initInvoicePrintHtmlAction($invoice, $invoiceDate);
    }
    public function invoicePrintAction(Invoice $invoice, InvoiceDate $invoiceDate = null): ResponseInterface
    {
        //echo($invoice->getType() .'<br />'); var_dump($invoice);exit(0);
        return $this->initInvoicePrintAction($invoice, $invoiceDate);
    }
    public function newAction($verband = null): ResponseInterface
    {
        if ($verband !== null) {
            $this->view->assign('mitgliedschaften', $this->mitgliedschaftRepository->findByVerband($verband));
            $zeitschriftRepository = GeneralUtility::makeInstance(ZeitschriftRepository::class);
            $journals = $zeitschriftRepository->findBy([
                'verband' => $verband,
            ]);
            $this->view->assign('journals', $journals);
        }
        $this->view->assign('verband', $verband);
        $this->view->assign('period', PeriodUtility::getCurrentPeriod());
        return parent::newAction();
    }
    
    public function createAction(Invoice $newInvoice): ResponseInterface
    {
        return $this->initCreateAction($newInvoice);
    }
    public function editAction(Invoice $invoice, array $search = []): ResponseInterface
    {
        $this->view->assign(
            'mitgliedschaften',
            $this->mitgliedschaftRepository->findByVerband($invoice->getVerbandId())
        );
        $zeitschriftRepository = GeneralUtility::makeInstance(ZeitschriftRepository::class);
        $journals = $zeitschriftRepository->findBy([
            'verband' => $invoice->getVerbandId(),
        ]);
        $this->view->assign('journals', $journals);
        
        $this->view->assign('verband', $invoice->getVerband());
        $this->view->assign('period', PeriodUtility::getCurrentPeriod());
        return $this->initEditAction($invoice, $search);
    }
    public function sortingAction(Invoice $invoice, InvoiceItem $invoiceItem, array $search = []): ResponseInterface
    {
        return $this->initsortingAction($invoice, $invoiceItem, $search);
    }
    public function addPaymentAction(Invoice $invoice, Payment $payment): ResponseInterface
    {
        return $this->initAddPaymentAction($invoice, $payment);
    }
    public function calculateAction(Invoice $invoice, string $calculate = null): ResponseInterface
    {
        return $this->initCalculateAction($invoice, $calculate);
    }
    public function bookAction(Invoice $invoice): ResponseInterface
    {
        return $this->initBookAction($invoice);
    }
    public function updateAction(Invoice $invoice, array $search = [], array $control = []): ResponseInterface
    {
        return $this->initUpdateAction($invoice, $search, $control);
    }
    public function deleteAction(Invoice $invoice, array $search = []): ResponseInterface
    {
        $message = GeneralUtility::makeInstance(
            FlashMessage::class,
            'Rechnung Nr. ' . $invoice->getUid() . ' wurde gelöscht.',
            '',
            ContextualFeedbackSeverity::OK,
            true
        );

        $this->flashMessageService->getMessageQueueByIdentifier(ConfUtility::$flashMessageQueueIdentifier)->enqueue(
            $message
        );
        
        $debitor = $invoice->getDebitor();
        $verbandId = $invoice->getVerbandId();

        $this->invoiceRepository->remove($invoice);

        if ($this->redirectUrl) {
            return $this->redirectToUri($this->redirectUrl);
        }
        if ($debitor instanceof Contact && empty($search)) {
            $uri = ContactUtility::getShowUri($this->request, $debitor, $this->settings, $verbandId);
            return $this->redirectToUri($uri);
        }
        return $this->redirect('list', null, null, [
            'search' => $search,
        ]);
    }
    public function multipleDeleteAction(array $multipleDelete): ResponseInterface
    {
        return $this->initMultipleDeleteAction($multipleDelete);
    }
    /**
     * action sendmailList: Alle Rechnunen die per E-Mail verschickt werden müssen verschicken
     */
    public function addToSendmailListAction(): ResponseInterface
    {
        return $this->initAddToSendmailListAction();
    }
    /**
     * action sendmailList: Alle Rechnunen die per E-Mail verschickt werden müssen anzeigen
     */
    public function showSendmailListAction(): ResponseInterface
    {
        return $this->initShowSendmailListAction();
    }

    /**
     * action sendmailList: Alle Rechnunen die per E-Mail verschickt werden müssen verschicken
     */
    public function sendmailListAction(): ResponseInterface
    {
        return $this->initSendmailListAction();
    }

    protected function getSearch()
    {
        $search = parent::getSearch();
        if (!($search['showentries'] ?? 0) && !isset($search['verband'])) {
            $verband = $this->securityUtility->getGlobalVerband();
            if ($verband) {
                $search['verband'] = $verband;
            }
        }
        return $search;
    }
}
