<?php

namespace Internetgalerie\IgCrmAdmin\Controller;

use Ig\IgFibu\Domain\Model\Invoice;
use Ig\IgFibu\Domain\Model\InvoiceItem;
use Internetgalerie\IgCrmAdmin\Utility\PeriodUtility;
use Internetgalerie\IgsCrm\Domain\Repository\MitgliedschaftRepository;
use Internetgalerie\IgsCrm\Domain\Repository\ZeitschriftRepository;
use TYPO3\CMS\Core\Utility\GeneralUtility;

class InvoiceItemController extends \Ig\IgFibu\Controller\InvoiceItemController
{
    protected $objectClass = InvoiceItem::class;

    public function assignEditFormfields(Invoice $invoice, InvoiceItem $invoiceItem): void
    {
        parent::assignEditFormfields($invoice, $invoiceItem);

        $mitgliedschaftRepository = GeneralUtility::makeInstance(MitgliedschaftRepository::class);
        $this->view->assign('mitgliedschaften', $mitgliedschaftRepository->findBy([
            'verband' => $invoice->getVerbandId(),
        ]));
        $zeitschriftRepository = GeneralUtility::makeInstance(ZeitschriftRepository::class);
        $journals = $zeitschriftRepository->findBy([
            'verband' => $invoice->getVerbandId(),
        ]);
        $this->view->assign('journals', $journals);
        $this->view->assign('verband', $invoice->getVerband());
        $this->view->assign('period', PeriodUtility::getCurrentPeriod());
    }
}
