<?php

namespace Internetgalerie\IgCrmAdmin\Controller;

use Internetgalerie\IgCrmAdmin\Utility\CompatibilityUtility;
use Internetgalerie\IgDatapoolFe\Controller\ActionController;
use Internetgalerie\IgRender\Utility\PdfUtility;
use Internetgalerie\IgsCrm\Domain\Model\Kursteilnehmer;
use Internetgalerie\IgsCrm\Domain\Repository\KurseRepository;
use Internetgalerie\IgsCrm\Domain\Repository\KursteilnehmerRepository;
use Internetgalerie\IgsCrm\Domain\Repository\PersonRepository;
use Psr\Http\Message\ResponseInterface;
use TYPO3\CMS\Core\Type\ContextualFeedbackSeverity;
use TYPO3\CMS\Core\Utility\ExtensionManagementUtility;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Pagination\QueryResultPaginator;
use TYPO3\CMS\Extbase\Persistence\Generic\PersistenceManager;
use TYPO3\CMS\Extbase\Property\TypeConverter\DateTimeConverter;
use TYPO3\CMS\Extbase\Utility\LocalizationUtility;
use TYPO3\CMS\Fluid\View\StandaloneView;

class KursteilnehmerController extends ActionController
{
    protected $objectClass = Kursteilnehmer::class;

    protected $kursteilnehmerRepository = null;
    
    protected $searchPrefix = 'search';
    protected $dateProperties = ['ktStartdatum', 'ktEnddatum'];
    protected $objectName = 'kursteilnehmer';

    /**
     * Parameter name of the object we are manipulating.
     * Used for forms with steps
     */
    protected $objectParamName = 'kursteilnehmer';

    public function injectKursteilnehmerRepository(KursteilnehmerRepository $kursteilnehmerRepository): void
    {
        $this->kursteilnehmerRepository = $kursteilnehmerRepository;
    }



    public function initializeAction(): void
    {
        parent::initializeAction();
        if ($this->arguments->hasArgument($this->objectName)) {
            $object = $this->arguments->getArgument($this->objectName);

            // Set date format of date fields
            foreach ($this->dateProperties as $dateField) {
                $object->getPropertyMappingConfiguration()
                    ->forProperty($dateField)
                    ->setTypeConverterOption(
                        DateTimeConverter::class,
                        DateTimeConverter::CONFIGURATION_DATE_FORMAT,
                        'Y-m-d'
                    );
            }
        }
    }
    /**
     * List Action
     * Renders a list of all Records
     * Useful repository methods:
     * $kursteilnehmerRepository->findAll(); - all records, order as in DB
     * $kursteilnehmerRepository->findAllWithSearch() - automagically search all properties. use searchform viewhelper, input name = property, respects sortheaders
     * ...write your own method for custom search, see repository class fo more!
     */
    public function listAction(): ResponseInterface
    {
        // Default search: if a formfield parses attribute (if the property exists and the formfield is not empty).
        // search vars inside extensionprefix[@search][formfield] = value
        //$this->response->addAdditionalHeaderData('<link rel="stylesheet" href="/typo3conf/ext/ig_crm_admin/Resources/Public/css/crm.css" />');
        $search = $this->request->hasArgument('search') ? $this->request->getArgument('search') : [];
        /*
        if ($this->request->hasArgument('@search')) {
        $search = $this->request->getArgument('@search');
        } elseif ($this->request->hasArgument('_search')) {
        $search = $this->request->getArgument('_search');
        } else {
        //$search = array();
        }
         */

        $kursteilnehmers = $this->kursteilnehmerRepository->findBySearchLogic($search);

        $currentPage = $this->request->hasArgument('currentPage') ? (int)$this->request->getArgument('currentPage') : 1;
        $paginator = new QueryResultPaginator($kursteilnehmers, $currentPage, 10);
        $pagination = CompatibilityUtility::createPagination($paginator, 10); // zweiter Argument: maximal Anzahl Links

        
        $jahre = [];
        for ($j = date('Y'); $j >= 2015; $j--) {
            $jahre[$j] = $j;
        }

        $this->view->assign('jahre', $jahre);

        $repositoryKurse = GeneralUtility::makeInstance(KurseRepository::class);
        $kurse = $repositoryKurse->findAllOrderedBy('kuName', 0);

        $this->view->assign('search', $search);

        $this->view->assign('kurse', $kurse);
        /*
        $query = $this->createQuery();
        $res=  $query->statement("SELECT DISTINCT YEAR(kt_startdatum) AS jahr FROM tx_igscrm_domain_model_kursteilnehmer ORDER BY jahr DESC");
        foreach ($query->execute() as $a) {echo('a<br />'); var_dump($a);}
        return  $res->execute();
         */
        if ($search['person'] > 0) {
            $repository = GeneralUtility::makeInstance(PersonRepository::class);
            $person = $repository->findOneBy([
                'uid' => $search['person'],
            ]);
            $this->view->assign('person', $person);
        }
        $this->view->assign('_search', $search);
        $this->view->assign('kursteilnehmers', $kursteilnehmers);
        $this->view->assign('pagination', [
            'paginator' => $paginator,
            'pagination' => $pagination,
        ]);
        return $this->htmlResponse($this->view->render());
    }
    
    public function briefAction(): ResponseInterface
    {
        $search = $this->request->hasArgument('search') ? $this->request->getArgument('search') : [];
        $kursteilnehmers = $this->kursteilnehmerRepository->findBySearchLogic($search, 'person');

        //$languageService = \TYPO3\CMS\Core\Utility\GeneralUtility::makeInstance('TYPO3\CMS\Core\Localization\LanguageService');
        //$this->view->assign('kursteilnehmers', $kursteilnehmers);
        // if ($request->hasArgument('@search')) {
        //     $search = $request->getArgument('@search');
        // } elseif ($request->hasArgument('_search')) {
        //     $search = $request->getArgument('_search');
        // } else {
        //     $search = array();
        // }

        if ($search['year']) {
            $year = $search['year'];
        } else {
            $year = 0;
        }

        $person = [];
        $personUid = [];
        foreach ($kursteilnehmers as $kt) {
            $m = $kt->getKtPerson();
            if (!is_object($m)) {
                continue;
            }
            $meLang = $m->getMeLanguageid();
            if (is_object($meLang) && $meLang->getUid() == 3) {
                //$languageService->includeLLFile('EXT:ig_crm_admin/Resources/Private/Language/fr.locallang.xlf');
                setlocale(LC_ALL, 'fr_CH.utf8');
                $date = strftime('le %d %B %Y');
                $lang = 'fr';
            } else {
                //$languageService->includeLLFile('EXT:ig_crm_admin/Resources/Private/Language/de.locallang.xlf');
                setlocale(LC_ALL, 'de_CH.utf8');
                $date = strftime('%d. %B %Y');
                $lang = 'de';
            }

            if (!in_array($m->getUid(), $personUid)) {
                $personUid[] = $m->getUid();
                $person[$m->getUid()] = [
                    'person' => $m,
                    'kurse' => [],
                    'date' => $date,
                    'lang' => $lang,
                    'fussnote' => 0,
                ];
            }
            $person[$m->getUid()]['kurse'][] = $kt;
            if ($kt->getKtKurse()->getKuFussnote()) {
                $person[$m->getUid()]['fussnote'] = 1;
            }
        }

        /*
        print_r($personUid);
        echo('<p><b>Result</b></p>');
        foreach( $person as $m) {
        echo($m['person']->getMeLastname() .'='.  count($m['kurse']) . '<br />');
        }
        echo('<p>end.</p>');
        exit(0);
         */
        // $GLOBALS['TSFE']->sys_language_uid == 2

        $markers = [
            //'kursteilnehmers' => $kursteilnehmers,
            'personkurse' => $person,
            'date' => $date,
            'year' => $year,
        ];

        $cssFile = GeneralUtility::getFileAbsFileName('EXT:ig_crm_admin/Resources/Public/Css/kursteilnehmer-brief.css');
        $css = file_get_contents($cssFile);
        /*        $html = '<!DOCTYPE html>
        <body>
        ' . */
        $filename = 'IGS_' . str_replace(
            '__',
            '_',
            str_replace('__', '_', preg_replace('/[^-_a-z0-9 ]/i', '', (string) $year ?: '2015-' . date('Y')))
        ) . '.pdf';
        $html = $this->renderFluid('Kursteilnehmer/Brief.html', $markers);
        $pdf = GeneralUtility::makeInstance(PdfUtility::class);
        $pdf->setFilename($filename);
        $pdf->setTitle('Bildungspass'); // TODO Sprache
        $pdf->setCss($css);
        if ($_GET['html'] == 1) {
            die($pdf->getHtml($html)); // HTML Ausgabe fuer Debug
        }
        $pdf->out($html);
        exit(0);

        if ($_GET['html'] == 1) {
            echo $html;
            exit(0);
        }
        //.'</body></html>';

        // die($pdf->getHtml($html)); // HTML Ausgabe fuer Debug

        $pdf->out($html);
        exit(0);
        return $this->htmlResponse($this->view->render());
    }

    public function showAction(Kursteilnehmer $kursteilnehmer): ResponseInterface
    {
        // set page title (<title>-tag, page title output and search index), use your own methods.
        $GLOBALS['TSFE']->page['title'] = $GLOBALS['TSFE']->indexedDocTitle = (string) $kursteilnehmer;

        $this->view->assign('kursteilnehmer', $kursteilnehmer);
        return $this->htmlResponse($this->view->render());
    }

    public function newAction(Kursteilnehmer $kursteilnehmer = null): ResponseInterface
    {
        $search = $this->request->hasArgument('search') ? $this->request->getArgument('search') : [];
        $this->view->assign('search', $search);

        if ($this->request->hasArgument('person')) {
            $personUid = $this->request->getArgument('person');
            $repositoryPerson = GeneralUtility::makeInstance(PersonRepository::class);
            $person = $repositoryPerson->findOneBy([
                'uid' => $personUid,
            ]);
            $this->view->assign('person', $person);
        }
        if ($this->request->hasArgument('kurs')) {
            $kursUid = $this->request->getArgument('kurs');
            $repositoryKurse = GeneralUtility::makeInstance(KurseRepository::class);
            $kurs = $repositoryKurse->findOneBy([
                'uid' => $kursUid,
            ]);
            $this->view->assign('kurs', $kurs);
        }

        $this->view->assign('kursteilnehmer', $kursteilnehmer);
        return $this->htmlResponse($this->view->render());
    }

    public function _initializeCreateAction(): ResponseInterface
    {
        $this->setLabel('validator.notempty.empty', 'my_custom_label_in_extension_xlf');
        $this->setLabel('validator.email.notvalid', 'Bitte tragen Sie Ihre E-Mail Adresse ein!', 'emailfeld');
        $this->setLabel('tx_myextension_domain_model_table.email', 'E-Mail / Benutzername');
        return $this->htmlResponse();
    }

    /**
     * action create
     */
    public function createAction(Kursteilnehmer $kursteilnehmer): ResponseInterface
    {
        $this->addFlashMessage(
            LocalizationUtility::translate('global.created', 'ig_render'),
            '',
            ContextualFeedbackSeverity::OK
        );
        $this->kursteilnehmerRepository->add($kursteilnehmer);
        GeneralUtility::makeInstance(PersistenceManager::class)->persistAll();
        return $this->redirectWithSearch('list');
    }

    public function editAction(Kursteilnehmer $kursteilnehmer): ResponseInterface
    {
        $search = $this->request->hasArgument('search') ? $this->request->getArgument('search') : [];
        $this->view->assign('search', $search);
        $this->view->assign('kurs', $kursteilnehmer->getKtKurse());
        $this->view->assign('kursteilnehmer', $kursteilnehmer);
        return $this->htmlResponse($this->view->render());
    }

    public function updateAction(Kursteilnehmer $kursteilnehmer): ResponseInterface
    {
        $this->addFlashMessage(
            LocalizationUtility::translate('global.updated', 'ig_render'),
            '',
            ContextualFeedbackSeverity::OK
        );
        $this->kursteilnehmerRepository->update($kursteilnehmer);
        GeneralUtility::makeInstance(PersistenceManager::class)->persistAll();
        return $this->redirectWithSearch('list');
    }
    public function confirmDeleteAction(Kursteilnehmer $kursteilnehmer): ResponseInterface
    {
        $search = $this->request->hasArgument('search') ? $this->request->getArgument('search') : [];
        $this->view->assign('search', $search);
        $this->view->assign('objectLabel', '<strong>&laquo;' . $kursteilnehmer->__toString() . '&raquo;</strong>');
        $this->view->assign('kursteilnehmer', $kursteilnehmer);
        return $this->htmlResponse($this->view->render());
    }

    public function deleteAction(Kursteilnehmer $kursteilnehmer): ResponseInterface
    {
        // 1. Access check: Am I allowed to update the Records. normally i have to be the owner! pass a FEUser Object or a UID to isRecordOwner
        // $this->access->isRecordOwner($object->getFrontendUser());

        // 1. display a Message "Your record has been deleted."
        $this->addFlashMessage(
            LocalizationUtility::translate('global.deleted', 'ig_render'),
            '',
            ContextualFeedbackSeverity::OK
        );

        // 2. remove it from the repository
        $this->kursteilnehmerRepository->remove($kursteilnehmer);
        GeneralUtility::makeInstance(PersistenceManager::class)->persistAll();
        // 3. redirect the user
        return $this->redirectWithSearch('list');
    }

    public function exportAction($type = null): ResponseInterface
    {
        /**
         * 1. QUERY THE DATA
         * =================
         */
        $kursteilnehmers = $this->kursteilnehmerRepository->findBySearch();

        if ($type === null) {
            return $this->htmlResponse('');
        }

        /*
         * 2. SELECT AN EXPORT TYPE
         * ========================
         *
         * possible types are, default: chosen by parameter
         * - CSV
         * - Excel
         * - XML
         * - JSON
         */
        $exporter = GeneralUtility::makeInstance(
            '\\Internetgalerie\\IgDatapoolFe\\Services\\Exporter\\' . ucfirst(
                strtolower((string) $type)
            ) . 'ExporterService',
            $type
        );

        /*
         * 3. CHOSE THE LAYOUT
         * ===================
         * Array of properties, Corresponds to the columns in the excel sheet.
         *
         * They may be:
         * Field => Label pairs
         * field    --> in this case, the fieldname is used as header OR if $options['dbLabel'] is set, then the fieldlabel from the table is used.
         *
         * Paths to submodels (think Relations!) are also supported, i.e., ('uid', 'name', 'telephonenumbers.0.number', 'telephonenumbers.1.number')
         */
        $fieldsWithLabels = [
            /*
        'uid' => 'Id',
        'name' => 'Name des Datensatzes',
        'bild' => \Internetgalerie\IgDatapoolFe\Services\LangService::ll('tx_morecomplexext_domain_model_person.geburtsdatum'),
        // --> this can be done automagically by the option 'dbLabel' = true
        'karte' => \Internetgalerie\IgDatapoolFe\Services\LangService::ll('some.label'),
        'geburtsdatum',
        'passwort',
        'textFeld' => 'TextFeld'
         */
        ];
        // @formatter:on

        /**
         * alternatively,
         *
         * 3b. DELEGATE LAYOUT TO MODEL
         * ============================
         * specify a method of the object
         */
        // $fieldsWithLabels = 'exportModel';
        // in this case, you can still set the headers like this:
        /*$exporter->setHeaders(
         *    array(
         *         'arrayKeyName' => 'Header 1'
         *     ));
         */

        /**
         * 4. SET EXPORTER OPTIONS
         * =======================
         * General:
         * - filename: the filename.
         *
         * CSV:
         * - enclosure: wraping around strings, default ""
         * - delimiter: default ;
         * - lineending: default \r\n
         *
         * CSV / Excel
         * - includeHeaders: boolean, default true
         * - dbLabel: Use dbLabel (i.e., the Header in the Language File) insted of the fieldname, default: false
         *
         * XML
         * - rootTag: the tag of the root element
         * - itemTag: the wrapping tag of each element
         *
         * JSON
         * - forceObject: Force arrays to be JS objects
         */
        $options = [
            'dbLabel' => true,
        ];
        $exporter->setOptions($fieldsWithLabels, $options);

        /**
         * 5. SET FIELD OPTIONS
         * ====================
         * Some Converters support convertion options. atm only used in the \DateTime converter.
         * XXX(all): add more in Services/Exporter/ExporterService.php, please document in Controller.txt template to get the info here.
         */
        $fieldOptions = [];
        $fieldOptions['geburtsdatum']['format'] = 'd.m.Y';
        $exporter->setFieldOptions($fieldOptions);

        // DO IT!
        $exporter->export($kursteilnehmers);
        exit;

        /**
         * 3b. DIRECT ARRAY EXPORT
         * ==================
         *
         * If you want to build the array to export yourself, use this:
         */
        $array = [];
        $array[0] = ['Erstes Feld', 'Zweites Feld', 'Drittes Feld'];
        $array[1] = ['A1', 'A2', 'A3'];
        $array[2] = ['B1', 'B2', 'B3'];
        $array[3] = ['C1', 'C2', 'C3'];
        $exporter->setOptions([], $options);
        $exporter->export($array);
        return $this->htmlResponse($this->view->render());
    }


    private function renderFluid($template, $parameter)
    {
        $fluidView = GeneralUtility::makeInstance(StandaloneView::class);
        // TYPO3 12
        if (method_exists($fluidView, 'setRequest')) {
            $fluidView->setRequest($this->request);
        }
        $extPath = ExtensionManagementUtility::extPath($this->request->getControllerExtensionKey());
        $templateFile = $extPath . 'Resources/Private/Templates/' . $template;
        $partialOrder = $extPath . 'Resources/Private/Partials/';
        $fluidView->setTemplatePathAndFilename($templateFile);
        $fluidView->setPartialRootPaths([$partialOrder]);
        $fluidView->assignMultiple($parameter);
        $fluidView->getRequest()
->setControllerExtensionName('ig_crm_admin');
        return $fluidView->render('index');
    }
}
