<?php

namespace Internetgalerie\IgCrmAdmin\Controller;

use Internetgalerie\IgsCrm\Domain\Repository\LanguageRepository;
use Internetgalerie\IgsCrm\Domain\Repository\VerbandRepository;
use Internetgalerie\IgsCrm\Utility\SecurityUtility;
use Psr\Http\Message\ResponseInterface;

class LogMailController extends \Ig\IgFibu\Controller\LogMailController
{
    /**
     * debitor: Join Config, Attributes for search and display debitor infos (name)
     *
     * @var array
     */
    protected $debitorConf = [
        'joinTable' => 'tx_igscrm_domain_model_contact',
        'joinAttribute' => 'uid',
        'displayAttribute' => ['me_companyname', 'me_firstname', 'me_lastname'], // space separated
        'searchAttribute' => ['me_companyname', 'me_firstname', 'me_lastname'],
    ];


    /**
     * securityUtility
     *
     * @var SecurityUtility
     */
    protected $securityUtility = null;

    /**
     *verbandRepository
     *
     * @var VerbandRepository
     */
    protected $verbandRepository = null;

    /**
     * languageRepository
     *
     * @var LanguageRepository
     */
    protected $languageRepository = null;

    /**
     * inject the SecurityUtility (for checking access to objects)
     */
    public function injectSecurityUtility(SecurityUtility $securityUtility): void
    {
        $this->securityUtility = $securityUtility;
    }

    public function injectVerbandRepository(VerbandRepository $verbandRepository): void
    {
        $this->verbandRepository = $verbandRepository;
    }

    public function injectLanguageRepository(LanguageRepository $languageRepository): void
    {
        $this->languageRepository = $languageRepository;
    }

    /**
     * action list
     */
    public function listAction(): ResponseInterface
    {
        $crmLanguages = $this->languageRepository->findAll();
        $this->view->assign('crmLanguages', $crmLanguages);
        $verbands = $this->verbandRepository->findAllWithAcl();
        $this->view->assign('verbands', $verbands);
        return parent::listAction();
    }
    

    protected function getSearch()
    {
        $search = parent::getSearch();
        if (!isset($search['verband'])) {
            $search['verband'] = $this->securityUtility->getGlobalVerband();
        }
        return $search;
    }
}
