<?php

namespace Internetgalerie\IgCrmAdmin\Controller;

use Internetgalerie\IgCrmAdmin\Controller\TYPO3\CMS\Extbase\Annotation\IgnoreValidation;
use Internetgalerie\IgCrmAdmin\Utility\CompatibilityUtility;
use Internetgalerie\IgsCrm\Domain\Model\Contact;
use Internetgalerie\IgsCrm\Domain\Model\Message;
use Internetgalerie\IgsCrm\Domain\Repository\ContactRepository;
use Internetgalerie\IgsCrm\Domain\Repository\MessageRepository;
use Internetgalerie\IgsCrm\Domain\Repository\VerbandRepository;
use Psr\Http\Message\ResponseInterface;
use TYPO3\CMS\Core\Type\ContextualFeedbackSeverity;
use TYPO3\CMS\Extbase\Pagination\QueryResultPaginator;

class MessageController extends AbstractCrmController
{
    protected $objectClass = Message::class;
    protected $searchPrefix = 'search';
    protected $searchDefault = [];
    /**
     * messageRepository
     *
     * @var MessageRepository
     */
    protected $messageRepository = null;


    /**
     * contactRepository
     *
     * @var ContactRepository
     */
    protected $contactRepository = null;

    /**
     *verbandRepository
     *
     * @var VerbandRepository
     */
    protected $verbandRepository = null;

    public function injectMessageRepository(MessageRepository $messageRepository): void
    {
        $this->messageRepository = $messageRepository;
    }
    
    public function injectVerbandRepository(VerbandRepository $verbandRepository): void
    {
        $this->verbandRepository = $verbandRepository;
    }

    public function injectContactRepository(ContactRepository $contactRepository): void
    {
        $this->contactRepository = $contactRepository;
    }

    
    /**
     * action list
     */
    public function listAction(): ResponseInterface
    {
        $search = [];
        if ($this->request->hasArgument('@search')) {
            $search = array_merge($search, $this->request->getArgument('@search'));
        } elseif ($this->request->hasArgument('_search')) {
            $search = array_merge($search, $this->request->getArgument('_search'));
        } elseif ($this->request->hasArgument('search')) {
            $search = array_merge($search, $this->request->getArgument('search'));
        } else {
            $search = $this->searchDefault;
            if ($this->settings['verbandUid']) {
                $search['verband'] = (int) $this->settings['verbandUid'];
            }
        }
        if ($search['contact'] ?? false) {
            $contactUid = $search['contact']['__identity'] ?? (int) $search['contact'];
            $search['contact'] = $contactUid;
        } else {
            $contact = false;
            $contactUid = 0;
        }
        $messages = $this->messageRepository->findBySearch($search);
        //foreach($messages as $message) {var_dump($message);    }exit(0);

        $currentPage = $this->request->hasArgument('currentPage') ? (int)$this->request->getArgument('currentPage') : 1;
 
        $paginator = new QueryResultPaginator($messages, $currentPage, 20);
        $pagination = CompatibilityUtility::createPagination($paginator, 10); // zweiter Argument: maximal Anzahl Links
 
        $this->view->assign('pagination', [
            'paginator' => $paginator,
            'pagination' => $pagination,
        ]);

        $this->view->assign('messages', $messages);
        if ($contactUid > 0) {
            $contact = $this->contactRepository->findByUid($contactUid);
            $search['contact'] = $contact;
        }
        $this->view->assign('contact', $contact);
        $this->view->assign('search', $search);
        return $this->htmlResponse($this->view->render());
    }

    /**
     * action show
     */
    public function showAction(Message $message): ResponseInterface
    {
        $this->view->assign('message', $message);
        return $this->htmlResponse($this->view->render());
    }

    /**
     * action new
     */
    #[IgnoreValidation([
        'argumentName' => 'new',
    ])] // Message
    public function newAction(Message $newMessage = null, Contact $contact = null): ResponseInterface
    {
        $this->view->assign('contact', $contact);
        $this->view->assign('newMessage', $newMessage);
        return $this->htmlResponse($this->view->render());
    }

    /**
     * action create
     */
    public function createAction(Message $newMessage, Contact $contact = null): ResponseInterface
    {
        $this->addFlashMessage('Meldung erstellt', '', ContextualFeedbackSeverity::OK);
        $this->messageRepository->add($newMessage);
        if ($contact instanceof Contact) {
            return $this->redirectToContact($contact);
        }
        return $this->redirectWithSearch('list');
    }

    /**
     * action edit
     */
    #[IgnoreValidation([
        'argumentName' => 'message',
    ])]
    public function editAction(Message $message, Contact $contact = null): ResponseInterface
    {
        $this->view->assign('message', $message);
        //var_dump($contact);exit(0);
        $this->view->assign('contact', $contact);
        return $this->htmlResponse($this->view->render());
    }

    /**
     * action update
     */
    public function updateAction(Message $message, Contact $contact = null): ResponseInterface
    {
        $this->addFlashMessage('Meldung aktualisiert', '', ContextualFeedbackSeverity::OK);
        $this->messageRepository->update($message);
        if ($contact instanceof Contact) {
            return $this->redirectToContact($contact);
        }
        return $this->redirectWithSearch('list');
    }

    /**
     * action delete
     */
    public function deleteAction(Message $message, Contact $contact = null): ResponseInterface
    {
        $this->addFlashMessage('Meldung gelöscht', '', ContextualFeedbackSeverity::OK);
        $this->messageRepository->remove($message);
        if (is_object($contact)) {
            return $this->redirectToContact($contact);
        }
        
        return $this->redirectWithSearch('list');
    }
}
