<?php

namespace Internetgalerie\IgCrmAdmin\Controller;

use Internetgalerie\IgCrmAdmin\Controller\TYPO3\CMS\Extbase\Annotation\IgnoreValidation;
use Internetgalerie\IgDatapoolFe\Controller\ActionController;
use Internetgalerie\IgsCrm\Domain\Model\Mitgliedschaft;
use Internetgalerie\IgsCrm\Domain\Model\Verband;
use Internetgalerie\IgsCrm\Domain\Repository\AnredeRepository;
use Internetgalerie\IgsCrm\Domain\Repository\CardRepository;
use Internetgalerie\IgsCrm\Domain\Repository\MitgliedschaftRepository;
use Internetgalerie\IgsCrm\Domain\Repository\VerbandRepository;
use Psr\Http\Message\ResponseInterface;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Utility\LocalizationUtility;

class MitgliedschaftController extends ActionController
{
    protected $objectClass = Mitgliedschaft::class;
    
    /**
     * mitgliedschaftRepository
     *
     * @var MitgliedschaftRepository
     */
    protected $mitgliedschaftRepository = null;

    /**
     * verbandRepository
     *
     * @var VerbandRepository
     */
    protected $verbandRepository = null;

    /**
     * cardRepository
     *
     * @var CardRepository
     */
    protected $cardRepository = null;


    public function injectVerbandRepository(VerbandRepository $verbandRepository): void
    {
        $this->verbandRepository = $verbandRepository;
    }

    public function injectMitgliedschaftRepository(MitgliedschaftRepository $mitgliedschaftRepository): void
    {
        $this->mitgliedschaftRepository = $mitgliedschaftRepository;
    }

    public function injectCardRepository(CardRepository $cardRepository): void
    {
        $this->cardRepository = $cardRepository;
    }
    
    /**
     * action new
     */
    #[IgnoreValidation([
        'argumentName' => 'mitgliedschaft',
    ])]
    public function newAction(Verband $verband, Mitgliedschaft $mitgliedschaft = null): ResponseInterface
    {
        $this->view->assign('mitgliedschaft', $mitgliedschaft);
        $this->view->assign('verband', $verband);
        $this->view->assign('verbaende', $this->verbandRepository->findAll());
        $this->assignOptionTypes();

        $this->anredeRepository = GeneralUtility::makeInstance(AnredeRepository::class);
        $this->view->assign('anreden', $this->anredeRepository->findAll());
        if ($this->request->hasArgument('activeTab')) {
            $activeTab = $this->request->getArgument('activeTab');
        }
        $this->view->assign('activeTab', $activeTab);
        return $this->htmlResponse($this->view->render());
    }

    /**
     * action edit
     */
    #[IgnoreValidation([
        'argumentName' => 'mitgliedschaft',
    ])]
    public function editAction(Mitgliedschaft $mitgliedschaft, Verband $verband): ResponseInterface
    {
        $this->view->assign('mitgliedschaft', $mitgliedschaft);
        $this->view->assign('verband', $verband);
        $this->view->assign('verbaende', $this->verbandRepository->findAll());
        $this->assignOptionTypes();

        $this->anredeRepository = GeneralUtility::makeInstance(AnredeRepository::class);
        $this->view->assign('anreden', $this->anredeRepository->findAll());

        $cards = $this->cardRepository->findAll();
        $this->view->assign('cards', $cards);
        if ($this->request->hasArgument('activeTab')) {
            $activeTab = $this->request->getArgument('activeTab');
        }
        $this->view->assign('activeTab', $activeTab);
        return $this->htmlResponse($this->view->render());
    }

    /**
     * action create
     */
    #[IgnoreValidation([
        'argumentName' => 'verband',
    ])]
    public function createAction(Mitgliedschaft $mitgliedschaft, Verband $verband): ResponseInterface
    {
        $this->mitgliedschaftRepository->add($mitgliedschaft);
        $this->addFlashMessage('Der Eintrag wurde erstellt.');
        $args = [
            'verband' => $verband,
        ];
        if ($this->request->hasArgument('activeTab')) {
            $args['activeTab'] = $this->request->getArgument('activeTab');
        }
        return $this->redirectWithSearch('show', 'Verband', null, $args);
    }

    /**
     * action update
     */
    #[IgnoreValidation([
        'argumentName' => 'verband',
    ])]
    public function updateAction(Mitgliedschaft $mitgliedschaft, Verband $verband): ResponseInterface
    {
        $this->mitgliedschaftRepository->update($mitgliedschaft);
        $this->addFlashMessage('Der Eintrag wurde aktualisiert.');
        $args = [
            'verband' => $verband,
        ];
        if ($this->request->hasArgument('activeTab')) {
            $args['activeTab'] = $this->request->getArgument('activeTab');
        }
        return $this->redirectWithSearch('show', 'Verband', null, $args);
    }
    /**
     * action confirmDelete
     */
    #[IgnoreValidation([
        'argumentName' => 'mitgliedschaft',
    ])]
    public function confirmDeleteAction(Mitgliedschaft $mitgliedschaft, Verband $verband): ResponseInterface
    {
        $this->view->assign('mitgliedschaft', $mitgliedschaft);
        $this->view->assign('verband', $verband);
        if ($this->request->hasArgument('activeTab')) {
            $activeTab = $this->request->getArgument('activeTab');
        }
        $this->view->assign('activeTab', $activeTab);
        return $this->htmlResponse($this->view->render());
    }

    /**
     * action delete
     */
    #[IgnoreValidation([
        'argumentName' => 'verband',
    ])]
    public function deleteAction(Mitgliedschaft $mitgliedschaft, Verband $verband): ResponseInterface
    {
        $this->mitgliedschaftRepository->remove($mitgliedschaft);
        $this->addFlashMessage('Der Eintrag wurde aktualisiert.');
        $args = [
            'verband' => $verband,
        ];
        if ($this->request->hasArgument('activeTab')) {
            $args['activeTab'] = $this->request->getArgument('activeTab');
        }
        return $this->redirectWithSearch('show', 'Verband', null, $args);
    }

    protected function assignOptionTypes()
    {
        $optionTypes = [];
        foreach ($GLOBALS['TCA']['tx_igscrm_domain_model_mitgliedschaft']['columns']['limit_to_type']['config']['items'] as $item) {
            $label = $item['label'] ?? $item[0] ?? '';
            $value = $item['value'] ?? $item[1] ?? '';
            $optionTypes[$value] = LocalizationUtility::translate($label);
        }
        $this->view->assign('optionTypes', $optionTypes);
    }
}
