<?php

namespace Internetgalerie\IgCrmAdmin\Controller;

use Internetgalerie\IgsCrm\Domain\Repository\LanguageRepository;
use Internetgalerie\IgsCrm\Domain\Repository\MitgliedschaftRepository;
use Internetgalerie\IgsCrm\Domain\Repository\PersonRepository;
use Internetgalerie\IgsCrm\Domain\Repository\TagRepository;
use Internetgalerie\IgsCrm\Domain\Repository\TagverbandRepository;
use Psr\Http\Message\ResponseInterface;

use TYPO3\CMS\Core\Utility\GeneralUtility;

class NewsletterApiController extends AbstractApiController
{
    /**
     * personRepository
     *
     * @var PersonRepository
     */
    protected $personRepository = null;
    
    public function injectPersonRepository(PersonRepository $personRepository): void
    {
        $this->personRepository = $personRepository;
    }


    /**
     * action list
     */
    public function listAction(): ResponseInterface
    {
        $search = $this->getSearch() ?? [];
        $token = $this->request->hasArgument('apiKey') ? $this->request->getArgument('apiKey') : '';
        $this->personRepository->setToken($token);
        $persons = $this->personRepository->findBySearchDoctrine($search ?? []);
        $persons = $this->arrayUnderscoredToNewsletter($persons);
        return $this->jsonResponse((string)json_encode([
                    'result' => $persons,
                ]));
    }

    /**
     * action tag
     */
    public function tagAction(): ResponseInterface
    {
        $search = $this->getSearch() ?? [];
        $token = $this->request->hasArgument('apiKey') ? $this->request->getArgument('apiKey') : '';
        $this->tagRepository = GeneralUtility::makeInstance(TagRepository::class);
        $this->tagRepository->setToken($token);
        $this->tagverbandRepository = GeneralUtility::makeInstance(TagverbandRepository::class);

        $tagverbands = $this->tagverbandRepository->findBySearch($search);
        $result = [];
        foreach ($tagverbands as $tagverband) {
            $search['tagverband'] = $tagverband['uid'];
            $tags = $this->tagRepository->findBySearch($search);
            $tags = $this->arrayUnderscoredToLowerCamelCase($tags);
            $result[$tagverband['name']] = $tags;
        }
        return $this->jsonResponse(
            (string)json_encode([
                    'meta' => [
                        'status' => 'success',
                    ],
                    'result' => $result,
                    
                ])
        );
    }


    /**
     * action language
     */
    public function languageAction(): ResponseInterface
    {
        $search = $this->getSearch() ?? [];
        $this->languageRepository = GeneralUtility::makeInstance(LanguageRepository::class);
        $this->languageRepository->setToken(false);
        
        $languages = $this->languageRepository->findBySearch($search);
        $result = $this->arrayUnderscoredToLowerCamelCase($languages);

        return $this->jsonResponse(
            (string)json_encode([
                    'meta' => [
                        'status' => 'success',
                    ],
                    'result' => $result,
                    
                ])
        );
    }



    /**
     * action mitgliedschaft
     */
    public function mitgliedschaftAction(): ResponseInterface
    {
        $search = $this->getSearch() ?? [];
        $this->mitgliedschaftRepository = GeneralUtility::makeInstance(MitgliedschaftRepository::class);
        $this->mitgliedschaftRepository->setToken(false);
        
        $mitgliedschafts = $this->mitgliedschaftRepository->findBySearch($search);
        $result = $this->arrayUnderscoredToLowerCamelCase($mitgliedschafts);

        return $this->jsonResponse(
            (string)json_encode([
                    'meta' => [
                        'status' => 'success',
                    ],
                    'result' => $result,
                    
                ])
        );
    }

    protected function arrayUnderscoredToNewsletter($objectsUnderscored)
    {
        $objects = [];
        foreach ($objectsUnderscored as $row) {
            $object = [
                'uid' => $row['uid'],
                'name' => trim((string) $row['me_firstname']) . ' ' . trim((string) $row['me_lastname']),
                'last_name' => trim((string) $row['me_lastname']),
                'first_name' => trim((string) $row['me_firstname']),
                'email' => trim((string) $row['me_email']),
                'module_sys_dmail_html' => 1,
            ];
            $objects[] = $object;
        }
        return $objects;
    }
}
