<?php

namespace Internetgalerie\IgCrmAdmin\Controller;

use Internetgalerie\IgsCrm\Domain\Repository\OrganisationRepository;
use Psr\Http\Message\ResponseInterface;

class OrganisationApiController extends AbstractApiController
{
    /**
     * organisationRepository
     *
     * @var OrganisationRepository
     */
    protected $organisationRepository = null;


    public function injectOrganisationRepository(OrganisationRepository $organisationRepository): void
    {
        $this->organisationRepository = $organisationRepository;
    }
 
    
    /**
     * action list
     */
    public function listAction(): ResponseInterface
    {
        $search = $this->getSearch() ?? [];
        $token = $this->request->hasArgument('apiKey') ? $this->request->getArgument('apiKey') : '';
        $this->organisationRepository->setToken($token);

        $organisationsRaw = $this->organisationRepository->findBySearchDoctrine($search ?? []);
        $organisations = $this->arrayUnderscoredToLowerCamelCase($organisationsRaw);

        return $this->jsonResponse((string)json_encode([
                    'result' => $organisations,
                ]));
        /*
        $this->view->assignMultiple([
            'json' => [
                'organisations' => $organisation,
            ]
        ]);
        $this->view->setVariablesToRender(['json']);
        $this->view->setConfiguration([
            'json' => [
                'organisations' => [
                    '_exclude' => ['qrCode'],
                    '_descendAll' => [
                        '_exclude' => ['qrCode'],
                        '_only' => ['type', 'meCompanyname', 'meAddon', 'bfsUid', 'meMap', 'meNoEmployees', 'isLehrbetrieb', 'meBbf', 'meAddress', 'meZip', 'meCity', 'meCountryAbrev', 'meAddressid', 'meShortname', 'meEmail', 'phone', 'fax', 'meUrl'],
                        // 'meLanguageid', 'fallbackLanguage''
                        //'_only' => ['languageCode', 'name', 'address', 'ddress2', 'address3', 'addon', 'poboxText', 'zip', 'city', 'countryIsoCode', 'type'],
                        '_exposeObjectIdentifier' => true,
                        //'_exposedObjectIdentifierKey' => 'guid',
                    ],
                ],
            ]
        ]);
        $this->view->assignMultiple([
            'json' => [
                'result' => $organisations,
            ]
        ]);
        return $this->jsonResponse($this->view->render());
        */
    }
    /**
     * action show
     */
    public function showAction(): ResponseInterface
    {
        $search = $this->getSearch() ?? [];
        $uid = (int) $search['uid'] ?? 0;
        $organisation = null;
        if ($uid > 0) {
            $token = $this->request->hasArgument('apiKey') ? $this->request->getArgument('apiKey') : '';
            $this->organisationRepository->setToken($token);
            $organisation = $this->organisationRepository->findByUid($uid);
        }

        $this->view->assignMultiple([
            'json' => [
                'result' => $organisation,
            ],
        ]);

        $this->view->setVariablesToRender(['json']);
        $this->view->setConfiguration([
            'json' => [
                'result' => [
                    '_exclude' => ['qrCode'],
                    '_only' => [
                        'type',
                        'meCompanyname',
                        'meAddon',
                        'bfsUid',
                        'meMap',
                        'meNoEmployees',
                        'isLehrbetrieb',
                        'meBbf',
                        'meAddress',
                        'meZip',
                        'meCity',
                        'meCountryAbrev',
                        'meAddressid',
                        'meShortname',
                        'meEmail',
                        'phone',
                        'fax',
                        'meUrl',
                    ],
                    // 'meLanguageid', 'fallbackLanguage''
                    //'_only' => ['languageCode', 'name', 'address', 'ddress2', 'address3', 'addon', 'poboxText', 'zip', 'city', 'countryIsoCode', 'type'],
                    '_exposeObjectIdentifier' => true,
                    '_exposedObjectIdentifierKey' => 'uid',
                ],
            ],
        ]);
        return $this->jsonResponse($this->view->render());
    }
}
