<?php

namespace Internetgalerie\IgCrmAdmin\Controller;

use Internetgalerie\IgCrmAdmin\Controller\TYPO3\CMS\Extbase\Annotation\IgnoreValidation;
use Internetgalerie\IgsCrm\Domain\Model\Organisation;
use Internetgalerie\IgsCrm\Domain\Repository\CategoryOrganisationRepository;
use Internetgalerie\IgsCrm\Domain\Repository\KantonRepository;
use Internetgalerie\IgsCrm\Domain\Repository\LanguageRepository;
use Internetgalerie\IgsCrm\Domain\Repository\OrganisationRepository;
use Psr\Http\Message\ResponseInterface;
use TYPO3\CMS\Core\Context\Context;
use TYPO3\CMS\Core\Type\ContextualFeedbackSeverity;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Persistence\Generic\PersistenceManager;

class OrganisationController extends ContactController
{
    protected $objectClass = Organisation::class;
    protected $type = 'Organisation';
    protected $aclReadGroup = 'fe_organisation';
    protected $aclWriteGroup = 'fe_organisation_edit';
    //protected $aclDeleteGroup = 'fe_organisation_delete';

    protected $partial = [
        'searchForm' => 'Organisation/SearchForm',
        'action' => 'Organisation/Action',
    ];
    
    /**
     * languageRepository
     *
     * @var LanguageRepository
     */
    protected $languageRepository = null;


    public function __construct(
        OrganisationRepository $entryRepository
    ) {
        $this->entryRepository = $entryRepository;
    }
    


    /**
     * action show
     */
    public function showAction(Organisation $organisation): ResponseInterface
    {
        $context = GeneralUtility::makeInstance(Context::class);
        $frontendUserId = $context->getPropertyFromAspect('frontend.user', 'id');

        // check access permissions
        if (!$this->securityUtility->hasPermissionRead(
            $organisation,
            'crm.contact',
            [$this->aclReadGroup]
        )) {
            return $this->htmlResponse(self::ACCESS_DENIED);
        }
        
        $verbaende = $this->verbandRepository->findAllWithAcl();

        $headerVerbands = $this->securityUtility->getFrontendUserHeaderVerband();
        if (empty($headerVerbands)) {
            $headerVerbands = $verbaende;
        }
        $this->view->assign('headerVerbands', $headerVerbands);

        
        $verbaendeTabs = $this->createTenantTabs($headerVerbands, $organisation);
        $this->view->assign('verbaendeTabs', $verbaendeTabs);
        
        $this->assignConf($this->getConf());

        $activeTab = $this->request->hasArgument('activeTab') ? $this->request->getArgument('activeTab') : '';
        $this->view->assign('activeTab', $activeTab);

        
        $this->view->assign('organisation', $organisation);
        return $this->htmlResponse($this->view->render());
    }

    /**
     * action new
     */
    #[IgnoreValidation([
        'argumentName' => 'new',
    ])] // Organisation
    public function newAction(Organisation $newOrganisation = null): ResponseInterface
    {
        if (!$this->securityUtility->hasGroupName($this->aclWriteGroup)) {
            return $this->htmlResponse(self::ACCESS_DENIED);
        }
        if ($this->settings['useOwnAddressNo'] == 1) {
            $nextAddress = $this->entryRepository->getMaxAddressNo() + 1;
        } else {
            $nextAddress = '';
        }
        $this->assignFormfields();
        $this->view->assign('nextAddressNo', $nextAddress);
        /**
         * Propagate vars
         * FIXME: THERE HAS TO BE A BETTER WAY
         */
        if ($this->request->hasArgument('meName')) {
            $this->view->assign('meName', $this->request->getArgument('meName'));
        }
        if ($this->request->hasArgument('meZipCity')) {
            $this->view->assign('meZipCity', $this->request->getArgument('meZipCity'));
        }
        if ($this->request->hasArgument('meErhaeltInvoice')) {
            $this->view->assign('erhaeltInvoice', $this->request->getArgument('meErhaeltInvoice'));
        }
        $search = $this->getSearch();
        $this->view->assign('search', $search);
        $this->assignEditNew();
        $this->view->assign('newOrganisation', $newOrganisation);
        return $this->htmlResponse($this->view->render());
    }

    public function assignEditNew(): void
    {
        $this->kantonRepository = GeneralUtility::makeInstance(KantonRepository::class);
        $this->view->assign('kantone', $this->kantonRepository->findAll());
        $this->categoryOrganisationRepository = GeneralUtility::makeInstance(CategoryOrganisationRepository::class);
        $this->view->assign('categories', $this->categoryOrganisationRepository->findByLimitToTypeOrNull($this->type));
        $this->languageRepository = GeneralUtility::makeInstance(LanguageRepository::class);
        $this->view->assign('languages', $this->languageRepository->findAll());
    }
    /**
     * action newFast
     */
    #[IgnoreValidation([
        'argumentName' => 'new',
    ])] // Organisation
    public function newFastAction(Organisation $newOrganisation = null): ResponseInterface
    {
        if (!$this->securityUtility->hasGroupName($this->aclWriteGroup)) {
            return $this->htmlResponse(self::ACCESS_DENIED);
        }
        $this->assignOpenerProperty();
        $this->view->assign('newOrganisation', $newOrganisation);
        $this->kantonRepository = GeneralUtility::makeInstance(KantonRepository::class);
        $this->view->assign('kantone', $this->kantonRepository->findAll());
        return $this->htmlResponse($this->view->render());
    }

    /**
     * action create
     */
    public function createAction(Organisation $organisation): ResponseInterface
    {
        if (!$this->securityUtility->hasGroupName($this->aclWriteGroup)) {
            return $this->htmlResponse(self::ACCESS_DENIED);
        }
        $search = $this->getSearch();
        $searchVerbandUid = (int)($search['verband'] ?? 0);
        $this->securityUtility->setAcl($organisation, $searchVerbandUid);
        $this->entryRepository->add($organisation);
        $this->addFlashMessage('Der Eintrag wurde erstellt.', '', ContextualFeedbackSeverity::OK);

        $persistenceManager = GeneralUtility::makeInstance(PersistenceManager::class);
        $persistenceManager->persistAll();
        return $this->redirectWithSearch('show', '', null, [
            'organisation' => $organisation,
        ]);
    }

    /**
     * action createFast
     */
    public function createFastAction(Organisation $organisation): ResponseInterface
    {
        if (!$this->securityUtility->hasGroupName($this->aclWriteGroup)) {
            return $this->htmlResponse(self::ACCESS_DENIED);
        }
        $this->entryRepository->add($organisation);
        $persistenceManager = GeneralUtility::makeInstance(PersistenceManager::class);
        $persistenceManager->persistAll(); //uid erzwingen
        //$this->addFlashMessage('Der Eintrag wurde erstellt.', '', \TYPO3\CMS\Core\Messaging\FlashMessage::OK);
        echo '<script>
opener.setCompany("' . $this->request->getArgument(
            'openerProperty'
        ) . '",' . $organisation->getUid() . ',"' . $organisation->getCompanyname() . '");
window.close();
</script>
';
        exit(0);
        return $this->htmlResponse($this->view->render());
    }

    /**
     * action edit
     */
    #[IgnoreValidation([
        'argumentName' => 'organisation',
    ])]
    public function editAction(Organisation $organisation): ResponseInterface
    {
        if (!$this->securityUtility->hasGroupName($this->aclWriteGroup)) {
            return $this->htmlResponse(self::ACCESS_DENIED);
        }

        $currentRp = $organisation->getMeRespPersonid();
        $responsibleOptionsArray = [];
        $found = false;
        /*
          // @todo responsibleOptions is probably used
        if (is_object($currentRp)) {
            $currentRpUid = $currentRp->getUid();
            foreach ($responsibleOptions as $rp) {
                if ($rp->getUid() == $currentRpUid) {
                    $found = true;
                    break;
                }
                $responsibleOptionsArray[] = $rp;
            }
        }
        */

        $this->assignFormfields();


        if (!$found && $currentRp) {
            $responsibleOptionsArray[] = $currentRp;
            $this->view->assign('responsibleOptions', $responsibleOptionsArray);
        }
        //findByMePersonOfOrganisationid($organisation);
        //$this->view->assign('responsibleOptions', $responsibleOptions);
        
        if ($this->request->hasArgument('meName')) {
            $this->view->assign('meName', $this->request->getArgument('meName'));
        }
        if ($this->request->hasArgument('meZipCity')) {
            $this->view->assign('meZipCity', $this->request->getArgument('meZipCity'));
        }
        $this->view->assign('organisation', $organisation);

        $filialen = $this->entryRepository->findFilialen($organisation->getUid());
        $this->view->assign('filialen', $filialen);

        $this->assignEditNew();
        return $this->htmlResponse($this->view->render());
    }

    /**
     * action update
     */
    public function updateAction(Organisation $organisation): ResponseInterface
    {
        if (!$this->securityUtility->hasGroupName($this->aclWriteGroup)) {
            return $this->htmlResponse(self::ACCESS_DENIED);
        }
        $this->addFlashMessage('Der Eintrag wurde aktualisiert.', '', ContextualFeedbackSeverity::OK);
        $this->entryRepository->update($organisation);
        return $this->redirectWithSearch('show', '', null, [
            'organisation' => $organisation,
        ]);
    }

    /**
     * action delete
     */
    public function deleteAction(Organisation $organisation): ResponseInterface
    {
        if (!$this->securityUtility->hasPermissionWrite($organisation, self::$requiredRole, [$this->aclDeleteGroup])) {
            return $this->htmlResponse(self::ACCESS_DENIED);
        }
        $this->entryRepository->remove($organisation);
        $this->addFlashMessage('Der Eintrag wurde gelöscht.', '', ContextualFeedbackSeverity::OK);
        return $this->redirectWithSearch('list');
    }
}
