<?php

namespace Internetgalerie\IgCrmAdmin\Controller;

use Ig\IgFibu\Domain\Model\Payment;
use Internetgalerie\IgsCrm\Utility\SecurityUtility;

class PaymentController extends \Ig\IgFibu\Controller\PaymentController
{
    protected $objectClass = Payment::class;
    /**
     * securityUtility
     *
     * @var SecurityUtility
     */
    protected $securityUtility = null;

    /**
     * inject the SecurityUtility (for checking access to objects)
     */
    public function injectSecurityUtility(SecurityUtility $securityUtility): void
    {
        $this->securityUtility = $securityUtility;
    }
    protected function getSearch()
    {
        $search = parent::getSearch();
        if (!($search['showentries'] ?? 0) && !isset($search['verband'])) {
            $globalVerband = $this->securityUtility->getGlobalVerband();
            if ($globalVerband > 0) {
                $search['verband'] = $this->securityUtility->getGlobalVerband();
            }
        }
        return $search;
    }
}
