<?php

namespace Internetgalerie\IgCrmAdmin\Controller;

use Internetgalerie\IgsCrm\Utility\SecurityUtility;

/**
 * InvoiceController
 */
class PaymentImportController extends \Ig\IgFibu\Controller\PaymentImportController
{
    /**
     * securityUtility
     *
     * @var SecurityUtility
     */
    protected $securityUtility = null;

    /**
     * inject the SecurityUtility (for checking access to objects)
     */
    public function injectSecurityUtility(SecurityUtility $securityUtility): void
    {
        $this->securityUtility = $securityUtility;
    }

    protected function getSearch()
    {
        $search = parent::getSearch();
        if (!$search['showentries'] ?? 0 && !isset($search['verband'])) {
            $search['verband'] = $this->securityUtility->getGlobalVerband();
        }

        return $search;
    }
}
