<?php

namespace Internetgalerie\IgCrmAdmin\Controller;

use Internetgalerie\IgCrmAdmin\Controller\TYPO3\CMS\Extbase\Annotation\IgnoreValidation;
use Internetgalerie\IgCrmAdmin\Utility\PeriodUtility;
use Internetgalerie\IgsCrm\Domain\Model\FrontendUser;
use Internetgalerie\IgsCrm\Domain\Model\FrontendUserGroup;
use Internetgalerie\IgsCrm\Domain\Model\Person;
use Internetgalerie\IgsCrm\Domain\Repository\KantonRepository;
use Internetgalerie\IgsCrm\Domain\Repository\PersonRepository;
use Internetgalerie\IgsCrm\Utility\ConfUtility;
use Internetgalerie\IgsCrm\Utility\SecurityUtility;
use Psr\Http\Message\ResponseInterface;
use TYPO3\CMS\Core\Page\PageRenderer;
use TYPO3\CMS\Core\Type\ContextualFeedbackSeverity;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Http\ForwardResponse;
use TYPO3\CMS\Extbase\Persistence\Generic\PersistenceManager;

class PersonController extends ContactController
{
    protected $objectClass = Person::class;

    protected $type = 'Person';
    protected $partial = [
        'searchForm' => 'Person/SearchForm',
        'action' => 'Person/Action',
    ];


    public function __construct(
        PersonRepository $entryRepository
    ) {
        $this->entryRepository = $entryRepository;
    }
 
    public function addJsContactEdit(): void
    {
        $pageRenderer = GeneralUtility::makeInstance(PageRenderer::class);
        $pageRenderer->addJsFooterFile('EXT:ig_crm_admin/Resources/Public/JavaScript/ContactEdit.js');
    }
    
    public function initializeShowAction(): void
    {
        $this->registerPersonFromRequest('person');
        $this->settings['invoicePeriod'] = PeriodUtility::getCurrentPeriod();
    }

    /**
     * action show
     */
    public function showAction(Person $person): ResponseInterface
    {
        if (!$this->securityUtility->hasPermissionRead($person, 'crm.contact', [$this->aclReadGroup])) {
            return $this->htmlResponse(self::ACCESS_DENIED);
        }
        //$search = $this->getSearch();        var_dump($search);exit(0);
        //var_dump($this->entryRepository->getUidByNumber(100012));exit(0);

        $verbaende = $this->verbandRepository->findAllWithAcl();
        $this->view->assign('person', $person);
        $this->view->assign('verbaende', $verbaende);

        $this->assignConf($this->getConf());
        
        $globalVerband = $this->securityUtility->getGlobalVerband();
        $currentGlobalVerbandFound = false;
        $headerVerbands = $this->securityUtility->getFrontendUserHeaderVerband($globalVerband);
        if (empty($headerVerbands)) {
            $headerVerbands = $verbaende;
        }
        $this->view->assign('headerVerbands', $headerVerbands);

        $verbaendeTabs = $this->createTenantTabs($headerVerbands, $person);
        $this->view->assign('verbaendeTabs', $verbaendeTabs);

        $activeTab = $this->request->hasArgument('activeTab') ? $this->request->getArgument('activeTab') : '';
        $this->view->assign('activeTab', $activeTab);
        return $this->htmlResponse($this->view->render());
    }

    /**
     * action new
     */
    #[IgnoreValidation([
        'argumentName' => 'person',
    ])]
    public function newAction(Person $person = null): ResponseInterface
    {
        if (!$this->securityUtility->hasPermissionWrite($person, self::$requiredRole, [$this->aclWriteGroup])) {
            return $this->htmlResponse(self::ACCESS_DENIED);
        }
        $this->addJsContactEdit();
        if ($this->settings['useOwnAddressNo'] >= 1) {
            $nextAddress = $this->entryRepository->getMaxAddressNo() + 1;
        } else {
            $nextAddress = '';
        }
        $personMeAddressid = $this->settings['useOwnAddressNo'] == 2 ? $nextAddress : '';

        $search = $this->getSearch();
        $this->view->assign('search', $search);
        $this->assignFormfields();
        $control = $this->getControl();
        $this->assignControl($control);

        if ($search['category'] ?? 0) {
            $this->view->assign('defaultCategories', [$search['category']]);
        }

        $this->view->assign('personNextMeAddressid', $nextAddress); // Value for Javascript
        $this->view->assign('personMeAddressid', $personMeAddressid); // default Value
        $this->view->assign('person', $person);
        //$this->view->assign('alterskategorie', 'Wird erst nach Speichern des Datensatzes angezeigt.');
        return $this->htmlResponse($this->view->render());
    }

    /**
     * action newFast
     */
    #[IgnoreValidation([
        'argumentName' => 'person',
    ])]
    public function newFastAction(Person $person = null): ResponseInterface
    {
        if (!$this->securityUtility->hasPermissionWrite($person, self::$requiredRole, [$this->aclWriteGroup])) {
            return $this->htmlResponse(self::ACCESS_DENIED);
        }
        $this->addJsContactEdit();
        $this->assignOpenerProperty();
        $this->assignFormfields();
        $this->view->assign('newPerson', $newPerson);
        $this->kantonRepository = GeneralUtility::makeInstance(KantonRepository::class);
        $this->view->assign('kantone', $this->kantonRepository->findAll());
        return $this->htmlResponse($this->view->render());
    }

    
    /**
     * action create
     */
    public function createAction(Person $person): ResponseInterface
    {
        if (!$this->securityUtility->hasPermissionWrite(null, self::$requiredRole, [$this->aclWriteGroup])) {
            return $this->htmlResponse(self::ACCESS_DENIED);
        }
        $control = $this->getControl();
        
        $search = $this->getSearch();
        $searchVerbandUid = (int)($search['verband'] ?? 0);
        $this->securityUtility->setAcl($person, $searchVerbandUid);
        $this->entryRepository->add($person);
        $persistenceManager = GeneralUtility::makeInstance(PersistenceManager::class);
        $persistenceManager->persistAll();
        $this->addFlashMessage('Der Eintrag wurde erstellt.', '', ContextualFeedbackSeverity::OK);
        //if ($this->request->hasArgument('addPersonverband')) {

        $tenantId = $searchVerbandUid;
        if ($control['verband'] ?? false) {
            $tenantId = (int) $control['verband'];
        } elseif ($this->settings['verbandUid'] ?? false) {
                $tenantId = (int) $this->settings['verbandUid'];
        }

        if ($tenantId) {
            $args = [
                'contact' => $person,
                'verband' => $tenantId,
                'control' => $control,
            ];
            //$args['activeTab']=$this->request->getArgument('activeTab');
            return $this->redirectWithSearch('edit', 'ContactVerband', null, $args);
        } elseif ($control['organisation'] ?? false) {
            $args = [
                'contact' => $person,
                'organisation' => (int) $control['organisation'],
                'control' => $control,
                //  'search' => $search,
            ];
            //$args['activeTab']=$this->request->getArgument('activeTab');
            //$this->redirect('edit', 'ContactContact', null, $args);
            return $this->redirectWithSearch('edit', 'ContactContact', null, $args);
        }
        return $this->redirectWithSearch('list', null, null, [
            'search' => $search,
        ]);
        
        return $this->htmlResponse($this->view->render());
    }
    
    /**
     * action createFast
     */
    public function createFastAction(Person $person): ResponseInterface
    {
        if (!$this->securityUtility->hasPermissionWrite(null, self::$requiredRole, [$this->aclWriteGroup])) {
            return $this->htmlResponse(self::ACCESS_DENIED);
        }
        $this->entryRepository->add($person);
        $persistenceManager = GeneralUtility::makeInstance(PersistenceManager::class);
        $persistenceManager->persistAll(); //uid erzwingen
        //$this->addFlashMessage('Der Eintrag wurde erstellt.', '', \TYPO3\CMS\Core\Messaging\FlashMessage::OK);
        echo '<script>
opener.setCompany("' . $this->request->getArgument(
            'openerProperty'
        ) . '",' . $person->getUid() . ',"' . $person->getName() . '");
window.close();
</script>
';
        exit(0);
        return $this->htmlResponse($this->view->render());
    }
    
    /**
     * action edit
     */
    #[IgnoreValidation([
        'argumentName' => 'person',
    ])]
    public function editAction(Person $person): ResponseInterface
    {
        if (!$this->securityUtility->hasPermissionWrite($person, self::$requiredRole, [$this->aclWriteGroup])) {
            return $this->htmlResponse(self::ACCESS_DENIED);
        }
        $this->assignFormfields();
        $control = $this->getControl();
        $this->assignControl($control);
        $this->view->assign('person', $person);
        return $this->htmlResponse($this->view->render());
    }

    public function initializeEditPersonAction(): void
    {
        $this->registerPersonFromRequest('person');
    }
    /**
     * action editPerson
     */
    #[IgnoreValidation([
        'argumentName' => 'person',
    ])]
    public function editPersonAction(Person $person): ResponseInterface
    {
        if (!$this->securityUtility->hasPermissionWrite($person, self::$requiredRole, [$this->aclWriteGroup])) {
            return $this->htmlResponse(self::ACCESS_DENIED);
        }
        $this->addJsContactEdit();
        
        if ($this->settings['useOwnAddressNo'] >= 1) {
            $nextAddress = $this->entryRepository->getMaxAddressNo() + 1;
        } else {
            $nextAddress = '';
        }
        $this->view->assign('personNextMeAddressid', $nextAddress);
        $personMeAddressid = $this->settings['useOwnAddressNo'] == 2 ? $nextAddress : '';
        $this->view->assign('person', $person);
        $this->assignFormfields();
        $control = $this->getControl();
        $this->assignControl($control);
        return $this->htmlResponse($this->view->render());
    }

    /**
     * action editAccount
     */
    #[IgnoreValidation([
        'argumentName' => 'person',
    ])]
    public function editAccountAction(
        Person $person,
        FrontendUser $frontendUser = null,
        string $password = null
    ): ResponseInterface {
        if (!$this->securityUtility->hasPermissionWrite($person, self::$requiredRole, [$this->aclWriteGroup])) {
            return $this->htmlResponse(self::ACCESS_DENIED);
        }
        $this->view->assign('person', $person);
        if ($frontendUser === null) {
            $frontendUser = $person->getFrontendUser();
        }
        if (true) {
            $this->view->assign('usernameDefault', $person->getMeAccount());
            $this->view->assign('showPassword', true);
        } else {
            $this->view->assign('usernameDefault', $person->getEmail());
            $this->view->assign('showPassword', false);
        }
        $this->view->assign('frontendUser', $frontendUser);
        $this->view->assign('password', $password);
        $control = $this->getControl();
        $this->assignControl($control);
        return $this->htmlResponse($this->view->render());
    }

    /**
     * action editBildungspass
     */
    #[IgnoreValidation([
        'argumentName' => 'person',
    ])]
    public function editBildungspassAction(Person $person): ResponseInterface
    {
        if (!$this->securityUtility->hasPermissionWrite($person, self::$requiredRole, [$this->aclWriteGroup])) {
            return $this->htmlResponse(self::ACCESS_DENIED);
        }
        $this->view->assign('person', $person);
        return $this->htmlResponse($this->view->render());
    }

    /**
     * action editFirma
     */
    #[IgnoreValidation([
        'argumentName' => 'person',
    ])]
    public function editFirmaAction(Person $person): ResponseInterface
    {
        if (!$this->securityUtility->hasPermissionWrite($person, self::$requiredRole, [$this->aclWriteGroup])) {
            return $this->htmlResponse(self::ACCESS_DENIED);
        }
        $this->view->assign('person', $person);
        return $this->htmlResponse($this->view->render());
    }

    /**
     * action editTvgCh
     */
    #[IgnoreValidation([
        'argumentName' => 'person',
    ])]
    public function editTvgChAction(Person $person): ResponseInterface
    {
        if (!$this->securityUtility->hasPermissionWrite($person, self::$requiredRole, [$this->aclWriteGroup])) {
            return $this->htmlResponse(self::ACCESS_DENIED);
        }
        $this->view->assign('person', $person);
        return $this->htmlResponse($this->view->render());
    }

    /**
     * action editNewsletter
     */
    #[IgnoreValidation([
        'argumentName' => 'person',
    ])]
    public function editNewsletterAction(Person $person): ResponseInterface
    {
        if (!$this->securityUtility->hasPermissionWrite($person, self::$requiredRole, [$this->aclWriteGroup])) {
            return $this->htmlResponse(self::ACCESS_DENIED);
        }
        $this->view->assign('person', $person);
        return $this->htmlResponse($this->view->render());
    }

    public function initializeUpdateAction(): void
    {
        $this->registerPersonFromRequest('person');
    }

    /**
     * action update
     */
    public function updateAction(Person $person): ResponseInterface
    {
        if (!$this->securityUtility->hasPermissionWrite($person, self::$requiredRole, [$this->aclWriteGroup])) {
            return $this->htmlResponse(self::ACCESS_DENIED);
        }

        // change owner
        //$person->setAclOwner($this->securityUtility->getFrontendUserId());
        $this->securityUtility->setAcl($person);
        $this->entryRepository->update($person);
        $this->addFlashMessage('Der Eintrag wurde aktualisiert.');

        $args = [
            'person' => $person,
        ];
        if ($this->request->hasArgument('activeTab')) {
            $args['activeTab'] = $this->request->getArgument('activeTab');
        }
        
        return $this->redirectWithSearch('show', '', null, $args);
    }

    /**
     * action updateAccount
     */
    public function updateAccountAction(
        Person $person,
        FrontendUser $frontendUser,
        string $password = null
    ): ResponseInterface {
        if (!$this->securityUtility->hasPermissionWrite($person, self::$requiredRole, [$this->aclWriteGroup])) {
            return $this->htmlResponse(self::ACCESS_DENIED);
        }
        if (!$person) {
            return $this->htmlResponse('No Person');
        }

        $isNew = ($frontendUser->getUid() === null);

        
        if ($password) {
            $passwordMessage = SecurityUtility::checkPassword($password);
            if ($passwordMessage !== null) {
                $this->addFlashMessage($passwordMessage, '', ContextualFeedbackSeverity::ERROR);
                return new ForwardResponse('editAccount');
            }
            $hashedPassword = $this->getHashedPassword($password);
            $frontendUser->setPassword($hashedPassword);
            $person->setMePassword($password);//@deprecated 0.8
        } else {
            if ($isNew) {
                $this->addFlashMessage('Passwort ist zwingend', '', ContextualFeedbackSeverity::ERROR);
                return new ForwardResponse('editAccount');
            }
        }
        if (trim($frontendUser->getUsername()) == '') {
            $this->addFlashMessage('Benutzername ist zwingend', '', ContextualFeedbackSeverity::ERROR);
            return new ForwardResponse('editAccount');
        }
        // @todo catch more errors e.g. username already in use, better password security...
        $person->setMeAccount($frontendUser->getUsername());//@deprecated 0.8

        $frontendUserStoragePid = (int) $this->settings['frontendUserStoragePid'];
        if ($isNew) {
            if ($frontendUserStoragePid) {
                $frontendUser->setPid($frontendUserStoragePid);
            }
            
            $frontendUserDefaultUsergroupsIds = GeneralUtility::intExplode(
                ',',
                $this->settings['frontendUserDefaultUsergroupsIds'],
                true
            );
            if (!empty($frontendUserDefaultUsergroupsIds)) {
                foreach ($frontendUserDefaultUsergroupsIds as $userGroupId) {
                    $userGroup = $this->frontendUserGroupRepository->findByUid($userGroupId);
                    if (!$userGroup instanceof FrontendUserGroup) {
                        die('Default FrontendUserGroup not found with uid=' . $userGroupId . '. Change constant "frontendUserDefaultUsergroupsIds"');
                    }
                    $frontendUser->addUsergroup($userGroup);
                }
            }
        }

        // sync data with person
        $frontendUser->setName($person->getMeFirstname() . ' ' . $person->getMeLastname());
        $frontendUser->setFirstName($person->getMeFirstname());
        $frontendUser->setLastName($person->getMeLastname());
        $frontendUser->setEmail($person->getMeMailAlias());
        $frontendUser->setAddress($person->getMeAddress());
        $frontendUser->setZip($person->getMeZip());
        $frontendUser->setCity($person->getMeCity());

        // trim username
        $trimmedUsername = trim($frontendUser->getUsername());
        if ($trimmedUsername != $frontendUser->getUsername()) {
            $frontendUser->setUsername($trimmedUsername);
        }
        if ($isNew) {
            $this->frontendUserRepository->add($frontendUser);
            $persistenceManager = GeneralUtility::makeInstance(PersistenceManager::class);
            $persistenceManager->persistAll();
            $person->setFrontendUser($frontendUser);
        } else {
            $this->frontendUserRepository->update($frontendUser);
        }
        //}

        $this->entryRepository->update($person);
        $this->addFlashMessage('Der Eintrag wurde aktualisiert.');
            
        $args = [
            'person' => $person,
        ];
        if ($this->request->hasArgument('activeTab')) {
            $args['activeTab'] = $this->request->getArgument('activeTab');
        }

        return $this->redirectWithSearch('show', '', null, $args);
    }

    /**
     * action delete
     */
    #[IgnoreValidation([
        'argumentName' => 'person',
    ])]
    public function deleteAction(Person $person): ResponseInterface
    {
        if (!$this->securityUtility->hasPermissionWrite($person, self::$requiredRole, [$this->aclDeleteGroup])) {
            return $this->htmlResponse(self::ACCESS_DENIED);
        }
        $this->entryRepository->remove($person);
        $this->addFlashMessage('Der Eintrag wurde gelöscht.');
        return $this->redirectWithSearch('list');
    }

    /**
     * action confirmDeleteAccount
     */
    public function confirmDeleteAccountAction(Person $person, FrontendUser $frontendUser): ResponseInterface
    {
        $this->view->assign('person', $person);
        $this->view->assign('frontendUser', $frontendUser);
        return $this->htmlResponse($this->view->render());
    }
    
    /**
     * action deleteAccount
     */
    public function deleteAccountAction(Person $person, FrontendUser $frontendUser): ResponseInterface
    {
        $this->frontendUserRepository->remove($frontendUser);
        $args = [
            'person' => $person,
        ];
        return $this->redirectWithSearch('show', '', null, $args);
    }

    protected function registerPersonFromRequest($argumentName)
    {
        $argument = $this->request->getArgument($argumentName);
        $uid = is_array($argument) ? intval($argument['__identity']) : intval($argument);
        $person = $this->entryRepository->findHiddenByUid($uid);
        $argument = $this->arguments->getArgument($argumentName);
        $argument->setValue($person);
    }
    protected function assignAdvancedSearch(array $search)
    {
        parent::assignAdvancedSearch($search);
        $this->confUtility ??= GeneralUtility::makeInstance(ConfUtility::class);
        $this->view->assign('crmJahrgaenge', $this->confUtility->getCrmJahrgaenge());
    }
}
