<?php

namespace Internetgalerie\IgCrmAdmin\Controller;

use Internetgalerie\IgsCrm\Domain\Model\Preise;
use Internetgalerie\IgsCrm\Domain\Repository\PreiseRepository;
use Psr\Http\Message\ResponseInterface;
use TYPO3\CMS\Extbase\Mvc\Controller\ActionController;

class PreiseController extends ActionController
{
    protected $objectClass = Preise::class;
    /**
     * preiseRepository
     *
     * @var PreiseRepository
     */
    protected $preiseRepository = null;

    public function injectPreiseRepository(PreiseRepository $preiseRepository): void
    {
        $this->preiseRepository = $preiseRepository;
    }

    /**
     * action list
     */
    public function listAction(): ResponseInterface
    {
        $preises = $this->preiseRepository->findAll();
        $this->view->assign('preises', $preises);
        return $this->htmlResponse($this->view->render());
    }
}
