<?php

namespace Internetgalerie\IgCrmAdmin\Controller;

use Internetgalerie\IgCrmAdmin\Controller\TYPO3\CMS\Extbase\Annotation\IgnoreValidation;
use Internetgalerie\IgDatapoolFe\Controller\ActionController;
use Internetgalerie\IgsCrm\Domain\Model\Tag;
use Internetgalerie\IgsCrm\Domain\Model\Verband;
use Internetgalerie\IgsCrm\Domain\Repository\TagRepository;
use Internetgalerie\IgsCrm\Domain\Repository\TagverbandRepository;
use Internetgalerie\IgsCrm\Domain\Repository\VerbandRepository;
use Psr\Http\Message\ResponseInterface;

class TagController extends ActionController
{
    protected $objectClass = Tag::class;
    /**
     * tagRepository
     *
     * @var TagRepository
     */
    protected $tagRepository = null;

    /**
     * verbandRepository
     *
     * @var VerbandRepository
     */
    protected $verbandRepository = null;

    /**
     * tagverbandRepository
     *
     * @var TagverbandRepository
     */
    protected $tagverbandRepository = null;

    public function injectVerbandRepository(VerbandRepository $verbandRepository): void
    {
        $this->verbandRepository = $verbandRepository;
    }

    public function injectTagRepository(TagRepository $tagRepository): void
    {
        $this->tagRepository = $tagRepository;
    }

    public function injectTagverbandRepository(TagverbandRepository $tagverbandRepository): void
    {
        $this->tagverbandRepository = $tagverbandRepository;
    }


    
    /**
     * action new
     */
    #[IgnoreValidation([
        'argumentName' => 'tag',
    ])]
    public function newAction(Verband $verband, Tag $tag = null): ResponseInterface
    {
        $this->view->assign('tag', $tag);
        $this->view->assign('verband', $verband);
        $this->view->assign('verbaende', $this->verbandRepository->findAll());
        $this->view->assign('tagsverband', $this->tagverbandRepository->findBy([
            'verband' => $verband,
        ]));
        if ($this->request->hasArgument('activeTab')) {
            $activeTab = $this->request->getArgument('activeTab');
        }
        $this->view->assign('activeTab', $activeTab);
        return $this->htmlResponse($this->view->render());
    }
    
    /**
     * action edit
     */
    #[IgnoreValidation([
        'argumentName' => 'tag',
    ])]
    public function editAction(Tag $tag, Verband $verband): ResponseInterface
    {
        $this->view->assign('tag', $tag);
        $this->view->assign('verband', $verband);
        $this->view->assign('verbaende', $this->verbandRepository->findAll());
        $this->view->assign('tagsverband', $this->tagverbandRepository->findBy([
            'verband' => $verband,
        ]));
        if ($this->request->hasArgument('activeTab')) {
            $activeTab = $this->request->getArgument('activeTab');
        }
        $this->view->assign('activeTab', $activeTab);
        return $this->htmlResponse($this->view->render());
    }

    /**
     * action create
     */
    #[IgnoreValidation([
        'argumentName' => 'verband',
    ])]
    public function createAction(Tag $tag, Verband $verband): ResponseInterface
    {
        $this->tagRepository->add($tag);
        $this->addFlashMessage('Der Eintrag wurde erstellt.');
        $args = [
            'verband' => $verband,
        ];
        if ($this->request->hasArgument('activeTab')) {
            $args['activeTab'] = $this->request->getArgument('activeTab');
        }
        return $this->redirectWithSearch('show', 'Verband', null, $args);
    }

    /**
     * action update
     */
    #[IgnoreValidation([
        'argumentName' => 'verband',
    ])]
    public function updateAction(Tag $tag, Verband $verband): ResponseInterface
    {
        $this->tagRepository->update($tag);
        $this->addFlashMessage('Der Eintrag wurde aktualisiert.');
        $args = [
            'verband' => $verband,
        ];
        if ($this->request->hasArgument('activeTab')) {
            $args['activeTab'] = $this->request->getArgument('activeTab');
        }
        return $this->redirectWithSearch('show', 'Verband', null, $args);
    }

    /**
     * action confirmDelete
     */
    #[IgnoreValidation([
        'argumentName' => 'tag',
    ])]
    public function confirmDeleteAction(Tag $tag, Verband $verband): ResponseInterface
    {
        $this->view->assign('tag', $tag);
        $this->view->assign('verband', $verband);
        if ($this->request->hasArgument('activeTab')) {
            $activeTab = $this->request->getArgument('activeTab');
        }
        $this->view->assign('activeTab', $activeTab);
        return $this->htmlResponse($this->view->render());
    }

    /**
     * action delete
     */
    #[IgnoreValidation([
        'argumentName' => 'verband',
    ])]
    public function deleteAction(Tag $tag, Verband $verband): ResponseInterface
    {
        $this->tagRepository->remove($tag);
        $this->addFlashMessage('Der Eintrag wurde aktualisiert.');
        $args = [
            'verband' => $verband,
        ];
        if ($this->request->hasArgument('activeTab')) {
            $args['activeTab'] = $this->request->getArgument('activeTab');
        }
        return $this->redirectWithSearch('show', 'Verband', null, $args);
    }
}
