<?php

namespace Internetgalerie\IgCrmAdmin\Controller;

use Internetgalerie\IgCrmAdmin\Controller\TYPO3\CMS\Extbase\Annotation\IgnoreValidation;
use Internetgalerie\IgDatapoolFe\Controller\ActionController;
use Internetgalerie\IgsCrm\Domain\Model\Tag;
use Internetgalerie\IgsCrm\Domain\Model\TagField;
use Internetgalerie\IgsCrm\Domain\Repository\TagFieldRepository;
use Internetgalerie\IgsCrm\Domain\Repository\TagRepository;
use Internetgalerie\IgsCrm\Domain\Repository\VerbandRepository;
use Psr\Http\Message\ResponseInterface;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Persistence\Generic\PersistenceManager;

/**
 * TagController
 */
class TagFieldController extends ActionController
{
    protected $objectClass = TagField::class;
    /**
     * tagFieldRepository
     *
     * @var TagFieldRepository
     */
    protected $tagFieldRepository = null;

    /**
     * verbandRepository
     *
     * @var VerbandRepository
     */
    protected $verbandRepository = null;

    /**
     * tagRepository
     *
     * @var TagRepository
     */
    protected $tagRepository = null;

    public function injectVerbandRepository(VerbandRepository $verbandRepository): void
    {
        $this->verbandRepository = $verbandRepository;
    }

    public function injectTagRepository(TagRepository $tagRepository): void
    {
        $this->tagRepository = $tagRepository;
    }

    public function injectTagFieldRepository(TagFieldRepository $tagFieldRepository): void
    {
        $this->tagFieldRepository = $tagFieldRepository;
    }


    /**
     * action list
     */
    public function listAction(Tag $tag): ResponseInterface
    {
        $this->view->assign('tag', $tag);
        $this->view->assign('verband', $tag->getVerband());
        $tagFields = $this->tagFieldRepository->findBy([
            'tag' => $tag,
        ]);
        $this->view->assign('tagFields', $tagFields);
        if ($this->request->hasArgument('activeTab')) {
            $activeTab = $this->request->getArgument('activeTab');
        }
        $this->view->assign('activeTab', $activeTab);
        return $this->htmlResponse($this->view->render());
    }
    
    /**
     * action new
     */
    #[IgnoreValidation([
        'argumentName' => 'tagField',
    ])]
    public function newAction(Tag $tag, TagField $tagField = null): ResponseInterface
    {
        $this->view->assign('tag', $tag);
        $this->view->assign('verband', $tag->getVerband());
        if ($this->request->hasArgument('activeTab')) {
            $activeTab = $this->request->getArgument('activeTab');
        }
        $languages = $this->getLanguagesWithoutDefault();
        //var_dump($languages);exit(0);
        $this->view->assign('languages', $languages);
        $fieldNumbers = $this->getFieldNumbers($tag);
        $this->view->assign('fieldNumbers', $fieldNumbers);
        $this->view->assign('activeTab', $activeTab);
        return $this->htmlResponse($this->view->render());
    }
    /**
     * action edit
     */
    #[IgnoreValidation([
        'argumentName' => 'tagField',
    ])]
    public function editAction(TagField $tagField, Tag $tag): ResponseInterface
    {
        $this->view->assign('tag', $tag);
        $this->view->assign('verband', $tag->getVerband());
        $this->view->assign('tagField', $tagField);

        $fieldNumbers = $this->getFieldNumbers($tag, $tagField->getUid());
        $this->view->assign('fieldNumbers', $fieldNumbers);
        
        // select uid,title from sys_language WHERE hidden=0;
        $languages = $this->getLanguagesWithoutDefault();
        $translate = [];
        foreach ($languages as $language) {
            $tagFieldTranslated = $this->tagFieldRepository->findRawByUidAndLanguage(
                $tagField->getUid(),
                $language->getLanguageId()
            );
            $translate[$language->getLanguageId()] = $tagFieldTranslated;
        }
        //var_dump( $translate);exit(0);
        
        $this->view->assign('languages', $languages);
        $this->view->assign('translate', $translate);
        if ($this->request->hasArgument('activeTab')) {
            $activeTab = $this->request->getArgument('activeTab');
        }
        $this->view->assign('activeTab', $activeTab);
        return $this->htmlResponse($this->view->render());
    }

    /**
     * action create
     */
    public function createAction(TagField $tagField, array $translate = []): ResponseInterface
    {
        $languages = $this->getLanguagesWithoutDefault();
        $this->tagFieldRepository->add($tagField);
        $persistenceManager = GeneralUtility::makeInstance(PersistenceManager::class);
        $persistenceManager->persistAll();

        foreach ($languages as $language) {
            $languageUid = $language->getLanguageId();
            //var_dump($languageUid, $translate[$languageUid]);
            if (isset($translate[$languageUid])) {
                $tagFieldTranslated = $this->tagFieldRepository->insertUpdateByUidAndLanguage(
                    $tagField,
                    $languageUid,
                    $translate[$languageUid]
                );
            }
        }
        $this->addFlashMessage('Der Eintrag wurde erstellt.');
        $args = [
            'tag' => $tagField->getTag(),
        ];
        if ($this->request->hasArgument('activeTab')) {
            $args['activeTab'] = $this->request->getArgument('activeTab');
        }
        return $this->redirectWithSearch('list', null, null, $args);
    }

    /**
     * action update
     */
    public function updateAction(TagField $tagField, array $translate = []): ResponseInterface
    {
        $languages = $this->getLanguagesWithoutDefault();
        $this->tagFieldRepository->update($tagField);
        foreach ($languages as $language) {
            $languageUid = $language->getLanguageId();
            if (isset($translate[$languageUid])) {
                $tagFieldTranslated = $this->tagFieldRepository->insertUpdateByUidAndLanguage(
                    $tagField,
                    $languageUid,
                    $translate[$languageUid]
                );
            }
        }

        //var_dump($translate,$tagField->getUid());exit(0);
        $this->addFlashMessage('Der Eintrag wurde aktualisiert.');
        $args = [
            'tag' => $tagField->getTag(),
        ];
        if ($this->request->hasArgument('activeTab')) {
            $args['activeTab'] = $this->request->getArgument('activeTab');
        }
        return $this->redirectWithSearch('list', null, null, $args);
    }

    /**
     * action confirmDelete
     */
    public function confirmDeleteAction(TagField $tagField): ResponseInterface
    {
        $this->view->assign('tag', $tagField->getTag());
        $this->view->assign('tagField', $tagField);
        if ($this->request->hasArgument('activeTab')) {
            $activeTab = $this->request->getArgument('activeTab');
        }
        $this->view->assign('activeTab', $activeTab);
        return $this->htmlResponse($this->view->render());
    }

    /**
     * action delete
     */
    public function deleteAction(TagField $tagField): ResponseInterface
    {
        $tag = $tagField->getTag();
        $this->tagFieldRepository->remove($tagField);
        $this->addFlashMessage('Der Eintrag wurde aktualisiert.');
        $args = [
            'tag' => $tag,
        ];
        if ($this->request->hasArgument('activeTab')) {
            $args['activeTab'] = $this->request->getArgument('activeTab');
        }
        return $this->redirectWithSearch('list', null, null, $args);
    }

    protected function getFieldNumbers(Tag $tag, int $uid = null)
    {
        $fieldNumbers = [];
        for ($i = 1; $i <= 3; $i++) {
            $fieldNumbers[$i] = $i;
        }
        $tagFields = $this->tagFieldRepository->findBy([
            'tag' => $tag,
        ]);
        foreach ($tagFields as $field) {
            if ($field->getUid() !== $uid) {
                unset($fieldNumbers[$field->getFieldNumber()]);
            }
        }
        return $fieldNumbers;
    }
    protected function getLanguages()
    {
        return $this->request
            ->getAttribute('site', null)
            ->getAllLanguages();
    }
    protected function getLanguagesWithoutDefault()
    {
        $allLanguages = $this->getLanguages();
        $languages = [];
        foreach ($allLanguages as $language) {
            if ($language->getLanguageId()) {
                $languages[] = $language;
            }
        }
        return $languages;
    }
}
