<?php

namespace Internetgalerie\IgCrmAdmin\Controller;

use Internetgalerie\IgCrmAdmin\Controller\TYPO3\CMS\Extbase\Annotation\IgnoreValidation;
use Internetgalerie\IgDatapoolFe\Controller\ActionController;
use Internetgalerie\IgsCrm\Domain\Model\Tag;
use Internetgalerie\IgsCrm\Domain\Model\TagRole;
use Internetgalerie\IgsCrm\Domain\Repository\TagRepository;
use Internetgalerie\IgsCrm\Domain\Repository\TagRoleRepository;
use Internetgalerie\IgsCrm\Domain\Repository\VerbandRepository;
use Psr\Http\Message\ResponseInterface;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Persistence\Generic\PersistenceManager;

/**
 * TagController
 */
class TagRoleController extends ActionController
{
    protected $objectClass = TagRole::class;
    /**
     * tagRoleRepository
     *
     * @var TagRoleRepository
     */
    protected $tagRoleRepository = null;

    /**
     * verbandRepository
     *
     * @var VerbandRepository
     */
    protected $verbandRepository = null;

    /**
     * tagRepository
     *
     * @var TagRepository
     */
    protected $tagRepository = null;

    public function injectVerbandRepository(VerbandRepository $verbandRepository): void
    {
        $this->verbandRepository = $verbandRepository;
    }

    public function injectTagRepository(TagRepository $tagRepository): void
    {
        $this->tagRepository = $tagRepository;
    }


    public function injectTagRoleRepository(TagRoleRepository $tagRoleRepository): void
    {
        $this->tagRoleRepository = $tagRoleRepository;
    }


    /**
     * action list
     */
    public function listAction(Tag $tag): ResponseInterface
    {
        $this->view->assign('tag', $tag);
        $verband = $tag->getVerband() ?: $tag->getTagVerband()
->getVerband();
        $this->view->assign('verband', $verband);
        $tagRoles = $this->tagRoleRepository->findBy([
            'tag' => $tag,
        ]);
        $this->view->assign('tagRoles', $tagRoles);
        if ($this->request->hasArgument('activeTab')) {
            $activeTab = $this->request->getArgument('activeTab');
        }
        $this->view->assign('activeTab', $activeTab);
        return $this->htmlResponse($this->view->render());
    }
    
    /**
     * action new
     */
    #[IgnoreValidation([
        'argumentName' => 'tagRole',
    ])]
    public function newAction(Tag $tag, TagRole $tagRole = null): ResponseInterface
    {
        $this->view->assign('tag', $tag);
        $verband = $tag->getVerband() ?: $tag->getTagVerband()
->getVerband();
        $this->view->assign('verband', $verband);
        if ($this->request->hasArgument('activeTab')) {
            $activeTab = $this->request->getArgument('activeTab');
        }
        $languages = $this->getLanguagesWithoutDefault();

        $sorting = $this->tagRoleRepository->getMaxSortingByTag($tag);
        $sorting += 10;
        $this->view->assign('defaultSorting', $sorting);

        $this->view->assign('languages', $languages);
        $this->view->assign('activeTab', $activeTab);
        return $this->htmlResponse($this->view->render());
    }

    /**
     * action edit
     */
    #[IgnoreValidation([
        'argumentName' => 'tagRole',
    ])]
    public function editAction(TagRole $tagRole, Tag $tag): ResponseInterface
    {
        $this->view->assign('tag', $tag);
        $verband = $tag->getVerband() ?: $tag->getTagVerband()
->getVerband();
        $this->view->assign('verband', $verband);
        $this->view->assign('tagRole', $tagRole);
        // select uid,title from sys_language WHERE hidden=0;
        $languages = $this->getLanguagesWithoutDefault();
        $translate = [];
        foreach ($languages as $language) {
            $tagRoleTranslated = $this->tagRoleRepository->findRawByUidAndLanguage(
                $tagRole->getUid(),
                $language->getLanguageId()
            );
            $translate[$language->getLanguageId()] = $tagRoleTranslated;
        }
        //var_dump( $translate);exit(0);
        
        $this->view->assign('languages', $languages);
        $this->view->assign('translate', $translate);
        if ($this->request->hasArgument('activeTab')) {
            $activeTab = $this->request->getArgument('activeTab');
        }
        $this->view->assign('activeTab', $activeTab);
        return $this->htmlResponse($this->view->render());
    }

    /**
     * action create
     */
    public function createAction(TagRole $tagRole, array $translate = []): ResponseInterface
    {
        $languages = $this->getLanguagesWithoutDefault();
        $this->tagRoleRepository->add($tagRole);
        $persistenceManager = GeneralUtility::makeInstance(PersistenceManager::class);
        $persistenceManager->persistAll();


        foreach ($languages as $language) {
            $languageUid = $language->getLanguageId();
            if (isset($translate[$languageUid])) {
                $tagRoleTranslated = $this->tagRoleRepository->insertUpdateByUidAndLanguage(
                    $tagRole,
                    $languageUid,
                    $translate[$languageUid]
                );
            }
        }
        $this->addFlashMessage('Der Eintrag wurde erstellt.');
        $args = [
            'tag' => $tagRole->getTag(),
        ];
        if ($this->request->hasArgument('activeTab')) {
            $args['activeTab'] = $this->request->getArgument('activeTab');
        }
        return $this->redirectWithSearch('list', null, null, $args);
    }

    /**
     * action update
     */
    public function updateAction(TagRole $tagRole, array $translate = []): ResponseInterface
    {
        $languages = $this->getLanguagesWithoutDefault();
        $this->tagRoleRepository->update($tagRole);
        foreach ($languages as $language) {
            $languageUid = $language->getLanguageId();
            if (isset($translate[$languageUid])) {
                $tagRoleTranslated = $this->tagRoleRepository->insertUpdateByUidAndLanguage(
                    $tagRole,
                    $languageUid,
                    $translate[$languageUid]
                );
            }
        }

        //var_dump($translate,$tagRole->getUid());exit(0);
        $this->addFlashMessage('Der Eintrag wurde aktualisiert.');
        $args = [
            'tag' => $tagRole->getTag(),
        ];
        if ($this->request->hasArgument('activeTab')) {
            $args['activeTab'] = $this->request->getArgument('activeTab');
        }
        return $this->redirectWithSearch('list', null, null, $args);
    }

    /**
     * action confirmDelete
     */
    public function confirmDeleteAction(TagRole $tagRole): ResponseInterface
    {
        $this->view->assign('tag', $tagRole->getTag());
        $this->view->assign('tagRole', $tagRole);
        if ($this->request->hasArgument('activeTab')) {
            $activeTab = $this->request->getArgument('activeTab');
        }
        $this->view->assign('activeTab', $activeTab);
        return $this->htmlResponse($this->view->render());
    }

    /**
     * action delete
     */
    public function deleteAction(TagRole $tagRole): ResponseInterface
    {
        $tag = $tagRole->getTag();
        $this->tagRoleRepository->remove($tagRole);
        $this->addFlashMessage('Der Eintrag wurde aktualisiert.');
        $args = [
            'tag' => $tag,
        ];
        if ($this->request->hasArgument('activeTab')) {
            $args['activeTab'] = $this->request->getArgument('activeTab');
        }
        return $this->redirectWithSearch('list', null, null, $args);
    }
    protected function getLanguages()
    {
        return $this->request
            ->getAttribute('site', null)
            ->getAllLanguages();
    }
    protected function getLanguagesWithoutDefault()
    {
        $allLanguages = $this->getLanguages();
        $languages = [];
        foreach ($allLanguages as $language) {
            if ($language->getLanguageId()) {
                $languages[] = $language;
            }
        }
        return $languages;
    }
}
