<?php

namespace Internetgalerie\IgCrmAdmin\Controller;

use Internetgalerie\IgCrmAdmin\Controller\TYPO3\CMS\Extbase\Annotation\IgnoreValidation;
use Internetgalerie\IgDatapoolFe\Controller\ActionController;
use Internetgalerie\IgsCrm\Domain\Model\Tagverband;
use Internetgalerie\IgsCrm\Domain\Model\Verband;
use Internetgalerie\IgsCrm\Domain\Repository\TagverbandRepository;
use Internetgalerie\IgsCrm\Domain\Repository\VerbandRepository;
use Psr\Http\Message\ResponseInterface;

class TagverbandController extends ActionController
{
    protected $objectClass = Tagverband::class;
    /**
     * verbandRepository
     *
     * @var VerbandRepository
     */
    protected $verbandRepository = null;

    /**
     * tagverbandRepository
     *
     * @var TagverbandRepository
     */
    protected $tagverbandRepository = null;

    public function injectVerbandRepository(VerbandRepository $verbandRepository): void
    {
        $this->verbandRepository = $verbandRepository;
    }

    public function injectTagverbandRepository(TagverbandRepository $tagverbandRepository): void
    {
        $this->tagverbandRepository = $tagverbandRepository;
    }


    /**
     * action new
     */
    #[IgnoreValidation([
        'argumentName' => 'tagverband',
    ])]
    public function newAction(Verband $verband, Tagverband $tagverband = null): ResponseInterface
    {
        $this->view->assign('tagverband', $tagverband);
        $this->view->assign('verband', $verband);
        $this->view->assign('verbaende', $this->verbandRepository->findAll());
        if ($this->request->hasArgument('activeTab')) {
            $activeTab = $this->request->getArgument('activeTab');
        }
        $this->view->assign('activeTab', $activeTab);
        return $this->htmlResponse($this->view->render());
    }
    /**
     * action edit
     */
    #[IgnoreValidation([
        'argumentName' => 'tagverband',
    ])]
    public function editAction(Tagverband $tagverband, Verband $verband): ResponseInterface
    {
        $this->view->assign('tagverband', $tagverband);
        $this->view->assign('verband', $verband);
        $this->view->assign('verbaende', $this->verbandRepository->findAll());
        if ($this->request->hasArgument('activeTab')) {
            $activeTab = $this->request->getArgument('activeTab');
        }
        $this->view->assign('activeTab', $activeTab);
        return $this->htmlResponse($this->view->render());
    }
    
    /**
     * action create
     */
    #[IgnoreValidation([
        'argumentName' => 'verband',
    ])]
    public function createAction(Tagverband $tagverband, Verband $verband): ResponseInterface
    {
        $this->tagverbandRepository->add($tagverband);
        $this->addFlashMessage('Der Eintrag wurde erstellt.');
        $args = [
            'verband' => $verband,
        ];
        if ($this->request->hasArgument('activeTab')) {
            $args['activeTab'] = $this->request->getArgument('activeTab');
        }
        return $this->redirectWithSearch('show', 'Verband', null, $args);
    }

    /**
     * action update
     */
    #[IgnoreValidation([
        'argumentName' => 'verband',
    ])]
    public function updateAction(Tagverband $tagverband, Verband $verband): ResponseInterface
    {
        $this->tagverbandRepository->update($tagverband);
        $this->addFlashMessage('Der Eintrag wurde aktualisiert.');
        $args = [
            'verband' => $verband,
        ];
        if ($this->request->hasArgument('activeTab')) {
            $args['activeTab'] = $this->request->getArgument('activeTab');
        }
        return $this->redirectWithSearch('show', 'Verband', null, $args);
    }

    /**
     * action confirmDelete
     */
    #[IgnoreValidation([
        'argumentName' => 'tagverband',
    ])]
    public function confirmDeleteAction(Tagverband $tagverband, Verband $verband): ResponseInterface
    {
        $this->view->assign('tagverband', $tagverband);
        $this->view->assign('verband', $verband);
        if ($this->request->hasArgument('activeTab')) {
            $activeTab = $this->request->getArgument('activeTab');
        }
        $this->view->assign('activeTab', $activeTab);
        return $this->htmlResponse($this->view->render());
    }

    /**
     * action delete
     */
    #[IgnoreValidation([
        'argumentName' => 'verband',
    ])]
    public function deleteAction(Tagverband $tagverband, Verband $verband): ResponseInterface
    {
        $this->tagverbandRepository->remove($tagverband);
        $this->addFlashMessage('Der Eintrag wurde aktualisiert.');
        $args = [
            'verband' => $verband,
        ];
        if ($this->request->hasArgument('activeTab')) {
            $args['activeTab'] = $this->request->getArgument('activeTab');
        }
        return $this->redirectWithSearch('show', 'Verband', null, $args);
    }
}
