<?php

namespace Internetgalerie\IgCrmAdmin\Controller;

use Ig\IgFibu\Domain\Repository\InvoicestatusRepository;
use Internetgalerie\IgCrmAdmin\Controller\TYPO3\CMS\Extbase\Annotation\IgnoreValidation;
use Internetgalerie\IgCrmTemplate\Domain\Model\TemplateLetter;
use Internetgalerie\IgCrmTemplate\Domain\Repository\TemplateLetterRepository;
use Internetgalerie\IgCrmTemplate\Domain\Repository\TemplateTypeRepository;
use Internetgalerie\IgDatapoolFe\Property\TypeConverter\ArrayStringConverter;
use Internetgalerie\IgsCrm\Domain\Model\Verband;
use Internetgalerie\IgsCrm\Domain\Repository\LanguageRepository;
use Internetgalerie\IgsCrm\Domain\Repository\MitgliedschaftRepository;
use Internetgalerie\IgsCrm\Domain\Repository\VerbandRepository;
use Psr\Http\Message\ResponseInterface;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Persistence\Generic\PersistenceManager;
use TYPO3\CMS\Extbase\Utility\LocalizationUtility;

class TemplateLetterController extends AbstractCrmController
{
    protected $objectClass = TemplateLetter::class;

    /**
     * verbandRepository
     *
     * @var VerbandRepository
     */
    protected $verbandRepository = null;

    /**
     * templateLetterRepository
     *
     * @var TemplateLetterRepository
     */
    protected $templateLetterRepository = null;

    /**
     * templateTypeRepository
     *
     * @var TemplateTypeRepository
     */
    protected $templateTypeRepository = null;

    public function injectVerbandRepository(VerbandRepository $verbandRepository): void
    {
        $this->verbandRepository = $verbandRepository;
    }
 
    public function injectTemplateLetterRepository(TemplateLetterRepository $templateLetterRepository): void
    {
        $this->templateLetterRepository = $templateLetterRepository;
    }

    public function injectTemplateTypeRepository(TemplateTypeRepository $templateTypeRepository): void
    {
        $this->templateTypeRepository = $templateTypeRepository;
    }
    
    /**
     * action edit
     */
    #[IgnoreValidation([
        'argumentName' => 'templateLetter',
    ])]
    public function editAction(TemplateLetter $templateLetter, Verband $verband): ResponseInterface
    {
        $this->assignGeneral($verband);
        //var_dump($items, $optionsType);exit(0);
        $this->view->assign('templateLetter', $templateLetter);
        return $this->htmlResponse($this->view->render());
    }

    /**
     * action new
     */
    public function newAction(Verband $verband): ResponseInterface
    {
        $this->assignGeneral($verband);
        $copy = $this->request->hasArgument('copy') ? (int)$this->request->getArgument('copy') : 0;
        $templateLetter = null;
        if ($copy) {
            $templateLetter = clone $this->templateLetterRepository->findByUid($copy);
            $templateLetter->setName($templateLetter->getName() . ' (COPY)');
            $verbands = $this->verbandRepository->findAllWithAcl();
            $this->view->assign('verbands', $verbands);
        }
        $this->view->assign('clone', $copy);

        $this->view->assign('templateLetter', $templateLetter);
        return $this->htmlResponse($this->view->render());
    }

    /**
     * action update
     */
    #[IgnoreValidation([
        'argumentName' => 'templateLetter',
    ])]
    public function updateAction(TemplateLetter $templateLetter, Verband $verband): ResponseInterface
    {
        /*
        if ($templateLetter->getType() !== get_class($templateLetter)) {
            var_dump($templateLetter->getType(), get_class($templateLetter));exit(0);
        }
        */
        $this->templateLetterRepository->update($templateLetter);
        $this->addFlashMessage('Der Eintrag wurde aktualisiert.');
        $args = [
            'verband' => $verband,
        ];
        if ($this->request->hasArgument('activeTab')) {
            $args['activeTab'] = $this->request->getArgument('activeTab');
        }
        return $this->redirectWithSearch('show', '', null, $args);
    }

    /**
     * action create
     */
    #[IgnoreValidation([
        'argumentName' => 'templateLetter',
    ])]
    public function createAction(TemplateLetter $templateLetter, Verband $verband): ResponseInterface
    {
        $this->templateLetterRepository->add($templateLetter);
        $this->addFlashMessage('Der Eintrag wurde erstellt.');
        $persistenceManager = GeneralUtility::makeInstance(PersistenceManager::class);
        $persistenceManager->persistAll();
        $args = [
            'verband' => $verband,
        ];
        //$args= ['templateLetter' => $templateLetter];
        if ($this->request->hasArgument('activeTab')) {
            $args['activeTab'] = $this->request->getArgument('activeTab');
        }
        return $this->redirectWithSearch('show', '', null, $args);
    }


    /**
     * action confirmDelete
     */
    #[IgnoreValidation([
        'argumentName' => 'templateLetter',
    ])]
    public function confirmDeleteAction(TemplateLetter $templateLetter, Verband $verband): ResponseInterface
    {
        $this->view->assign('templateLetter', $templateLetter);
        $this->view->assign('verband', $verband);
        if ($this->request->hasArgument('activeTab')) {
            $activeTab = $this->request->getArgument('activeTab');
        }
        $this->view->assign('activeTab', $activeTab);
        return $this->htmlResponse($this->view->render());
    }

    /**
     * action delete
     */
    #[IgnoreValidation([
        'argumentName' => 'verband',
    ])]
    public function deleteAction(TemplateLetter $templateLetter, Verband $verband): ResponseInterface
    {
        $this->templateLetterRepository->remove($templateLetter);
        $this->addFlashMessage('Der Eintrag wurde aktualisiert.');
        $args = [
            'verband' => $verband,
        ];
        if ($this->request->hasArgument('activeTab')) {
            $args['activeTab'] = $this->request->getArgument('activeTab');
        }
        return $this->redirectWithSearch('show', 'Verband', null, $args);
    }

    
    protected function assignGeneral(Verband $verband)
    {
        $items = $GLOBALS['TCA']['tx_igcrmtemplate_domain_model_templateletter']['columns']['object_type']['config']['items'];
        $optionsObjectType = [];
        foreach ($items as $item) {
            $label = $item['label'] ?? $item[0] ?? '';
            $value = $item['value'] ?? $item[1] ?? '';
            $optionsObjectType[$value] = $label;
        }
        $this->view->assign('optionsObjectType', $optionsObjectType);

        $items = $GLOBALS['TCA']['tx_igfibu_domain_model_invoice']['columns']['type']['config']['items'];
        $optionsTemplateObjectType = [];
        foreach ($items as $item) {
            $label = $item['label'] ?? $item[0] ?? '';
            $value = $item['value'] ?? $item[1] ?? '';
            if ($label ?? false) {
                $optionsTemplateObjectType[$value] = LocalizationUtility::translate($label);
            }
        }
        $this->view->assign('optionsTemplateObjectType', $optionsTemplateObjectType);

        $debitorMarkers = [
            'debitor.salutation' => 'Anrede (Herr/Frau)',
            'debitor.salutationFormal' => 'Sehr geehrte/r Herr/Frau',
            'debitor.salutationInformal' => 'Liebe/r',
            'debitor.salutationLetterFormal' => 'Sehr geehrte/r Herr/Frau Nachname',
            'debitor.salutationLetterInformal' => 'Liebe/r Vorname Nachname',
            'debitor.name' => 'Vorname Nachname',
            'debitor.firstname' => 'Vorname',
            'debitor.lastname' => 'Nachname',
            'debitor.address' => 'Adresse',
            'debitor.address2' => 'Adresse Zeile 2',
            'debitor.zip' => 'PLZ',
            'debitor.city' => 'Ort',
            'debitor.countryPostalCode' => 'Land Kürzel (CH)',
        ];

        $invoiceMarkers = [
            'invoice.subtotal' => 'Total vor Tax/MWST und Rabatt',
            'invoice.totalTax' => 'Total MWST (früher: invoice.totalMwst)',
            'invoice.taxRate' => 'MWST Satz (früher: invoice.mwst)',
            'invoice.totalDiscount' => 'Total Rabatt in CHF',
            'invoice.prePaymentCreditAmount' => 'Verrechnete Gutschriften vor Zahlung',
            'invoice.postPaymentCreditAmount' => 'Verrechnete Gutschriften nach Zahlung',
            'invoice.totalExkl' => 'Total Betrag exkl. MWST',
            'invoice.total' => 'Total Betrag inkl. MWST (früher: invoice.totalInkl, invoice.betragEz)',
            'invoice.amountDue' => 'Total offener Betrag inkl. MWST (verrechnete Gutschriften (pre) sind berücksichtigt, aber keine Zahlungen)',
            'invoice.amountPaid' => 'Bezahlter Betrag',
            'invoice.amountRemaining' => 'Restbetrag: Differenz von amountDue und amountPaid',
            'invoice.amountOpen' => 'Total noch offenere Betrag (berechneter Betrag) ist gleich amountRemaining oder 0 falls amountRemaining < 0',
            'invoice.amountOpenMinus' => '-invoice.amountOpen',
            'invoice.invoiceitems' => 'Subeinträge der Rechnung',
        ];
        $invoiceItemMarkers = [
            'invoiceItem.title' => 'Item Titel',
            'invoiceItem.description' => 'Item Beschreibung',
            'invoiceItem.quantity' => 'Item Anzahl',
            'invoiceItem.unitPrice' => 'Item Preis pro Stück',
            'invoiceItem.taxBehavior' => 'Steuer Verhalten',
            'invoiceItem.taxBehaviorIsInkl' => 'Ist Eintrag inkl. Steuer',
            'invoiceItem.taxBehaviorIsExkl' => 'Ist Eintrag exkl. Steuer',
            'invoiceItem.taxRate' => 'Item MWST Rate',
            'invoiceItem.amount' => 'Item Betrag',
            'invoiceItem.costCenter' => 'Item Kostenstelle',
            'invoiceItem.period' => 'Item Periode',
        ];
        $templateMarkers = [
            'template.name' => 'Template: Name',
            'template.title ' => 'Template: Titel',
            'template.logos' => 'Template: Logos',
            'template.showPp ' => 'Template: PP darstellen',
            'template.showTax' => 'Template: Tax/Steuer darstellen',
        ];
        $senderMarkers = [
            'sender.name' => 'Mandant: Name',
            'sender.nameHr' => 'Mandant: Name (HR)',
            'sender.nameFibu' => 'Mandant: Name (Rechnung)',
            'sender.nameDe' => 'Mandant: Name (Deutsch)',
            'sender.nameFr' => 'Mandant: Name (Français)',
            'sender.nameIt' => 'Mandant: Name (Italiano)',
            'sender.nameEn' => 'Mandant: Name (English)',
            'sender.email' => 'Mandant: E-Mail',
            'sender.url' => 'Mandant: URL',
            'sender.iban' => 'Mandant: IBAN',
            'sender.qrIban' => 'Mandant: QR-IBAN',
            'sender.bankName' => 'Mandant: Bank Name',
            'sender.bankZipCity' => 'Mandant: Bank PLZ Ort',
            'sender.bankKonto' => 'Mandant: Bank Konto',
            'sender.mwstNr' => 'Mandant: MWST Nr.',
            'sender.invoiceText' => 'Mandant: Rechnungstext',
            'sender.logo' => 'Mandant: Logo',
            'sender.logoMail' => 'Mandant: Logo für Mail',
            'sender.street' => 'Mandant: Strasse',
            'sender.streetNumber' => 'Mandant: Strasse Nr',
            'sender.address2' => 'Mandant: Adresszeile 2',
            'sender.address3' => 'Mandant: Adresszeile 3',
            'sender.zip' => 'Mandant: PLZ',
            'sender.countryIsoCode ' => 'Mandant: Land (z.B. CH)',
            'sender.city' => 'Mandant: Ort',
            'sender.cityDe' => 'Mandant: Ort (Deutsch)',
            'sender.phone' => 'Mandant: Telefon',
            'sender.invoiceBaseText' => 'Mandant: Rechnungsbasistext',
            'sender.senderLine' => 'Mandant: Sender Linie',
            'sender.titleExtraTextfield1' => 'Mandant: Titel Extras Text Feld 1',
            'sender.titleExtraTextfield2' => 'Mandant: Titel Extras Text Feld 2',
            'sender.titleExtraTextfield3' => 'Mandant: Titel Extras Text Feld 3',
            'sender.titleExtraTextarea1' => 'Mandant: Titel Extras Text Area 1',
            'sender.titleExtraTextarea2' => 'Mandant: Titel Extras Text Area 2',
            'sender.titleExtraTextarea3' => 'Mandant: Titel Extras Text Area 3',
            'sender.titleExtraTextarea1' => 'Mandant: Titel Extras Text Area 1',
            'sender.titleExternalId' => 'Mandant: Titel Externe ID',
            'sender.taxBehavior' => 'Mandant: Tax verhalten 1=inkl. MWST, 0=exkl. MWST',
            'sender.taxRate' => 'Mandant: MWST Rate',
            'sender.usePp' => 'Mandant: PP verwenden',
            'sender.useOwnAddressNumber' => 'Mandant: Eigene Nummer verwenden',
        ];

        $allMarkers = array_merge(
            $debitorMarkers,
            $invoiceMarkers,
            $invoiceItemMarkers,
            $senderMarkers,
            $templateMarkers
        );
        
        $crmTemplateMarkers = [];
        foreach ($allMarkers as $marker => $label) {
            $crmTemplateMarkers[] = [
                'label' => '{' . $marker . '} (' . $label . ')',
                'html' => '{' . $marker . '}',
            ];
        }

            
        
        $this->view->assign('crmTemplateMarkers', $crmTemplateMarkers);
        
        $crmDefaultPageTemplate = '<f:render partial="TemplateLayout/Parts/Title" arguments="{_all}" />
<f:render partial="TemplateLayout/Parts/TextBefore" arguments="{_all}" />
<f:render partial="TemplateLayout/Parts/PartialBefore" arguments="{_all}" />
<f:render partial="TemplateLayout/Parts/Template" arguments="{_all}" />
<f:render partial="TemplateLayout/Parts/PartialAfter" arguments="{_all}" />
<f:render partial="TemplateLayout/Parts/TextAfter" arguments="{_all}" />';
        $this->view->assign('crmDefaultPageTemplate', $crmDefaultPageTemplate);

        $items = $GLOBALS['TCA']['tx_igcrmtemplate_domain_model_templateletter']['columns']['title_layout']['config']['items'];
        $optionsTitleLayout = [];
        foreach ($items as $item) {
            $label = $item['label'] ?? $item[0] ?? '';
            $value = $item['value'] ?? $item[1] ?? '';
            $optionsTitleLayout[$value] = LocalizationUtility::translate($label);
        }
        $this->view->assign('optionsTitleLayout', $optionsTitleLayout);


        
        $optionsTemplateType = $this->templateTypeRepository->findAll();
        $this->view->assign('optionsTemplateType', $optionsTemplateType);
        $this->languageRepository = GeneralUtility::makeInstance(LanguageRepository::class);
        $this->view->assign('languages', $this->languageRepository->findAll());

        $mitgliedschaftRepository = GeneralUtility::makeInstance(MitgliedschaftRepository::class);
        $this->view->assign('mitgliedschaften', $mitgliedschaftRepository->findBy([
            'verband' => $verband,
        ]));

        $invoicestatusRepository = GeneralUtility::makeInstance(InvoicestatusRepository::class);
        $this->view->assign('optionsInvoicestatus', $invoicestatusRepository->findAll());
        
        $this->view->assign('verband', $verband);

        if ($this->request->hasArgument('activeTab')) {
            $activeTab = $this->request->getArgument('activeTab');
        }
        $this->view->assign('activeTab', $activeTab);
    }


    protected function initializeUpdateAction()
    {
        $pmc = $this->arguments->getArgument('templateLetter')
->getPropertyMappingConfiguration();
        $tc = GeneralUtility::makeInstance(ArrayStringConverter::class);
        $pmc->forProperty('subTags')
->setTypeConverter($tc);
    }
}
