<?php

namespace Internetgalerie\IgCrmAdmin\Controller;

use Internetgalerie\IgCrmAdmin\Controller\TYPO3\CMS\Extbase\Annotation\IgnoreValidation;
use Internetgalerie\IgCrmTemplate\Domain\Model\Translate;
use Internetgalerie\IgCrmTemplate\Domain\Repository\TranslateRepository;
use Internetgalerie\IgsCrm\Domain\Model\Verband;
use Internetgalerie\IgsCrm\Domain\Repository\LanguageRepository;
use Internetgalerie\IgsCrm\Domain\Repository\VerbandRepository;
use Psr\Http\Message\ResponseInterface;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Persistence\Generic\PersistenceManager;

class TranslateController extends AbstractCrmController
{
    protected $objectClass = Translate::class;
    /**
     * verbandRepository
     *
     * @var VerbandRepository
     */
    protected $verbandRepository = null;

    /**
     * translateRepository
     *
     * @var TranslateRepository
     */
    protected $translateRepository = null;

    public function injectVerbandRepository(VerbandRepository $verbandRepository): void
    {
        $this->verbandRepository = $verbandRepository;
    }
 
    public function injectTranslateRepository(TranslateRepository $translateRepository): void
    {
        $this->translateRepository = $translateRepository;
    }
    
    /**
     * action edit
     */
    #[IgnoreValidation([
        'argumentName' => 'translate',
    ])]
    public function editAction(Translate $translate, Verband $verband): ResponseInterface
    {
        $this->assignGeneral($verband);
        //var_dump($items, $optionsType);exit(0);
        $this->view->assign('translate', $translate);
        return $this->htmlResponse($this->view->render());
    }
    
    /**
     * action new
     */
    public function newAction(Verband $verband): ResponseInterface
    {
        $this->assignGeneral($verband);
        $this->view->assign('translate', $translate);
        return $this->htmlResponse($this->view->render());
    }


    /**
     * action update
     */
    #[IgnoreValidation([
        'argumentName' => 'translate',
    ])]
    public function updateAction(Translate $translate, Verband $verband): ResponseInterface
    {
        /*
        if ($translate->getType() !== get_class($translate)) {
            var_dump($translate->getType(), get_class($translate));exit(0);
        }
        */
        $this->translateRepository->update($translate);
        $this->addFlashMessage('Der Eintrag wurde aktualisiert.');
        $args = [
            'verband' => $verband,
        ];
        if ($this->request->hasArgument('activeTab')) {
            $args['activeTab'] = $this->request->getArgument('activeTab');
        }
        return $this->redirectWithSearch('show', '', null, $args);
    }

    /**
     * action create
     */
    #[IgnoreValidation([
        'argumentName' => 'translate',
    ])]
    public function createAction(Translate $translate, Verband $verband): ResponseInterface
    {
        $this->translateRepository->add($translate);
        $this->addFlashMessage('Der Eintrag wurde erstellt.');
        $persistenceManager = GeneralUtility::makeInstance(PersistenceManager::class);
        $persistenceManager->persistAll();
        $args = [
            'verband' => $verband,
        ];
        //$args= ['translate' => $translate];
        if ($this->request->hasArgument('activeTab')) {
            $args['activeTab'] = $this->request->getArgument('activeTab');
        }
        return $this->redirectWithSearch('show', '', null, $args);
    }

    /**
     * action confirmDelete
     */
    #[IgnoreValidation([
        'argumentName' => 'translate',
    ])]
    public function confirmDeleteAction(Translate $translate, Verband $verband): ResponseInterface
    {
        $this->view->assign('translate', $translate);
        $this->view->assign('verband', $verband);
        if ($this->request->hasArgument('activeTab')) {
            $activeTab = $this->request->getArgument('activeTab');
        }
        $this->view->assign('activeTab', $activeTab);
        return $this->htmlResponse($this->view->render());
    }

    /**
     * action delete
     */
    #[IgnoreValidation([
        'argumentName' => 'verband',
    ])]
    public function deleteAction(Translate $translate, Verband $verband): ResponseInterface
    {
        $this->translateRepository->remove($translate);
        $this->addFlashMessage('Der Eintrag wurde aktualisiert.');
        $args = [
            'verband' => $verband,
        ];
        if ($this->request->hasArgument('activeTab')) {
            $args['activeTab'] = $this->request->getArgument('activeTab');
        }
        return $this->redirectWithSearch('show', 'Verband', null, $args);
    }

    
    protected function assignGeneral(Verband $verband)
    {
        $this->languageRepository = GeneralUtility::makeInstance(LanguageRepository::class);
        $this->view->assign('languages', $this->languageRepository->findAll());

        $this->view->assign('verband', $verband);

        if ($this->request->hasArgument('activeTab')) {
            $activeTab = $this->request->getArgument('activeTab');
        }
        $this->view->assign('activeTab', $activeTab);
    }
}
