<?php

namespace Internetgalerie\IgCrmAdmin\Controller;

use Internetgalerie\IgsCrm\Domain\Repository\VerbandRepository;
use Psr\Http\Message\ResponseInterface;

class VerbandApiController extends AbstractApiController
{
    /**
     * dataRepository
     *
     * @var VerbandRepository
     */
    protected $dataRepository = null;

    public function injectDataRepository(VerbandRepository $dataRepository): void
    {
        $this->dataRepository = $dataRepository;
    }

    /**
     * action list
     */
    public function listAction(): ResponseInterface
    {
        $search = $this->getSearch() ?? [];
        $token = $this->request->hasArgument('apiKey') ? $this->request->getArgument('apiKey') : '';
        $this->dataRepository->setToken($token);
        $datas = $this->dataRepository->findBySearch($_GET['search'] ?? [], true);
        $datas = $this->arrayUnderscoredToLowerCamelCase($datas);
        return $this->jsonResponse(
            (string)json_encode([
                    'meta' => [
                        'status' => 'success',
                    ],
                    'result' => $datas,

                ])
        );
    }
}
