<?php

namespace Internetgalerie\IgCrmAdmin\Controller;

use DateTime;
use Exception;
use Ig\IgFibu\Utility\PeriodUtility;
use Internetgalerie\IgCrmAdmin\Controller\TYPO3\CMS\Extbase\Annotation\IgnoreValidation;
use Internetgalerie\IgDatapoolFe\Property\TypeConverter\DateTimeConverter;
use Internetgalerie\IgExcel\Domain\Model\ImportConfig;
use Internetgalerie\IgExcel\Utility\ImportUtility;
use Internetgalerie\IgsCrm\Domain\Model\Contact;
use Internetgalerie\IgsCrm\Domain\Model\ContactVerband;
use Internetgalerie\IgsCrm\Domain\Model\Export;
use Internetgalerie\IgsCrm\Domain\Model\Mitgliedschaft;
use Internetgalerie\IgsCrm\Domain\Model\Organisation;
use Internetgalerie\IgsCrm\Domain\Model\Person;
use Internetgalerie\IgsCrm\Domain\Model\Verband;
use Internetgalerie\IgsCrm\Domain\Repository\AnredeRepository;
use Internetgalerie\IgsCrm\Domain\Repository\ApiRepository;
use Internetgalerie\IgsCrm\Domain\Repository\CategoryRepository;
use Internetgalerie\IgsCrm\Domain\Repository\ContactRepository;
use Internetgalerie\IgsCrm\Domain\Repository\ContactVerbandRepository;
use Internetgalerie\IgFrontendUser\Domain\Repository\FrontendUserGroupRepository;
use Internetgalerie\IgsCrm\Domain\Repository\KantonRepository;
use Internetgalerie\IgsCrm\Domain\Repository\LanguageRepository;
use Internetgalerie\IgsCrm\Domain\Repository\MitgliedschaftRepository;
use Internetgalerie\IgsCrm\Domain\Repository\OrganisationRepository;
use Internetgalerie\IgsCrm\Domain\Repository\PersonRepository;
use Internetgalerie\IgsCrm\Domain\Repository\SektionRepository;
use Internetgalerie\IgsCrm\Domain\Repository\TagRepository;
use Internetgalerie\IgsCrm\Domain\Repository\TagverbandRepository;
use Internetgalerie\IgsCrm\Domain\Repository\VerbandRepository;
use Internetgalerie\IgsCrm\Domain\Repository\ZeitschriftRepository;
use Internetgalerie\IgsCrm\Utility\ConfUtility;
use Internetgalerie\IgsCrm\Utility\ExcelUtility;
use Internetgalerie\IgsCrm\Utility\ExportUtility;
//use Internetgalerie\IgsCrm\Utility\ImportUtility;
//use Internetgalerie\IgsCrm\Domain\Model\ImportConfig;
use Psr\Http\Message\ResponseInterface;
use TYPO3\CMS\Core\Context\Context;
use TYPO3\CMS\Core\Database\ConnectionPool;
use TYPO3\CMS\Core\Resource\File as FileResource;
use TYPO3\CMS\Core\Resource\FileRepository;
use TYPO3\CMS\Core\Type\ContextualFeedbackSeverity;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Persistence\Generic\PersistenceManager;
use TYPO3\CMS\Extbase\Utility\LocalizationUtility;

class VerbandController extends AbstractCrmController
{
    protected const ACCESS_DENIED = 'Access denied';
    protected static $requiredRole = 'crm.contact';
    protected $objectClass = Verband::class;


    protected $updateModes = [
        'append' => 'nicht aktualisieren, Verband-Mitgliedschaft aktualisieren/importieren',
        'update' => 'aktualisieren',
        'new' => 'Adressen neu importiern (sind dann doppelt vorhanden)',
        'none' => 'nicht aktualisieren/importieren (Es werden auch keine Verband-Mitgliedschaft angelegt)',
    ];
    protected $addressMatchMethods = [
        'exact' => 'Exakt (Vorname und Nachname oder Firmenname,  PLZ, Ort, Adresse',
        'nameMail' => 'E-Mail und (Vorname und Nachname oder Firmenname) (falls exakt scheitert)',
        'mail' => ' nur E-Mail (falls allels andere scheitert)',
        //'none' => 'nicht aktualisieren/importieren (Es werden auch keine Verband-Mitgliedschaft angelegt)',
    ];


    /**
     * verbandRepository
     *
     * @var VerbandRepository
     */
    protected $verbandRepository = null;

    /**
     * personRepository
     *
     * @var PersonRepository
     */
    protected $personRepository = null;

    /**
     * organisationRepository
     *
     * @var OrganisationRepository
     */
    protected $organisationRepository = null;

    /**
     * contactRepository
     *
     * @var ContactRepository
     */
    protected $contactRepository = null;

    /**
     * contactVerbandRepository
     *
     * @var ContactVerbandRepository
     */
    protected $contactVerbandRepository = null;

    /**
     * tagRepository
     *
     * @var TagRepository
     */
    protected $tagRepository = null;

    /**
     * apiRepository
     *
     * @var apiRepository
     */
    protected $apiRepository = null;

    /**
     * frontendUserGroupRepository
     *
     * @var FrontendUserGroupRepository
     */
    protected $frontendUserGroupRepository = null;
    /**
     * MitgliedschaftRepository
     *
     * @var MitgliedschaftRepository
     */
    protected $mitgliedschaftRepository = null;

    /**
     * languageRepository
     *
     * @var LanguageRepository
     */

    protected $languageRepository = null;
    
    protected $optionsLogicalOperators = [
        1 => [
            'uid' => 1,
            'name' => 'Und',
            'operator' => 'AND',
        ],
        2 => [
            'uid' => 2,
            'name' => 'Oder',
            'operator' => 'OR',
        ],
    ];


    public function injectTagverbandRepository(TagverbandRepository $tagverbandRepository): void
    {
        $this->tagverbandRepository = $tagverbandRepository;
    }

    public function injectVerbandRepository(VerbandRepository $verbandRepository): void
    {
        $this->verbandRepository = $verbandRepository;
    }

    public function injectPersonRepository(PersonRepository $personRepository): void
    {
        $this->personRepository = $personRepository;
    }
    
    public function injectOrganisationRepository(OrganisationRepository $organisationRepository): void
    {
        $this->organisationRepository = $organisationRepository;
    }

    public function injectContactRepository(ContactRepository $contactRepository): void
    {
        $this->contactRepository = $contactRepository;
    }

    public function injectContactVerbandRepository(ContactVerbandRepository $contactVerbandRepository): void
    {
        $this->contactVerbandRepository = $contactVerbandRepository;
    }

    public function injectTagRepository(TagRepository $tagRepository): void
    {
        $this->tagRepository = $tagRepository;
    }
    
    public function injectApiRepository(ApiRepository $apiRepository): void
    {
        $this->apiRepository = $apiRepository;
    }

    public function injectMitgliedschaftRepository(MitgliedschaftRepository $mitgliedschaftRepository): void
    {
        $this->mitgliedschaftRepository = $mitgliedschaftRepository;
    }

    public function injectLanguageRepository(LanguageRepository $languageRepository): void
    {
        $this->languageRepository = $languageRepository;
    }

    public function injectFrontendUserGroupRepository(FrontendUserGroupRepository $frontendUserGroupRepository): void
    {
        $this->frontendUserGroupRepository = $frontendUserGroupRepository;
    }

    public function initializeAction(): void
    {
        parent::initializeAction();
        if (isset($this->arguments['verband'])) {
            $verband = $this->arguments['verband'];
            // allow creation of sub entries
            foreach (['languages'] as $fieldName) {
                $verband->getPropertyMappingConfiguration()
->allowCreationForSubProperty($fieldName . '.*');
            }
        }
    }

    /**
     * action list
     */
    public function listAction(array $search = []): ResponseInterface
    {
        $verband = null;
        if (!isset($search['parent'])) {
            //$context = GeneralUtility::makeInstance(Context::class);
            //$frontendUserId = $context->getPropertyFromAspect('frontend.user', 'id');
            
            $crmVerbandUids = $this->securityUtility->getFrontendUser()->getCrmVerbandUids() ?? '';
            $crmVerbandUids = GeneralUtility::intExplode(',', $crmVerbandUids, true);
            $verbandUids = $this->verbandRepository->findAllRoots();
            if (!empty($verbandUids)) {
                $search['uids'] = $verbandUids;
            } else {
                $search['parent'] = 0;
            }
        }
        if ($search['parent'] > 0) {
            $verband = $this->verbandRepository->findByUid($search['parent']);
        }
        //var_dump($search, $verbandUids);die('');
        $verbands = $this->verbandRepository->findBySearch($search);
        $this->view->assign('verband', $verband);
        $this->view->assign('verbands', $verbands);
        return $this->htmlResponse($this->view->render());
    }


    /**
     * action dashboardAction
     */
    public function dashboardAction(): ResponseInterface
    {
        $verbandUid = $this->securityUtility->getGlobalVerband();
        $globalVerband = null;
        if ($verbandUid === 0) {
            $crmVerbandUids = [];
            /*            if (!empty($GLOBALS['TSFE']->fe_user->user['crm_verband_uids'])) {
                          $crmVerbandUids = GeneralUtility::intExplode(',', $GLOBALS['TSFE']->fe_user->user['crm_verband_uids'], true);
                          $verbands = $this->verbandRepository->findWithUids($crmVerbandUids);
                          }  else {*/
            $rootVerbandUids = $this->verbandRepository->findAllRoots();
            if (!empty($rootVerbandUids)) {
                $verbands = $this->verbandRepository->findWithUids($rootVerbandUids);
            } else {
                $verbands = $this->verbandRepository->findAllWithAcl();
            }
            //}
        } else {
            $verbands = $this->verbandRepository->findWithParent((int) $verbandUid);
            $globalVerband = $this->verbandRepository->findOneWithUid((int) $verbandUid);
            if ($globalVerband) {
                $personCount = $this->personRepository->countActiveInYearByVerband($globalVerband);
                $this->view->assign('personCount', $personCount);
            }
        }

        $this->view->assign('verbands', $verbands);
        $this->view->assign('globalVerband', $globalVerband);
        //var_dump($verbandUid, $verband->getName());exit(0);
        return $this->htmlResponse($this->view->render());
    }


    /**
     * action menuAction
     */
    public function menuAction(): ResponseInterface
    {
        $userAspect = GeneralUtility::makeInstance(Context::class)->getAspect('frontend.user');
        if (!$userAspect->isLoggedIn()) {
            return $this->htmlResponse('');
        }
        $verbands = $this->verbandRepository->findAllWithAcl();
        $verband = $this->securityUtility->getGlobalVerband();
        $this->view->assign('verbands', $verbands);
        return $this->htmlResponse($this->view->render());
    }

    public function getYear(int $showLastYearUpToMonth = 10)
    {
        // Jahr
        if ($this->request->hasArgument('year')) {
            $year = intval($this->request->getArgument('year'));
        } else {
            $year = date('Y');
            if (date('m') <= $showLastYearUpToMonth) {
                --$year;
            }
        }
        return $year;
    }
    
    public function assignDatesVerband($verband, $year): void
    {
        $statisticDate = new DateTime(($year) . '-12-31');
        $this->view->assign('data', [
            'year' => $year,
            'nextYear' => $year + 1,
            'verband' => $verband,
            'statisticDate' => $statisticDate,
            'searchYearOptions' => $this->getZeitraumJahre(),
        ]);
    }
    
    /**
     * action jahresbericht
     */
    public function jahresberichtAction(Verband $verband): ResponseInterface
    {
        if (!$this->securityUtility->hasPermissionRead($verband, 'crm.tenant', ['fe_verband'])) {
            return $this->htmlResponse(self::ACCESS_DENIED);
        }
        $verbands = $this->verbandRepository->findAllWithAcl();
        $this->view->assign('verbands', $verbands);
        $this->view->assign('verband', $verband);

        $year = $this->getYear(); // 9
        $this->assignDatesVerband($verband, $year);

        // Personen
        /////////////////
        $this->personRepository->setActiveYear($year);
        $personCountInYear = $this->personRepository->countActiveInYearByVerband($verband, 'inYear');
        $personCountStartYear = $this->personRepository->countActiveInYearByVerband($verband, 'startYear');
        //$search = ['verband' => $verband, 'memberActive' => 'endYear', 'type' => 'Person']; //, 'memberDateFrom' =>  $year . '-01-01', 'memberDateTo' => $year . '-12-31'];
        $personCountEndYear = $this->personRepository->countActiveInYearByVerband($verband, 'endYear');
        $personCountStartNextYear = $this->personRepository->countActiveInYearByVerband($verband, 'nextYear');
        //$personCountEndYear = $this->personRepository->findBySearchExecute($search)->count();

        //Person: Mitgliedschaft
        $personMitgliedschafts = $this->personRepository->findByVerbandJoinContactVerbandGroupBy(
            $verband,
            'tx_igscrm_domain_model_mitgliedschaft',
            'mitgliedschaft',
            'name'
        );
        $personMitgliedschaftEntries = [];
        foreach ($personMitgliedschafts as $personMitgliedschaft) {
            $personMitgliedschaft['alterskategorien'] = $this->personRepository->findByVerbandAlterskategorieGroupBy(
                $verband,
                $personMitgliedschaft['xuid']
            );
            $personMitgliedschaftEntries[] = $personMitgliedschaft;
        }


        // Person: Tags
        $tagverbands = $this->tagverbandRepository->findByVerband($verband);
        $contactTagverands = [];
        foreach ($tagverbands as $tagverband) {
            $tagSum = $this->personRepository->findByVerbandTagsGroupBy($verband, $tagverband->getUid());
            $contactTagverands[] = [
                'tagverband' => $tagverband,
                'tagSum' => $tagSum,
            ];
        }

        // Person Verstorben
        $search = [
            'verstorben' => 'endYear',
            'verband' => $verband,
            'memberActive' => 'inYear',
            'usedForStatistics' => '1',
            'type' => 'Person',
        ];
        $personVerstorben = $this->personRepository->findBySearchExecute($search);
        //$this->view->assign('personVerstorben', $this->personRepository->findVerstorbenByVerband($verband, $year, 0));

        // Person Verstorben nicht in Statistik
        $search = [
            'verstorben' => 'endYear',
            'verband' => $verband,
            'memberActive' => 'inYear',
            'usedForStatistics' => '0',
            'type' => 'Person',
        ];
        $personVerstorbenNotUsedForStatistics = $this->personRepository->findBySearchExecute($search);

        // Veterane
        $veteranenAlter = $verband->getVeteranenAlter();
        if ($veteranenAlter > 0) {
            $veteranenJahr = $year - $veteranenAlter; // Veterane Alter IGS: 62
            $personVeteranen = $this->personRepository->findVeteranenByVerband($verband, $year, $veteranenJahr);
        } else {
            $personVeteranen = null;
        }


        $this->view->assign('personStatistics', [
            'title' => 'Mitglieder',
            'countEndYear' => $personCountEndYear,
            'countStartYear' => $personCountStartYear,
            'countStartNextYear' => $personCountStartNextYear,
            'countInYear' => $personCountInYear,
            'mitgliedschaft' => $personMitgliedschaftEntries,
            'tag' => $contactTagverands,
            'verbandEintritte' => $this->contactVerbandRepository->findEintritteByVerband(
                $verband,
                $year,
                'Person'
            ), // Person Eintritte
            'verbandAustritte' => $this->contactVerbandRepository->findAustritteByVerband(
                $verband,
                $year,
                'Person'
            ), // Person Austritte
            'verbandEintritteCertificates' => $this->contactVerbandRepository->findGroupedEintritteByVerbandWithCertificates(
                $verband,
                $year,
                'Person'
            ),
            'terminated' => [
                'title' => 'Verstorben',
                'symbol' => '† ',
                'entries' => $personVerstorben,
                'entriesNotUsedForStatistics' => $personVerstorbenNotUsedForStatistics,
            ],
            'veteranen' => $personVeteranen,
            'veteranenJahr' => $veteranenJahr,
        ]);
        
        //$this->view->assign('personVerstorbenNoPerson', $this->personRepository->findVerstorbenByVerband($verband, $year, 1));

        // Organisationen
        /////////////////
        $this->organisationRepository->setActiveYear($year);



        //$search = ['verband' => $verband, 'memberActive' => 'inYear']; //, 'memberDateFrom' =>  $year . '-01-01', 'memberDateTo' => $year . '-12-31'];
        //$organisationCountInYear = $this->organisationRepository->findBySearchExecute($search)->count();
        $organisationCountInYear = $this->organisationRepository->countActiveInYearByVerband($verband, 'inYear');


        // Organisations found
        if ($organisationCountInYear > 0) {
            //$search = ['verband' => $verband, 'memberActive' => 'endYear'];
            //$organisationCountEndYear = $this->organisationRepository->findBySearchExecute($search)->count();
            $organisationCountEndYear = $this->organisationRepository->countActiveInYearByVerband($verband, 'endYear');
            //$search = ['verband' => $verband, 'memberActive' => 'startYear'];
            //$organisationCountStartYear = $this->organisationRepository->findBySearchExecute($search)->count();
            $organisationCountStartYear = $this->organisationRepository->countActiveInYearByVerband(
                $verband,
                'startYear'
            );
            $organisationCountStartNextYear = $this->organisationRepository->countActiveInYearByVerband(
                $verband,
                'nextYear'
            );

            // Organisation: Mitgliedschaft
            $contactMitgliedschafts = $this->organisationRepository->findByVerbandJoinContactVerbandGroupBy(
                $verband,
                'tx_igscrm_domain_model_mitgliedschaft',
                'mitgliedschaft',
                'name'
            );
            $contactMitgliedschaftEntries = [];
            foreach ($contactMitgliedschafts as $contactMitgliedschaft) {
                $contactMitgliedschaft['alterskategorien'] = $this->contactRepository->findByVerbandAlterskategorieGroupBy(
                    $verband,
                    $contactMitgliedschaft['xuid']
                );
                $contactMitgliedschaftEntries[] = $contactMitgliedschaft;
            }

            // Organisation: Aufgeloest
            $search = [
                'verstorben' => 'endYear',
                'verband' => $verband,
                'memberActive' => 'inYear',
                'usedForStatistics' => '1',
            ];
            $organisationDissolved = $this->organisationRepository->findBySearchExecute($search);
            $search = [
                'verstorben' => 'endYear',
                'verband' => $verband,
                'memberActive' => 'inYear',
                'usedForStatistics' => '0',
            ];
            $organisationDissolvedNotUsedForStatistics = $this->organisationRepository->findBySearchExecute($search);



            //Organisation: CategoryOrganisation
            $search = [
                'meCategoryOrganisation' => 1,
                'verband' => $verband,
                'memberActive' => 'endYear',
            ]; //, 'memberDateFrom' =>  $year . '-01-01', 'memberDateTo' => $year . '-12-31'];
            $organisationHauptsitz = $this->organisationRepository->findBySearchExecute($search);
            $this->view->assign(
                'organisationHauptsitzAnzahl',
                count($organisationHauptsitz)
            );//+count($organisationNoEmployees));

            $search = [
                'meCategoryOrganisation' => 2,
                'verband' => $verband,
                'memberActive' => 'endYear',
            ]; //, 'memberDateFrom' =>  $year . '-01-01', 'memberDateTo' => $year . '-12-31'];
            $organisationFiliale = $this->organisationRepository->findBySearchExecute($search);

            //Organisation: Without Emploees
            $search = [
                'meNoEmployees' => 1,
                'verband' => $verband,
                'memberActive' => 'endYear',
            ]; //, 'memberDateFrom' =>  $year . '-01-01', 'memberDateTo' => $year . '-12-31'];
            $organisationNoEmployees = $this->organisationRepository->findBySearchExecute($search);

            
            $this->view->assign('organisationStatistics', [
                'title' => $verband->getTitleOrganisationId() ? 'Büros' : 'Organisationen',
                'countEndYear' => $organisationCountEndYear,
                'countStartYear' => $organisationCountStartYear,
                'countStartNextYear' => $organisationCountStartNextYear,
                'countInYear' => $organisationCountInYear,
                'mitgliedschaft' => $contactMitgliedschaftEntries,
                'tag' => null,
                'verbandEintritte' => $this->contactVerbandRepository->findEintritteByVerband(
                    $verband,
                    $year,
                    'Organisation'
                ), // Organisation: Eintritte
                'verbandAustritte' => $this->contactVerbandRepository->findAustritteByVerband(
                    $verband,
                    $year,
                    'Organisation'
                ), // Organisation: Austritte
                'verbandEintritteCertificates' => $this->contactVerbandRepository->findGroupedEintritteByVerbandWithCertificates(
                    $verband,
                    $year,
                    'Organisation'
                ),
                'terminated' => [
                    'title' => 'Aufgelöst',
                    'symbol' => '',
                    'entries' => $organisationDissolved,
                    'entriesNotUsedForStatistics' => $organisationDissolvedNotUsedForStatistics,
                ],
                'categoryOrganisation' => [
                    'hauptsitz' => $organisationHauptsitz,
                    'filiale' => $organisationFiliale,
                    'noEmployees' => $organisationNoEmployees,
                ],
            ]);
        }

        return $this->htmlResponse($this->view->render());
    }
    /**
     * action statistik
     */
    public function statistikAction(Verband $verband): ResponseInterface
    {
        if (!$this->securityUtility->hasPermissionRead($verband, 'crm.tenant', ['fe_verband'])) {
            return $this->htmlResponse(self::ACCESS_DENIED);
        }
        $verbands = $this->verbandRepository->findAllWithAcl();
        $this->view->assign('verbands', $verbands);
        $this->view->assign('verband', $verband);
        $year = $this->getYear(); //10
        $this->assignDatesVerband($verband, $year);
        $this->personRepository->setActiveYear($year);
        $tagverbands = $this->tagverbandRepository->findByVerband($verband);
        $contactTagverands = [];
        foreach ($tagverbands as $tagverband) {
            $tagSum = $this->personRepository->findByVerbandTagsGroupBy($verband, $tagverband->getUid());
            $contactTagverands[] = [
                'tagverband' => $tagverband,
                'tagSum' => $tagSum,
            ];
        }
        $this->view->assign('contactTagverands', $contactTagverands);



        /*
          $personSektion = $this->personRepository->findByVerbandMmGroupBy($verband, 'sektion');
          $this->view->assign('personSektion', $personSektion);
          $personCategory = $this->personRepository->findByVerbandMmGroupBy($verband, 'category');
          $this->view->assign('personCategory', $personCategory);
          $personCommission = $this->personRepository->findByVerbandMmGroupBy($verband, 'commission');
          $this->view->assign('personCommission', $personCommission);
          $contactTag = $this->personRepository->findByVerbandMmGroupBy($verband, 'tag');
          $this->view->assign('contactTag', $contactTag);
         */

        $personStartDate = $this->personRepository->findByVerbandGroupBy($verband, 'YEAR(start_date)');
        $this->view->assign('personStartDate', $personStartDate);

        $personKanton = $this->personRepository->findByVerbandJoinPersonGroupBy(
            $verband,
            'tx_igscrm_domain_model_kanton',
            'me_kanton_id',
            'ka_abkuerzung'
        );
        $this->view->assign('personKanton', $personKanton);
        /*
          $personKanton = $this->personRepository->findByVerbandJoinPersonGroupBy($verband, 'tx_igscrm_domain_model_kanton', 'me_kanton_id', 'ka_abkuerzung' );
          $this->view->assign('personKanton', $personKanton);
        */


        $personAnrede = $this->personRepository->findByVerbandJoinPersonGroupBy(
            $verband,
            'tx_igscrm_domain_model_anrede',
            'me_anrede_id',
            'an_name'
        );
        $this->view->assign('personAnrede', $personAnrede);

        $personSprache = $this->personRepository->findByVerbandJoinPersonGroupBy(
            $verband,
            'tx_igscrm_domain_model_language',
            'me_languageid',
            'lg_name'
        );
        $this->view->assign('personSprache', $personSprache);

        $personGeburtsjahr = $this->personRepository->findByVerbandGroupBy(
            $verband,
            'CASE WHEN me_date_of_birth IS NOT NULL THEN YEAR(me_date_of_birth) ELSE me_year_of_birth END'
        );
        $this->view->assign('personGeburtsjahr', $personGeburtsjahr);


        $personMitgliedschaft = $this->personRepository->findByVerbandJoinContactVerbandGroupBy(
            $verband,
            'tx_igscrm_domain_model_mitgliedschaft',
            'mitgliedschaft',
            'name'
        );
        $this->view->assign('personMitgliedschaft', $personMitgliedschaft);


        $personAlterskategorie = $this->personRepository->findByVerbandAlterskategorieGroupBy($verband);
        $this->view->assign('personAlterskategorie', $personAlterskategorie);



        /*
          $organisationKanton = $this->personRepository->findByVerbandJoinPersonOrganisationVerbandGroupBy($verband, 'ka_abkuerzung');
          $this->view->assign('organisationKanton', $organisationKanton);
        */
        $organisationKanton = $this->organisationRepository->findByVerbandJoinPersonGroupBy(
            $verband,
            'tx_igscrm_domain_model_kanton',
            'me_kanton_id',
            'ka_abkuerzung'
        );
        //$organisationKanton = $this->organisationRepository->findByOfIgsActiveGroupByKanton('ka_abkuerzung', $year);
        $this->view->assign('organisationKanton', $organisationKanton);

        return $this->htmlResponse($this->view->render());
    }

    /**
     * action dataList
     */
    public function dataListAction(Verband $verband): ResponseInterface
    {
        if (!$this->securityUtility->hasPermissionRead($verband, 'crm.tenant', ['fe_verband'])) {
            return $this->htmlResponse(self::ACCESS_DENIED);
        }
        $verbands = $this->verbandRepository->findAllWithAcl();
        $this->view->assign('verbands', $verbands);
        $this->view->assign('verband', $verband);

        $list = $this->personRepository->getDataList($verband->getUid(), 0);
        $this->view->assign('list', $list);
        return $this->htmlResponse($this->view->render());
    }
    /**
     * action jahresbericht
     */
    public function exportFormAction(Verband $verband): ResponseInterface
    {
        $this->view->assign('verband', $verband);
        $this->view->assign('optionsLogicalOperators', $this->optionsLogicalOperators);
        $this->confUtility = GeneralUtility::makeInstance(ConfUtility::class);
        $this->view->assign('crmJahrgaenge', $this->confUtility->getCrmJahrgaenge());
        $mitgliedschaftenExclude = $this->mitgliedschaftRepository->findByVerbandExcludedStatistik($verband, 1);
        $this->view->assign('mitgliedschaften', $this->mitgliedschaftRepository->findBy([
            'verband' => $verband,
        ]));
        $this->view->assign('mitgliedschaftenExclude', $mitgliedschaftenExclude);

        $headerVerbands = $this->securityUtility->getFrontendUserHeaderVerband();
        $this->view->assign('headerVerbands', $headerVerbands);
        
        $search = $this->request->hasArgument('search') ? $this->request->getArgument('search') : [];
        if (!is_array($search)) {
            if (!empty($mitgliedschaftenExclude)) {
                $search = [];
                $search['mitgliedschaftenExclude'] = [];
                foreach ($mitgliedschaftenExclude as $mitgliedschaftExclude) {
                    $search['mitgliedschaftenExclude'][$mitgliedschaftExclude->getUid()] = 1;
                }
            }
        }
        // default search
        if (!isset($search['memberActive'])) {
            $search['memberActive'] = 1;
        }
        if (!isset($search['memberActive'])) {
            $search['memberActive'] = 1;
        }
        $this->view->assign('search', $search);



        $crmLimit = [
            '-1' => 'Keine Beschränkung',
            '31' => 'FIBU Länge (generall 31 Zeichen, Ort 25, Briefanrede 65)',
        ];
        $this->view->assign('crmLimit', $crmLimit);
        $this->view->assign('optionsActive', [
            '1' => 'Aktive',
            '0' => 'Inaktive',
        ]);

        $crmStatus = [
            '0' => 'angestellt',
            '1' => 'freierwerbend mit Zeichnungsberechtigung',
        ];
        $this->view->assign('crmStatus', $crmStatus);

        $this->anredeRepository = GeneralUtility::makeInstance(AnredeRepository::class);
        $this->view->assign('anreden', $this->anredeRepository->findAll());
        
        $this->kantonRepository = GeneralUtility::makeInstance(KantonRepository::class);
        $this->view->assign('crmkantone', $this->kantonRepository->findAll());
        $crmJahre = [];
        for ($j = date('Y') + 1;$j >= date('Y') - 2;$j--) {
            if ($j == date('Y')) {
                $crmJahre[date('Y-m-d')] = 'Bis Heute (' . date('d.m.Y') . ')';
            }
            $crmJahre[$j] = $j;
        }
        $this->view->assign('crmJahre', $crmJahre);
        $jahr = $this->request->hasArgument('jahr') ? $this->request->getArgument('jahr') : date('Y');
        $this->view->assign('jahr', $jahr);
        $this->personRepository->setActiveYear($jahr);

        $this->view->assign('crmLanguages', $this->languageRepository->findAll());

        $this->view->assign('crmVertorbene', [
            '0' => 'Keine Verstorbene',
            '' => 'Alle, inkl. Verstorbene',
            '1' => 'nur Verstrobene',
        ]);
        
        $this->view->assign('tags', $this->tagRepository->findBy([
            'verband' => $verband,
        ]));
        $this->view->assign('tagsverband', $this->tagverbandRepository->findByVerband($verband));
        $journalRepository = GeneralUtility::makeInstance(ZeitschriftRepository::class);
        $this->view->assign('journals', $journalRepository->findBy([
            'verband' => $verband,
        ]));
        $categoryRepository = GeneralUtility::makeInstance(CategoryRepository::class);
        $this->view->assign('categories', $categoryRepository->findBy([
            'verband' => $verband,
        ]));
        $sektionRepository = GeneralUtility::makeInstance(SektionRepository::class);
        $this->view->assign('sektionen', $sektionRepository->findBy([
            'verband' => $verband,
        ]));

        $this->view->assign('crmboolean', [
            '1' => 'Ja',
            '0' => 'Nein',
        ]);
        return $this->htmlResponse($this->view->render());
    }

    /**
     * action exportLink
     */
    public function exportLinkAction(): ResponseInterface
    {
        $companyTagIds = explode(',', (string) $GLOBALS['TSFE']->fe_user->user['company']);
        //var_dump($companyTagIds);exit(0);
        //$context = GeneralUtility::makeInstance(Context::class);
        //$company_sektionsId = intval($context->getPropertyFromAspect('frontend.user', 'company'));
        $userTags = [];
        $tagUids = [];
        $verband = null;
        if (count($companyTagIds) > 0) {
            foreach ($companyTagIds as $tagId) {
                $userTag = $this->tagRepository->findByUid($tagId);
                $userTags[] = $userTag;
                $tagUids[] = $userTag->getUid();
                if ($verband === null) {
                    $verband = $userTag->getTagverband()
->getVerband();
                }
            }
        }
        $search = [
            'showentries' => 1,
            'memberActive' => 1,
            'tags' => $tagUids,
            'verband' => $verband->getUid(),
        ];
        $this->view->assign('search', $search);
        $this->view->assign('verband', $verband);
        $this->view->assign('userTags', $userTags);
        $this->view->assign('formats', [
            'xlsx' => 'Excel (xlsx)',
        ]);
        //$this->view->assign('verband', $verband);
        return $this->htmlResponse($this->view->render());
    }

    /**
     * action export
     */
    public function exportAction(Verband $verband, Export $export): ResponseInterface
    {
        $this->view->assign('verband', $verband);
        $search = $this->request->getArgument('@search');
        // falls nicht geliefert nur aktive
        if (!isset($search['memberActive'])) {
            $search['memberActive'] = 1;
        }
        $jahr = $this->request->hasArgument('jahr') ? $this->request->getArgument('jahr') : date('Y');
        $search['jahr'] = $jahr;
        $this->personRepository->setActiveYear($jahr);

        //var_dump($search);exit(0);
        //$export = $this->request->getArgument('export');
        //    die('a='.$verband->getName());
        //var_dump($export);
        $this->exportInvoicesVerband($verband, $export, $search);
        return $this->htmlResponse($this->view->render());
    }


    /**
     * action importForm - Tags auswählen, File auswählen
     */
    public function importFormUploadAction(Verband $verband): ResponseInterface
    {
        if (!$this->securityUtility->hasPermissionRead($verband, 'crm.tenant', ['fe_person_edit'])) {
            return $this->htmlResponse(self::ACCESS_DENIED);
        }
        $this->view->assign('verband', $verband);
        return $this->htmlResponse($this->view->render());
    }

    
    
    /**
     * action formColsImport - Aktuell auf TVG Lernende speziallisiert
     */
    public function importFormConfigAction(Verband $verband, FileResource $importFile = null): ResponseInterface
    {
        if (!$this->securityUtility->hasPermissionRead($verband, 'crm.tenant', ['fe_person_edit'])) {
            return $this->htmlResponse(self::ACCESS_DENIED);
        }
        if ($importFile === null) {
            $this->addFlashMessage('Kein File zum Importieren vorhanden.', '', ContextualFeedbackSeverity::ERROR);
            $args = [
                'verband' => $verband,
            ];
            return $this->redirectWithSearch('importFormUpload', '', null, $args);
            // debug add a file
            //$fileRepository = GeneralUtility::makeInstance(\TYPO3\CMS\Core\Resource\FileRepository::class);
            //$importFile = $fileRepository->findByUid(98);
        }


        $aliases = [
            'me_address' => [
                'attributes' => ['Strasse', 'Adresse', 'Road', 'Street', 'Address'],
            ],
            'me_city' => [
                'attributes' => ['Ort', 'city', 'Stadt'],
            ],
            'me_zip' => [
                'attributes' => ['PLZ', 'ACode', 'zip'],
            ],
            'me_country_abrev' => [
                'attributes' => ['Land', 'country', 'CCode'],
            ],
            'me_languageid' => [
                'filter' => 'getLanguage',
                'attributes' => ['language', 'Lang', 'Sprache'],
            ],
            'me_anrede_id' => [
                'filter' => 'getAnrede',
                'attributes' => ['Anrede D', 'Anrede'],
            ],
            'me_addressid' => [
                'attributes' => ['Kundennummer', 'Kundennr', 'Kundennr.'],
            ],
            
        ];
        
        $localPath = $importFile->getForLocalProcessing(false);
        $excelUtility = GeneralUtility::makeInstance(ExcelUtility::class);
        // attributes not shown for import selection
        $excludes = [
            'me_firma',
            'me_firma_address',
            'me_firma_address2',
            'me_firma_address3',
            'me_firma_zip',
            'me_firma_city',
            'me_firma_country_abrev',
            'me_bildungspass',
            'type',
            'acl_owner',
            'acl_read_groups',
            'acl_write_groups',
            'me_diplom_name',
            'me_patent_vorhanden',
            'me_patent_year',
            'me_ssmafperson_year',
            'me_certificates',
            'hash',
            'me_erhaelt_invoice',
            'me_invoicesadresse',
            'me_diplom_jahr',
            'me_mail_alias',
            'me_mail_geosuisse',
            'me_mail_igs',
            'me_extra_firma',
        ];
        try {
            $importConfig = $excelUtility->config('tx_igscrm_domain_model_contact', $localPath, $aliases, $excludes);
        } catch (Exception $e) {
            die('<h3>Exception ' . $e::class . '</h3> ' . $e->getMessage());
        }
        $filters = [
            'getKanton' => 'Kanton aus Abkürzung (z.B. BE)',
            'getAnrede' => 'Anrede (Herr,Frau,Firma oder m,w/f,c)',
            'getBoolean' => 'Boolean Wert (j,y,x und Zahl>0 = true)',
            'getDate' => 'Datum (d.m.Y -> Y-m-d)',
            'getInt' => 'Integer Wert erzwingen (\' entfernen)',
            'getLanguage' => 'Sprache (d,f,e,i,D,F,E,I),',
        ];

        
        //$tags = $this->getTagObjects('tags');
        $this->view->assign('importConfig', $importConfig);
        $this->view->assign('updateModes', $this->updateModes);
        $this->view->assign('addressMatchMethods', $this->addressMatchMethods);
        $this->view->assign('filters', $filters);
        $types = [];
        foreach ($GLOBALS['TCA']['tx_igscrm_domain_model_contact']['columns']['type']['config']['items'] as $type) {
            $types[$type['value']] = LocalizationUtility::translate($type['label']);
        }
        $this->view->assign('types', $types);
        $this->view->assign('verband', $verband);
        $this->view->assign('tagsverband', $this->tagverbandRepository->findByVerband($verband));
        $this->view->assign('mitgliedschaften', $this->mitgliedschaftRepository->findBy([
            'verband' => $verband,
        ]));
        $this->view->assign('importFile', $importFile);
        $this->view->assign('localPath', $localPath);
        //var_dump($localPath, $importFile);exit(0);
        return $this->htmlResponse($this->view->render());
    }
        
    /**
     * action import - Aktuell auf TVG Lernende speziallisiert
     */
    public function importAction(Verband $verband, int $fileUid, array $config, array $setting): ResponseInterface
    {
        if (!$this->securityUtility->hasPermissionRead($verband, 'crm.tenant', ['fe_person_edit'])) {
            return $this->htmlResponse(self::ACCESS_DENIED);
        }
        //$content = '';
        $fileRepository = GeneralUtility::makeInstance(FileRepository::class);
        $importFile = $fileRepository->findByUid($fileUid);

        $debug = $this->request->hasArgument('test') ? (bool) $this->request->getArgument('test') : false;

        $importObjectType = $setting['type'] ?? 'Person';
        $importObjectClass = $importObjectType == 'Organisation' ? Organisation::class : Person::class;

        //$debug = true;
        $updateMode = $this->request->hasArgument('updateMode') ? $this->request->getArgument('updateMode') : 'append';
        $addressMatchMethod = $this->request->hasArgument('addressMatchMethod') ? $this->request->getArgument(
            'addressMatchMethod'
        ) : 'exact';
        
        $membershipCount = $this->request->hasArgument('membershipCount') ? $this->request->getArgument(
            'membershipCount'
        ) : 0;
        $mitgliedschaftUid = $this->request->hasArgument('mitgliedschaft') ? $this->request->getArgument(
            'mitgliedschaft'
        ) : 0;
        if ($mitgliedschaftUid) {
            $mitgliedschaft = $this->mitgliedschaftRepository->findByUid($mitgliedschaftUid);
        } else {
            $mitgliedschaft = null;
        }
        $dateTimeConverter = GeneralUtility::makeInstance(DateTimeConverter::class);
        $formStartDate = $this->request->hasArgument('startDate') ? $this->request->getArgument('startDate') : null;
        $startDate = $dateTimeConverter->convertFrom($formStartDate, DateTime::class);
        if ($startDate === null) {
            return $this->htmlResponse(
                '<h1>Fehler: Eintrittsdatum ist zwingend</h1><p><a href="Javascript:history.back()">Zurück</a></p>'
            );
        }
        $active = true;
        
        $localPath = $importFile->getForLocalProcessing(false);
        $tags = $this->getTagObjects('tags');


        /*
          $content .= '<div class="frame-space-before-none frame-space-after-medium">';
          $content .= '<h2>'.($debug ? 'Testlauf ' : '').'Import Verband: '.$verband->getName().' (' . $verband->getUid() .')</h2>';
          if ($debug) {
          $content .= '<p>Dies ist nur ein Testlauf! Es werden keine Daten importiert oder aktualisiert!</p>';
          }
          $content .= '</div>';
         */
        /*
          $content .= '<div class="frame-space-before-none frame-space-after-medium">';
          $content .= '<h4>Tags/Kategorien anlegen/hinzufügen</h4><ul>';
          foreach ($tags as $tag) {
          $content .= '<li>Tag: '.$tag->getName().' ('.$tag->getUid().')</li>';
          }
          $content .= '</ul>';
          $content .= '</div>';
        */
        //$content .= '<div class="frame-space-before-none frame-space-after-medium">';


        //$content .= '<h4 title="Path: '. $localPath . 'File UID: ' . $importFile->getUid() . '">Import File: '. $importFile->getName() . '</h4>';

        $this->importUtility = GeneralUtility::makeInstance(ImportUtility::class);
        $importConfig = GeneralUtility::makeInstance(ImportConfig::class);
        $importConfig->setTablename('tx_igscrm_domain_model_contact');

        $meRemark = 'IMPORT' . strftime('%Y%m%d');
        $importSource = strftime('%Y%m%d %H:%M');
        

        $importConfig->setDefaultValues(
            [
                'pid' => 2006,
                'me_remark' => $meRemark,
                'me_languageid' => 1, //Sprache auf Deutsch, falls nichts im Excel vorhanden
                'me_import_source' => $importSource,
            ]
        );
        $importConfig->setCols($config);


        $this->importUtility->open($localPath, $importConfig);
        $updates = [];
        $importUids = [];
        $totals = [
            'total' => 0,
            'foundAddress' => 0,
            'foundMail' => 0,
            'newPerson' => 0,
            'personActive' => 0,
            'personInactive' => 0,
            'newContactVerband' => 0,
            'contactVerbandActive' => 0,
            'contactVerbandInactive' => 0,
            'newMembership' => 0,
            'duplicates' => 0,
            'tags' => [],
            'tagCount' => 0,
        ];
        foreach ($tags as $tag) {
            $totals['tags'][$tag->getUid()] = [
                'tag' => $tag,
                'new' => 0,
                'old' => 0,
                'newTag' => 0,
                'newContactVerband' => 0,
                'newPerson' => 0,
            ];
        }
        
        while ($line = $this->importUtility->getLine()) {
            $missing = [];
            $contactVerbandActive = true;
            $personActive = true;
            $update = [
                'isNew' => null,
                'foundMethod' => '',
                'updateMode' => '', // update mode of existing addresses
                'updateMethod' => '', // update method of contactVerband
                'tagCount' => 0,
                'missing' => '',
                'newEmail' => false,
                'person' => [],
            ];
            $found = false;
            // test ob exisitert
            $row = $line['tx_igscrm_domain_model_contact'];
            if (!$row['me_email']) {
                continue;
            }
            $totals['total']++;
            // Found Entry by Address and name
            $entry = $this->contactRepository->findSimilarByString(
                $row['me_lastname'],
                $row['me_firstname'],
                $row['me_companyname'],
                $row['me_zip'],
                $row['me_city'],
                $row['me_address'],
                $importObjectType
            );
            if ($entry !== false && count($entry) > 0) {
                $totals['foundAddress']++;
                $update['foundMethod'] = 'address';
                $found = true;
                //var_dump($entry);
                //var_dump($row);
            } else {
                // found entry by name and email
                if ($addressMatchMethod === 'nameMail' || $addressMatchMethod === 'mail') {
                    $entry = $this->contactRepository->findByMailAndName(
                        $row['me_lastname'],
                        $row['me_firstname'],
                        $row['me_companyname'],
                        $row['me_email'],
                        $importObjectType
                    );
                    if ($entry === false || count($entry) == 0) {
                        // found entry by email only
                        if ($addressMatchMethod === 'mail') {
                            $entry = $this->contactRepository->findByMailType($row['me_email'], $importObjectType);
                            if ($row['me_email'] && $entry !== false && count($entry) > 0) {
                                $totals['foundMail']++;
                                $update['foundMethod'] = 'email';
                                $found = true;
                            } else {
                                $totals['newPerson']++;
                            }
                        }
                    } else {
                        $totals['foundMail']++;
                        $update['foundMethod'] = 'name, email';
                        $found = true;
                        //$content .= ('<h3>NEW</h3>');
                    }
                }
            }

            if ($found && $updateMode !== 'new') {
                $update['isNew'] = false;
                $update['updateMode'] = $updateMode;
                if ($updateMode === 'none') {
                    //nichts machen
                } else {
                    $contact = $entry->getFirst();
                    if (isset($importUids[$contact->getUid()])) {
                        $totals['duplicates']++;
                        $update['missing'] = 'Dduplicate';
                    } else {
                        $importUids[$contact->getUid()] = true;
                    }
                    // Hat Person ein E-Mail gesetzt -> sonst setzen wenn vorhanden
                    if (!$debug) {
                        if ($updateMode === 'update') {
                            $missing = $this->updateContactWithRow($contact, $row);
                            $update['missing'] = implode(', ', $missing);
                        }
                        $this->securityUtility->setAcl($contact);
                        $this->contactRepository->update($contact);
                    }
                    $update['newEmail'] = true;
                    //$content .= ('<span style="color: #0000ff">[E-Mail missing]</span> ');
 
                    //  [' . $row['me_lastname'] .' ' . $row['me_firstname'] . ']
                    if ($contactVerband = $contact->getContactVerbandById($verband->getUid())) {
                        // Person vorhanden und in Mitglied von Verband
                        if ($contactVerband->getActiveWithDates()) {
                            $totals['contactVerbandActive']++;
                            $contactVerbandActive = true;
                        } else {
                            $totals['contactVerbandInactive']++;
                            $contactVerbandActive = false;
                            if ($startDate !== null) {
                                $contactVerband->setStartDate($startDate);
                                $contactVerband->setActive(true);
                                $contactVerband->setEndDate(null);
                            }
                        }
                        foreach ($tags as $tag) {
                            if (!$contactVerband->hasTag($tag)) {
                                $contactVerband->addTag($tag);
                                $update['tagCount']++;
                                $totals['tags'][$tag->getUid()]['new']++;
                                $totals['tags'][$tag->getUid()]['newTag']++;
                                $totals['tagCount']++;
                                if (!$debug) {
                                    $this->contactVerbandRepository->update($contactVerband);
                                }
                                $update['updateMethod'] = 'VerbandPerson: Add Tag(s)';
                            } else {
                                $totals['tags'][$tag->getUid()]['old']++;
                            }
                            $currentMitgliedschaft = $contactVerband->getMitgliedschaft();
                            $update['mitgliedschaft'] = $currentMitgliedschaft instanceof Mitgliedschaft ? $currentMitgliedschaft->getName() : '';
                            $contactVerband->setMitgliedschaft($mitgliedschaft);
                            //$content .= ('<span style="color: #ff0000">[VerbandPerson: Add Tag]</span> ');
                        }

                        
                        if (!$debug) {
                            $this->contactVerbandRepository->update($contactVerband);
                        }
                        $update['updateMethod'] = 'Update VerbandPerson';
                    } else {
                        // Person vorhanden, aber nicht Mitglied von Verband
                        $totals['newContactVerband']++;
                        if ($contact->getActive()) {
                            $totals['personActive']++;
                            $personActive = true;
                        } else {
                            $totals['personInactive']++;
                            $personActive = false;
                        }
                        $contactVerband = GeneralUtility::makeInstance(ContactVerband::class);
                        $contactVerband->setVerband($verband);
                        $contactVerband->setContact($contact);
                        foreach ($tags as $tag) {
                            $contactVerband->addTag($tag);
                            $update['tagCount']++;
                            $totals['tags'][$tag->getUid()]['new']++;
                            $totals['tags'][$tag->getUid()]['newContactVerband']++;
                            $totals['tagCount']++;
                        }
                        $contactVerband->setStartDate($startDate);
                        $contactVerband->setActive($active);
                        $contactVerband->setImportSource($importSource);
                        $contactVerband->setMitgliedschaft($mitgliedschaft);
                        $contact->addMeContactVerband($contactVerband);
                        //$contact->setMeImportTmp('20200212');
                        if (!$debug) {
                            $this->securityUtility->setAcl($contact);
                            $this->contactRepository->update($contact);
                        }
                        $update['updateMethod'] = 'Add VerbandPerson';
                        //$content .= ('<span style="color: #ff0000">[Add VerbandPerson]</span> ');
                    }
                    
                    $update['person'] = [
                        'uid' => $contact->getUid(),
                        'salutation' => $contact->getSalutation(),
                        'name' => $contact->getName(),
                        'email' => $contact->getMeEmail(),
                        'address' => $contact->getAddress(),
                        'address2' => $contact->getAddress2(),
                        'address3' => $contact->getAddress3(),
                        'zipCity' => $contact->getZip() . ' ' . $contact->getCity() . '',
                        'type' => $contact->getType(),
                        'personActive' => $personActive,
                        'contactVerbandActive' => $contactVerbandActive,
                    ];
                }
            } else {
                // Person existiert nicht
                $totals['newPerson']++;
                $update['isNew'] = true;
                $languageRepository = GeneralUtility::makeInstance(LanguageRepository::class);
                $language = $languageRepository->findByUid(1);

                $contact = GeneralUtility::makeInstance($importObjectClass);
                $contact->setType($importObjectType);

                $missing = $this->updateContactWithRow($contact, $row);
                $update['missing'] = implode(', ', $missing);
                /*
                  if ($row['me_lastname'] ?? false) {
                  $contact->setMeLastname($row['me_lastname']);
                  }
                  if ($row['me_firstname'] ?? false) {
                  $contact->setMeFirstname($row['me_firstname']);
                  }
                  $contact->setMeZip($row['me_zip']);
                  $contact->setMeCity($row['me_city']);
                  $contact->setMeAddress($row['me_address']);
                  $contact->setMeKantonId($row['me_kanton_id']);
                  $contact->setMeLanguageid($language);
                  $contact->setMeRemark($meRemark);
                  $contact->setMeImportSource($importSource);
                  $contact->setMeEmail($row['me_email']);
                  if ($row['me_companyname'] ?? false) {
                  $contact->setMeCompanyname($row['me_companyname']);
                  }
                 */
                $contactVerband = GeneralUtility::makeInstance(ContactVerband::class);
                $contactVerband->setVerband($verband);
                $contactVerband->setContact($contact);
                foreach ($tags as $tag) {
                    $contactVerband->addTag($tag);
                    $update['tagCount']++;
                    $totals['tags'][$tag->getUid()]['new']++;
                    $totals['tags'][$tag->getUid()]['newPerson']++;
                    $totals['tagCount']++;
                }
                $contactVerband->setStartDate($startDate);
                $contactVerband->setActive($active);
                $contactVerband->setImportSource($importSource);
                $contactVerband->setMitgliedschaft($mitgliedschaft);
                $contact->addMeContactVerband($contactVerband);
                //$contact->setMeImportTmp('20200212');
                if (!$debug) {
                    $this->securityUtility->setAcl($contact, $verband->getUid());
                    $this->contactRepository->add($contact);
                }
                $update['person'] = [
                    'uid' => $contact->getUid(),
                    'salutation' => $contact->getSalutation(),
                    'name' => $contact->getName(),
                    'email' => $contact->getMeEmail(),
                    'address' => $contact->getAddress(),
                    'address2' => $contact->getAddress2(),
                    'address3' => $contact->getAddress3(),
                    'zipCity' => $contact->getZip() . ' ' . $contact->getCity() . '',
                    'type' => $contact->getType(),
                    'personActive' => $personActive,
                    'contactVerbandActive' => $contactVerbandActive,
                ];
                //(($content .= ('<span style="color: #ff0000">New uid=' . $contact->getUid() . ' ('.$contact->getMeLastname() . ' ' . $contact->getMeFirstname().')</span>');
                /*
                  foreach ($contact->getMeContactVerband() as $pv) {
                  $content .= ('[PV=' . $pv->getStartDate()->format('d.m.Y') .', Tags: ');
                  foreach ($pv->getTags() as $t) {
                  $content .= (''.$t->getName().', ');
                  }
                  $content .= (']');
                  }
                  $content .= ('<br />');
                */
            }
            $updates[] = $update;
        }
        $this->importUtility->close();

        if ($debug) {
            $this->addFlashMessage(
                'Testlauf - es wurden KEINE Daten importiert.',
                '',
                ContextualFeedbackSeverity::WARNING
            );
        } else {
            $this->addFlashMessage('Daten wurden importiert.', '', ContextualFeedbackSeverity::OK);
        }
        
        
        $this->view->assign('debug', $debug);
        $this->view->assign('setting', $setting);
        $this->view->assign('mitgliedschaft', $mitgliedschaft);
        $this->view->assign('membershipCount', $membershipCount);
        $this->view->assign('updateMode', [
            'id' => $updateMode,
            'label' => $this->updateModes[$updateMode] ?? '???',
            
        ]);
        $this->view->assign('verband', $verband);
        $this->view->assign('startDate', $startDate);
        $this->view->assign('tags', $tags);
        $this->view->assign('localPath', $localPath);
        $this->view->assign('importFile', $importFile);
        $this->view->assign('updates', $updates);
        $this->view->assign('content', $content);
        $this->view->assign('totals', $totals);
        return $this->htmlResponse($this->view->render());
    }

    public function getOrganisationUid($organisation)
    {
        $queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable(
            'tx_igscrm_domain_model_organisation'
        );

        $queryBuilder->select('uid')
                     ->from('tx_igscrm_domain_model_organisation')
                     ->where(
                         $queryBuilder->expr()
->eq('of_companyname', intval($organisation['of_companyname'])),
                         $queryBuilder->expr()
->eq('of_street', $queryBuilder->createNamedParameter($organisation['of_street'])),
                         $queryBuilder->expr()
->eq('of_zip', intval($organisation['of_zip'])),
                         $queryBuilder->expr()
->eq('of_city', $queryBuilder->createNamedParameter($organisation['of_city']))
                     );
        $result = $queryBuilder->execute();
        $row = $result->fetch();
        return $row ? $row['uid'] : false;
    }
    /**
     * action show
     */
    #[IgnoreValidation([
        'argumentName' => 'verband',
    ])]
    public function showAction(Verband $verband): ResponseInterface
    {
        if (!$this->securityUtility->hasPermissionRead($verband, 'crm.tenant', ['fe_verband'])) {
            return $this->htmlResponse(self::ACCESS_DENIED);
        }
        $this->view->assign('verband', $verband);
        $activeTab = $this->request->hasArgument('activeTab') ? $this->request->getArgument('activeTab') : '';
        $this->view->assign('activeTab', $activeTab);
        if ($verband->getTestDates()) {
            $personenBugs = $this->contactRepository->findBugsByVerband($verband->getUid(), $this->settings);
        } else {
            $personenBugs = [];
        }
        $this->view->assign('personenBugs', $personenBugs);

        $apis = $this->apiRepository->findBy([
            'verband' => $verband,
        ]);

        $this->view->assign('apis', $apis);
        return $this->htmlResponse($this->view->render());
    }

    /**
     * action bug
     */
    #[IgnoreValidation([
        'argumentName' => 'verband',
    ])]
    public function bugAction(Verband $verband): ResponseInterface
    {
        if (!$this->securityUtility->hasPermissionRead($verband, 'crm.tenant', ['fe_verband'])) {
            return $this->htmlResponse(self::ACCESS_DENIED);
        }
        $this->view->assign('verband', $verband);
        $activeTab = $this->request->hasArgument('activeTab') ? $this->request->getArgument('activeTab') : '';
        $this->view->assign('activeTab', $activeTab);
        $personenBugs = $this->contactRepository->findBugsByVerband($verband->getUid(), $this->settings);
        $this->view->assign('personenBugs', $personenBugs);
        return $this->htmlResponse($this->view->render());
    }
    
    /**
     * action editAddress
     */
    #[IgnoreValidation([
        'argumentName' => 'verband',
    ])]
    public function editAddressAction(Verband $verband): ResponseInterface
    {
        if (!$this->securityUtility->hasPermissionWrite($verband, self::$requiredRole, ['fe_verband_edit'])) {
            return $this->htmlResponse(self::ACCESS_DENIED);
        }
        $this->view->assign('verband', $verband);
        $activeTab = $this->request->hasArgument('activeTab') ? $this->request->getArgument('activeTab') : '';
        $this->view->assign('activeTab', $activeTab);
        return $this->htmlResponse($this->view->render());
    }

    /**
     * action editFibu
     */
    #[IgnoreValidation([
        'argumentName' => 'verband',
    ])]
    public function editFibuAction(Verband $verband): ResponseInterface
    {
        if (!$this->securityUtility->hasPermissionWrite($verband, self::$requiredRole, ['fe_verband_edit'])) {
            return $this->htmlResponse(self::ACCESS_DENIED);
        }
        $this->assignEditFormfields($verband);
        $this->view->assign('verband', $verband);
        $activeTab = $this->request->hasArgument('activeTab') ? $this->request->getArgument('activeTab') : '';
        $this->view->assign('activeTab', $activeTab);
        return $this->htmlResponse($this->view->render());
    }

    /**
     * action editFields
     */
    #[IgnoreValidation([
        'argumentName' => 'verband',
    ])]
    public function editFieldsAction(Verband $verband): ResponseInterface
    {
        if (!$this->securityUtility->hasPermissionWrite($verband, self::$requiredRole, ['fe_verband_edit'])) {
            return $this->htmlResponse(self::ACCESS_DENIED);
        }
        $this->view->assign('verband', $verband);
        $activeTab = $this->request->hasArgument('activeTab') ? $this->request->getArgument('activeTab') : '';
        $this->view->assign('activeTab', $activeTab);
        return $this->htmlResponse($this->view->render());
    }

    /**
     * action editAdmin
     */
    #[IgnoreValidation([
        'argumentName' => 'verband',
    ])]
    public function editAdminAction(Verband $verband): ResponseInterface
    {
        if (!$this->securityUtility->hasPermissionWrite($verband, self::$requiredRole, ['fe_admin'])) {
            return $this->htmlResponse(self::ACCESS_DENIED);
        }
        $this->view->assign('verband', $verband);
        $activeTab = $this->request->hasArgument('activeTab') ? $this->request->getArgument('activeTab') : '';
        $this->view->assign('crmLanguages', $this->languageRepository->findAll());

        $this->frontendUserGroupRepository->setRespectStoragePage(false);
        $frontendUserGroups = $this->frontendUserGroupRepository->findAll();
        $this->view->assign('frontendUserGroups', $frontendUserGroups);
        $this->view->assign('activeTab', $activeTab);
        return $this->htmlResponse($this->view->render());
    }


    /**
     * action editName
     */
    #[IgnoreValidation([
        'argumentName' => 'verband',
    ])]
    public function editNameAction(Verband $verband): ResponseInterface
    {
        if (!$this->securityUtility->hasPermissionWrite($verband, self::$requiredRole, ['fe_verband_edit'])) {
            return $this->htmlResponse(self::ACCESS_DENIED);
        }
        $this->view->assign('verband', $verband);
        $activeTab = $this->request->hasArgument('activeTab') ? $this->request->getArgument('activeTab') : '';
        $this->view->assign('activeTab', $activeTab);
        $verbands = $this->verbandRepository->findAllWithAcl(true);
        $this->view->assign('verbands', $verbands);
        return $this->htmlResponse($this->view->render());
    }

    /**
     * action edit
     */
    #[IgnoreValidation([
        'argumentName' => 'verband',
    ])]
    public function editAction(Verband $verband): ResponseInterface
    {
        if (!$this->securityUtility->hasPermissionWrite($verband, self::$requiredRole, ['fe_verband_edit'])) {
            return $this->htmlResponse(self::ACCESS_DENIED);
        }
        $this->view->assign('verband', $verband);
        $activeTab = $this->request->hasArgument('activeTab') ? $this->request->getArgument('activeTab') : '';
        $this->view->assign('activeTab', $activeTab);
        return $this->htmlResponse($this->view->render());
    }

    /**
     * action new
     */
    public function newAction(): ResponseInterface
    {
        if (!$this->securityUtility->hasPermissionWrite(null, self::$requiredRole, ['fe_verband_edit'])) {
            return $this->htmlResponse(self::ACCESS_DENIED);
        }
        $this->view->assign('verband', $verband);
        $activeTab = $this->request->hasArgument('activeTab') ? $this->request->getArgument('activeTab') : '';
        $this->view->assign('activeTab', $activeTab);
        $verbands = $this->verbandRepository->findAllWithAcl(true);
        $this->view->assign('verbands', $verbands);
        return $this->htmlResponse($this->view->render());
    }


    /**
     * action update
     */
    #[IgnoreValidation([
        'argumentName' => 'verband',
    ])]
    public function updateAction(Verband $verband): ResponseInterface
    {
        if (!$this->securityUtility->hasPermissionWrite($verband, self::$requiredRole, ['fe_verband_edit'])) {
            return $this->htmlResponse(self::ACCESS_DENIED);
        }
        /*      $pathUids = [];
                $pathVerband = $verband;
                do {
                $pathUids[] = $pathVerband->getUid();
                $pathVerband = $pathVerband->getParent();
                } while ($pathVerband);
                $pathUids = array_reverse($pathUids);
                $pathUidsString = implode(',', $pathUids);
                var_dump($pathUids, $pathUidsString);exit(0);
                $verband->setPathUids($pathUidsString);
        */
        //$this->verbandRepository->updatePathUids($verband);
        $this->verbandRepository->update($verband);
        $this->addFlashMessage('Der Eintrag wurde aktualisiert.');
        $args = [
            'verband' => $verband,
        ];
        if ($this->request->hasArgument('activeTab')) {
            $args['activeTab'] = $this->request->getArgument('activeTab');
        }
        return $this->redirectWithSearch('show', '', null, $args);
    }

    /**
     * action create
     */
    #[IgnoreValidation([
        'argumentName' => 'verband',
    ])]
    public function createAction(Verband $verband): ResponseInterface
    {
        if (!$this->securityUtility->hasPermissionWrite(null, self::$requiredRole, self::$requiredRole, ['fe_verband_edit'])) {
            return $this->htmlResponse(self::ACCESS_DENIED);
        }
        $this->securityUtility->setAcl($verband);
        $this->verbandRepository->add($verband);
        $this->addFlashMessage('Der Eintrag wurde erstellt.');
        $persistenceManager = GeneralUtility::makeInstance(PersistenceManager::class);
        $persistenceManager->persistAll();
        $args = [
            'verband' => $verband,
        ];
        if ($this->request->hasArgument('activeTab')) {
            $args['activeTab'] = $this->request->getArgument('activeTab');
        }
        return $this->redirectWithSearch('show', '', null, $args);
    }
    /**
     * assign for edit/new form
     */
    public function assignEditFormfields(Verband $verband): void
    {
        $periodUtility = GeneralUtility::makeInstance(PeriodUtility::class);

        //$periodService = $periodUtility->getPeriodServiceByDuration($verband->getInvoicePeriodeLengthInMonth() ?? 12);
        $periods = $periodUtility->getAll();
        //var_dump($periodService);exit(0);
        //$periodDates = $periodService->getRangeByCount(new \DateTime(), 2);
        $this->view->assign('periods', $periods);
    }





    /**
     * action export Rechnungen Verband
     */
    protected function exportInvoicesVerband($verband, $export, $search): ResponseInterface
    {
        $filename = substr(str_replace(' ', '-', $verband->getName() . '-' . $export->getFilename()) . '-', 0, 22) . strftime(
            '%Y%m%d'
        ); // Max 31 Zeichen
        $config = $export->getConfigArray();
        $fields = $export->getFieldsArray();
        $tagverbands = $this->tagverbandRepository->findByVerband($verband);
        $tagverbandHeaders = [];
        $tagverbandEmptyRows = [];
        $tagIdNames = [];
        $tagRowCount = 0;
        if (!empty($tagverbands)) {
            foreach ($tagverbands as $tagverband) {
                $tagverbandHeaders[] = $tagverband->getName();
                $tagverband->getName();
                $tags = $tagverband->getTags();
                foreach ($tags as $tag) {
                    $tagIdNames[$tag->getUid()] = [
                        'name' => $tag->getName(),
                        'row' => $tagRowCount,
                    ];
                }
                $tagverbandEmptyRows[] = [];
                $tagRowCount++;
            }
        }
        $headerVerbands = [];
        if ($search['showVerbandHeader'] ?? 0) {
            $headerVerbands = $this->securityUtility->getFrontendUserHeaderVerband();
        }
        $this->personRepository->setUseAcl(false);
        //var_dump($export->getConfigArray());exit(0);
        $exports = $this->personRepository->findByVerband($verband, $search);
        /*
          foreach($exports as $m) {
          echo('-' .$m->getMeLastname()."<br />\n");
          }die('C='.count($exports));
        */
        $type = 'excel';
        $this->exportUtility = GeneralUtility::makeInstance(ExportUtility::class);

        $allRows = [];

        $limitLength = $search['limitLength'] ?? $config['limitLength'];
        $limitLengthAnrede = $limitLength > 0 ? 65 : 0; // spzielle Werte fuer geosuisse/IGS SAGE
        $limitLengthCity = $limitLength > 0 ? 25 : 0;
        $limitLengthSort = $limitLength > 0 ? 11 : 0;

        foreach ($exports as $nr => $person) {
            $contactVerband = $person->getContactVerbandById($verband->getUid());
            if (!is_object($contactVerband)) {
                die('error: data was changed?!');
            }
            $mitgliedschaft = $contactVerband->getMitgliedschaft();
            $organisation = $contactVerband->getCombinedInvoiceAddress();
            $row = [];

            if (!empty($headerVerbands)) {
                foreach ($headerVerbands as $headerVerband) {
                    //    <crm:person.verband person="{person}" verband="{verband}" as="contactVerband">
                    $headerContactVerband = $person->getContactVerbandById($headerVerband->getUid());
                    $row[] = $headerContactVerband instanceof ContactVerband && $headerContactVerband->getActive() ? 'X' : '';
                }
            }

            
            if ($verband->getPersonUidAttribute() == 'meAddressid') {
                $personNumber = $person->getMeAddressid();
            } elseif ($verband->getPersonUidAttribute() == 'uid' || $verband->getPersonUidAttribute() == '') {
                if (isset($config['jahr']) && $config['jahr'] > 0) {
                    //$personNumber = $person->getUid() + (300+intval($config['jahr']))*10000000; // 2Stellen Jahr, 7 Stellen Kundennummer ( 3= VerbandsId von SGPF)
                    $personNumber = $person->getUid() + (intval(
                        $config['jahr']
                    )) * 10000000; // 2Stellen Jahr, 7 Stellen Kundennummer
                    $jahr = $config['jahr'];
                } else {
                    $personNumber = $person->getUid() + $verband->getUid() * 10000000; //7 Stellen Kundennummer
                    // $personNumber = $person->getUid() + $verband->getUid()*100*10000000;// 2Stellen Jahr, 7 Stellen Kundennummer ( 3= VerbandsId von SGPF)
                    $jahr = 0;
                }
            } else {
                die('ERROR: not defined Person UID Attribute ' . $verband->getPersonUidAttribute() . ', Verband: ' . $verband->getName());
            }
            $row[] = $personNumber;

            if ($organisation instanceof Organisation) {
                $row[] = 'Büro';
                $row[] = $this->exportUtility->value($organisation->getMeCompanyname(), $limitLength); //Corp
                $row[] = $this->exportUtility->value($person->getMeLastname(), $limitLength);
                $row[] = $this->exportUtility->value($person->getMeFirstname(), $limitLength);

                $row[] = $this->exportUtility->value(
                    $person->getMeLastname() . ' ' . $person->getMeFirstname(),
                    $limitLength
                ); //Line 1
                $row[] = $this->exportUtility->value(
                    $organisation->getMePobox() ?: $organisation->getMeAddon(),
                    $limitLength
                ); // Line 2
                $row[] = $this->exportUtility->value($organisation->getMeStreet(), $limitLength); // Road
                $row[] = $this->exportUtility->value($organisation->getCountryIsoCode(), 3); // CCode
                $row[] = $organisation->getMeZip(); // ACode
                $row[] = $this->exportUtility->value($organisation->getMeCity(), $limitLengthCity); // City
                $row[] = $this->exportUtility->value($organisation->getMePobox(), $limitLength); // Postfach
                $row[] = $this->exportUtility->value($organisation->getMeAddon(), $limitLength); // Firmenzusatz

                $row[] = $this->exportUtility->value($person->getBriefanredeDF(), $limitLengthAnrede);// Salut
                $row[] = $person->getLanguageShort() == 'F' ? 'F' : 'D';
                $row[] = $this->exportUtility->value($organisation->getMeSort(), $limitLengthSort);
            } else {
                $row[] = 'Person';
                $row[] = $this->exportUtility->value(
                    $person->getMeLastname() . ' ' . $person->getMeFirstname(),
                    $limitLength
                ); //Corp
                $row[] = $this->exportUtility->value($person->getMeLastname(), $limitLength);
                $row[] = $this->exportUtility->value($person->getMeFirstname(), $limitLength);
                $row[] = $this->exportUtility->value($person->getMeAddon(), $limitLength); // Line 1
                $row[] = $this->exportUtility->value($person->getMePobox() ?? '', $limitLength);

                $row[] = $this->exportUtility->value($person->getMeAddress(), $limitLength); // Road
                $row[] = $this->exportUtility->value($person->getCountryIsoCode(), 3);
                $row[] = $person->getMeZip();
                $row[] = $this->exportUtility->value($person->getMeCity(), $limitLengthCity);
                $row[] = '';
                $row[] = '';
                $row[] = $this->exportUtility->value($person->getBriefanredeDF(), $limitLengthAnrede);// Salut
                $row[] = $person->getLanguageCode() == 'fr' ? 'F' : 'D';
                $row[] = $this->exportUtility->value($person->getMeSort(), $limitLengthSort);
            }

            /*
              $row[] = $this->exportUtility->value($person->getMeAddress(),$limitLength); // Road
              $row[] = $this->exportUtility->value($person->getMeAddress2(),$limitLength); // Road
              $row[] = $this->exportUtility->value($person->getMeAddress3(),$limitLength); // Road
              $row[] = $this->exportUtility->value($person->getMeExtraText1(),$limitLength); // Kontaktperson Vorname
              $row[] = $this->exportUtility->value($person->getMeExtraText2(),$limitLength); // Kontaktperson Nachname
              $row[] = $person->getMeCountryAbrev();
              $row[] = $person->getMeZip();
              $row[] = $this->exportUtility->value($person->getMeCity(),$limitLengthCity);
            */
            /*
              $row[] = $person->getMeFirma();
              $row[] = $person->getMeExtraText3();
              $row[] = $person->getMeExtraText5();
              $row[] = $person->getMeSort();
             */
            // Rechnungen - kein FIBU
            if ($config['showEmail']) {
                $email = $person->getMeEmail();
                if (!$email) {
                    $email = $person->getMeMailIgs() ?: $person->getMeMailGeosuisse();
                }
                $row[] = $email;
            }

            foreach ($fields as $attribute => $title) {
                if (strpos((string) $attribute, '.')) {
                    $parts = explode('.', (string) $attribute);
                    $object = $parts[0];
                    $objectAttribute = $parts[1];
                    if ($object == 'person') {
                        $func = 'get' . ucfirst($objectAttribute);
                        $row[] = $person->{$func}();
                    } elseif ($object == 'contactVerband') {
                        $func = 'get' . ucfirst($objectAttribute);
                        $row[] = $contactVerband->{$func}();
                    } else {
                        die('fields/object not found: ' . $attribute . '=' . $object . '.' . $objectAttribute);
                    }
                } else {
                    $func = 'get' . ucfirst((string) $attribute);
                    $row[] = $person->{$func}();
                }
            }

            //$row[] = $person->getMeExternId();

            if ($config['showAnrede']) {
                $row[] = $person->getMeTitel(); // Titel

                $row[] = $person->getAnrede(); // Anrede D,F,I
                $row[] = $person->getMeAnrede(); // Anrede D
                $row[] = $person->getBriefanredeDF();
                $row[] = $person->getBriefanrede();
                $row[] = $person->getBriefanredeOhneNameDF();
                $row[] = $person->getBriefanredeOhneName();
                $meLang = $person->getMeLanguageid();
                $row[] = $meLang ? $meLang->getLgShort() : 'de'; // Lang

                $row[] = $person->getMeProfession();
            }

            if ($config['showInvoice']) {
                $row[] = $person->getMeAlterWithYear();//Alter in Jahre
                $row[] = $person->getMeYearOfBirth(); //Geburtsjahr
                //$row[] = $person->getMeSgpfBeitrag(); // SGPF Teilbeitrag

                $row[] = $mitgliedschaft ? $mitgliedschaft->getBetragWithAlter(
                    $person->getMeAlterWithYear(),
                    $person->getAnredeId()
                ) : 0; // Mitgliederbeitrag
                $row[] = $contactVerband->getJournalAmount(); // Zeitschriftsbetrag - je nach Mitgliedschaft ist die immer 0
                if ($verband->getExtraBetragvalue() > 0) {
                    $row[] = $contactVerband->getVerbandExtraBetragvalue();
                }
                //$row[] = $person->getMeSgpfZeitschriftBetrag(); // SGPF Zeitschriftsbetrag

                $row[] = $mitgliedschaft ? $mitgliedschaft->getName() : '';
                $row[] = $mitgliedschaft ? $mitgliedschaft->getInvoicestextWithAlter(
                    $person->getMeAlterWithYear()
                ) : ''; // Invoicestext


                $d = $contactVerband->getStartDate();
                $row[] = $d ? $d->format('Y-m-d') : ''; // Eintritt
                /*
                  foreach($this->exportUtility-> getAddressValues( $person->getMeSgpfInvoiceId(), 'SGPF'  ) as $addressValue ) {
                  $row[] = $addressValue;
                  }
                */
            }

            if (!empty($tagverbands)) {
                $tagIds = $contactVerband->getTagIds();
                $tagRows = $tagverbandEmptyRows;
                foreach ($tagIds as $tagId) {
                    $tagIdName = $tagIdNames[$tagId];
                    $tagRows[$tagIdName['row']][] = $tagIdName['name'];
                }
                foreach ($tagRows as $tagRow) {
                    $row[] = implode(', ', $tagRow);
                }
            }

            
            if ($config['showPrivatAddress']) {
                $row[] = $this->exportUtility->value(
                    $person->getMeLastname() . ' ' . $person->getMeFirstname(),
                    $limitLength
                ); //Corp
                $row[] = $this->exportUtility->value($person->getMeAddon(), $limitLength); // Line 1
                $row[] = $this->exportUtility->value($person->getMePobox() ?? '', $limitLength); // Line 2
                $row[] = $this->exportUtility->value($person->getMeAddress(), $limitLength); // Road
                $row[] = $this->exportUtility->value($person->getCountryIsoCode(), 3); // CCode
                $row[] = $person->getMeZip(); // ACode
                $row[] = $this->exportUtility->value($person->getMeCity(), $limitLengthCity); // City
            }
            if ($config['showInvoiceAddress']) {
                if ($organisation instanceof Organisation) {
                    $row[] = $this->exportUtility->value($organisation->getMeCompanyname(), $limitLength); //Corp
                    $row[] = $this->exportUtility->value(
                        $person->getMeLastname() . ' ' . $person->getMeFirstname(),
                        $limitLength
                    ); //Line 1
                    $row[] = $this->exportUtility->value(
                        $organisation->getMePobox() ?: $organisation->getMeAddon(),
                        $limitLength
                    ); // Line 2
                    $row[] = $this->exportUtility->value($organisation->getMeStreet(), $limitLength); // Road
                    $row[] = $this->exportUtility->value($organisation->getCountryIsoCode(), 3);
                    $row[] = $organisation->getMeZip();
                    $row[] = $this->exportUtility->value($organisation->getMeCity(), $limitLengthCity);
                    $row[] = $this->exportUtility->value($organisation->getMePobox(), $limitLength);
                    $row[] = $this->exportUtility->value($organisation->getMeAddon(), $limitLength); // Line 2
                } else {
                    // Spalten leer fueller
                    for ($i = 0;$i < 7;$i++) {
                        $row[] = '';
                    }
                }
            }

            //if( $total>0)
            $allRows[] = $row;
        }
        //var_dump($allRows);exit(0$);
        $headers = [];
        if (!empty($headerVerbands)) {
            foreach ($headerVerbands as $headerVerband) {
                $headers[] = $headerVerband->getName();
            }
        }
        $headers[] = 'AdrId';
        $headers[] = 'Code';
        $headers[] = 'Corp';
        $headers[] = 'Nachname';
        $headers[] = 'Vorname';
        $headers = array_merge(
            $headers,
            [
                'Line1', // Zusatz
                'Line2',
                'Road',
                'CCode',
                'ACode',
                'City',
                'Firma Postfach',
                'Firmenzusatz',
                'Salut',
                'Lang',
                'Sort',
            ]
        );

        if ($config['showEmail']) {
            $headers[] = 'E-Mail';
        }
        foreach ($fields as $attribute => $title) {
            $headers[] = $title;
        }
        if ($config['showAnrede']) {
            $headers = array_merge(
                $headers,
                [
                    'Titel',
                    'Anrede D+F+I',
                    'Anrede D',
                    'Briefanrede D,F',
                    'Briefanrede D,F,I',
                    'Briefanrede ohne Name D+F',
                    'Briefanrede ohne Name D,F,I',
                    'Lang (D, F, I)',
                    'Beruf',
                ]
            );
        }
        if ($config['showInvoice']) {
            $headers = array_merge(
                $headers,
                ['Alter in Jahre', 'Geburtsjahr', 'Teilbeitrag', 'Zeitschriftsbetrag'],
                $verband->getExtraBetragValue() > 0 ? [$verband->getExtraBetragTitle()] : [],
                ['Mitgliedschaft', 'Mitgliedschaft Invoicestext', 'Eintritt']
            );
        }

        
        if (!empty($tagverbandHeaders)) {
            $headers = array_merge($headers, $tagverbandHeaders);
        }


        if ($config['showPrivatAddress']) {
            $headers = array_merge(
                $headers,
                [
                    'Privat: Corp',
                    'Privat: Line1',
                    'Privat: Line2',
                    'Privat: Road',
                    'Privat: CCode',
                    'Privat: ACode',
                    'Privat: City',
                ]
            );
        }
        if ($config['showInvoiceAddress']) {
            $headers = array_merge(
                $headers,
                [
                    'Rechnungsadresse: Corp',
                    'Rechnungsadresse: Line1',
                    'Rechnungsadresse: Line2',
                    'Rechnungsadresse: Road',
                    'Rechnungsadresse: CCode',
                    'Rechnungsadresse: ACode',
                    'Rechnungsadresse: City',
                    'Rechnungsadresse: Postfach',
                    'Rechnungsadresse: Firmenzusatz',
                ]
            );
        }



        //$headers = array_merge( $headers, $this->exportUtility->getAddressHeaderValues( 'SGPF'));
        $excelUtility = GeneralUtility::makeInstance(ExcelUtility::class);
        $excelUtility->export($headers, $allRows, $filename);
        return $this->htmlResponse($this->view->render());
    }
    private function updateContactWithRow(Contact $contact, array $row): array
    {
        $missing = [];
        foreach ($row as $attribute => $value) {
            // disallow some attributes for security
            if (in_array(
                $attribute,
                ['uid', 'pid', 'type', 'acl_owner', 'acl_read_groups', 'acl_write_groups', 'deleted', 'hidden', 'tstamp', 'crdate']
            )) {
                continue;
            }
            if ($attribute == 'me_email') {
                $meEmailAscii = idn_to_ascii($row['me_email']);
                if (filter_var($meEmailAscii, FILTER_VALIDATE_EMAIL)) {
                    $contact->setMeEmail($row['me_email']);
                }
            } else {
                $words = explode('_', $attribute);
                $words = array_map('ucfirst', $words);
                $propertyName = 'set' . implode('', $words);
                if (method_exists($contact, $propertyName)) {
                    $contact->{$propertyName}($value);
                } else {
                    $missing[] = $attribute;
                }
            }
        }
        return $missing;
    }
    
    private function getZeitraumJahre()
    {
        $zeitraumJahre = [];
        for ($y = date('Y') + 1;$y > date('Y') - 10;$y--) {
            $zeitraumJahre[$y] = $y;
        }
        return $zeitraumJahre;
    }

    private function getTagObjects(string $formFieldName)
    {
        $tags = [];
        if ($this->request->hasArgument($formFieldName)) {
            $formTags = $this->request->getArgument($formFieldName);
            foreach ($formTags as $formTag) {
                $tag = $this->tagRepository->findByUid($formTag);
                $tags[] = $tag;
                //$tagsTitleUid[] = $tag->getName() .' (' . $tag->getUid(). ')';
            }
        }
        return $tags;
    }
}
