<?php

namespace Internetgalerie\IgCrmAdmin\Controller;

use Internetgalerie\IgCrmAdmin\Controller\TYPO3\CMS\Extbase\Annotation\IgnoreValidation;
use Internetgalerie\IgDatapoolFe\Controller\ActionController;
use Internetgalerie\IgsCrm\Domain\Model\Verband;
use Internetgalerie\IgsCrm\Domain\Model\Zeitschrift;
use Internetgalerie\IgsCrm\Domain\Repository\ContactVerbandRepository;
use Internetgalerie\IgsCrm\Domain\Repository\VerbandRepository;
use Internetgalerie\IgsCrm\Domain\Repository\ZeitschriftRepository;
use Psr\Http\Message\ResponseInterface;

class ZeitschriftController extends ActionController
{
    protected $objectClass = Zeitschrift::class;
    /**
     * zeitschriftRepository
     *
     * @var ZeitschriftRepository
     */
    protected $zeitschriftRepository = null;

    /**
     * verbandRepository
     *
     * @var VerbandRepository
     */
    protected $verbandRepository = null;


    /**
     * contactVerbandRepository
     *
     * @var ContactVerbandRepository
     */
    protected $contactVerbandRepository = null;

    public function injectVerbandRepository(VerbandRepository $verbandRepository): void
    {
        $this->verbandRepository = $verbandRepository;
    }

    public function injectContactVerbandRepository(ContactVerbandRepository $contactVerbandRepository): void
    {
        $this->contactVerbandRepository = $contactVerbandRepository;
    }

    public function injectZeitschriftRepository(ZeitschriftRepository $zeitschriftRepository): void
    {
        $this->zeitschriftRepository = $zeitschriftRepository;
    }
    
    /**
     * action new
     */
    #[IgnoreValidation([
        'argumentName' => 'zeitschrift',
    ])]
    public function newAction(Verband $verband, Zeitschrift $zeitschrift = null): ResponseInterface
    {
        $this->view->assign('zeitschrift', $zeitschrift);
        $this->view->assign('verband', $verband);
        $this->view->assign('verbaende', $this->verbandRepository->findAll());
        if ($this->request->hasArgument('activeTab')) {
            $activeTab = $this->request->getArgument('activeTab');
        }
        $this->view->assign('activeTab', $activeTab);
        return $this->htmlResponse($this->view->render());
    }
    
    /**
     * action edit
     */
    #[IgnoreValidation([
        'argumentName' => 'zeitschrift',
    ])]
    public function editAction(Zeitschrift $zeitschrift, Verband $verband): ResponseInterface
    {
        $this->view->assign('zeitschrift', $zeitschrift);
        $this->view->assign('verband', $verband);
        $this->view->assign('verbaende', $this->verbandRepository->findAll());
        if ($this->request->hasArgument('activeTab')) {
            $activeTab = $this->request->getArgument('activeTab');
        }
        $this->view->assign('activeTab', $activeTab);
        return $this->htmlResponse($this->view->render());
    }
    
    /**
     * action create
     */
    #[IgnoreValidation([
        'argumentName' => 'verband',
    ])]
    public function createAction(Zeitschrift $zeitschrift, Verband $verband): ResponseInterface
    {
        $this->zeitschriftRepository->add($zeitschrift);
        $this->addFlashMessage('Der Eintrag wurde erstellt.');
        $args = [
            'verband' => $verband,
        ];
        if ($this->request->hasArgument('activeTab')) {
            $args['activeTab'] = $this->request->getArgument('activeTab');
        }
        return $this->redirectWithSearch('show', 'Verband', null, $args);
    }

    /**
     * action update
     */
    #[IgnoreValidation([
        'argumentName' => 'verband',
    ])]
    public function updateAction(Zeitschrift $zeitschrift, Verband $verband): ResponseInterface
    {
        $this->zeitschriftRepository->update($zeitschrift);
        $this->addFlashMessage('Der Eintrag wurde aktualisiert.');
        $args = [
            'verband' => $verband,
        ];
        if ($this->request->hasArgument('activeTab')) {
            $args['activeTab'] = $this->request->getArgument('activeTab');
        }
        return $this->redirectWithSearch('show', 'Verband', null, $args);
    }

    /**
     * action confirmDelete
     */
    #[IgnoreValidation([
        'argumentName' => 'zeitschrift',
    ])]
    public function confirmDeleteAction(Zeitschrift $zeitschrift, Verband $verband): ResponseInterface
    {
        $this->view->assign('zeitschrift', $zeitschrift);
        $this->view->assign('verband', $verband);

        $contactVerbandCount = $this->contactVerbandRepository->count([
            'journal' => $zeitschrift,
        ]);
        $this->view->assign('contactVerbandCount', $contactVerbandCount);
        
        if ($this->request->hasArgument('activeTab')) {
            $activeTab = $this->request->getArgument('activeTab');
        }
        $this->view->assign('activeTab', $activeTab);
        return $this->htmlResponse($this->view->render());
    }

    /**
     * action delete
     */
    #[IgnoreValidation([
        'argumentName' => 'verband',
    ])]
    public function deleteAction(Zeitschrift $zeitschrift, Verband $verband): ResponseInterface
    {
        $this->zeitschriftRepository->remove($zeitschrift);
        $this->addFlashMessage('Der Eintrag wurde aktualisiert.');
        $args = [
            'verband' => $verband,
        ];
        if ($this->request->hasArgument('activeTab')) {
            $args['activeTab'] = $this->request->getArgument('activeTab');
        }
        return $this->redirectWithSearch('show', 'Verband', null, $args);
    }
}
