<?php

declare(strict_types=1);

namespace Internetgalerie\IgCrmAdmin\Mvc\View;

use Internetgalerie\IgCrmTemplate\Domain\Model\AddressInterface;
use Internetgalerie\IgCrmTemplate\Domain\Model\TemplateLetter;
use TYPO3\CMS\Fluid\View\TemplateView;

/**
 * A PDF view
 *
 * @todo v12: Drop 'implements ViewInterface' together with removal of extbase ViewInterface
 */
class PdfView extends TemplateView
{
    /**
     * @var string
     */
    protected $output = '';

    /**
     * @var string
     */
    protected $containerClass = '';

    /**
     * @var TemplateLetter 
     */
    protected $templateLetter;

    /**
     * @var AddressInterface;
     */
    protected $sender;

    /**
     * @var AddressInterface;
     */
    protected $receiver;

    /**
     * @var string
     */
    protected $date;
    
    public function setContainerClass(string $containerClass): void
    {
        $this->containerClass = $containerClass;
    }

    public function setTemplateLetter(TemplateLetter $templateLetter = null): void
    {
        $this->templateLetter = $templateLetter;
    }

    public function setSender(AddressInterface $sender): void
    {
        $this->sender = $sender;
    }

    public function setReceiver(AddressInterface $receiver): void
    {
        $this->receiver = $receiver;
    }
    
    public function setDate(string $date): void
    {
        $this->date = $date;
    }
    
    /**
     * Loads the template source and render the template.
     * If "layoutName" is set in a PostParseFacet callback, it will render the file with the given layout.
     *
     * @param string|null $actionName If set, this action's template will be rendered instead of the one defined in the context.
     * @return string Rendered Template
     * @api
     */
    public function renderAdd($actionName = null): void
    {
        $this->assign('template', $this->templateLetter);
        $this->assign('sender', $this->sender);
        $this->assign('receiver', $this->receiver);
        $this->assign('date', $this->date);
        // first page
        $classes = ['letter-container'];
        if ($this->containerClass) {
            $classes[] = $this->containerClass;
        }
        if ($this->output == '') {
            $classes[] = 'page-break-before';
        }
        $this->output .= '<div class="' . implode(' ', $classes) . '">';

        $this->output .= $this->render($actionName);
        $this->output .= '</div>';
    }
    public function renderLayout()
    {
        $partialFooter = $this->templateLetter->getPartialFooter();
        if ($partialFooter) {
            $this->setTemplate('Document.html');
            $footer = $this->render();
            //$footer = '<div class="footer" id="footer">A=' . $partialFooter . '</div>';
        } else {
            $footer = '';
        }
        
        return $footer . $this->output;
    }
}
