<?php

namespace Internetgalerie\IgCrmAdmin\Utility;

use GeorgRinger\NumberedPagination\NumberedPagination;
use TYPO3\CMS\Core\Pagination\PaginatorInterface;
use TYPO3\CMS\Core\Pagination\SimplePagination;
use TYPO3\CMS\Core\Pagination\SlidingWindowPagination;

class CompatibilityUtility
{
    public static function createPagination(PaginatorInterface $paginator, int $maximumNumberOfLinks = 0)
    {
        if (class_exists(SlidingWindowPagination::class)) {
            return new SlidingWindowPagination($paginator, $maximumNumberOfLinks);
        }
        if (class_exists(NumberedPagination::class)) {
            return new NumberedPagination($paginator, $maximumNumberOfLinks);
        }
        return new SimplePagination($paginator);
    }
}
