<?php

namespace Internetgalerie\IgCrmAdmin\Utility;

use Internetgalerie\IgsCrm\Domain\Model\Contact;
use TYPO3\CMS\Core\SingletonInterface;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Mvc\RequestInterface;
use TYPO3\CMS\Extbase\Mvc\Web\Routing\UriBuilder;

class ContactUtility implements SingletonInterface
{
    /**
     * get url of show page of contact (Person/Organisation)
     *
     * @param Conact $contact a contact Person/Organisation
     * @param array $settings settings
     * @param int $verbandId optional verband uid for Tab Link
     */

    public static function getShowUri(
        RequestInterface $request,
        Contact $contact,
        array $settings,
        int $verbandId = null
    ) {
        $uriBuilder = GeneralUtility::makeInstance(UriBuilder::class);
        
        $modelClassName = $contact->getType() ?: 'Person';
        $argumentName = strtolower((string) $modelClassName);
        $settingsName = $argumentName . 'Pid';
        $args = [
            $argumentName => $contact,
        ];

        if ($verbandId > 0) {
            $args['activeTab'] = 'verband-' . (int) $verbandId;
        }
        
        $uriBuilder
            ->reset()
            ->setRequest($request)
            ->setTargetPageUid($settings[$settingsName]);
        $uri = $uriBuilder->uriFor(
            'show',
            $args,
            $modelClassName,
            'IgCrmAdmin',
            $modelClassName == 'Organisation' ? 'Of' : 'Mi'
        );
        return $uri;
    }
    /**
     * get url of show page of contact (Person/Organisation)
     *
     * @param int $contactUid uid of a contact Person/Organisation
     * @param string $contactType type of the contact Person or Organisation
     * @param array $settings settings
     * @param int $verbandId optional verband uid for Tab Link
     */

    public static function getShowUriByUidType(
        RequestInterface $request,
        int $contactUid,
        string $contactType,
        array $settings,
        int $verbandId = null
    ) {
        $uriBuilder = GeneralUtility::makeInstance(UriBuilder::class);
        
        $modelClassName = $contactType == 'Organisation' ? 'Organisation' : 'Person';
        $argumentName = strtolower($modelClassName);
        $settingsName = $argumentName . 'Pid';
        $args = [
            $argumentName => $contactUid,
        ];

        if ($verbandId > 0) {
            $args['activeTab'] = 'verband-' . (int) $verbandId;
        }
        
        $uriBuilder
            ->reset()
            ->setRequest($request)
            ->setTargetPageUid($settings[$settingsName]);
        $uri = $uriBuilder->uriFor(
            'show',
            $args,
            $modelClassName,
            'IgCrmAdmin',
            $modelClassName == 'Organisation' ? 'Of' : 'Mi'
        );
        return $uri;
    }
}
