<?php

namespace Internetgalerie\IgCrmAdmin\Utility;

use DateTime;
use TYPO3\CMS\Core\SingletonInterface;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Configuration\ConfigurationManagerInterface;

class PeriodUtility implements SingletonInterface
{
    public static $configurationManager = null;
    public static $settings = null;

    /**
     * get current period for new entries from settings
     */
    public static function getCurrentPeriod()
    {
        if (static::$settings === null) {
            $all = static::getConfigurationManager()->getConfiguration(
                ConfigurationManagerInterface::CONFIGURATION_TYPE_FULL_TYPOSCRIPT
            );
            static::$settings = $all['plugin.']['tx_igcrmadmin.']['settings.'];
        }
        if (static::$settings['period.']['text'] ?? false) {
            $period = static::$settings['period.']['text'];
        } elseif (static::$settings['period.']['startDate'] ?? false) {
            $startDate = static::$settings['period.']['startDate'];
            if (strlen((string) $startDate) == 5) {
                $startDate = date('Y') . '-' . $startDate;
            } elseif (strlen((string) $startDate) == 2) {
                $startDate = date('Y-m') . '-' . $startDate;
            } else {
                $startDate = date('Y-m-d');
            }
            $startDateTime = DateTime::createFromFormat('Y-m-d', $startDate);
            $now = new DateTime();
            $period = date('Y');
            if ($now >= $startDateTime) {
                $period++;
            }
        } else {
            $period = date('Y');
        }
      
        return $period;
    }

    /**
     * Returns instance of the configuration manager
     *
     * @return ConfigurationManagerInterface
     */
    protected static function getConfigurationManager()
    {
        if (static::$configurationManager !== null) {
            return static::$configurationManager;
        }
        $configurationManager = GeneralUtility::makeInstance(ConfigurationManagerInterface::class);
        static::$configurationManager = $configurationManager;
        return $configurationManager;
    }
}
