jQuery('.tr-line .td-click').click(function() {
    let link = jQuery(this).parent('tr').attr('data-link');
    window.location.href = link;
});
jQuery('.crm-js-open').click(function() {
    window.open(jQuery(this).data('link'));
});

function getCookie(cname) {
    let name = cname + "=";
    let ca = document.cookie.split(';');
    for (let i = 0; i < ca.length; i++) {
        let c = ca[i];
        while (c.charAt(0) == ' ') {
            c = c.substring(1);
        }
        if (c.indexOf(name) == 0) {
            return c.substring(name.length, c.length);
        }
    }
    return "";
}

function setCookie(cname, cvalue, exdays = 0) {
    const d = new Date();
    let expires = "";
    if (exdays != 0) {
	d.setTime(d.getTime() + (exdays * 24 * 60 * 60 * 1000));
	expires = "expires=" + d.toUTCString() + ";";
    }
    document.cookie = cname + "=" + cvalue + ";" + expires + "path=/";
}


jQuery('#menu-igcrm-verband').on('change', function() {
    let global = {'verband': parseInt(jQuery(this).val())};
    setCookie('global', JSON.stringify(global));
    setCookie('globalChanged', true);
    location.reload();
    //jQuery(this).parents('form').trigger('submit');
});

// set all verband selectes on global verband change
let cookieGlobal = getCookie('global');
let global = null;
if (cookieGlobal) {
    global  = JSON.parse(cookieGlobal);
    jQuery('#menu-igcrm-verband option[value="' + global['verband'] + '"]').prop('selected', true);
}
if (getCookie('globalChanged')) {
    setCookie('globalChanged', '', -1); // delete
    if (global.hasOwnProperty('verband')) {
      jQuery('select.set-verband').val(global['verband']);
    }
}
document.addEventListener("DOMContentLoaded", function() {
    let accordionHandler = window.igJs.getLib('AccordionHandler');
    if (typeof  accordionHandler === 'object') {
	accordionHandler.afterOpen.add(function(el) {
	    $('.ui-multiselect', el.parentTarget).each( function() {this.style.width = '100%';});
	});
    }
});