function CrmPersonRoleRequest(postUrl, prefix) {
    this.postUrl = postUrl;
    this.prefix = prefix;
    this.lastCalltime = 0;

    this.update= function(url, formData) {
	formData.append(this.prefix + '[calltime]', (new Date()).getTime());
	this.post(url, formData, 'test');
    };
    this.post = function(url, formData, container) {
        let request = new XMLHttpRequest();
        let crmPersonRoleRequest = this;
        request.onreadystatechange = function() {
            if (request.readyState === 4) {
                if (request.status === 200) {
                    // success
                    let data = JSON.parse(request.responseText);
		    
                    if( data.calltime > crmPersonRoleRequest.lastCalltime) {
			data.updateRoleForPersonUids.forEach(
			    personUid => {
				jQuery('form.person-role tr[data-id="' + personUid + '"] td.tag-role').html(data.tagRoleName);
			    });
			//console.log(data, container);
                    }
                } else {
                    console.log(request.responseText);
                }
            }
        };
	
        request.open('POST', url, true);
        request.send(formData);
    };
};

jQuery('.personrole-person').on('change', function(event) {
    event.preventDefault();
    console.log('sedt');
    jQuery('#set-select-for-checked').addClass('has-changes');
});
jQuery('#set-select-for-checked').click(function(event) {
    event.preventDefault();
    let formData = new FormData();
/*
    let form = document.getElementById('form-person-role');
    for(let i=0; i < form.elements.length; i++){
	let e = form.elements[i];
	console.log(e.name+"="+e.value);
    }
*/
    // input[type="checkbox"]:checked, input[type="hidden"], input[type="text"]
    jQuery('form.person-role').find('input, select').each(function() {
	if ($(this).attr('type') == 'checkbox') {
	    formData.append($(this).attr('name'),$(this).is(':checked'));
	} else {
	    formData.append($(this).attr('name'),$(this).val());
	}
    });
    jQuery('form.person-searchform').find('input[type="checkbox"]:checked, input[type="hidden"], select').each(function() {
	let name = $(this).attr('name');
	if (name && (name.startsWith('tx_igscrm_mi[@search]') || name.startsWith('tx_igscrm_mi[search]'))) {
	    console.log(name);
	    formData.append(name, $(this).val());
	}
    });

    let postUrl = jQuery(this).data('url');
    let prefix = jQuery(this).data('prefix');
    let crmPersonRoleRequest = new CrmPersonRoleRequest(postUrl, prefix);
    jQuery('#set-select-for-checked').removeClass('has-changes');
    crmPersonRoleRequest.update(postUrl, formData);
    //console.log(postUrl, tagRoleName, tagRoleValue);
});

let showCount = function() {
     let count = jQuery('form.person-role input.personrole-person:checked').length;
    if (count ==0) {
	jQuery('.show-for-check').hide();
    } else {
	jQuery('.show-for-check').show();
	jQuery('#set-select-for-checked').addClass('has-changes');
    }
    jQuery('#set-select-for-checked .count').html(' (' + count + ')');
    
};

jQuery('form.person-role input.personrole-person').on('change', function() {
    showCount();
});

showCount();
jQuery('form.person-role .select-all-none').on('click', function(event) {
    let state;
    event.preventDefault();
    if (jQuery(this).data('state') == 'all') {
	jQuery('form.person-role input[type="checkbox"]').prop('checked', true);
	state ='none';
    } else {
	jQuery('form.person-role input[type="checkbox"]').prop('checked', false);
	state ='all';
    }
    jQuery(this).data('state', state)
    jQuery(this).html(jQuery(this).data(state));
    showCount();
});
