<?php

declare(strict_types=1);

namespace Internetgalerie\IgCrmTemplate\Domain\Repository;

use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Persistence\Generic\Typo3QuerySettings;
use TYPO3\CMS\Extbase\Persistence\QueryInterface;
use TYPO3\CMS\Extbase\Persistence\Repository;

/**
 * The repository for TemplatePageLayouts
 */
class TemplatePageLayoutRepository extends Repository
{
    protected $defaultOrderings = [
        'tenantId' => QueryInterface::ORDER_ASCENDING,
        'templateType' => QueryInterface::ORDER_ASCENDING,
    ];

    public function initializeObject(): void
    {
        $querySettings = GeneralUtility::makeInstance(Typo3QuerySettings::class);
        $querySettings->setRespectStoragePage(false);
        $this->setDefaultQuerySettings($querySettings);
    }

    public function findOneByTenantUidAndTemplateTypeName(
        ?int $tenantUid,
        string $templateType,
        string $pageFormat = null,
        string $pageOrientation = null
    ) {
        $query = $this->createQuery();
        $constraints = [
            $query->logicalOr(
                $query->equals('tenantId', null),
                $query->equals('tenantId', 0),
                $query->equals('tenantId', (int)$tenantUid),
            ),
            $query->logicalOr(
                $query->equals('templateType', null),
                $query->equals('templateType.name', $templateType),
            ),
        ];
        if ($pageFormat) {
            $constraints[] = $query->equals('pageFormat', $pageFormat);
        }
        if ($pageOrientation) {
            $constraints[] = $query->equals('pageOrientation', $pageOrientation);
        }
        $query->matching($query->logicalAnd(...$constraints));
        // move entries with null to the end
        $query->setOrderings(
            [
                'templateType' => QueryInterface::ORDER_DESCENDING,
                'tenantId' => QueryInterface::ORDER_DESCENDING,
            ]
        );
        return $query->execute()
                     ->getFirst();
    }
}
