<?php

namespace Internetgalerie\IgCrmTemplate\Utility;

use TYPO3\CMS\Core\Database\Connection;

use TYPO3\CMS\Core\Database\ConnectionPool;
use TYPO3\CMS\Core\Utility\GeneralUtility;

class CrmTranslate
{
    public static $db = null;
    public static $tenantId = null;
    public static $crmLanguage = null;

    public static function setVerband($tenantId): void
    {
        self::$tenantId = $tenantId;
    }
    public static function setTenantId($tenantId): void
    {
        self::$tenantId = $tenantId;
    }
    
    public static function setCrmLanguage($crmLanguage): void
    {
        self::$crmLanguage = $crmLanguage;
    }
    
    public static function translate($textKey, $crmLanguage = null)
    {
        $crmLanguage ??= self::$crmLanguage;
        if ($crmLanguage === null) {
            die('CrmTranslate: crmLanguage not set');
        }
        if (self::$db === null) {
            if (self::$tenantId === null) {
                die('CrmTranslate: tenant/mandant/verband not set');
            }
            $tenantId = self::$tenantId;
            $queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable(
                'tx_igcrmtemplate_domain_model_translate'
            );
            $result = $queryBuilder
                    ->select('tx_igcrmtemplate_domain_model_translate.*', 'lg_code')
                    ->from('tx_igcrmtemplate_domain_model_translate')
                    ->join(
                        'tx_igcrmtemplate_domain_model_translate',
                        'tx_igscrm_domain_model_language',
                        'lg',
                        $queryBuilder->expr()
                                     ->eq('crm_language', $queryBuilder->quoteIdentifier('lg.uid'))
                    )
                    ->where(
                        $queryBuilder->expr()
                                     ->eq(
                                         'tenant_id',
                                         $queryBuilder->createNamedParameter($tenantId, Connection::PARAM_INT)
                                     )
                    )
                    ->executeQuery();
            while ($row = $result->fetchAssociative()) {
                if (!is_array(self::$db[$row['lg_code']])) {
                    self::$db[$row['lg_code']] = [];
                }
                if (!is_array(self::$db[$row['crm_language']])) {
                    self::$db[$row['crm_language']] = [];
                }
                // nach lang key
                self::$db[$row['lg_code']][$row['text_key']] = $row['text_value'];
                // nach uid
                self::$db[$row['crm_language']][$row['text_key']] = $row['text_value'];
            }
            //var_dump($tenantId, $textKey, self::$db);exit(0);
        }
        return self::$db[$crmLanguage][trim((string) $textKey)] ?? $textKey;
    }
}
