<?php

namespace Internetgalerie\IgCrmTemplate\ViewHelpers;

use Closure;
use Internetgalerie\IgCrmTemplate\Domain\Model\AddressInterface;
use Internetgalerie\IgCrmTemplate\Domain\Model\TemplateObjectInterface;
use Internetgalerie\IgCrmTemplate\Domain\Model\TenantInterface;
use Internetgalerie\IgCrmTemplate\Utility\TemplateUtility;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Configuration\ConfigurationManagerInterface;
use TYPO3\CMS\Fluid\View\StandaloneView;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;

class TemplateViewHelper extends AbstractViewHelper
{
    protected $escapeOutput = false;
    
    protected static ?ConfigurationManagerInterface $configurationManager = null;
    protected static ?array $setup = null;
    
    /**
     * Initialize the arguments.
     * @api
     */
    public function initializeArguments(): void
    {
        parent::initializeArguments();
        $this->registerArgument(
            'tenant',
            TenantInterface::class,
            'tenant for config, logo, fibu and sender if not set',
            false,
            null
        );
        $this->registerArgument('sender', AddressInterface::class, 'sender address', false, null);
        $this->registerArgument('receiver', AddressInterface::class, 'receiver if used in tempalte', false, null);
        $this->registerArgument('type', 'string', 'template to use', false, null);
        $this->registerArgument('templateObject', TemplateObjectInterface::class, 'template object', false, null);
        $this->registerArgument('title', 'string', 'title for page', false);
    }
    
    public function render(): string
    {
        $tenant = null;
        $receiver = null;
        $tenant = null;
        $templateUtility = GeneralUtility::makeInstance(TemplateUtility::class);
        if ($this->arguments['tenant'] ?? false) {
            $tenant = $this->arguments['tenant'];
            $templateUtility->setTenant($tenant);
            $sender = $tenant;
        }
        if ($this->arguments['sender'] ?? false) {
            $sender = $this->arguments['sender'];
        }
        if ($this->arguments['receiver'] ?? false) {
            $receiver = $this->arguments['receiver'];
            //$templateUtility->setReceiver($receiver);
        }

        $templateObject = $this->arguments['templateObject'] ?? null;
        
        if ($this->arguments['type'] ?? false) {
            $template = $templateUtility->getTemplate($this->arguments['type'], $templateObject, $receiver);
            if ($template === null) {
                echo '<h3>No Template Found in TemplateViewHelper</h3>';
                echo 'Tenant: ' . $tenant . '<br />';
                echo 'Type: ' . $this->arguments['type'] . '<br />';
                echo 'Receiver: ' . ($receiver ? $receiver->getUid() : '') . '<br />';
                die('TemplateObject: ' . $templateObject);
            }
            //$template = empty($templates) ? null : $templates[0];
            $view = GeneralUtility::makeInstance(StandaloneView::class);
            // TYPO3 12
            if (method_exists($view, 'setRequest')) {
                $request = $this->renderingContext->getRequest();
                $view->setRequest($request);
            }
            $extbaseFrameworkConfiguration = static::getSetup();
            
            $view->setLayoutRootPaths($extbaseFrameworkConfiguration['view.']['layoutRootPaths.']);
            $view->setPartialRootPaths($extbaseFrameworkConfiguration['view.']['partialRootPaths.']);
            $view->setTemplateRootPaths($extbaseFrameworkConfiguration['view.']['templateRootPaths.']);

            /*          if ($this->arguments['layout'] == 'Logo') {
                        $templateFile = 'EXT:ig_crm_template/Resources/Private/Templates/TemplateLetter/Logo.html';
                        } else {
                        $templateFile = 'EXT:ig_crm_template/Resources/Private/Templates/TemplateLetter/Default.html';
                        }
                        $view->setTemplatePathAndFilename($templateFile);
            */
            
            $templateFilename = $template->getTemplateType()
                                         ->getTemplateFilename();
            if ($templateFilename === null || trim((string) $templateFilename) == '') {
                die('templateFilename missing in template ' . $template->getName() . '(' . $template->getUid() . ')');
            }
            //$parseHtml = GeneralUtility::getFileAbsFileName($templateFilename);
            //return $this->renderingContext->getTemplateParser()->parse($parseHtml)->render($this->renderingContext);
 
            $view->setTemplate($templateFilename);
            //$templateVariableContainer=$this->renderingContext->getVariableProvider();

            $view->assign('template', $template);
            $view->assign('receiver', $receiver);
            $view->assign('tenant', $tenant);
            $view->assign('sender', $sender);
            $view->assign('verband', $tenant); // compatibility
            $view->assign('content', [
                'title' => [
                    'value' => $this->arguments['title'] ?? $template->getTitle(),
                    'parse' => true,
                    'formatHtml' => true,
                ],
                'text' => [
                    'value' => $this->renderChildren(),
                    'formatHtml' => false,
                    'parse' => true,
                ],
            ]);
            $html = $view->render();
        }
        return $html;
    }

    protected static function getConfigurationManager()
    {
        if (static::$configurationManager !== null) {
            return static::$configurationManager;
        }
        static::$configurationManager = GeneralUtility::makeInstance(ConfigurationManagerInterface::class);
        return static::$configurationManager;
    }

    protected static function getSetup(): array
    {
        if (static::$setup === null) {
            $all = static::getConfigurationManager()->getConfiguration(
                ConfigurationManagerInterface::CONFIGURATION_TYPE_FULL_TYPOSCRIPT
            );
            static::$setup = $all['plugin.']['tx_igcrmtemplate.'] ?? [];
        }
        return static::$setup;
    }
}
