<?php

use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Core\Information\Typo3Version;
use TYPO3\CMS\Core\Resource\File;

$versionInformation = GeneralUtility::makeInstance(Typo3Version::class);
if ($versionInformation->getMajorVersion() > 11) {
    $logosConfig = [
        'type' => 'file',
        'foreign_match_fields' => [
            'tablenames' => 'tx_igcrmtemplate_domain_model_templateletter',
        ],
        'maxitems' => 9999,
        'allowed' => 'common-image-types',
    ];
} else {
    $logosConfig = [
        ### !!! Watch out for fieldName different from columnName
        'type' => 'file',
        'allowed' => $GLOBALS['TYPO3_CONF_VARS']['GFX']['imagefile_ext'],
        'appearance' => [
            'createNewRelationLinkTitle' => 'LLL:EXT:frontend/Resources/Private/Language/locallang_ttc.xlf:images.addFileReference'
        ],
        'foreign_match_fields' => [
            'tablenames' => 'tx_igcrmtemplate_domain_model_templateletter',
        ],
        'foreign_types' => [
            '0' => [
                'showitem' => '
                            --palette--;LLL:EXT:lang/locallang_tca.xlf:sys_file_reference.imageoverlayPalette;imageoverlayPalette,
                            --palette--;;filePalette'
            ],
            File::FILETYPE_TEXT => [
                'showitem' => '
                            --palette--;LLL:EXT:lang/locallang_tca.xlf:sys_file_reference.imageoverlayPalette;imageoverlayPalette,
                            --palette--;;filePalette'
            ],
            File::FILETYPE_IMAGE => [
                'showitem' => '
                            --palette--;LLL:EXT:lang/locallang_tca.xlf:sys_file_reference.imageoverlayPalette;imageoverlayPalette,
                            --palette--;;filePalette'
            ],
            File::FILETYPE_AUDIO => [
                'showitem' => '
                            --palette--;LLL:EXT:lang/locallang_tca.xlf:sys_file_reference.imageoverlayPalette;imageoverlayPalette,
                            --palette--;;filePalette'
            ],
            File::FILETYPE_VIDEO => [
                'showitem' => '
                            --palette--;LLL:EXT:lang/locallang_tca.xlf:sys_file_reference.imageoverlayPalette;imageoverlayPalette,
                            --palette--;;filePalette'
            ],
            File::FILETYPE_APPLICATION => [
                'showitem' => '
                            --palette--;LLL:EXT:lang/locallang_tca.xlf:sys_file_reference.imageoverlayPalette;imageoverlayPalette,
                            --palette--;;filePalette'
            ]
        ],
        'maxitems' => 9999,
    ];
}

return [
    'ctrl' => [
        'title' => 'LLL:EXT:ig_crm_template/Resources/Private/Language/locallang_db.xlf:tx_igcrmtemplate_domain_model_templateletter',
        'label' => 'name',
        'tstamp' => 'tstamp',
        'crdate' => 'crdate',
        'delete' => 'deleted',
        'enablecolumns' => [
            'disabled' => 'hidden',
            'starttime' => 'starttime',
            'endtime' => 'endtime',
        ],
        'searchFields' => 'name,title, template, partial_before, partial_footer, partial_after, partial_header, page_template',
        'iconfile' => 'EXT:ig_crm_template/Resources/Public/Icons/tx_igcrmtemplate_domain_model_templateletter.gif'
    ],
    'types' => [
        '1' => ['showitem' => 'sys_language_uid, l10n_parent, l10n_diffsource, hidden, active, favorite, name, filename,
--div--;Auswahl,
 tenant_id, template_type, template_object_type, main_tags, sub_tags, object_type, crm_language,
--div--;Page,
page_css_file, page_class, partial_header, page_template, partial_footer, logos, show_number_in_header, show_debitor_number, show_letter_date, show_sender, show_pp, show_mwst,
--div--;Inhalte,
title, title_layout, template_object_items_per_page,  text_before, partial_before, template, partial_after, text_after'],
    ],
    'columns' => [
        'hidden' => [
            'exclude' => true,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.hidden',
            'config' => [
                'type' => 'check',
                'items' => [
                    '1' => [
                        'label' => 'LLL:EXT:lang/Resources/Private/Language/locallang_core.xlf:labels.enabled'
                    ]
                ],
            ],
        ],
        'starttime' => [
            'exclude' => true,
            'behaviour' => [
                'allowLanguageSynchronization' => true
            ],
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.starttime',
            'config' => [
                'type' => 'datetime',
                'size' => 13,
                'default' => 0,
            ],
        ],
        'endtime' => [
            'exclude' => true,
            'behaviour' => [
                'allowLanguageSynchronization' => true
            ],
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.endtime',
            'config' => [
                'type' => 'datetime',
                'size' => 13,
                'default' => 0,
                'range' => [
                    'upper' => mktime(0, 0, 0, 1, 1, 2038)
                ],
            ],
        ],
        'active' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_crm_template/Resources/Private/Language/locallang_db.xlf:tx_igcrmtemplate_domain_model_templateletter.active',
            'config' => [
                'type' => 'check',
                'items' => [
                    [
                        'label' => 'LLL:EXT:lang/Resources/Private/Language/locallang_core.xlf:labels.enabled'
                    ]
                ],
                'default' => 1,
            ],
        ],
        'favorite' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_crm_template/Resources/Private/Language/locallang_db.xlf:tx_igcrmtemplate_domain_model_templateletter.favorite',
            'config' => [
                'type' => 'check',
                'items' => [
                    [
                        'label' => 'LLL:EXT:lang/Resources/Private/Language/locallang_core.xlf:labels.enabled'
                    ]
                ],
                'default' => 1,
            ],
        ],
        'crm_language' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:ig_crm_template/Resources/Private/Language/locallang_db.xlf:tx_igcrmtemplate_domain_model_templateletter.crm_language',
            'config' => [
               'type' => 'number',
                'size' => 30,
                'eval' => 'trim',
                'nullable' => true
            ],
        ],
         'name' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_crm_template/Resources/Private/Language/locallang_db.xlf:tx_igcrmtemplate_domain_model_templateletter.name',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
         'template_object_type' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_crm_template/Resources/Private/Language/locallang_db.xlf:tx_igcrmtemplate_domain_model_templateletter.template_object_type',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectSingle',
                'items' => [
                    [  'label' => 'LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_invoice.type.invoice', 'value' => 'Invoice' ],
                    [  'label' => 'LLL:EXT:ig_fibu/Resources/Private/Language/locallang_db.xlf:tx_igfibu_domain_model_invoice.type.invoiceAnnual', 'value' => 'InvoiceAnnual'],
                ],
                'default' => 'Invoice'
            ],
        ],
        'template_object_items_per_page' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_crm_template/Resources/Private/Language/locallang_db.xlf:tx_igcrmtemplate_domain_model_templateletter.template_object_items_per_page',
            'config' => [
                'type' => 'number',
                'size' => 30,
                'nullable' => true
            ],
        ],
        'template_type' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_crm_template/Resources/Private/Language/locallang_db.xlf:tx_igcrmtemplate_domain_model_templateletter.template_type',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectSingle',
                'foreign_table' => 'tx_igcrmtemplate_domain_model_templatetype',
                'default' => 0,
                'minitems' => 0,
                'maxitems' => 1,
            ],
        ],
        'invoice_type' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_crm_template/Resources/Private/Language/locallang_db.xlf:tx_igcrmtemplate_domain_model_templateletter.invoice_type',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
         'object_type' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_crm_template/Resources/Private/Language/locallang_db.xlf:tx_igcrmtemplate_domain_model_templateletter.object_type',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectSingle',
                'items' => [
                    ['label' => 'Alle', 'value' => null],
                    ['label' => 'Person', 'value' => 'Person'],
                    ['label' => 'Organisation', 'value' => 'Organisation'],
                ],
                'nullable' => true,
            ],
        ],
        'main_tags' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_crm_template/Resources/Private/Language/locallang_db.xlf:tx_igcrmtemplate_domain_model_templateletter.main_tags',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
        'sub_tags' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:ig_crm_template/Resources/Private/Language/locallang_db.xlf:tx_igcrmtemplate_domain_model_templateletter.sub_tags',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
         'title' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_crm_template/Resources/Private/Language/locallang_db.xlf:tx_igcrmtemplate_domain_model_templateletter.title',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
         'title_layout' => [
            'exclude' => true,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.type',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectSingle',
                'items' => [
                    [
                        'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.default_value',
                        'value' => 0,
                    ],
                    [
                        'label' => 'LLL:EXT:frontend/Resources/Private/Language/locallang_ttc.xlf:header_layout.I.1',
                        'value' => 1,
                    ],
                    [
                        'label' => 'LLL:EXT:frontend/Resources/Private/Language/locallang_ttc.xlf:header_layout.I.2',
                        'value' => 2,
                    ],
                    [
                        'label' => 'LLL:EXT:frontend/Resources/Private/Language/locallang_ttc.xlf:header_layout.I.3',
                        'value' => 3,
                    ],
                    [
                        'label' => 'LLL:EXT:frontend/Resources/Private/Language/locallang_ttc.xlf:header_layout.I.4',
                        'value' => 4,
                    ],
                    [
                        'label' => 'LLL:EXT:frontend/Resources/Private/Language/locallang_ttc.xlf:header_layout.I.5',
                        'value' => 5,
                    ],
                    [
                        'label' => 'LLL:EXT:frontend/Resources/Private/Language/locallang_ttc.xlf:header_layout.I.6',
                        'value' => 100,
                    ],
                ],
                'default' => 0,
            ],
         ],
        'tenant_id' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_crm_template/Resources/Private/Language/locallang_db.xlf:tx_igcrmtemplate_domain_model_templateletter.tenant_id',
            'config' => [
               'type' => 'number',
                'size' => 30,
                'eval' => 'trim',
                'nullable' => true
            ],
        ],

        'text_before' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_crm_template/Resources/Private/Language/locallang_db.xlf:tx_igcrmtemplate_domain_model_templateletter.text_before',
            'config' => [
                'type' => 'text',
                'enableRichtext' => true,
                'richtextConfiguration' => 'default',
                'fieldControl' => [
                    'fullScreenRichtext' => [
                        'disabled' => false,
                    ],
                ],
                'cols' => 40,
                'rows' => 15,
                'eval' => 'trim'
            ],
        ],
        'partial_header' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_crm_template/Resources/Private/Language/locallang_db.xlf:tx_igcrmtemplate_domain_model_templateletter.partial_header',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
        'partial_footer' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_crm_template/Resources/Private/Language/locallang_db.xlf:tx_igcrmtemplate_domain_model_templateletter.partial_footer',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
        'show_number_in_header' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:ig_crm_template/Resources/Private/Language/locallang_db.xlf:tx_igcrmtemplate_domain_model_templateletter.show_number_in_header',
            'config' => [
                'type' => 'check',
                'default' => 0
            ]
        ],
        'show_debitor_number' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:ig_crm_template/Resources/Private/Language/locallang_db.xlf:tx_igcrmtemplate_domain_model_templateletter.show_debitor_number',
            'config' => [
                'type' => 'check',
                'default' => 0
            ]
        ],
        'show_letter_date' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:ig_crm_template/Resources/Private/Language/locallang_db.xlf:tx_igcrmtemplate_domain_model_templateletter.show_letter_date',
            'config' => [
                'type' => 'check',
                'default' => 1
            ]
        ],
        'show_sender' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:ig_crm_template/Resources/Private/Language/locallang_db.xlf:tx_igcrmtemplate_domain_model_templateletter.show_sender',
            'config' => [
                'type' => 'check',
                'default' => 0
            ]
        ],
        'show_pp' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:ig_crm_template/Resources/Private/Language/locallang_db.xlf:tx_igcrmtemplate_domain_model_templateletter.show_pp',
            'config' => [
                'type' => 'check',
                'default' => 0
            ]
        ],
        'show_mwst' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:ig_crm_template/Resources/Private/Language/locallang_db.xlf:tx_igcrmtemplate_domain_model_templateletter.show_mwst',
            'config' => [
                'type' => 'check',
                'default' => 0
            ]
        ],
        'partial_before' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_crm_template/Resources/Private/Language/locallang_db.xlf:tx_igcrmtemplate_domain_model_templateletter.partial_before',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
        'template' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_crm_template/Resources/Private/Language/locallang_db.xlf:tx_igcrmtemplate_domain_model_templateletter.template',
            'config' => [
                'type' => 'text',
                'cols' => 40,
                'rows' => 15,
                'eval' => 'trim'
            ],
        ],
        'page_template' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_crm_template/Resources/Private/Language/locallang_db.xlf:tx_igcrmtemplate_domain_model_templateletter.page_template',
            'config' => [
                'type' => 'text',
                'cols' => 40,
                'rows' => 15,
                'eval' => 'trim'
            ],
        ],

        'partial_after' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_crm_template/Resources/Private/Language/locallang_db.xlf:tx_igcrmtemplate_domain_model_templateletter.partial_after',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],

        'text_after' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_crm_template/Resources/Private/Language/locallang_db.xlf:tx_igcrmtemplate_domain_model_templateletter.text_after',
            'config' => [
                'type' => 'text',
                'enableRichtext' => true,
                'richtextConfiguration' => 'default',
                'fieldControl' => [
                    'fullScreenRichtext' => [
                        'disabled' => false,
                    ],
                ],
                'cols' => 40,
                'rows' => 15,
                'eval' => 'trim'
            ],
        ],

        'logos' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_crm_template/Resources/Private/Language/locallang_db.xlf:tx_igcrmtemplate_domain_model_templateletter.logos',
            'config' => $logosConfig,
        ],
        'page_css_file' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_crm_template/Resources/Private/Language/locallang_db.xlf:tx_igcrmtemplate_domain_model_templateletter.page_css_file',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
        'page_class' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_crm_template/Resources/Private/Language/locallang_db.xlf:tx_igcrmtemplate.page_class',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
        'filename' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_crm_template/Resources/Private/Language/locallang_db.xlf:tx_igcrmtemplate.filename',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],


    ],
];
