<?php
return [
    'ctrl' => [
        'title' => 'LLL:EXT:ig_crm_template/Resources/Private/Language/locallang_db.xlf:tx_igcrmtemplate_domain_model_translate',
        'label' => 'text_key',
        'tstamp' => 'tstamp',
        'crdate' => 'crdate',
        'versioningWS' => false,
        //'languageField' => 'sys_language_uid',
        //'transOrigPointerField' => 'l10n_parent',
        //'transOrigDiffSourceField' => 'l10n_diffsource',
        'delete' => 'deleted',
        'enablecolumns' => [
            'disabled' => 'hidden',
            'starttime' => 'starttime',
            'endtime' => 'endtime',
        ],
        'searchFields' => 'text_key, text_value',
        'iconfile' => 'EXT:ig_crm_template/Resources/Public/Icons/tx_igcrmtemplate_domain_model_translate.gif'
    ],
    'types' => [
        '1' => ['showitem' => 'tenant_id, crm_language, text_key, text_value'],
    ],
    'columns' => [
        'hidden' => [
            'exclude' => true,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.hidden',
            'config' => [
                'type' => 'check',
                'items' => [
                    '1' => [
                        'label' => 'LLL:EXT:lang/Resources/Private/Language/locallang_core.xlf:labels.enabled'
                    ]
                ],
            ],
        ],
        'starttime' => [
            'exclude' => true,
            'behaviour' => [
                'allowLanguageSynchronization' => true
            ],
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.starttime',
            'config' => [
                'type' => 'datetime',
                'size' => 13,
                'default' => 0,
            ],
        ],
        'endtime' => [
            'exclude' => true,
            'behaviour' => [
                'allowLanguageSynchronization' => true
            ],
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.endtime',
            'config' => [
                'type' => 'datetime',
                'size' => 13,
                'default' => 0,
                'range' => [
                    'upper' => mktime(0, 0, 0, 1, 1, 2038)
                ],
            ],
        ],
        'crm_language' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:ig_crm_template/Resources/Private/Language/locallang_db.xlf:tx_igcrmtemplate_domain_model_translate.crm_language',
            'config' => [
               'type' => 'number',
                'size' => 30,
                'eval' => 'trim',
                'nullable' => true
            ],
        ],
         'text_key' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_crm_template/Resources/Private/Language/locallang_db.xlf:tx_igcrmtemplate_domain_model_translate.text_key',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
         'text_value' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_crm_template/Resources/Private/Language/locallang_db.xlf:tx_igcrmtemplate_domain_model_translate.text_value',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
        'tenant_id' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_crm_template/Resources/Private/Language/locallang_db.xlf:tx_igcrmtemplate_domain_model_translate.tenant_id',
            'config' => [
               'type' => 'number',
                'size' => 30,
                'eval' => 'trim',
                'nullable' => true
            ],
        ],

        
    ],
];
