<?php

namespace Internetgalerie\IgCrmTemplate\Domain\Model;

use TYPO3\CMS\Extbase\DomainObject\AbstractEntity;

/**
 * base address
 */
class Address extends AbstractEntity implements AddressInterface
{
    protected ?string $postalAddress = null;
    
    public function setUid(int $uid): void
    {
        $this->uid = $uid;
    }
    
    public function set(AddressInterface $address = null): void
    {
        if ($address) {
            $this->setLanguageCode($address->getLanguageCode());
            $this->setIsOrganisation($address->getIsOrganisation());
            $this->setOrganisationName($address->getOrganisationName());
            if (method_exists($address, 'getAnredeSprache')) {
                $this->setAnredeSprache($address->getAnredeSprache());
            }
            if (method_exists($address, 'getLetterAddressSalutation')) {
                $this->setLetterAddressSalutation($address->getLetterAddressSalutation());
            }
            
            $this->setName($address->getName());
            $this->setNumber($address->getNumber());
            $this->setAddress($address->getAddress());
            $this->setAddon($address->getAddon());
            $this->setPoboxText($address->getPoboxText());
            $this->setAddress2($address->getAddress2());
            $this->setAddress3($address->getAddress3());
            $this->setZip($address->getZip());
            $this->setCity($address->getCity());
            $this->setCountryIsoCode($address->getCountryIsoCode());
            $this->setInvoiceEmail($address->getInvoiceEmail());
            $this->setType($address->getType());
            $this->contactPerson = null;
        }
    }
    public function setArray(array $data): void
    {
        $this->setLanguageCode($data['languageCode'] ?? '');
        $this->setIsOrganisation($data['isOrganisation'] ?? null);
        $this->setOrganisationName($data['organisationName'] ?? '');
        $this->setName($data['name'] ?? '');
        $this->setNumber($data['number'] ?? '');
        $this->setAddress($data['address'] ?? '');
        $this->setAddon($data['addon'] ?? '');
        $this->setPoboxText($data['poboxText'] ?? '');
        $this->setAddress2($data['address2'] ?? '');
        $this->setAddress3($data['address3'] ?? '');
        $this->setZip($data['zip'] ?? '');
        $this->setCity($data['city'] ?? '');
        $this->setCountryIsoCode($data['countryIsoCode'] ?? '');
        $this->setInvoiceEmail($data['invoiceEmail'] ?? '');
        $this->setType($data['type'] ?? null);

        $this->setPhone($data['phone'] ?? '');
        $this->setEmail($data['email'] ?? '');
        $this->setUrl($data['url'] ?? '');


        $this->contactPerson = null;
    }
    public function setContactPerson($contactPerson): void
    {
        $this->contactPerson = $contactPerson;
    }

    public function getContactPerson()
    {
        return $this->contactPerson;
    }


    public function setType($type): void
    {
        $this->type = $type;
    }

    public function getType()
    {
        return $this->type;
    }

    public function setLanguageCode($languageCode): void
    {
        $this->languageCode = $languageCode;
    }

    public function getLanguageCode()
    {
        return $this->languageCode;
    }

    public function setIsOrganisation($isOrganisation): void
    {
        $this->isOrganisation = $isOrganisation;
    }

    public function getIsOrganisation()
    {
        return $this->isOrganisation;
    }

    public function setOrganisationName($organisationName): void
    {
        $this->organisationName = $organisationName;
    }

    public function getOrganisationName()
    {
        return $this->organisationName;
    }

    //fehlt org + ver
    public function setAnredeSprache($anredeSprache): void
    {
        $this->anredeSprache = $anredeSprache;
    }

    public function getAnredeSprache()
    {
        return $this->anredeSprache;
    }
    public function setLetterAddressSalutation($letterAddressSalutation)
    {
        return $this->letterAddressSalutation = $letterAddressSalutation;
    }
    public function getLetterAddressSalutation()
    {
        return $this->letterAddressSalutation;
    }

    public function setName($name): void
    {
        $this->name = $name;
    }

    public function getName()
    {
        return $this->name;
    }

    public function setNumber($number): void
    {
        $this->number = $number;
    }

    public function getNumber()
    {
        return $this->number;
    }


    public function setAddress($address): void
    {
        $this->address = $address;
    }

    public function getAddress()
    {
        return $this->address;
    }

    public function setAddon($addon): void
    {
        $this->addon = $addon;
    }

    public function getAddon()
    {
        return $this->addon;
    }

    public function setPoboxText($poboxText): void
    {
        $this->poboxText = $poboxText;
    }

    public function getPoboxText()
    {
        return $this->poboxText;
    }

    //fehlt org + ver
    public function setAddress2($address2): void
    {
        $this->address2 = $address2;
    }

    public function getAddress2()
    {
        return $this->address2;
    }

    // fehlt org + ver
    public function setAddress3($address3): void
    {
        $this->address3 = $address3;
    }

    public function getAddress3()
    {
        return $this->address3;
    }

    public function setZip($zip): void
    {
        $this->zip = $zip;
    }

    public function getZip()
    {
        return $this->zip;
    }

    public function setCity($city): void
    {
        $this->city = $city;
    }

    public function getCity()
    {
        return $this->city;
    }

    public function setCountryIsoCode($countryIsoCode): void
    {
        $this->countryIsoCode = $countryIsoCode;
    }

    public function getCountryIsoCode()
    {
        return $this->countryIsoCode;
    }
    public function getCountryPostalCode()
    {
        return $this->countryIsoCode == 'LI' ? 'FL' : $this->countryIsoCode;
    }
    public function setInvoiceEmail($invoiceEmail): void
    {
        $this->invoiceEmail = $invoiceEmail;
    }
    public function getInvoiceEmail()
    {
        return $this->invoiceEmail;
    }


    public function setPhone($phone): void
    {
        $this->phone = $phone;
    }

    public function getPhone()
    {
        return $this->phone;
    }

    public function setEmail($email): void
    {
        $this->email = $email;
    }

    public function getEmail()
    {
        return $this->email;
    }

    public function setUrl($url): void
    {
        $this->url = $url;
    }

    public function getUrl()
    {
        return $this->url;
    }
    public function getPostalAddress()
    {
        if ($this->getIsOrganisation()) {
            $address[] = $this->getOrganisationName();
            $contactPerson = $this->getContactPerson();
            if ($contactPerson) {
                $address[] = $contactPerson->getAnrede() . ' ' . $contactPerson->getName();
            }
        } else {
            if ($this->getLetterAddressSalutation()) {
                $address[] = $this->getLetterAddressSalutation();
            }
            $address[] = $this->getName();
        }
        if ($this->getAddon()) {
            $address[] = $this->getAddon();
        }
        if ($this->getPoboxText()) {
            $address[] = $this->getPoboxText();
        }
        if ($this->getAddress()) {
            $address[] = $this->getAddress();
        }
        if ($this->getAddress2()) {
            $address[] = $this->getAddress2();
        }
        if ($this->getAddress3()) {
            $address[] = $this->getAddress3();
        }
        if ($this->getCountryPostalCode()) {
            $address[] = $this->getCountryPostalCode();
        }
        $address[] = $this->getZip() . ' ' . $this->getCity();
        $this->postalAddress = implode("\n", $address);
        return $this->postalAddress;
    }
}
