<?php

declare(strict_types=1);

namespace Internetgalerie\IgCrmTemplate\Domain\Model;

use TYPO3\CMS\Extbase\DomainObject\AbstractEntity;

class CssPagedMediaMarginBox extends AbstractEntity
{
    /**
     * position
     *
     * @var string
     */
    protected $position = '';

    /**
     * partial
     *
     * @var string
     */
    protected $partial = '';

    /**
     * template
     *
     * @var string
     */
    protected $template = '';

    /**
     * content
     *
     * @var string
     */
    protected $content = '';

    protected int $contentMode = 0;

    /**
     * pageCss
     *
     * @var string
     */
    protected $pageCss = '';

    /**
     * elementCss
     *
     * @var string
     */
    protected $elementCss = '';

    /**
     * css
     *
     * @var string
     */
    protected $css = '';

    /**
     * Returns the position
     *
     * @return string
     */
    public function getPosition()
    {
        return $this->position;
    }

    /**
     * Sets the position
     */
    public function setPosition(string $position): void
    {
        $this->position = $position;
    }

    /**
     * Returns the partial
     *
     * @return string
     */
    public function getPartial()
    {
        return $this->partial;
    }

    /**
     * Sets the partial
     */
    public function setPartial(string $partial): void
    {
        $this->partial = $partial;
    }

    /**
     * Returns the template
     *
     * @return string
     */
    public function getTemplate()
    {
        return $this->template;
    }

    /**
     * Sets the template
     */
    public function setTemplate(string $template): void
    {
        $this->template = $template;
    }

    /**
     * Returns the content
     *
     * @return string
     */
    public function getContent()
    {
        return $this->content;
    }

    /**
     * Sets the content
     */
    public function setContent(string $content): void
    {
        $this->content = $content;
    }

    public function getContentMode(): int
    {
        return $this->contentMode;
    }

    public function setContentMode(int $contentMode): void
    {
        $this->contentMode = $contentMode;
    }
    
    /**
     * Returns the pageCss
     *
     * @return string
     */
    public function getPageCss()
    {
        return $this->pageCss;
    }

    /**
     * Sets the pageCss
     */
    public function setPageCss(string $pageCss): void
    {
        $this->pageCss = $pageCss;
    }

    /**
     * Returns the elementCss
     *
     * @return string
     */
    public function getElementCss()
    {
        return $this->elementCss;
    }

    /**
     * Sets the elementCss
     */
    public function setElementCss(string $elementCss): void
    {
        $this->elementCss = $elementCss;
    }

    /**
     * Returns the css
     *
     * @return string
     */
    public function getCss()
    {
        return $this->css;
    }

    /**
     * Sets the css
     */
    public function setCss(string $css): void
    {
        $this->css = $css;
    }
}
