<?php

namespace Internetgalerie\IgCrmTemplate\Domain\Model;

use Internetgalerie\IgDatapoolFe\Utility\FormUtility;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Domain\Model\FileReference;

class Tenant extends Address implements TenantInterface
{
    /**
     * logo
     */
    protected ?FileReference $logo = null;

    /**
     * getUseOwnAddressNumber
     *
     * @var bool
     */
    protected $useOwnAddressNumber = false;

    public function setArray(array $data): void
    {
        parent::setArray($data);
        if (isset($data['useOwnAddressNumber'])) {
            $this->setUseOwnAddressNumber($data['useOwnAddressNumber']);
        }
        if ($data['logo'] ?? false) {
            $this->formUtility = GeneralUtility::makeInstance(FormUtility::class);
            $logoFile = $this->formUtility->retrieveFileOrFolderObject($data['logo']);
            $logoFileReference = $this->formUtility->createFileReferenceFromFileResourceObject($logoFile);
            if ($logoFileReference  instanceof FileReference) {
                $this->setLogo($logoFileReference);
            }
        }
    }
    /**
     * Returns the useOwnAddressNumber
     */
    public function getUseOwnAddressNumber(): bool
    {
        return $this->useOwnAddressNumber;
    }

    /**
     * Sets the useOwnAddressNumber
     */
    public function setUseOwnAddressNumber(bool $useOwnAddressNumber): void
    {
        $this->useOwnAddressNumber = $useOwnAddressNumber;
    }

    /**
     * Returns the logo
     */
    public function getLogo(): ?FileReference
    {
        return $this->logo;
    }

    /**
     * Sets the logo
     */
    public function setLogo(?FileReference $logo = null): void
    {
        $this->logo = $logo;
    }
}
