<?php

namespace Internetgalerie\IgCrmTemplate\Utility;

use Internetgalerie\IgCrmTemplate\Domain\Model\AddressInterface;
use Internetgalerie\IgCrmTemplate\Domain\Model\CssPagedMediaMarginBoxs;
use Internetgalerie\IgCrmTemplate\Domain\Model\TemplateLetter;
use Internetgalerie\IgCrmTemplate\Domain\Model\TemplateObjectInterface;
use Internetgalerie\IgCrmTemplate\Domain\Model\TemplatePageLayout;
use Internetgalerie\IgCrmTemplate\Domain\Model\Tenant;
use Internetgalerie\IgCrmTemplate\Domain\Model\TenantInterface;
use Internetgalerie\IgCrmTemplate\Domain\Repository\TemplateLetterRepository;
use Internetgalerie\IgCrmTemplate\Domain\Repository\TemplatePageLayoutRepository;
use Psr\EventDispatcher\EventDispatcherInterface;
use TYPO3\CMS\Core\Context\Context;
use TYPO3\CMS\Core\Error\Http\InternalServerErrorException;

use TYPO3\CMS\Core\SingletonInterface;
use TYPO3\CMS\Core\TypoScript\TypoScriptService;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Configuration\ConfigurationManagerInterface;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;

class TemplateUtility implements SingletonInterface
{
    /**
     * tenant Uid
     */
    protected ?int $tenantUid = null;

    /**
     * $tenant
     *
     * @var object
     */
    protected $tenant = null;

    /**
     * crm language uir
     */
    protected ?int $languageUid = 0;


    /**
     * templateLetterRepository
     */
    protected ?TemplateLetterRepository $templateLetterRepository = null;

    /**
     * templatePageLayoutRepository
     */
    protected ?TemplatePageLayoutRepository $templatePageLayoutRepository = null;


    public function __construct(
        TypoScriptService $typoScriptService,
        ConfigurationManagerInterface $configurationManager,
        EventDispatcherInterface $eventDispatcher,
        Context $context
    ) {
        $this->configurationManager = $configurationManager;
        $this->typoScriptService = $typoScriptService;
        $this->eventDispatcher = $eventDispatcher;
        $this->context = $context;

        $all = $this->configurationManager->getConfiguration(
            ConfigurationManagerInterface::CONFIGURATION_TYPE_FULL_TYPOSCRIPT
        );
        $this->settings = $this->typoScriptService->convertTypoScriptArrayToPlainArray(
            $all['plugin.']['tx_igcrmtemplate.']['settings.'] ?? []
        );
    }



    public function injectTemplateLetterRepository(TemplateLetterRepository $templateLetterRepository): void
    {
        $this->templateLetterRepository = $templateLetterRepository;
    }

    public function injectTemplatePageLayoutRepository(TemplatePageLayoutRepository $templatePageLayoutRepository): void
    {
        $this->templatePageLayoutRepository = $templatePageLayoutRepository;
    }

    /**
     * Returns the tenant
     */
    public function getTenantUid(): int
    {
        return $this->tenant->getUid();
    }

    public function getTenant(): TenantInterface
    {
        return $this->tenant;
    }
    public function getTenantByUid(?int $tenantId = 1): TenantInterface
    {
        $tenant = null;
        $conf = $this->settings['tenant'];
        if ($conf['repository'] ?? false) {
            $tenantRepository = GeneralUtility::makeInstance($conf['repository']);
            if ($tenantId) {
                $tenant = $tenantRepository->findOneByUid($tenantId);
            } elseif ($conf['default']['uid'] ?? false) {
                $tenant = $tenantRepository->findOneByUid((int) $conf['default']['uid']);
            } else {
                throw new InternalServerErrorException(
                    'repository: ' . $conf['repository'] . ' is set, but tenantId is not set'
                );
            }
        } elseif (isset($conf['default'])) {
            // @todo default Tenant from $conf['model'] ?
            $tenant = GeneralUtility::makeInstance(Tenant::class);
            $tenant->setArray($conf['default']);
            $tenant->setUid($conf['default']['uid'] ?? 0); //bugfix for use of tenant in links - should always 0
        } else {
            throw new InternalServerErrorException(
                'No Tenant found, set plugin.tx_igcrmtemplate.settings.tenant.uid or plugin.tx_igcrmtemplate.settings.tenant.default {name=...} ',
                1717138123
            );
        }
        return $tenant;
    }

    /**
     * Sets the tenant
     */
    public function setTenantById(?int $tenantUid = null): void
    {
        $this->tenant = $this->getTenantByUid($tenantUid);
    }
    /**
     * Sets the tenant
     */
    public function setTenantByUid(?int $tenantUid = null): void
    {
        $this->tenant = $this->getTenantByUid($tenantUid);
    }
    /**
     * Sets the tenant
     */
    public function setTenant(TenantInterface $tenant = null): void
    {
        if ($tenant === null) {
            throw new InternalServerErrorException('No Tenant set');
        }
        $this->tenant = $tenant;
    }

    /**
     * Returns the languageUid
     */
    public function getLanguageUid(): ?int
    {
        return $this->languageUid;
    }
    /**
     * Sets languageUid
     */
    public function setLanguageUid(?int $languageUid = null): void
    {
        $this->languageUid = $languageUid;
    }

    public function getTemplate(
        string $templateType,
        TemplateObjectInterface $templateObject = null,
        AddressInterface $contact = null
    ): ?TemplateLetter {
        $objectType = null;
        if ($contact) {
            $objectType = $contact->getType();
        }
        if ($this->tenant) {
            CrmTranslate::setVerband($this->tenant->getUid());
        }
        $crmLanguageUid = $this->getLanguageUid();
        CrmTranslate::setCrmLanguage($crmLanguageUid);
        //die('U=' . $this->tenant->getUid() . ' L=' . $crmLanguageUid);

        return $this->templateLetterRepository->findByTenantUidTypeWithTemplateObject(
            $this->tenant->getUid(),
            $templateType,
            $templateObject,
            $contact,
            $crmLanguageUid
        );
    }

    public function getDefaultTemplatePageLayout(
        string $pageFormat = 'A4',
        $pageOrientation = 'portrait',
        array $margins = ['15mm', '0', '0', '0']
    ): TemplatePageLayout {
        $templatePageLayout = GeneralUtility::makeInstance(TemplatePageLayout::class);
        $templatePageLayout->setPageFormat($pageFormat);
        $templatePageLayout->setPageOrientation($pageOrientation);
        $templatePageLayout->setName('Default ' . $pageFormat . ' ' . $pageOrientation);
        if (!empty($margins)) {
            $templatePageLayout->setPageMarginTop((string)$margins[0]);
            $templatePageLayout->setPageMarginRight((string)($margins[1] ?? $margins[0]));
            $templatePageLayout->setPageMarginBottom((string)($margins[2] ?? $margins[0]));
            $templatePageLayout->setPageMarginLeft((string)($margins[3] ?? $margins[1] ?? $margins[0]));
        }
        //var_dump($templatePageLayout);exit(0);
        return $templatePageLayout;
    }

    public function getTemplatePageLayout(
        string $templateType,
        string $pageFormat = 'A4',
        string $pageOrientation = 'portrait',
        array $margins = ['15mm', '0', '0mm', '0']
    ): ?TemplatePageLayout {
        $templatePageLayout = $this->templatePageLayoutRepository->findOneByTenantUidAndTemplateTypeName(
            $this->tenant ? $this->tenant->getUid() : null,
            $templateType,
            $pageFormat,
            $pageOrientation
        );
        if ($templatePageLayout instanceof TemplatePageLayout) {
            return $templatePageLayout;
        }
        if ($pageFormat && $pageOrientation) {
            return $this->getDefaultTemplatePageLayout($pageFormat, $pageOrientation, $margins);
        }
        return null;
    }

    public function renderCssPagedMediaMarginBoxs(
        TemplatePageLayout $templatePageLayout,
        RenderingContextInterface $renderingContext = null
    ) {
        $cssPagedMediaMarginBoxs = $templatePageLayout->getCssPagedMediaMarginBoxs();
        if (!empty($cssPagedMediaMarginBoxs)) {
            $renderCssPagedMediaMarginBoxs = GeneralUtility::makeInstance(CssPagedMediaMarginBoxs::class);
            foreach ($cssPagedMediaMarginBoxs as $cssPagedMediaMarginBox) {
                $renderCssPagedMediaMarginBoxs->add($cssPagedMediaMarginBox, $renderingContext);
            }
            return $renderCssPagedMediaMarginBoxs->getStyle() . $renderCssPagedMediaMarginBoxs->getHtml();
        }
        return '';
    }
    /*
      public function getPageLayoutCss()
      {
      return $this->getPageLayoutCssA4Portrait();
      }
      public function getPageLayoutCssA4Portrait()
      {
      return file_get_contents(GeneralUtility::getFileAbsFileName('EXT:ig_crm_template/Resources/Public/Css/PageLayout/a4-portrait.css'));
      }
      public function getPageLayoutCssA4Landscapt()
      {
      return file_get_contents(GeneralUtility::getFileAbsFileName('EXT:ig_crm_template/Resources/Public/Css/PageLayout/a4-landscape.css'));
      }
    */
}
