<?php

namespace Internetgalerie\IgCrmTemplate\ViewHelpers;

use Closure;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;

class ContentViewHelper extends AbstractViewHelper
{
    protected $escapeOutput = false;
    
    
    /**
     * Initialize the arguments.
     * @api
     */
    public function initializeArguments(): void
    {
        parent::initializeArguments();
        $this->registerArgument('value', 'array|string', 'value to use', false);
        $this->registerArgument('formatHtml', 'bool', 'use f:format.html to fromat value', false, true);
        $this->registerArgument('parse', 'bool', 'use f:inline to parse value', false, false);
    }

    public function render(): string
    {
        $parse = $this->arguments['parse'];
        $formatHtml = $this->arguments['formatHtml'];
        if (is_array($this->arguments['value'])) {
            $html = $this->arguments['value']['value'];
            $parse = $this->arguments['value']['parse'] ?? $this->arguments['parse'];
            $formatHtml = $this->arguments['value']['formatHtml'] ?? $this->arguments['formatHtml'];
        } else {
            $html = (string)$this->arguments['value'];
        }
        if ($html === null | $html == '') {
            return '';
        }
        if ($parse) {
            $html = $this->renderingContext
                  ->getTemplateParser()
                  ->parse($html)
                  ->render($this->renderingContext);
        }
        if ($formatHtml) {
            $html = htmlspecialchars((string) $html);
        }
        return $html;
    }
}
