<?php

namespace Internetgalerie\IgCrmTemplate\ViewHelpers;

use Closure;
use Internetgalerie\IgCrmTemplate\Domain\Model\TemplatePageLayout;
use Internetgalerie\IgCrmTemplate\Utility\TemplateUtility;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;

class PageLayoutViewHelper extends AbstractViewHelper
{
    protected $escapeOutput = false;
    
    
    /**
     * Initialize the arguments.
     * @api
     */
    public function initializeArguments(): void
    {
        parent::initializeArguments();
        $this->registerArgument('templatePageLayout', TemplatePageLayout::class, 'templatePageLayout', true);
    }

    public function render(): string
    {
        $templateUtility = GeneralUtility::makeInstance(TemplateUtility::class);

        $templatePageLayout = $this->arguments['templatePageLayout'];

        $html = $templateUtility->renderCssPagedMediaMarginBoxs($templatePageLayout, $this->renderingContext);
        $html .= $this->renderChildren();
    
        return $html;
    }
}
