<?php

namespace Internetgalerie\IgCrmTemplate\Database\Query;

use TYPO3\CMS\Core\Database\Query\QueryBuilder;

class TemplateLetterQueryBuilder extends QueryBuilder
{
    protected $tablename = 'tx_igcrmtemplate_domain_model_templateletter';
    protected $templatetypeTablename = 'tx_igcrmtemplate_domain_model_templatetype';

    public function joinTemplatetype(): void
    {
        $this->join(
            $this->tablename,
            $this->templatetypeTablename,
            $this->templatetypeTablename,
            $this->expr()
                 ->eq(
                     $this->tablename . '.template_type',
                     $this->quoteIdentifier($this->templatetypeTablename . '.uid')
                 )
        );
    }
    public function addTemplateTypeByName(?string $templateTypeName)
    {
        if ($templateTypeName !== null && $templateTypeName !== '') {
            $this->andWhere(
                $this->expr()
                     ->eq($this->templatetypeTablename . '.name', $this->createNamedParameter($templateTypeName))
            );
        }
        return $this;
    }
    
    public function addSearch($search)
    {
        $constrains = [];
        if (isset($search['uid']) && $search['uid'] !== '') {
            $constrains[] = $this->expr()->eq($this->tablename . '.uid', trim((string) $search['uid']));
        }
        if (!empty($constrains)) {
            $this->andWhere(...$constrains);
        }
        return $this;
    }
    public function addArrayOrderBy(array $orderBys)
    {
        foreach ($orderBys as $attribute => $order) {
            $this->addOrderBy($attribute, $order);
        }
        return $this;
    }
}
