<?php

declare(strict_types=1);

namespace Internetgalerie\IgCrmTemplate\Domain\Model;

use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\DomainObject\AbstractEntity;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;

class CssPagedMediaMarginBoxs extends AbstractEntity
{
    public const CONTENT_MODE_TEXT = 0;
    public const CONTENT_MODE_CSS = 1;
    
    protected string $html = '';
    protected string $css = '';
    protected string $pageCss = '';

    public function getHtml()
    {
        return $this->html;
    }

    public function getCss()
    {
        return $this->pageCss ? '@page {' . "\n" . $this->pageCss . "\n}\n" . $this->css . "\n" : $this->css . "\n";
    }

    public function getStyle()
    {
        return "<style>\n" . $this->getCss() . '</style>';
    }
    
    public function addContent(
        string $position,
        string $template,
        string $partial,
        string $content,
        int $contentMode,
        string $pageCss,
        string $elementCss,
        RenderingContextInterface $renderingContext
    ): void {
        $view = $renderingContext->getViewHelperVariableContainer()
                                 ->getView();
        $pageCss = trim($pageCss ?? '');
        //die($templatePageLayout->getUid() . '=' . $templatePageLayout->getName());
        $boxHtml = '';
        if ($template) {
            $boxHtml .= $renderingContext->getTemplateParser()
                                         ->parse($template)
                                         ->render($renderingContext);
        }
        if ($partial) {
            if (str_starts_with($partial, 'EXT:')) {
                $fileName = GeneralUtility::getFileAbsFileName($partial);
                if (file_exists($fileName)) {
                    $partialContent = file_get_contents($fileName);
                    $boxHtml .= $renderingContext->getTemplateParser()
                                                 ->parse($partialContent)
                                                 ->render($renderingContext);
                }
            } else {
                $boxHtml .= $view->renderPartial($partial, null, []);
            }
        }
        $positionParts = explode('-', $position);
        $class = 'ig-crm-template-box-' . $position;
        foreach ($positionParts as $positionPart) {
            $class .= ' ig-crm-template-box-' . $positionPart;
        }
        if ($boxHtml) {
            $this->html .= '<div class="' . $class . '" id="ig-crm-template-box-' . $position . '">' . $boxHtml . '</div>';
            $this->pageCss .= '@' . $position . ' {content: element(ig-crm-template-box-' . $position . '-element);}' . "\n";
            $this->css .= '.ig-crm-template-box-' . $position . ' {position: running(ig-crm-template-box-' . $position . '-element);' . trim(
                $elementCss ?? ''
            ) . '}' . "\n";
        } elseif ($content) {
            $elementCssTrim = trim($elementCss ?? '');
            if ($elementCssTrim) {
                $this->css .= '.ig-crm-template-box-' . $position . ' {' . $elementCssTrim . '}' . "\n";
            }
            if ($contentMode === self::CONTENT_MODE_CSS) {
                // content is css value and includes quotation marks
                $pageCss .= 'content: ' . $content . ';' . "\n" . $pageCss;
            } else {
                // contet is only text and has no surrounding quotation marks
                $pageCss .= 'content: "' . str_replace('"', '\0022', $content) . '";' . "\n" . $pageCss;
            }
        }
        $this->pageCss .= '@' . $position . ' {' . trim($pageCss) . '}' . "\n";
    }
    public function add(
        CssPagedMediaMarginBox $cssPagedMediaMarginBox,
        RenderingContextInterface $renderingContext
    ): void {
        $this->addContent(
            $cssPagedMediaMarginBox->getPosition(),
            $cssPagedMediaMarginBox->getTemplate(),
            $cssPagedMediaMarginBox->getPartial(),
            $cssPagedMediaMarginBox->getContent(),
            $cssPagedMediaMarginBox->getContentMode(),
            $cssPagedMediaMarginBox->getPageCss(),
            $cssPagedMediaMarginBox->getElementCss(),
            $renderingContext
        );
        if ($cssPagedMediaMarginBox->getCss()) {
            $this->css .= $cssPagedMediaMarginBox->getCss() . "\n";
        }
    }
}
