<?php

namespace Internetgalerie\IgCrmTemplate\Domain\Model;

use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Domain\Model\FileReference;
use TYPO3\CMS\Extbase\DomainObject\AbstractEntity;
use TYPO3\CMS\Extbase\Persistence\ObjectStorage;

class TemplateLetter extends AbstractEntity
{
    /**
     * Kommunikationssprache
     */
    public ?int $crmLanguage = null;

    /**
     * Tenant ID
     */
    public ?int $tenantId = null;

    /**
     * active
     *
     * @var bool
     */
    protected $active = 1;

    /**
     * favorite
     *
     * @var bool
     */
    protected $favorite = false;
    
    /**
     * templateType
     *
     * @var TemplateType
     */
    protected $templateType;

    /**
     * template object items per page
     *
     * @var int
     */
    protected $templateObjectItemsPerPage;

    /**
     * templateObjectType
     *
     * @var string
     */
    protected $templateObjectType = '';

    /**
     * mainTags
     */
    protected ?string $mainTags = null;
    
    /**
     * subTags
     */
    protected ?string $subTags = null;

    /**
     * objectType
     *
     * @var string
     */
    protected $objectType = '';

    /**
     * name
     *
     * @var string
     */
    protected $name = '';

    /**
     * title
     *
     * @var string
     */
    protected $title = '';

    /**
     * titleLayout
     */
    protected int $titleLayout = 0;
    
    /**
     * partialHeader
     *
     * @var string
     */
    protected $partialHeader = '';

    /**
     * partialFooter
     *
     * @var string
     */
    protected $partialFooter = '';

    /**
     * showNumberInHeader
     *
     * @var bool
     */
    protected $showNumberInHeader = false;

    /**
     * showDebitorNumber
     *
     * @var bool
     */
    protected $showDebitorNumber = false;

    /**
     * showLetterDate
     *
     * @var bool
     */
    protected $showLetterDate = true;

    /**
     * showSender
     *
     * @var bool
     */
    protected $showSender = false;

    /**
     * showPp
     *
     * @var bool
     */
    protected $showPp = false;

    /**
     * showMwst
     *
     * @var bool
     */
    protected $showMwst = false;


    /**
     * textBefore
     *
     * @var string
     */
    protected $textBefore = '';

    /**
     * partialBefore
     *
     * @var string
     */
    protected $partialBefore = '';

    /**
     * partialAfter
     *
     * @var string
     */
    protected $partialAfter = '';

    /**
     * template
     *
     * @var string
     */
    protected $template = '';

    /**
     * pageTemplate
     *
     * @var string
     */
    protected $pageTemplate = '';

    /**
     * textAfter
     *
     * @var string
     */
    protected $textAfter = '';

    /**
     * pageCssFile
     *
     * @var string
     */
    protected $pageCssFile = '';

    /**
     * pageClass
     *
     * @var string
     */
    protected $pageClass = '';

    /**
     * filename
     *
     * @var string
     */
    protected $filename = '';

    /**
     * logos
     *
     * @var ObjectStorage<FileReference>
     */
    #[TYPO3\CMS\Extbase\Annotation\ORM\Cascade([
        'value' => 'remove',
    ])]
    protected $logos = null;

    /**
     * Returns the last change timestamp
     *
     * @return bool
     */
    public function getActive()
    {
        return $this->active;
    }
    
    /**
     * Set the value of Active
     *
     * @return self
     */
    public function setActive(bool $active): void
    {
        $this->active = $active;
    }
    
    /**
     * Returns the last change timestamp
     *
     * @return bool
     */
    public function getFavorite()
    {
        return $this->favorite;
    }
    
    /**
     * Set the value of Favorite
     *
     * @return self
     */
    public function setFavorite(bool $favorite): void
    {
        $this->favorite = $favorite;
    }
    
    /**
     * Returns the type
     *
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * Sets the type
     *
     * @param string $type
     */
    public function setType($type): void
    {
        $this->type = $type;
    }

    
    /**
     * Returns the name
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Sets the name
     *
     * @param string $name
     */
    public function setName($name): void
    {
        $this->name = $name;
    }

    /**
     * Returns the templateType
     */
    public function getTemplateType(): TemplateType
    {
        return $this->templateType;
    }

    /**
     * Sets the templateType
     */
    public function setTemplateType(TemplateType $templateType): void
    {
        $this->templateType = $templateType;
    }
    

    /**
     * Returns the templateObjectItemsPerPage
     */
    public function getTemplateObjectItemsPerPage(): ?int
    {
        return $this->templateObjectItemsPerPage;
    }

    /**
     * Sets the templateObjectItemsPerPage
     */
    public function setTemplateObjectItemsPerPage(?int $templateObjectItemsPerPage = null): void
    {
        $this->templateObjectItemsPerPage = $templateObjectItemsPerPage;
    }

    /**
     * Returns the templateObjectType
     *
     * @return string
     */
    public function getTemplateObjectType()
    {
        return $this->templateObjectType;
    }

    /**
     * Sets the templateObjectType
     *
     * @param string $templateObjectType
     */
    public function setTemplateObjectType($templateObjectType): void
    {
        $this->templateObjectType = $templateObjectType;
    }

    
    /**
     * Returns the objectType
     *
     * @return string
     */
    public function getObjectType()
    {
        return $this->objectType;
    }

    /**
     * Sets the objectType
     *
     * @param string $objectType
     */
    public function setObjectType($objectType): void
    {
        $this->objectType = $objectType;
    }

    /**
     * Returns the crmLanguage
     */
    public function getCrmLanguage(): ?int
    {
        return $this->crmLanguage;
    }

    /**
     * Sets the crmLanguage
     */
    public function setCrmLanguage(?int $crmLanguage = null): void
    {
        $this->crmLanguage = $crmLanguage;
    }

    
    /**
     * Returns the title
     *
     * @return string
     */
    public function getTitle()
    {
        return $this->title;
    }

    /**
     * Sets the title
     *
     * @param string $title
     */
    public function setTitle($title): void
    {
        $this->title = $title;
    }

    /**
     * Returns the titleLayout
     */
    public function getTitleLayout(): int
    {
        return $this->titleLayout;
    }
    public function getTitleLayoutTag(): string
    {
        if ($this->titleLayout === 100) {
            return '';
        }
        
        return 'h' . ($this->titleLayout ?: '1');
    }

    /**
     * Sets the titleLayout
     */
    public function setTitleLayout(int $titleLayout): void
    {
        $this->titleLayout = $titleLayout;
    }


    
    /**
     * Returns the Tenant
     */
    public function getTenantId(): int
    {
        return $this->tenantId;
    }

    /**
     * Sets the Tenant
     */
    public function setTenantId(int $tenantId): void
    {
        $this->tenantId = $tenantId;
    }

    /**
     * Returns the mainTags
     */
    public function getMainTags(): array
    {
        return $this->mainTags === null ? [] : GeneralUtility::intExplode(',', $this->mainTags, true);
    }

    /**
     * Sets the mainTags
     */
    public function setMainTags(?string $mainTags = null): void
    {
        $this->mainTags = $mainTags;
    }

    /**
     * Returns the subtags
     *
     * @return string
     */
    public function getSubTags(): array
    {
        return $this->subTags === null ? [] : GeneralUtility::intExplode(',', $this->subTags, true);
        //return $this->subTags;
    }
 
    /**
     * Sets the subTags
     */
    public function setSubTags(?string $subTags = null): void
    {
        $this->subTags = $subTags;
    }
 
    /**
     * Returns the showNumberInHeader
     *
     * @return bool
     */
    public function getShowNumberInHeader()
    {
        return $this->showNumberInHeader;
    }

    /**
     * Sets the showNumberInHeader
     *
     * @param bool $showNumberInHeader
     */
    public function setShowNumberInHeader($showNumberInHeader): void
    {
        $this->showNumberInHeader = $showNumberInHeader;
    }

    /**
     * Returns the showDebitorNumber
     *
     * @return bool
     */
    public function getShowDebitorNumber()
    {
        return $this->showDebitorNumber;
    }

    /**
     * Sets the showDebitorNumber
     *
     * @param bool $showDebitorNumber
     */
    public function setShowDebitorNumber($showDebitorNumber): void
    {
        $this->showDebitorNumber = $showDebitorNumber;
    }

    /**
     * Returns the showLetterDate
     *
     * @return bool
     */
    public function getShowLetterDate()
    {
        return $this->showLetterDate;
    }

    /**
     * Sets the showLetterDate
     *
     * @param bool $showLetterDate
     */
    public function setShowLetterDate($showLetterDate): void
    {
        $this->showLetterDate = $showLetterDate;
    }

    /**
     * Returns the showSender
     *
     * @return bool
     */
    public function getShowSender()
    {
        return $this->showSender;
    }

    /**
     * Sets the showSender
     *
     * @param bool $showSender
     */
    public function setShowSender($showSender): void
    {
        $this->showSender = $showSender;
    }

    /**
     * Returns the showPp
     *
     * @return bool
     */
    public function getShowPp()
    {
        return $this->showPp;
    }

    /**
     * Sets the showPp
     *
     * @param bool $showPp
     */
    public function setShowPp($showPp): void
    {
        $this->showPp = $showPp;
    }

    /**
     * Returns the showMwst
     *
     * @return bool
     */
    public function getShowMwst()
    {
        return $this->showMwst;
    }
    public function getShowTax()
    {
        return $this->showMwst;
    }

    /**
     * Sets the showMwst
     *
     * @param bool $showMwst
     */
    public function setShowMwst($showMwst): void
    {
        $this->showMwst = $showMwst;
    }
    
    /**
     * Returns the partialHeader
     *
     * @return string
     */
    public function getPartialHeader()
    {
        return $this->partialHeader;
    }

    /**
     * Sets the partialHeader
     *
     * @param string $partialHeader
     */
    public function setPartialHeader($partialHeader): void
    {
        $this->partialHeader = $partialHeader;
    }

    /**
     * Returns the partialFooter
     *
     * @return string
     */
    public function getPartialFooter()
    {
        return $this->partialFooter;
    }

    /**
     * Sets the partialFooter
     *
     * @param string $partialFooter
     */
    public function setPartialFooter($partialFooter): void
    {
        $this->partialFooter = $partialFooter;
    }


    
    /**
     * Returns the partialBefore
     *
     * @return string
     */
    public function getPartialBefore()
    {
        return $this->partialBefore;
    }

    /**
     * Sets the partialBefore
     *
     * @param string $partialBefore
     */
    public function setPartialBefore($partialBefore): void
    {
        $this->partialBefore = $partialBefore;
    }
    
    /**
     * Returns the partialAfter
     *
     * @return string
     */
    public function getPartialAfter()
    {
        return $this->partialAfter;
    }

    /**
     * Sets the partialAfter
     *
     * @param string $partialAfter
     */
    public function setPartialAfter($partialAfter): void
    {
        $this->partialAfter = $partialAfter;
    }

    /**
     * Returns the template
     *
     * @return string
     */
    public function getTemplate()
    {
        return $this->template ?: '<template:content value="{content.text}" />';
        //  parse="{content.text.parse}" formatHtml="{content.text.formatHtml}"
        //<f:if condition="{content.text}"><f:format.html><f:inline>{content.text}</f:inline></f:format.html></f:if>';
        // '<template:content value="{content.text}" parse="1" formatHtml="1" />
        //'<f:format.raw>{content.text}</f:format.raw>';
    }

    /**
     * Sets the template
     *
     * @param string $template
     */
    public function setTemplate($template): void
    {
        $this->template = $template;
    }

    /**
     * Returns the pageTemplate
     *
     * @return string
     */
    public function getPageTemplate()
    {
        return $this->pageTemplate;
    }
    /**
     * Sets the pageTemplate
     *
     * @param string $pageTemplate
     */
    public function setPageTemplate($pageTemplate): void
    {
        $this->pageTemplate = $pageTemplate;
    }
 
    /**
     * Returns the textBefore
     *
     * @return string
     */
    public function getTextBefore()
    {
        return $this->textBefore;
    }

    /**
     * Sets the textBefore
     *
     * @param string $textBefore
     */
    public function setTextBefore($textBefore): void
    {
        $this->textBefore = $textBefore;
    }

    
    /**
     * Returns the textAfter
     *
     * @return string
     */
    public function getTextAfter()
    {
        return $this->textAfter;
    }

    /**
     * Sets the textAfter
     *
     * @param string $textAfter
     */
    public function setTextAfter($textAfter): void
    {
        $this->textAfter = $textAfter;
    }

    /**
     * Returns the pageCssFile
     */
    public function getPageCssFile(): string
    {
        return $this->pageCssFile;
    }
    public function getCssFile(): string
    {
        return $this->pageCssFile;
    }

    /**
     * Sets the pageCssFile
     */
    public function setPageCssFile(string $pageCssFile): void
    {
        $this->pageCssFile = $pageCssFile;
    }
    
    public function getCssFiles(?string $media = 'pdf'): array
    {
        $cssFiles = [];
        $cssFiles[] = 'EXT:ig_crm_template/Resources/Public/Css/box.css';
        if ($media === 'pdf') {
            $cssFiles[] = 'EXT:ig_crm_template/Resources/Public/Css/pdf.css';
        } elseif ($media === 'email') {
            $cssFiles[] = 'EXT:ig_crm_template/Resources/Public/Css/email.css';
        }
        $cssFileName = $this->getPageCssFile();
        if ($cssFileName) {
            // @todo is this secury?
            if (str_starts_with($cssFileName, 'EXT:')) {
                $cssFiles[] = $cssFileName;
            }
        }
        $cssFileName = $this->getTemplateType()
                            ->getCssFile();
        if ($cssFileName) {
            // @todo is this secury?
            if (str_starts_with($cssFileName, 'EXT:')) {
                $cssFiles[] = $cssFileName;
            }
        }
        $cssIgLayout = 'EXT:ig_layout/Resources/Public/Pdf/Css/styles.css';
        $cssFileIgLayout = GeneralUtility::getFileAbsFileName($cssIgLayout);
        if ($cssFileIgLayout && file_exists($cssFileIgLayout)) {
            $cssFiles[] = $cssIgLayout;
        }
        return $cssFiles;
    }

    public function getCss(?string $media = 'pdf'): string
    {
        $cssFiles = $this->getCssFiles($media);
        $css = '';
        foreach ($cssFiles as $cssFile) {
            if ($css) {
                $css .= "\n";
            }
            $css .= file_get_contents(GeneralUtility::getFileAbsFileName($cssFile));
        }
        return $css;
    }
    public function getCssMediaEmail(): string
    {
        return $this->getCss('email');
    }
    public function getCssMediaPdf(): string
    {
        return $this->getCss('pdf');
    }
    /**
     * Returns the pageClass
     */
    public function getPageClass(): string
    {
        return $this->pageClass;
    }

    /**
     * Sets the pageClass
     */
    public function setPageClass(string $pageClass): void
    {
        $this->pageClass = $pageClass;
    }

    /**
     * Returns the filename
     */
    public function getFilename(): string
    {
        return $this->filename;
    }

    /**
     * Sets the filename
     */
    public function setFilename(string $filename): void
    {
        $this->filename = $filename;
    }


    /**
     * Adds a FileReference
     */
    public function addLogos(FileReference $logos): void
    {
        $this->logos->attach($logos);
    }
    /**
     * Removes a FileReference
     *
     * @param FileReference $logosToRemove The FileReference to be removed
     */
    public function removeLogos(FileReference $logosToRemove): void
    {
        $this->logos->detach($logosToRemove);
    }

    /**
     * Returns the logos
     *
     * @param ObjectStorage<FileReference> $logos
     */
    public function setLogos(ObjectStorage $logos): void
    {
        $this->logos = $logos;
    }

    /**
     * Returns the logos
     *
     * @return ObjectStorage<FileReference> $logos
     */
    public function getLogos()
    {
        return $this->logos;
    }
}
