<?php

declare(strict_types=1);

namespace Internetgalerie\IgCrmTemplate\Domain\Model;

use TYPO3\CMS\Extbase\DomainObject\AbstractEntity;
use TYPO3\CMS\Extbase\Persistence\ObjectStorage;

class TemplatePageLayout extends AbstractEntity
{
    public const PAGE_FORMART_A4 = 'A4';

    public const PAGE_ORIENTATION_PORTRAIT = 'portrait';
    public const PAGE_ORIENTATION_LANDSCAPE = 'landscape';




    /**
     * cssPagedMediaMarginBoxs
     *
     * @var ObjectStorage<CssPagedMediaMarginBox>
     */
    #[TYPO3\CMS\Extbase\Annotation\ORM\Cascade([
        'value' => 'remove',
    ])]
    protected $cssPagedMediaMarginBoxs = null;

    
    /**
     * headerLeftPartial
     *
     * @var string
     */
    protected $headerLeftPartial = '';

    /**
     * headerCenterPartial
     *
     * @var string
     */
    protected $headerCenterPartial = '';

    /**
     * headerRightPartial
     *
     * @var string
     */
    protected $headerRightPartial = '';

    /**
     * headerLeftTemplate
     *
     * @var string
     */
    protected $headerLeftTemplate = '';

    /**
     * headerCenterTemplate
     *
     * @var string
     */
    protected $headerCenterTemplate = '';

    /**
     * headerRightTemplate
     *
     * @var string
     */
    protected $headerRightTemplate = '';

    /**
     * headerLeftContent
     *
     * @var string
     */
    protected $headerLeftContent = '';

    /**
     * headerCenterContent
     *
     * @var string
     */
    protected $headerCenterContent = '';

    /**
     * headerRightContent
     *
     * @var string
     */
    protected $headerRightContent = '';

    /**
     * tenantId
     *
     * @var ?int
     */
    protected $tenantId = null;

    /**
     * name
     *
     * @var string
     */
    protected $name = '';

    /**
     * pageFormat
     *
     * @var string
     */
    protected $pageFormat = '';

    /**
     * pageOrientation
     *
     * @var string
     */
    protected $pageOrientation = '';

    /**
     * pageMarginTop
     *
     * @var string
     */
    protected $pageMarginTop = '';

    /**
     * pageMarginRight
     *
     * @var string
     */
    protected $pageMarginRight = '';

    /**
     * pageMarginBottom
     *
     * @var string
     */
    protected $pageMarginBottom = '';

    /**
     * pageMarginLeft
     *
     * @var string
     */
    protected $pageMarginLeft = '';

    /**
     * pageCssFile
     *
     * @var string
     */
    protected $pageCssFile = '';

    /**
     * pageCss
     *
     * @var string
     */
    protected $pageCss = '';

    /**
     * footerPartial
     *
     * @var string
     */
    protected $footerPartial = '';

    /**
     * footerLeftContent
     *
     * @var string
     */
    protected $footerLeftContent = '';

    /**
     * footerCenterContent
     *
     * @var string
     */
    protected $footerCenterContent = '';

    /**
     * footerRightContent
     *
     * @var string
     */
    protected $footerRightContent = '';

    /**
     * templateType
     *
     * @var TemplateType
     */
    protected $templateType = null;

    /**
     * Returns the tenantId
     *
     * @return int
     */
    public function getTenantId()
    {
        return $this->tenantId;
    }

    /**
     * Sets the tenantId
     */
    public function setTenantId(int $tenantId): void
    {
        $this->tenantId = $tenantId;
    }

    /**
     * Returns the name
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Sets the name
     */
    public function setName(string $name): void
    {
        $this->name = $name;
    }

    /**
     * Returns the pageFormat
     *
     * @return string
     */
    public function getPageFormat()
    {
        return $this->pageFormat;
    }

    /**
     * Sets the pageFormat
     */
    public function setPageFormat(string $pageFormat): void
    {
        $this->pageFormat = $pageFormat;
    }

    /**
     * Returns the pageOrientation
     *
     * @return string
     */
    public function getPageOrientation()
    {
        return $this->pageOrientation;
    }

    /**
     * Sets the pageOrientation
     */
    public function setPageOrientation(string $pageOrientation): void
    {
        $this->pageOrientation = $pageOrientation;
    }

    /**
     * Returns the pageMarginTop
     *
     * @return string
     */
    public function getPageMarginTop()
    {
        return $this->pageMarginTop;
    }

    /**
     * Sets the pageMarginTop
     */
    public function setPageMarginTop(string $pageMarginTop): void
    {
        $this->pageMarginTop = $pageMarginTop;
    }

    /**
     * Returns the pageMarginRight
     *
     * @return string
     */
    public function getPageMarginRight()
    {
        return $this->pageMarginRight;
    }

    /**
     * Sets the pageMarginRight
     */
    public function setPageMarginRight(string $pageMarginRight): void
    {
        $this->pageMarginRight = $pageMarginRight;
    }

    /**
     * Returns the pageMarginBottom
     *
     * @return string
     */
    public function getPageMarginBottom()
    {
        return $this->pageMarginBottom;
    }

    /**
     * Sets the pageMarginBottom
     */
    public function setPageMarginBottom(string $pageMarginBottom): void
    {
        $this->pageMarginBottom = $pageMarginBottom;
    }

    /**
     * Returns the pageMarginLeft
     *
     * @return string
     */
    public function getPageMarginLeft()
    {
        return $this->pageMarginLeft;
    }

    /**
     * Sets the pageMarginLeft
     */
    public function setPageMarginLeft(string $pageMarginLeft): void
    {
        $this->pageMarginLeft = $pageMarginLeft;
    }

    /**
     * Returns the pageCssFile
     *
     * @return string
     */
    public function getPageCssFile()
    {
        return $this->pageCssFile;
    }

    /**
     * Sets the pageCssFile
     */
    public function setPageCssFile(string $pageCssFile): void
    {
        $this->pageCssFile = $pageCssFile;
    }

    /**
     * Returns the pageCss
     *
     * @return string
     */
    public function getPageCss()
    {
        return $this->pageCss;
    }

    /**
     * Sets the pageCss
     */
    public function setPageCss(string $pageCss): void
    {
        $this->pageCss = $pageCss;
    }

    /**
     * Returns the footerPartial
     *
     * @return string
     */
    public function getFooterPartial()
    {
        return $this->footerPartial;
    }

    /**
     * Sets the footerPartial
     */
    public function setFooterPartial(string $footerPartial): void
    {
        $this->footerPartial = $footerPartial;
    }

    /**
     * Returns the footerLeftContent
     *
     * @return string
     */
    public function getFooterLeftContent()
    {
        return $this->footerLeftContent;
    }

    /**
     * Sets the footerLeftContent
     */
    public function setFooterLeftContent(string $footerLeftContent): void
    {
        $this->footerLeftContent = $footerLeftContent;
    }

    /**
     * Returns the footerCenterContent
     *
     * @return string
     */
    public function getFooterCenterContent()
    {
        return $this->footerCenterContent;
    }

    /**
     * Sets the footerCenterContent
     */
    public function setFooterCenterContent(string $footerCenterContent): void
    {
        $this->footerCenterContent = $footerCenterContent;
    }

    /**
     * Returns the footerRightContent
     *
     * @return string
     */
    public function getFooterRightContent()
    {
        return $this->footerRightContent;
    }

    /**
     * Sets the footerRightContent
     */
    public function setFooterRightContent(string $footerRightContent): void
    {
        $this->footerRightContent = $footerRightContent;
    }

    /**
     * Returns the templateType
     *
     * @return TemplateType
     */
    public function getTemplateType()
    {
        return $this->templateType;
    }

    /**
     * Sets the templateType
     */
    public function setTemplateType(TemplateType $templateType): void
    {
        $this->templateType = $templateType;
    }

    /**
     * Returns the headerLeftPartial
     *
     * @return string headerLeftPartial
     */
    public function getHeaderLeftPartial()
    {
        return $this->headerLeftPartial;
    }

    /**
     * Sets the headerLeftPartial
     */
    public function setHeaderLeftPartial(string $headerLeftPartial): void
    {
        $this->headerLeftPartial = $headerLeftPartial;
    }

    /**
     * Returns the headerCenterPartial
     *
     * @return string headerCenterPartial
     */
    public function getHeaderCenterPartial()
    {
        return $this->headerCenterPartial;
    }

    /**
     * Sets the headerCenterPartial
     */
    public function setHeaderCenterPartial(string $headerCenterPartial): void
    {
        $this->headerCenterPartial = $headerCenterPartial;
    }

    /**
     * Returns the headerRightPartial
     *
     * @return string headerRightPartial
     */
    public function getHeaderRightPartial()
    {
        return $this->headerRightPartial;
    }

    /**
     * Sets the headerRightPartial
     */
    public function setHeaderRightPartial(string $headerRightPartial): void
    {
        $this->headerRightPartial = $headerRightPartial;
    }

    /**
     * Returns the headerLeftTemplate
     *
     * @return string
     */
    public function getHeaderLeftTemplate()
    {
        return $this->headerLeftTemplate;
    }

    /**
     * Sets the headerLeftTemplate
     */
    public function setHeaderLeftTemplate(string $headerLeftTemplate): void
    {
        $this->headerLeftTemplate = $headerLeftTemplate;
    }

    /**
     * Returns the headerCenterTemplate
     *
     * @return string
     */
    public function getHeaderCenterTemplate()
    {
        return $this->headerCenterTemplate;
    }

    /**
     * Sets the headerCenterTemplate
     */
    public function setHeaderCenterTemplate(string $headerCenterTemplate): void
    {
        $this->headerCenterTemplate = $headerCenterTemplate;
    }

    /**
     * Returns the headerRightTemplate
     *
     * @return string
     */
    public function getHeaderRightTemplate()
    {
        return $this->headerRightTemplate;
    }

    /**
     * Sets the headerRightTemplate
     */
    public function setHeaderRightTemplate(string $headerRightTemplate): void
    {
        $this->headerRightTemplate = $headerRightTemplate;
    }

    /**
     * Returns the headerLeftContent
     *
     * @return string
     */
    public function getHeaderLeftContent()
    {
        return $this->headerLeftContent;
    }

    /**
     * Sets the headerLeftContent
     */
    public function setHeaderLeftContent(string $headerLeftContent): void
    {
        $this->headerLeftContent = $headerLeftContent;
    }

    /**
     * Returns the headerCenterContent
     *
     * @return string
     */
    public function getHeaderCenterContent()
    {
        return $this->headerCenterContent;
    }

    /**
     * Sets the headerCenterContent
     */
    public function setHeaderCenterContent(string $headerCenterContent): void
    {
        $this->headerCenterContent = $headerCenterContent;
    }

    /**
     * Returns the headerRightContent
     *
     * @return string
     */
    public function getHeaderRightContent()
    {
        return $this->headerRightContent;
    }

    /**
     * Sets the headerRightContent
     */
    public function setHeaderRightContent(string $headerRightContent): void
    {
        $this->headerRightContent = $headerRightContent;
    }

    /**
     * Adds a CssPagedMediaMarginBox
     */
    public function addCssPagedMediaMarginBox(CssPagedMediaMarginBox $cssPagedMediaMarginBox): void
    {
        $this->cssPagedMediaMarginBoxs->attach($cssPagedMediaMarginBox);
    }

    /**
     * Removes a CssPagedMediaMarginBox
     *
     * @param CssPagedMediaMarginBox $cssPagedMediaMarginBoxToRemove The CssPagedMediaMarginBox to be removed
     */
    public function removeCssPagedMediaMarginBox(CssPagedMediaMarginBox $cssPagedMediaMarginBoxToRemove): void
    {
        $this->cssPagedMediaMarginBoxs->detach($cssPagedMediaMarginBoxToRemove);
    }

    /**
     * Returns the cssPagedMediaMarginBoxs
     *
     * @return ObjectStorage<CssPagedMediaMarginBox>
     */
    public function getCssPagedMediaMarginBoxs()
    {
        return $this->cssPagedMediaMarginBoxs;
    }

    /**
     * Sets the cssPagedMediaMarginBoxs
     *
     * @param ObjectStorage<CssPagedMediaMarginBox> $cssPagedMediaMarginBoxs
     */
    public function setCssPagedMediaMarginBoxs(ObjectStorage $cssPagedMediaMarginBoxs): void
    {
        $this->cssPagedMediaMarginBoxs = $cssPagedMediaMarginBoxs;
    }

    public function getCss()
    {
        $css = '@page {
    size: ' . $this->getPageFormat() . ' ' . $this->getPageOrientation() . ';
    margin: ' . $this->getPageMarginTop() . ' ' . $this->getPageMarginRight() . ' ' . $this->getPageMarginBottom() . ' ' . $this->getPageMarginLeft() . ';
}
';
        if ($this->pageCss) {
            $css .= $this->pageCss . "\n";
        }
        if ($this->pageCssFile) {
            $css .= file_get_contents(GeneralUtility::getFileAbsFileName($this->pageCssFile)) . "\n";
        }
        return $css;
    }
}
